function [f,g] = specrad(x,pars)
%
% spectral radius (max of moduli of eigenvalues) of the matrix A(x)
% as a function of parameters x1,...,x_nvar and its gradient
% input: vector x (the parameters) and structure pars with fields:
%   pars.getmats is a string with the name of a function that returns
%    the matrix A(x) and its partial derivatives B{j} wrt x(j), j=1,...,nvar: 
%    [A,B] = getmats(x,pars)
%   pars.nvar is the number of variables x(j)
%
[A,B] = feval(pars.getmats,x,pars); % the matrix and its derivatives
nvar = pars.nvar;
[V,D,W] = eig(A); % right eigenvectors V, left eigenvectors W
d = diag(D); % eigenvalues
[f,indx] = max(abs(d)); % spectral radius (for spectral abscissa, use max(real(d)))
d = d(indx); % relevant eigenvalue
v = V(:,indx); % relevant right eigenvector
w = W(:,indx); % relevant left eigenvector
g = zeros(nvar,1); % the gradient must be a column vector
for j=1:nvar
    % derivative of f wrt x(j)
    numer = (conj(d)/abs(d))*w'*B{j}*v; % for spectral abscissa, use w'*B{j}*v
    denom = w'*v;
    g(j) = real(numer/denom);
end

