function [A,B] = dampedLinOsc(x,pars)
%
% damped linear oscillator 
% see Burke, Lewis, Overton, Optimizing Matrix Stability 
% Proceedings of the American Mathematical Society 129 (2001), pp. 1635-1642.
% Just one variable: A(x) has a double eigenvalue with a Jordan block at
% the minimizer x=2
% input pars is not used here, but it can be used in more complicated
% examples to pass other information
%
A = [0 1; -1 -x];
B{1} = [0 0; 0 -1]; % derivative of A(x) wrt the single variable x
