function [A,B] = bloAMS(x,pars)
%
% example from Section 2 of Burke, Lewis, Overton, Optimizing Matrix Stability 
% Proceedings of the American Mathematical Society 129 (2001), pp. 1635-1642.
% The matrix has order n and the number of variables is n-1: 
% A(x) has a multiple eigenvalue with a Jordan block of order n at
% the minimizer x1=...=x_n-1 = 0
% input pars is not used here, but it can be used in more complicated
% examples to pass other information
%
n = pars.n;
% the matrix A is
% [-x(1)  1  0 0 ....0]
% [ x(1)  0  1 0 ... 0]
%              ...
% [x(n-2) 0 ........ 1]
% [x(n-1) 0 .........0]
A = diag(ones(n-1,1),1); % Jordan block of size n
A(1,1) = -x(1);
for j=2:n
    A(j,1) = x(j-1);
end
%
% derivatives of A(x) wrt x_1,...,x_n-1
%
for j=2:n
    B{j-1} = zeros(n,n);
    B{j-1}(j,1) = 1;
end
B{1}(1,1) = -1;  % do not put this before loop, as B{1} is set to zero in loop
