function [x, f, g, dnorm, X, G, w] = gradsamp1run(x0, f0, g0, pars, options);
% repeatedly run gradient sampling minimization, for various sampling radii
% return info only from final sampling radius
% intended to be called by gradsamp only
samprad = options.samprad;
cpufinish = cputime + options.cpumax;
for choice = 1:length(samprad)
    options.cpumax = cpufinish - cputime; % time left
    [x, f, g, dnorm, X, G, w, quitall] = ...
        gradsampfixed(x0, f0, g0, samprad(choice), pars, options);
    if quitall % terminate early
        return  
    end
    % get ready for next run, with lower sampling radius
    x0 = x;   % start from where previous one finished,
                           % because this is lowest function value so far
    f0 = f;
    g0 = g;
end
