function [xbundle, gbundle] = getbundle(x, g, samprad, N, pars);
%  get bundle of N-1 gradients at points near x, in addition to g,
%  which is gradient at x and goes in first column
%  intended to be called by gradsampfixed

m = length(x);
xbundle(:,1) = x;
gbundle(:,1) = g;
for k = 2:N  % note the 2
   xpert = x + samprad*(rand(m,1) - 0.5); % uniform distribution
   [f,grad] = feval(pars.fgname, xpert, pars);
   while f == inf  % disallow infinite function values
       xpert = (x + xpert)/2;     % contract back until feasible
       [f,grad] = feval(pars.fgname, xpert, pars);
   end; % discard function values
   xbundle(:,k) = xpert;
   gbundle(:,k) = grad;   
end
