function runRandomExamples(n, N, randomtype)
% test affpolymin for degree n on N randomly generated problems
%  randomtype = 0: take b from uniform distribution (positive)
%  randomtype = 1: take b from normal distribution (mixed signs)
%
% residuals are enormous if n > 10, and even for smaller n especially in
% the abscissa case, when roots can have large modulus and hence
% coefficients can be enormous
%
%  If this code terminates with a keyboard prompt, please save the data
%  and send it to Michael Overton, overton@cs.nyu.edu
%  with subject header containing the string "affpolymin".
%  Version 1.0, 2010, see GPL license info below.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  AFFPOLYMIN 1.0 Copyright (C) 2010  Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin < 3
    randomtype = 1; % normal distribution
end
for j=1:N
    if randomtype
        b = randn(1, n+1);
    else
        b = rand(1, n+1);
    end
    % real radius
    fprintf('Test %d, real radius\n',j)
    [optroot, c, k, M, allroots] = affpolymin(b,1);
    k
    if ~isnan(M)
        fprintf('why is M not NaN in real radius case?')
        keyboard
    end
    optroot
    coeffmax = max(abs(c));
    roots_c = roots(c)
    resid = sum(b.*c)
    if norm(imag(allroots)) > 0
        fprintf('why does allroots include complex roots')
        keyboard
    end
    if abs(optroot) ~= min(abs(allroots))
        fprintf('why is abs(optroot) is not min of abs of allroots?\n')
        keyboard
    end
    fprintf('hit any key to continue\n')
    pause
    fprintf('Test %d, real abscissa\n',j)
    [optroot, c, k, M, allroots] = affpolymin(b,0); 
    k
    M
    optroot
    coeffmax = max(abs(c));
    roots_c = roots(c)
    resid = sum(b.*c)
    if norm(imag(allroots)) > 0
        fprintf('why does allroots include complex roots')
        keyboard
    end
    if -optroot ~= max(allroots)
        fprintf('why is -optroot is not max of allroots?\n')
        keyboard
    end
    fprintf('hit any key to continue\n')
    pause
    if randomtype
        b = b + i*randn(1, n+1);
    else
        b = b + i*rand(1, n+1);
    end
    fprintf('Test %d, complex radius\n', j)
    [optroot, c, k, M, allroots] = affpolymin(b,1);
    optroot
    coeffmax = max(abs(c));
    roots_c = roots(c)
    resid = sum(b.*c)
    if k > 0
        fprintf('why is k > 0 in complex case?\n')
        keyboard
    end
    if ~isnan(M)
        fprintf('why is M not NaN in complex case?')
        keyboard
    end
    if abs(optroot) ~= min(abs(allroots))
        fprintf('why is abs(optroot) is not min of abs(allroots)?\n')
        keyboard
    end
    fprintf('hit any key to continue\n')
    pause
    fprintf('Test %d, complex abscissa\n',j)
    [optroot, c, k, M, allroots] = affpolymin(b,0);
    optroot
    coeffmax = max(abs(c));
    roots_c = roots(c)
    resid = sum(b.*c)
    if k > 0
        fprintf('why is k > 0 in complex case?\n')
        keyboard
    end
    if real(-optroot) ~= max(real(allroots))
        fprintf('why is real(-optroot) not max of real(allroots)?\n')
        keyboard
    end
    fprintf('hit any key to continue\n')
    pause
end