function v = convolvebinomials(n1,n2)
% Consider the equation
% p(s) = s^n + c_1 s^n-1 + ... + c_n
%      = (s + z)^n1 + (s - z)^n2
%      = (s^n1 + n1 z s^n1-1 + ... + z^n1)(s^n2 - n2 z s^n2-1 + ... +/- z^n2)
%      = s^n + (n1 - n2) z s^n-1 + 
%         + ((n1 choose 2) - n1 n2 + (n2 choose 2)) z^2 s^n-2 + ...
%      = s^n + v_1 z s^n-1 + v_2 z^2 s^n-2 + ...
% Return the v_j, a convolution of the two vectors
% of binomial coefficients.
% In the special case n2=0, v_j+1 = nchoosek(n1,j)
%  Send comments or bug reports to Michael Overton, overton@cs.nyu.edu,
%  with subject header containing the string "affpolymin".
%  Version 1.0, 2010, see GPL license info below.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  AFFPOLYMIN 1.0 Copyright (C) 2010  Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for j=0:n1
    V(j+1) = nchoosek(n1,j);
end
for j=0:n2
    W(j+1) = nchoosek(n2,j);
    if floor(j/2) ~= j/2
        W(j+1) = -W(j+1);
    end
end
v = conv(V,W);