classdef freecurvebox < box

    properties
        boxid           %id for creating a graph of boxes
        
        passesJaccobian = false;
        containsCurve = false;
        
        testresults = cell(0,1);
        inherittestindices = zeros(0,1);

        pnbr %principle neighbors: d*2 array of boxes
             %pnbr(i,:) contains the neighbors along dimension i where
             %pnbr(i,1) has the smaller coordinate

        edges %list of PV-edges
        faces %list of PV-faces
        plothandle %list of handles to all plotted features
    end

    methods
        function this = freecurvebox(varargin)
            %box(boxdimensions)
            this = this@box(varargin{:});
            %this.containscurve = false;
            %this.passesJaccobian = false;
        end
        function children = split(this)
            %check if the box was already split or if it is excluded by C0 anyway
            if ~isempty(this.children) || isempty(this.boxdimensions) || ...
               (~isempty(this.testresults{1}) && this.testresults{1}) || (~isempty(this.testresults{2}) && this.testresults{2})
                children = [];
                return
            end
            
            children = split@box(this);
            for i = 1:numel(this.children)
                this.children(i).inherittestindices = this.inherittestindices;
                this.children(i).testresults = cell(size(this.testresults));
                for j = 1:numel(this.inherittestindices)
                    if any(this.testresults{this.inherittestindices(j)})
                        this.children(i).testresults{this.inherittestindices(j)} = this.testresults{this.inherittestindices(j)};
                    end
                end
            end
            
            D = size(this.boxdimensions,1);
            d = D; %D-sum(this.length0);

            classtype = class(this);
            emptypnbr(d,2) = eval([classtype,'();']);
            for i = numel(this.children):-1:1
                this.children(i).pnbr = emptypnbr;
            end

            %%Update principle neighbors
            v     = ones(1, d);
            vLim = 2*ones(1,d);
            ready = false;
            while ~ready
                Index = arrayindexing.sub2indV(vLim, v);
                
                %Update principle neighbors among the children
                dind = 0;
                for i = 1:D
                    if ~this.length0(i)
                        dind = dind+1;
                        vnbr = v;
                        vnbr(dind) = 3-v(dind);
                        this.children(Index).pnbr(dind,3-v(dind)) = this.children(arrayindexing.sub2indV(vLim, vnbr));
                    end
                end
                
                %Update other principle neighbors of children
                dind = 0;
                for i = 1:D
                    if ~this.length0(i)
                        dind = dind+1;
                        if ~isempty(this.pnbr) && ~isempty(this.pnbr(dind,v(dind)).boxdimensions)
                            if isempty(this.pnbr(dind,v(dind)).children) %before: this.pnbr(dind,v(dind)).depth == this.depth
                                this.children(Index).pnbr(dind,v(dind)) = this.pnbr(dind,v(dind));
                            else
                                vnbr = v;
                                vnbr(dind) = 3-v(dind);
                                Indexnbr = arrayindexing.sub2indV(vLim, vnbr);
                                if ~isempty(this.pnbr(dind,v(dind)).children(Indexnbr))
                                    this.children(Index).pnbr(dind,v(dind)) = this.pnbr(dind,v(dind)).children(Indexnbr);
                                    %Update neighboring boxes' principle neighbor
                                    this.pnbr(dind,v(dind)).children(Indexnbr).pnbr(dind,vnbr(dind)) = this.children(Index);
                                end
                            end
                        end
                    end
                end
                
                [v,ready] = arrayindexing.updateindexvec(v,vLim);
            end
            children = this.children(:)';
            
            %Remove plotted objects
            this.edges = []; 
            this.faces = []; 
            this.plothandle = [];
        end
        
        function markcurve(this)
            if this.passesJaccobian && ~this.containsCurve
                this.containsCurve = true;
                for i = 1:numel(this.children)
                    this.children(i).passesJaccobian = true;
                    this.children(i).markcurve();
                end
                
                if this.depth > 0
                    this.parent.markcurve();
                end
            end
        end
        function jacroot = getjacroot(this)
            if this.depth > 0 && this.parent.passesJaccobian
                jacroot = this.parent.getjacroot();
            else
                jacroot = this;
            end
        end

        function Q = directionsubboxes(this,direction)
            %direction, given as basis vector (0,0,...,0,1 or 2,0,...,0) 
            if isempty(this.children)
                Q = this;
            else
                dirind = find(direction);
                reduceddirind = dirind-sum(this.length0(1:dirind));
                shiftedchildren = shiftdim(this.children,reduceddirind);
                Q = reshape(shiftedchildren,[],2);
                Q = Q(:,direction(dirind))';
            end
        end
        function Q = neighborsdirection(this,direction)
            %returns a list of all neighbors in direction, given as basis vector (0,0,...,0,1 or 2,0,...,0) 
            dind = find(direction);
            if ~isempty(this.pnbr) && ~isempty(this.pnbr(dind,direction(dind)).boxdimensions)
                oppositedirection = direction;
                oppositedirection(dind) = 3-direction(dind);
                Q = this.pnbr(dind,direction(dind)).directionsubboxes(oppositedirection);  
            else
                Q = [];
            end
        end
        function Q = neighbors(this)
            D = size(this.boxdimensions,1);
            d = D-sum(this.length0);
            Q = [];
            for i = 1:d
                for j = 1:2
                    direction = zeros(1,D);
                    inds = find(~this.length0);
                    direction(inds(i)) = j;
                    Q = [Q,this.neighborsdirection(direction)];
                end
            end
        end

        function delete(this)
            if ~isempty(this.children)
                while ~isempty(this.children)
                    this.children(1).delete;
                    this.children(1) = [];
                end
            end
            for i = numel(this.pnbr):-1:1
                if isvalid(this.pnbr(i)) && ~isempty(this.pnbr(i))
                    this.pnbr(i).pnbr = [];
                end
            end
            this.pnbr = [];
            if ~isempty(this.parent)
                this.parent = [];
            end
        end
    end
end