classdef funmanipulation
%Tips for manipulating functions:
%https://www.mathworks.com/company/newsletters/articles/tips-and-tricks-combining-functions-using-anonymous-functions.html
    methods(Static)
        function result = splitxyzapply(fun,varargin)
            %If the input is a box or an interval vector, 
            % then this function splits the input into its x,y,z components
            %If the input is already split, then this function plugs the input into function fun

            if length(varargin) == 1 %input is either a box or an interval vector
                input = varargin{1};
                if isa(input,'box')
                    %convert the box into an interval vector
                    input = input.interval;
                end
                C = num2cell(input');
                result = fun(C{:});
            else %input is split in x,y and z components
                result = fun(varargin{:});
            end
        end
        function testsplitcomponents
            B = box([1,2;3,4;5,6]);
            I = B.interval;
            f = @(x,y,z) x.^2+y-z;
            comp = @funmanipulation.splitxyz;
            [x,y,z] = comp(B);
            disp(f(x,y,z));
            [x,y,z] = comp(I);
            disp(f(x,y,z));
            [x,y,z] = comp(x,y,z);
            disp(f(x,y,z));
        end
        %Is it possible to use the following function in order to compose with a function f(x,y,z)?
%         function [X,Y,Z] = splitxyz(fun,varargin)
%             %If the input is a box or an interval vector, 
%             % then this function splits the input into its x,y,z components
%             %If the input is already split, then this function returns the input
%             if length(varargin) == 1 %input is either a box or an interval vector
%                 input = varargin{1};
%                 if isa(input,'box')
%                     %convert the box into an interval vector
%                     input = input.interval;
%                 end
%                 C = num2cell(input');
%                 [X,Y,Z] = C{:};
%             else %input is split in x,y and z components
%                 [X,Y,Z] = varargin{:};
%             end
%         end
        function varargout = boxfunction(varargin)
        %converts a regular Matlab function with input x,y,z
        %into one that can also take boxes as well as interval vectors as input.
        %It can convert multiple functions at the same time: [fout,gout] = boxfunction(f,g)
            n = length(varargin);
            varargout = cell(1,n);
            for i = 1:n
                fun_orig = varargin{i};
                varargout{i} = @(varargin) funmanipulation.splitxyzapply(fun_orig,varargin{:});
            end
        end
        function Bint = convert2vec(varargin)
            %If the input is split in x,y,z components, 
            % then this function merges these into a vector
            %If the input is a box, then it outputs and interval vector
            %Otherwise do nothing
            if length(varargin) == 3 %input is split in x,y,z components
                Bint = [varargin{1};varargin{2};varargin{3}];
            elseif length(varargin) == 1 && isa(varargin{1},'box')
                Bint = varargin{1}.interval;
            else
                Bint = varargin{1};
            end
        end
    end
end