function B = evsumdiv(R,Evsum,blk)
% EVSUMDIV  divides R entrywise by Evsum
%
% B = evsumdiv(R,Evsum,blk)
%
% input variables:
%     - R         an nxn block diagonal matrix
%     - Evsum     an nxn block diagonal matrix
%     - blk       block structure vector
%
% output variables:
%     - B         an nxn block diagonal matrix equal to R ./ Evsum blockwise

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 3/24/97
%
 nblk = length(blk);
 n = sum(blk);
 if nblk > 1,
    B = sparse(n,n);
 else,
    B = zeros(n,n);
 end;
%
 if (size(R) ~= [n n]) | (size(Evsum) ~= [n n]),
    error('evsumdiv: input improperly dimensioned!');
 end;
%
 start = 1;  fin = 0;
 for i=1:nblk,
    bsize = blk(i);
    fin = fin + bsize;
    B(start:fin,start:fin) = R(start:fin,start:fin) ./ Evsum(start:fin,start:fin);
    start = start + bsize;
 end;
%
% END function
