function M = SDSchur(A,X,Zeigvec,Evsum,blk,nolyapsol)
% SDSCHUR   construct Schur complement for the SDP system
%
% M = SDSchur(A,X,Zeigvec,Evsum,blk)
%
% input variables:
%     - A         the constraint matrix
%     - X         a symmetric block diagonal matrix
%     - Zeigvec   eigenvectors of dual slack
%     - Evsum     sums of pairs of eigenvalues of dual slack
%     - blk       block structure vector
%
% output variables:
%     - M         the Schur complement

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 4/20/97
%
 [m,sumblk2] = size(A);
 nblk = length(blk);
 B = zeros(sumblk2,m);
 for k=1:m,
    Ak = smat(A(k,:),blk);  % the matrix Ak is the kth row of A
    rhsk = X*Ak;
    rhsk = rhsk + rhsk';
    if nblk == 1 | nolyapsol
       rhsk = Zeigvec'*rhsk*Zeigvec;
       rhsk = Zeigvec*evsumdiv(rhsk,Evsum,blk)*Zeigvec';
    else
       rhsk = lyapsol(rhsk,Zeigvec,Evsum,blk);
    end
    B(:,k) = svec(rhsk,blk);
 end;
 M = A*B;   % NOT symmetric
%
% END function
