% LRND  sets up an SDP to compute the Lovasz theta function of
%       a random graph with n vertices and an expected density
%       of edges equal to dsty
%
%   Creates a list of edges in the matrix G, where G(k,1) = p,
%   G(k,2) = q, if the k-th edge of the graph joins vertices p and
%   q.  Also creates w, vector of vertex weights.
%
%   Note: C = -sqrt(w w^T), b = [0 ... 0 1] where length(b) = m =
%   1 + (# of vertices of graph), and
%           A_k = e_p e_q^T + e_q e_p^T,  1 <= k <= m-1
%   if G(k,1) = p, G(k,2) = q, and
%           A_m = eye(n).
%
% The following variables must be available in Matlab workspace:
%    - n      number of vertices in the graph
%    - dsty   expected edge density

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 6/8/97

% fist construct the adjacency matrix of a random undirected
% graph having n vertices and dsty*[n(n-1)/2] expected number of
% edges (no self-loops)
%
 Adj = sprandsym(n,dsty);   % a random sparse symmetric matrix with
 Adj = spones(Adj);         % about dsty percentage of 1's
%
% is this graph really connected?
%
 Aold = Adj + eye(n);
 Anew = Aold*Aold;
 Anew = (Anew > 0);
 while sum(sum(abs(Anew-Aold))) ~= 0
    Aold = Anew;
    Anew = Anew*Anew;
    Anew = (Anew > 0);
 end
 if ~isempty(find(Anew == 0))
    fprintf('lrnd: Graph not connected!  Proceeding anyway.\n\n');
 end
%
 [I,J] = find(Adj);         % row and column indices of nonzeros
 K = I<J;                   % only want the strictly lower triangular part
 G = [I(K) J(K)];           % list of edges
 e = size(G,1);             % # of nonzeros = # of edges
 w = rand(n,1);             % random vertex weights
%
 clear Anew Aold Adj I J K e;
