% RNDFEAS   creates random block diagonal SDP problems with a
%           feasible starting point (X,y,Z)
%
% The following variables must be available in the Matlab workspace:
%    - blk      block structure vector
%    - m        number of constraints
%

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 n = sum(blk);
 n2 = (sum(blk .* (blk+1)))/2;
 A = zeros(m,n2);     % the rows of A hold the vector form of the
                      % matrices Ak, 1 <= k <= m
%
% set up the matrices Ak
%
 for i = 1:m,
   A(i,:) = svec(brandsym(blk),blk)';  % a full vector
 end;
%
% set the matrix C, chosen positive definite so it is
% easy to find a feasible starting point (X,y,Z)
%
 C = brandpos(blk);  % sparse matrix if # blocks > 1
%
% set up (y,Z) dual feasible
%
 Z = C;
 y = zeros(m,1);
%
% now set up X
%
 X = brandpos(blk);  % sparse matrix if # blocks > 1
%
% finally the vector b so that X is primal feasible
%
 b = A*svec(X,blk);
