function [dX,dy,dZ] = sdpsol(X,A,Q,Evsum,Rd,rp,Rc,Lfac,Ufac,Perm,blk)
% SDPSOL  computes the solution of the 3x3 block linear system
%         for SDP using Schur complement.
%
% [dX,dy,dZ] = sdpsol(X,A,Q,Evsum,Rd,rp,Rc,Lfac,Ufac,Perm,blk)
%
%  input variables
%     - X         the primal variable
%     - A         matrix of primal constraints
%     - Q         the orthogonal matrix of eigenvectors of the dual slack Z
%     - Evsum     the matrix of eigenvalue sums of the dual slack Z
%     - Rd        the dual residual
%     - rp        the primal residual
%     - Rc        the centrality residual
%     - Lfac      the L factor from the LU factorization of the Schur complement
%     - Ufac      the U factor from the LU factorization of the Schur complement
%     - Perm      the permutation matrix for the LU factorization of the Schur complement
%     - blk       block structure vector
%
%  output variables
%     - dX        the primal step
%     - dy        the y component of the dual step
%     - dZ        the slack component of the dual step

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 rhs1 = X*Rd;
 rhs1 = rhs1 + rhs1' - Rc; % essential to compute right-hand side in this
                           % way: cannot cancel terms (see AHO section 5)
 rhs1 = Q'*rhs1*Q;
 tmp = Q*evsumdiv(rhs1,Evsum,blk)*Q';
 yrhs = rp + A*svec(tmp,blk);
 dy = Ufac\(Lfac\(Perm*yrhs));
 dZ = Rd - smat(A'*dy,blk);
 Xrhs = X*dZ;
 Xrhs = Rc - (Xrhs + Xrhs');
 Xrhs = Q'*Xrhs*Q;
 dX = Q*evsumdiv(Xrhs,Evsum,blk)*Q';
%
% END function
