% MAKEA  given nxn matrices A1,...,Am, with block structure blk,
%        construct a matrix A of size m by n(n+1)/2 whose rows
%        are the vector versions of the Ak
%
% The following variables must be available in the Matlab workspace:
%    - m          number of primal constraints
%    - blk        block structure vector
%    - A1,A2,...

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 sumblk2 = sum(blk .* (1+blk))/2;
 A = zeros(m,sumblk2);
 sparseblocks = 0;
 for k = 1:m,
    eval(['Ak = A',int2str(k),';']);
    if Ak ~= Ak',
       fprintf('%3.0d - th component matrix not symmetric:  symmetrized\n');
       Ak = 0.5*(Ak + Ak');
    end;
    if ~sparseblocks,
       if issparse(Ak),
          sparseblocks = 1;
          A = sparse(A);
       end;
    end;
    A(k,:) = svec(Ak,blk)';
 end;
