% Convert a block diagonal SDP in SDPPACK's notation to a form
% that can be used with the SDPA software by Kojima et al.
%
% Requires the following to be defined:
% A - constraint matrix
% b - rhs of constraints
% C - cost matrix
% blk - vector containing block sizes
% outfile - string denoting file to which new format should be written 
%
% Notation:
% SDPA assumes that the primal is a max formulation 
% for details.  This results in the following conversion.
%
% SDPPACK               SDPA
%------------------------------------
% b                     -c
% A_{k}                 -F_{k}
% C                     -F_{0}
% 
%

fp = fopen(outfile, 'w');

% Write m, # of blocks and blk vector

nblk = length(blk);
m = size(A,1);
fprintf(fp, '%d = mDIM \n%d = nBLOCK \n', m, nblk);
for i=1:nblk
   fprintf(fp, '%d ', blk(i));
end;
fprintf(fp, '= bLOCKsTRUCT \n{');

% Write rhs of constraints, b

for i=1:m-1
   fprintf(fp, '%f, ', -b(i));
end;
fprintf(fp, '%f}\n', -b(m));

% Write cost matrix

fprintf(fp, '{\n');
start = 0;
for j=1:nblk   % loop through blocks of C
   fprintf(fp, '   {\n');
   for k=1:blk(j)   % loop through rows of this block
      fprintf(fp, '      {');
      row = start + k;
      for l=1:blk(j)-1   % loop through columns of this block
         fprintf(fp, '%f, ', -C(row, start+l));
      end;   % l-loop
      fprintf(fp, '%f}', -C(row, start+blk(j)));
      if k ~= blk(j) fprintf(fp, ',\n'); end;
   end;   % k-loop
   fprintf(fp, '   }\n');
   start = start + blk(j);
end;   % j-loop
fprintf(fp, '}\n');   % this matrix is done

% Write constraint matrices

for i=1:m   % loop through constraint matrices
   fprintf(fp, '{\n');
   this_A = smat(A(i,:), blk);
   start = 0;
   for j=1:nblk   % loop through blocks in each matrix
      fprintf(fp, '   {\n');
      for k=1:blk(j)   % loop through rows of this block
         fprintf(fp, '      {');
         row = start + k;
         for l=1:blk(j)-1   % loop through columns of this block
            fprintf(fp, '%f, ', -this_A(row, start+l));
         end;   % l-loop
         fprintf(fp, '%f}', -this_A(row, start+blk(j)));
         if k ~= blk(j) fprintf(fp, ',\n'); end;
      end;   % k-loop
      fprintf(fp, '   }\n');
      start = start + blk(j);
   end;   % j-loop
   fprintf(fp, '}\n');   % this matrix is done
end;   % i-loop

clear this_A;
fprintf('Done...Result saved in %s\n', outfile);
fclose(fp);

% end script
