function M = randpos(n);
% RANDPOS   creates a random symmetric positive definite nxn matrix
%
% M = randpos(n)
%
% input variables:
%  - n            size of matrix
%
% output variables:
%  - M            a positive definite symmetric nxn matrix


% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 M = randsym(n);
 [Q,D] = eig(M);
 D = diag(rand(n,1));
 M = Q*D*Q';
 M = 0.5*(M + M');
%
% END function
