/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * USER DEFINED HEADERS
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <linux/videodev.h>
static int depths[] = { -1, 1, 2, 2, 3, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 };

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"
/*
 * USER DEFINED HEADERS
 */
#define RGBSATURATE(x) (unsigned char)( (x<0)? 0 : ( (x>255)? 255 : x))

/*
 * DECLARATIONS
 */
extern_c struct VClass_object Vt_object;
struct CClass_object;
struct CClass_v4ldevice
{
  struct VClass_v4ldevice *Vtbl;
  int fd;
  int width;
  int height;
  int frame;
  int depth;
  int nframe;
  gptr buffer;
  int buffersize;
  int currentformat;
  gptr framebuffer;
  int cap_channels;
  int cap_audios;
  int cap_maxwidth;
  int cap_maxheight;
  int cap_minwidth;
  int cap_minheight;
  struct video_capability *capability;
  struct video_channel *channel;
  struct video_tuner *tuner;
  struct video_capture *capture;
  struct video_picture *picture;
  struct video_mmap *mmapinfo;
  struct video_mbuf *mbuffer;
};
struct VClass_v4ldevice
{
  void *Cdoc;
  void (*Cdestroy) (gptr);
  char (*M_cleanup) (struct CClass_v4ldevice *);
    real (*M_set_format) (struct CClass_v4ldevice *, int, int, int);
  char (*M_v4ldevice) (struct CClass_v4ldevice *, struct srg *, struct srg *,
		       int, int, int);
  int (*M_adjust) (struct CClass_v4ldevice *, int, int, int, int, int);
  int (*M_tune) (struct CClass_v4ldevice *, int);
  char (*M__destructor) (struct CClass_v4ldevice *);
    real (*M_grab) (struct CClass_v4ldevice *);
    real (*M_grab_rgb24_into_rgbx) (struct CClass_v4ldevice *, struct idx *);
    real (*M_grab_rgb32_into_rgbx) (struct CClass_v4ldevice *, struct idx *);
    real (*M_grab_rgb24_into_rgba) (struct CClass_v4ldevice *, struct idx *,
				    int);
    real (*M_grab_rgb32_into_rgba) (struct CClass_v4ldevice *, struct idx *,
				    int);
    real (*M_grab_yuv422_into_yuv422) (struct CClass_v4ldevice *,
				       struct idx *);
    real (*M_grab_yuv420p_into_rgbx) (struct CClass_v4ldevice *,
				      struct idx *);
    real (*M_grab_yuv420p_into_rgba) (struct CClass_v4ldevice *, struct idx *,
				      int);
    real (*M_grab_yuv420p_into_yuv) (struct CClass_v4ldevice *, struct idx *);
    real (*M_grab_grey_into_y) (struct CClass_v4ldevice *, struct idx *);
    real (*M_grab_into_rgb) (struct CClass_v4ldevice *, struct idx *);
    real (*M_grab_into_rgbx) (struct CClass_v4ldevice *, struct idx *);
    real (*M_grab_into_rgba) (struct CClass_v4ldevice *, struct idx *, int);
  struct idx *(*M_record_into_rgb) (struct CClass_v4ldevice *, struct idx *,
				    int);
    real (*M_grab_rgb24_acc_rgbx) (struct CClass_v4ldevice *, struct idx *);
    real (*M_grab_rgb24_acc_rgba) (struct CClass_v4ldevice *, struct idx *,
				   int);
};
extern_c struct VClass_v4ldevice Vt_v4ldevice;
extern_c char C_cleanup_C_v4ldevice (struct CClass_v4ldevice *);
extern_c real C_set_format_C_v4ldevice (struct CClass_v4ldevice *, int, int,
					int);
extern_c char C_v4ldevice_C_v4ldevice (struct CClass_v4ldevice *,
				       struct srg *, struct srg *, int, int,
				       int);
extern_c int C_adjust_C_v4ldevice (struct CClass_v4ldevice *, int, int, int,
				   int, int);
extern_c int C_tune_C_v4ldevice (struct CClass_v4ldevice *, int);
extern_c char C__destructor_C_v4ldevice (struct CClass_v4ldevice *);
extern_c real C_grab_C_v4ldevice (struct CClass_v4ldevice *);
extern_c real C_grab_rgb24_into_rgbx_C_v4ldevice (struct CClass_v4ldevice *,
						  struct idx *);
extern_c real C_grab_rgb32_into_rgbx_C_v4ldevice (struct CClass_v4ldevice *,
						  struct idx *);
extern_c real C_grab_rgb24_into_rgba_C_v4ldevice (struct CClass_v4ldevice *,
						  struct idx *, int);
extern_c real C_grab_rgb32_into_rgba_C_v4ldevice (struct CClass_v4ldevice *,
						  struct idx *, int);
extern_c real C_grab_yuv422_into_yuv422_C_v4ldevice (struct CClass_v4ldevice
						     *, struct idx *);
extern_c real C_grab_yuv420p_into_rgbx_C_v4ldevice (struct CClass_v4ldevice *,
						    struct idx *);
extern_c real C_grab_yuv420p_into_rgba_C_v4ldevice (struct CClass_v4ldevice *,
						    struct idx *, int);
extern_c real C_grab_yuv420p_into_yuv_C_v4ldevice (struct CClass_v4ldevice *,
						   struct idx *);
extern_c real C_grab_grey_into_y_C_v4ldevice (struct CClass_v4ldevice *,
					      struct idx *);
extern_c real C_grab_into_rgb_C_v4ldevice (struct CClass_v4ldevice *,
					   struct idx *);
extern_c real C_grab_into_rgbx_C_v4ldevice (struct CClass_v4ldevice *,
					    struct idx *);
extern_c real C_grab_into_rgba_C_v4ldevice (struct CClass_v4ldevice *,
					    struct idx *, int);
extern_c struct idx *C_record_into_rgb_C_v4ldevice (struct CClass_v4ldevice *,
						    struct idx *, int);
extern_c real C_grab_rgb24_acc_rgbx_C_v4ldevice (struct CClass_v4ldevice *,
						 struct idx *);
extern_c real C_grab_rgb24_acc_rgba_C_v4ldevice (struct CClass_v4ldevice *,
						 struct idx *, int);

/* ---------------------------------------- */

/*
 * FUNCTION v4l-dummy
 */
extern_c char
C_v4l_dummy ()
{
  TRACE_PUSH ("C_v4l_dummy");
  {
    TRACE_POP ("C_v4l_dummy");
    return 0;
  }
}

/*
 * METHOD FUNCTION cleanup (class v4ldevice)
 */
extern_c char
C_cleanup_C_v4ldevice (struct CClass_v4ldevice *L1_this)
{
  TRACE_PUSH ("C_cleanup_C_v4ldevice");
  {
    if (L1_this->buffer)
      {
	munmap ((L1_this->buffer), (L1_this->mbuffer)->size);
      }
    if ((L1_this->fd > 0))
      {
	close ((L1_this->fd));
      }
    if (L1_this->capability)
      {
	free ((L1_this->capability));
      }
    if (L1_this->channel)
      {
	free ((L1_this->channel));
      }
    if (L1_this->capture)
      {
	free ((L1_this->capture));
      }
    if (L1_this->capture)
      {
	free ((L1_this->tuner));
      }
    if (L1_this->picture)
      {
	free ((L1_this->picture));
      }
    if (L1_this->mmapinfo)
      {
	free ((L1_this->mmapinfo));
      }
    if (L1_this->mbuffer)
      {
	free ((L1_this->mbuffer));
      }
    TRACE_POP ("C_cleanup_C_v4ldevice");
    return 0;
  }
}

/*
 * METHOD FUNCTION set-format (class v4ldevice)
 */
extern_c real
C_set_format_C_v4ldevice (struct CClass_v4ldevice * L1_this, int L1_f,
			  int L1_w, int L1_h)
{
  TRACE_PUSH ("C_set_format_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if ((L1_w > L1_this->cap_maxwidth))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if ((L1_h > L1_this->cap_maxheight))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if ((L1_w < L1_this->cap_minwidth))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		if ((L1_h < L1_this->cap_minheight))
		  {
		    L_Tmp1 = 1;
		  }
		else
		  {
		    if ((L1_f < 1))
		      {
			L_Tmp1 = 1;
		      }
		    else
		      {
			if ((L1_f > 16))
			  {
			    L_Tmp1 = 1;
			  }
			else
			  {
			    L_Tmp1 = 0;
			  }
		      }
		  }
	      }
	  }
      }
    if (L_Tmp1)
      {
	L_Tmp0 = -1;
      }
    else
      {
	{
	  int L2_2_retcode;
	  L2_2_retcode = 0;
	  {
	    int changedp = 0;
	    int code;
	    if (((L1_f) != (L1_this->mmapinfo)->format) ||
		((L1_w) != (L1_this->mmapinfo)->width) ||
		((L1_h) != (L1_this->mmapinfo)->height))
	      {
		changedp = 1;
		(L1_this->mmapinfo)->format = (L1_f);
		(L1_this->mmapinfo)->width = (L1_this->width) = (L1_w);
		(L1_this->mmapinfo)->height = (L1_this->height) = (L1_h);
		(L1_this->depth) = depths[(L1_f)];
		/* now grab a couple of frames to clear
		   the buffer from inapropriately formated frames */
		for ((L1_this->frame) = 0;
		     (L1_this->frame) < (L1_this->nframe); (L1_this->frame)++)
		  {
		    (L1_this->mmapinfo)->frame = (L1_this->frame);
		    (L2_2_retcode) =
		      ioctl ((L1_this->fd), VIDIOCMCAPTURE,
			     (L1_this->mmapinfo));
		    code =
		      ioctl ((L1_this->fd), VIDIOCSYNC, &((L1_this->frame)));
		  }
		(L1_this->mmapinfo)->frame = (L1_this->frame) = 0;
	      }
	  }
	  L_Tmp0 = L2_2_retcode;
	}
      }
    TRACE_POP ("C_set_format_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION v4ldevice (class v4ldevice)
 */
extern_c char
C_v4ldevice_C_v4ldevice (struct CClass_v4ldevice *L1_this,
			 struct srg *L1_devname, struct srg *L1_n, int L1_c,
			 int L1_w, int L1_h)
{
  TRACE_PUSH ("C_v4ldevice_C_v4ldevice");
  {
    char L_Tmp0;
    L1_this->width = L1_w;
    L1_this->height = L1_h;
    L1_this->capability =
      (struct video_capability
       *) ((gptr) (malloc (sizeof (struct video_capability))));
    L1_this->channel =
      (struct video_channel
       *) ((gptr) (malloc (sizeof (struct video_channel))));
    L1_this->tuner =
      (struct video_tuner *) ((gptr) (malloc (sizeof (struct video_tuner))));
    L1_this->capture =
      (struct video_capture
       *) ((gptr) (malloc (sizeof (struct video_capture))));
    L1_this->picture =
      (struct video_picture
       *) ((gptr) (malloc (sizeof (struct video_picture))));
    L1_this->mmapinfo =
      (struct video_mmap *) ((gptr) (calloc (sizeof (struct video_mmap), 1)));
    L1_this->mbuffer =
      (struct video_mbuf *) ((gptr) (malloc (sizeof (struct video_mbuf))));
    {
      int L2_1_retcode;
      Msrg_declare (L2_2_7_srg);
      Msrg_declare (L2_3_8_srg);
      Msrg_declare (L2_4_9_srg);
      Msrg_declare (L2_5_10_srg);
      char L_Tmp12;
      Msrg_init (L2_2_7_srg, ST_U8);
      Msrg_init (L2_3_8_srg, ST_U8);
      Msrg_init (L2_4_9_srg, ST_U8);
      Msrg_init (L2_5_10_srg, ST_U8);
      L2_1_retcode = 0;
      L1_this->fd = open ((char *) ((L1_devname)->data), O_RDWR + O_NONBLOCK);
      L1_this->fd = ((int) floor ((double) L1_this->fd));
      if ((-1 == L1_this->fd))
	{
	  {
	    Msrg_declare (L3_6_0_srg);
	    struct srg *L3_7__info;
	    Msrg_declare (L3_8_1_srg);
	    Msrg_init (L3_6_0_srg, ST_U8);
	    Msrg_init (L3_8_1_srg, ST_U8);
	    Msrg_resize (L3_6_0_srg, 0 + 1);
	    strcpy ((char *) ((L3_6_0_srg)->data), "");
	    L3_7__info = L3_6_0_srg;
	    Msrg_resize (L3_8_1_srg, 0 + 1);
	    strcpy ((char *) ((L3_8_1_srg)->data), "");
	    if ((strcmp ((L3_7__info)->data, (L3_8_1_srg)->data) != 0))
	      {
		printf ("%s\n", (char *) ((L3_7__info)->data));
	      }
	    (L1_this)->Vtbl->M_cleanup (L1_this);
	    run_time_error ("could not open V4L video device ");
	    Msrg_free (L3_6_0_srg);
	    Msrg_free (L3_8_1_srg);
	  }
	}
      (L2_1_retcode) =
	ioctl ((L1_this->fd), VIDIOCGCAP, (L1_this->capability));
      if ((-1 == L2_1_retcode))
	{
	  {
	    Msrg_declare (L3_9_2_srg);
	    struct srg *L3_10__info;
	    Msrg_declare (L3_11_3_srg);
	    Msrg_init (L3_9_2_srg, ST_U8);
	    Msrg_init (L3_11_3_srg, ST_U8);
	    Msrg_resize (L3_9_2_srg, 0 + 1);
	    strcpy ((char *) ((L3_9_2_srg)->data), "");
	    L3_10__info = L3_9_2_srg;
	    Msrg_resize (L3_11_3_srg, 0 + 1);
	    strcpy ((char *) ((L3_11_3_srg)->data), "");
	    if ((strcmp ((L3_10__info)->data, (L3_11_3_srg)->data) != 0))
	      {
		printf ("%s\n", (char *) ((L3_10__info)->data));
	      }
	    (L1_this)->Vtbl->M_cleanup (L1_this);
	    run_time_error ("could not get V4L device capabilities");
	    Msrg_free (L3_9_2_srg);
	    Msrg_free (L3_11_3_srg);
	  }
	}
      L1_this->cap_channels = (L1_this->capability)->channels;
      L1_this->cap_channels = ((int) floor ((double) L1_this->cap_channels));
      L1_this->cap_audios = (L1_this->capability)->audios;
      L1_this->cap_audios = ((int) floor ((double) L1_this->cap_audios));
      L1_this->cap_maxwidth = (L1_this->capability)->maxwidth;
      L1_this->cap_maxwidth = ((int) floor ((double) L1_this->cap_maxwidth));
      L1_this->cap_maxheight = (L1_this->capability)->maxheight;
      L1_this->cap_maxheight =
	((int) floor ((double) L1_this->cap_maxheight));
      L1_this->cap_minwidth = (L1_this->capability)->minwidth;
      L1_this->cap_minwidth = ((int) floor ((double) L1_this->cap_minwidth));
      L1_this->cap_minheight = (L1_this->capability)->minheight;
      L1_this->cap_minheight =
	((int) floor ((double) L1_this->cap_minheight));
      if ((L1_this->width > L1_this->cap_maxwidth))
	{
	  L_Tmp12 = 1;
	}
      else
	{
	  if ((L1_this->height > L1_this->cap_maxheight))
	    {
	      L_Tmp12 = 1;
	    }
	  else
	    {
	      if ((L1_this->width < L1_this->cap_minwidth))
		{
		  L_Tmp12 = 1;
		}
	      else
		{
		  if ((L1_this->height < L1_this->cap_minheight))
		    {
		      L_Tmp12 = 1;
		    }
		  else
		    {
		      L_Tmp12 = 0;
		    }
		}
	    }
	}
      if (L_Tmp12)
	{
	  {
	    Msrg_declare (L3_13_4_srg);
	    struct srg *L3_14__info;
	    Msrg_declare (L3_15_5_srg);
	    Msrg_init (L3_13_4_srg, ST_U8);
	    Msrg_init (L3_15_5_srg, ST_U8);
	    {
	      char tempstr[1100];
	      int templen;
	      sprintf (tempstr,
		       "requested image size %dx%d out of bounds (%dx%d to %dx%d)",
		       L1_this->width, L1_this->height, L1_this->cap_minwidth,
		       L1_this->cap_minheight, L1_this->cap_maxwidth,
		       L1_this->cap_maxheight);
	      tempstr[sizeof (tempstr) - 1] = 0;
	      templen = strlen (tempstr);
	      if (templen >= sizeof (tempstr) - 1)
		run_time_error ("sprintf buffer full");
	      Msrg_resize (L3_13_4_srg, templen + 1);
	      strcpy ((char *) (L3_13_4_srg->data), tempstr);
	    }
	    L3_14__info = L3_13_4_srg;
	    Msrg_resize (L3_15_5_srg, 0 + 1);
	    strcpy ((char *) ((L3_15_5_srg)->data), "");
	    if ((strcmp ((L3_14__info)->data, (L3_15_5_srg)->data) != 0))
	      {
		printf ("%s\n", (char *) ((L3_14__info)->data));
	      }
	    (L1_this)->Vtbl->M_cleanup (L1_this);
	    run_time_error ("bad size argument");
	    Msrg_free (L3_13_4_srg);
	    Msrg_free (L3_15_5_srg);
	  }
	}
      if ((L1_c != -1))
	{
	  (L1_this->channel)->channel = (L1_c);
	  (L2_1_retcode) =
	    ioctl ((L1_this->fd), VIDIOCGCHAN, (L1_this->channel));
	  if ((-1 == L2_1_retcode))
	    {
	      {
		Msrg_declare (L3_16_6_srg);
		struct srg *L3_17__info;
		Msrg_init (L3_16_6_srg, ST_U8);
		Msrg_resize (L3_16_6_srg, 26 + 1);
		strcpy ((char *) ((L3_16_6_srg)->data),
			"could not get channel info");
		L3_17__info = L3_16_6_srg;
		printf ("v4l Warning: %s\n", (char *) ((L3_17__info)->data));
		Msrg_free (L3_16_6_srg);
	      }
	    }
	  Msrg_resize (L2_2_7_srg, 3 + 1);
	  strcpy ((char *) ((L2_2_7_srg)->data), "PAL");
	  if ((strcmp ((L2_2_7_srg)->data, (L1_n)->data) == 0))
	    {
	      (L1_this->channel)->norm = VIDEO_MODE_PAL;
	    }
	  else
	    {
	      Msrg_resize (L2_3_8_srg, 4 + 1);
	      strcpy ((char *) ((L2_3_8_srg)->data), "NTSC");
	      if ((strcmp ((L2_3_8_srg)->data, (L1_n)->data) == 0))
		{
		  (L1_this->channel)->norm = VIDEO_MODE_NTSC;
		}
	      else
		{
		  Msrg_resize (L2_4_9_srg, 5 + 1);
		  strcpy ((char *) ((L2_4_9_srg)->data), "SECAM");
		  if ((strcmp ((L2_4_9_srg)->data, (L1_n)->data) == 0))
		    {
		      (L1_this->channel)->norm = VIDEO_MODE_SECAM;
		    }
		  else
		    {
		      Msrg_resize (L2_5_10_srg, 4 + 1);
		      strcpy ((char *) ((L2_5_10_srg)->data), "AUTO");
		      if ((strcmp ((L2_5_10_srg)->data, (L1_n)->data) == 0))
			{
			  (L1_this->channel)->norm = VIDEO_MODE_AUTO;
			}
		      else
			{
			  if (1)
			    {
			      {
				Msrg_declare (L3_18_11_srg);
				struct srg *L3_19__info;
				Msrg_declare (L3_20_12_srg);
				Msrg_init (L3_18_11_srg, ST_U8);
				Msrg_init (L3_20_12_srg, ST_U8);
				Msrg_resize (L3_18_11_srg, 0 + 1);
				strcpy ((char *) ((L3_18_11_srg)->data), "");
				L3_19__info = L3_18_11_srg;
				Msrg_resize (L3_20_12_srg, 0 + 1);
				strcpy ((char *) ((L3_20_12_srg)->data), "");
				if ((strcmp
				     ((L3_19__info)->data,
				      (L3_20_12_srg)->data) != 0))
				  {
				    printf ("%s\n",
					    (char *) ((L3_19__info)->data));
				  }
				(L1_this)->Vtbl->M_cleanup (L1_this);
				run_time_error
				  ("unsupported video mode (must be NTSC, PAL, SECAM, or AUTO)");
				Msrg_free (L3_18_11_srg);
				Msrg_free (L3_20_12_srg);
			      }
			    }
			  else
			    {
			    }
			}
		    }
		}
	    }
	  (L2_1_retcode) =
	    ioctl ((L1_this->fd), VIDIOCSCHAN, (L1_this->channel));
	  if ((-1 == L2_1_retcode))
	    {
	      {
		Msrg_declare (L3_21_13_srg);
		struct srg *L3_22__info;
		Msrg_init (L3_21_13_srg, ST_U8);
		Msrg_resize (L3_21_13_srg, 21 + 1);
		strcpy ((char *) ((L3_21_13_srg)->data),
			"could not set channel");
		L3_22__info = L3_21_13_srg;
		printf ("v4l Warning: %s\n", (char *) ((L3_22__info)->data));
		Msrg_free (L3_21_13_srg);
	      }
	    }
	}
      (L2_1_retcode) = ioctl ((L1_this->fd), VIDIOCGMBUF, (L1_this->mbuffer));
      if ((-1 == L2_1_retcode))
	{
	  {
	    Msrg_declare (L3_23_14_srg);
	    struct srg *L3_24__info;
	    Msrg_declare (L3_25_15_srg);
	    Msrg_init (L3_23_14_srg, ST_U8);
	    Msrg_init (L3_25_15_srg, ST_U8);
	    Msrg_resize (L3_23_14_srg, 0 + 1);
	    strcpy ((char *) ((L3_23_14_srg)->data), "");
	    L3_24__info = L3_23_14_srg;
	    Msrg_resize (L3_25_15_srg, 0 + 1);
	    strcpy ((char *) ((L3_25_15_srg)->data), "");
	    if ((strcmp ((L3_24__info)->data, (L3_25_15_srg)->data) != 0))
	      {
		printf ("%s\n", (char *) ((L3_24__info)->data));
	      }
	    (L1_this)->Vtbl->M_cleanup (L1_this);
	    run_time_error ("could not get mbuffer info");
	    Msrg_free (L3_23_14_srg);
	    Msrg_free (L3_25_15_srg);
	  }
	}
      L1_this->buffer = (gptr) ((char *) mmap (NULL, (L1_this->mbuffer)->size,
					       PROT_READ + PROT_WRITE,
					       MAP_SHARED, (L1_this->fd), 0));
      {
	real L3_26_a;
	real L3_27_b;
	L3_26_a = 2;
	L3_27_b = (L1_this->mbuffer)->frames;
	L3_27_b = ((int) floor ((double) L3_27_b));
	if ((L3_26_a < L3_27_b))
	  {
	    L1_this->nframe = L3_26_a;
	  }
	else
	  {
	    L1_this->nframe = L3_27_b;
	  }
      }
      L1_this->buffersize = (L1_this->mbuffer)->size;
      L1_this->buffersize = ((int) floor ((double) L1_this->buffersize));
      L1_this->frame = 0;
      if ((L2_1_retcode < 0))
	{
	  {
	    Msrg_declare (L3_28_16_srg);
	    struct srg *L3_29__info;
	    Msrg_declare (L3_30_17_srg);
	    Msrg_init (L3_28_16_srg, ST_U8);
	    Msrg_init (L3_30_17_srg, ST_U8);
	    Msrg_resize (L3_28_16_srg, 0 + 1);
	    strcpy ((char *) ((L3_28_16_srg)->data), "");
	    L3_29__info = L3_28_16_srg;
	    Msrg_resize (L3_30_17_srg, 0 + 1);
	    strcpy ((char *) ((L3_30_17_srg)->data), "");
	    if ((strcmp ((L3_29__info)->data, (L3_30_17_srg)->data) != 0))
	      {
		printf ("%s\n", (char *) ((L3_29__info)->data));
	      }
	    (L1_this)->Vtbl->M_cleanup (L1_this);
	    run_time_error ("could not start grabbing frame 0");
	    Msrg_free (L3_28_16_srg);
	    Msrg_free (L3_30_17_srg);
	  }
	}
      L_Tmp0 = 0;
      Msrg_free (L2_2_7_srg);
      Msrg_free (L2_3_8_srg);
      Msrg_free (L2_4_9_srg);
      Msrg_free (L2_5_10_srg);
    }
    TRACE_POP ("C_v4ldevice_C_v4ldevice");
    return 0;
  }
}

/*
 * METHOD FUNCTION adjust (class v4ldevice)
 */
extern_c int
C_adjust_C_v4ldevice (struct CClass_v4ldevice *L1_this, int L1_bright,
		      int L1_hue, int L1_color, int L1_cont, int L1_white)
{
  TRACE_PUSH ("C_adjust_C_v4ldevice");
  {
    int L_Tmp0;
    printf ("%d %d %d %d %d\n", L1_bright, L1_hue, L1_color, L1_cont,
	    L1_white);
    {
      int L2_1_ret;
      L2_1_ret = 0;
      {
	struct video_picture vid_pic;
	vid_pic.brightness = (unsigned short) (256 * (L1_bright));
	vid_pic.hue = (unsigned short) (256 * (L1_hue));
	vid_pic.colour = (unsigned short) (256 * (L1_color));
	vid_pic.contrast = (unsigned short) (256 * (L1_cont));
	vid_pic.whiteness = (unsigned short) (256 * (L1_white));

	(L2_1_ret) = ioctl ((L1_this->fd), VIDIOCSPICT, &vid_pic);
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_adjust_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION tune (class v4ldevice)
 */
extern_c int
C_tune_C_v4ldevice (struct CClass_v4ldevice *L1_this, int L1_n)
{
  TRACE_PUSH ("C_tune_C_v4ldevice");
  {
    int L_Tmp0;
    {
      int L2_1_retcode;
      L2_1_retcode = 0;
      {
	long freq;
	freq = (long) (L1_n);
	(L1_this->tuner)->tuner = 0;
	(L2_1_retcode) =
	  ioctl ((L1_this->fd), VIDIOCGTUNER, (L1_this->tuner));
	/* printf("1 %d\n",$retcode); */
	(L1_this->tuner)->tuner = 0;
	(L2_1_retcode) =
	  ioctl ((L1_this->fd), VIDIOCSTUNER, (L1_this->tuner));
	/* printf("2 %d\n",$retcode); */
	(L2_1_retcode) = ioctl ((L1_this->fd), VIDIOCSFREQ, &freq);
	/* printf("3 %d\n",$retcode); */
	(L2_1_retcode) =
	  ioctl ((L1_this->fd), VIDIOCGTUNER, (L1_this->tuner));
	/* printf("4 %d\n",$retcode); */
	(L2_1_retcode) = (int) (L1_this->tuner)->signal;
      }
      L_Tmp0 = L2_1_retcode;
    }
    TRACE_POP ("C_tune_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION -destructor (class v4ldevice)
 */
extern_c char
C__destructor_C_v4ldevice (struct CClass_v4ldevice *L1_this)
{
  TRACE_PUSH ("C__destructor_C_v4ldevice");
  {
    char L_Tmp0;
    L_Tmp0 = (L1_this)->Vtbl->M_cleanup (L1_this);
    TRACE_POP ("C__destructor_C_v4ldevice");
    return 0;
  }
}

/*
 * METHOD FUNCTION grab (class v4ldevice)
 */
extern_c real
C_grab_C_v4ldevice (struct CClass_v4ldevice * L1_this)
{
  TRACE_PUSH ("C_grab_C_v4ldevice");
  {
    real L_Tmp0;
    {
      int L2_1_retcode;
      L2_1_retcode = 0;
      {
	int lastframe, code;
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	if ((L1_this->mmapinfo)->format == 0)
	  {
	    error (NIL, "video format was not set", NIL);
	  }
	(L1_this->mmapinfo)->frame = (L1_this->frame);

	(L2_1_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	(L1_this->framebuffer) =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];

      }
      if ((L2_1_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-rgb24-into-rgbx (class v4ldevice)
 */
extern_c real
C_grab_rgb24_into_rgbx_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				    struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_rgb24_into_rgbx_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 3))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBX image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe, code;
	unsigned char *imgptr, *bufptr;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_RGB24;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		imgptr[0] = bufptr[2];
		imgptr[1] = bufptr[1];
		imgptr[2] = bufptr[0];
		bufptr += 3;
		imgptr += mod1;
	      }
	  }

      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_rgb24_into_rgbx_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-rgb32-into-rgbx (class v4ldevice)
 */
extern_c real
C_grab_rgb32_into_rgbx_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				    struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_rgb32_into_rgbx_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 3))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBX image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe, code;
	unsigned char *imgptr, *bufptr;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_RGB32;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		imgptr[0] = bufptr[2];
		imgptr[1] = bufptr[1];
		imgptr[2] = bufptr[0];
		bufptr += 4;
		imgptr += mod1;
	      }
	  }

      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_rgb32_into_rgbx_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-rgb24-into-rgba (class v4ldevice)
 */
extern_c real
C_grab_rgb24_into_rgba_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				    struct idx * L1_img, int L1_alpha)
{
  TRACE_PUSH ("C_grab_rgb24_into_rgba_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] != 4))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBA image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe;
	int code;
	unsigned char *imgptr, *bufptr;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_RGB24;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		imgptr[0] = bufptr[2];
		imgptr[1] = bufptr[1];
		imgptr[2] = bufptr[0];
		imgptr[3] = (L1_alpha);
		bufptr += 3;
		imgptr += mod1;
	      }
	  }

      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_rgb24_into_rgba_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-rgb32-into-rgba (class v4ldevice)
 */
extern_c real
C_grab_rgb32_into_rgba_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				    struct idx * L1_img, int L1_alpha)
{
  TRACE_PUSH ("C_grab_rgb32_into_rgba_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] != 4))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBA image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe;
	int code;
	unsigned char *imgptr, *bufptr;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_RGB32;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		imgptr[0] = bufptr[2];
		imgptr[1] = bufptr[1];
		imgptr[2] = bufptr[0];
		imgptr[3] = (L1_alpha);
		bufptr += 4;
		imgptr += mod1;
	      }
	  }

      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_rgb32_into_rgba_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-yuv422-into-yuv422 (class v4ldevice)
 */
extern_c real
C_grab_yuv422_into_yuv422_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				       struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_yuv422_into_yuv422_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    char L_Tmp2_contigue;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] != 2))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		Midx_contiguep3 (L1_img, L_Tmp2_contigue);
		if (!(L_Tmp2_contigue))
		  {
		    L_Tmp1 = 1;
		  }
		else
		  {
		    L_Tmp1 = 0;
		  }
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for image matrix");
      }
    {
      int L2_3_retcode;
      L2_3_retcode = 0;
      {
	int lastframe, code;
	unsigned char *imgptr, *bufptr;
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_YUV422;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_3_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);
	memcpy (imgptr, bufptr, (L1_this->width) * (L1_this->height) * 2);

      }
      if ((L2_3_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_yuv422_into_yuv422_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-yuv420p-into-rgbx (class v4ldevice)
 */
extern_c real
C_grab_yuv420p_into_rgbx_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				      struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_yuv420p_into_rgbx_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 3))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBX image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe, code;
	unsigned char *imgptr, *bufptr;
	register float y, u, v, p;
	int y_pos, cb_pos, cr_pos;
	int even;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_YUV420P;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	even = 1;
	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		// if (i==200) { printf("new: %d %d %d\n",i,j,(int)(imgptr));}

		y_pos = i * (L1_this->width) + j;
		y = 1.1643835 * ((float) (bufptr[y_pos]) - 16.0);
		cb_pos =
		  (L1_this->width) * (L1_this->height) +
		  (i / 2) * (L1_this->width) / 2 + j / 2;
		cr_pos =
		  (L1_this->width) * (L1_this->height) * 5 / 4 +
		  (i / 2) * (L1_this->width) / 2 + j / 2;
		u = 1.1339285 * ((float) (bufptr[cb_pos]) - 128.0);
		v = 1.1339285 * ((float) (bufptr[cr_pos]) - 128.0);
		p = y + 1.402 * v;
		imgptr[0] = RGBSATURATE (p);
		p = y - 0.344 * u - 0.714 * v;
		imgptr[1] = RGBSATURATE (p);
		p = y + 1.772 * u;
		imgptr[2] = RGBSATURATE (p);
		even = 1 - even;
		imgptr += mod1;
	      }
	  }
      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_yuv420p_into_rgbx_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-yuv420p-into-rgba (class v4ldevice)
 */
extern_c real
C_grab_yuv420p_into_rgba_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				      struct idx * L1_img, int L1_alpha)
{
  TRACE_PUSH ("C_grab_yuv420p_into_rgba_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 4))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBX image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe, code;
	unsigned char *imgptr, *bufptr;
	register float y, u, v, p;
	int y_pos, cb_pos, cr_pos;
	int even;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_YUV420P;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	even = 1;
	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		y_pos = i * (L1_this->width) + j;
		y = 1.1643835 * ((float) (bufptr[y_pos]) - 16.0);
		cb_pos =
		  (L1_this->width) * (L1_this->height) +
		  (i / 2) * (L1_this->width) / 2 + j / 2;
		cr_pos =
		  (L1_this->width) * (L1_this->height) * 5 / 4 +
		  (i / 2) * (L1_this->width) / 2 + j / 2;
		u = 1.1339285 * ((float) (bufptr[cb_pos]) - 128.0);
		v = 1.1339285 * ((float) (bufptr[cr_pos]) - 128.0);
		p = y + 1.402 * v;
		imgptr[0] = RGBSATURATE (p);
		p = y - 0.344 * u - 0.714 * v;
		imgptr[1] = RGBSATURATE (p);
		p = y + 1.772 * u;
		imgptr[2] = RGBSATURATE (p);
		even = 1 - even;
		imgptr[3] = (L1_alpha);
		imgptr += mod1;
	      }
	  }
      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_yuv420p_into_rgba_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-yuv420p-into-yuv (class v4ldevice)
 */
extern_c real
C_grab_yuv420p_into_yuv_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				     struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_yuv420p_into_yuv_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 3))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for YUVX image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe, code;
	unsigned char *imgptr, *bufptr;
	int y_pos, cb_pos, cr_pos;
	int even;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_YUV420P;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	even = 1;
	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		// if (i==200) { printf("new: %d %d %d\n",i,j,(int)(imgptr));}

		y_pos = i * (L1_this->width) + j;
		cb_pos =
		  (L1_this->width) * (L1_this->height) +
		  (i / 2) * (L1_this->width) / 2 + j / 2;
		cr_pos =
		  (L1_this->width) * (L1_this->height) * 5 / 4 +
		  (i / 2) * (L1_this->width) / 2 + j / 2;
		imgptr[0] = bufptr[y_pos];
		imgptr[1] = bufptr[cb_pos];
		imgptr[2] = bufptr[cr_pos];
		even = 1 - even;
		imgptr += mod1;
	      }
	  }
      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_yuv420p_into_yuv_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-grey-into-y (class v4ldevice)
 */
extern_c real
C_grab_grey_into_y_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_grey_into_y_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    char L_Tmp2_contigue;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    Midx_contiguep2 (L1_img, L_Tmp2_contigue);
	    if (!(L_Tmp2_contigue))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for image matrix");
      }
    {
      int L2_3_retcode;
      L2_3_retcode = 0;
      {
	int lastframe, code;
	unsigned char *imgptr, *bufptr;
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_GREY;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_3_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);
	memcpy (imgptr, bufptr, (L1_this->width) * (L1_this->height));
      }
      if ((L2_3_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_grey_into_y_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-into-rgb (class v4ldevice)
 */
extern_c real
C_grab_into_rgb_C_v4ldevice (struct CClass_v4ldevice * L1_this,
			     struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_into_rgb_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 3))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBX image matrix");
      }
    {
      int L2_2_fmt;
      int L2_3_newfmt;
      real L_Tmp4;
      real L_Tmp5;
      real L_Tmp6;
      L2_2_fmt = (int) ((L1_this->mmapinfo)->format);
      L2_3_newfmt = L2_2_fmt;
      if ((0 == L2_2_fmt))
	{
	  L_Tmp4 =
	    (L1_this)->Vtbl->M_set_format (L1_this, 4, L1_this->width,
					   L1_this->height);
	  if ((0 == L_Tmp4))
	    {
	      L2_3_newfmt = 4;
	    }
	  else
	    {
	      L_Tmp5 =
		(L1_this)->Vtbl->M_set_format (L1_this, 5, L1_this->width,
					       L1_this->height);
	      if ((0 == L_Tmp5))
		{
		  L2_3_newfmt = 5;
		}
	      else
		{
		  L_Tmp6 =
		    (L1_this)->Vtbl->M_set_format (L1_this, 15,
						   L1_this->width,
						   L1_this->height);
		  if ((0 == L_Tmp6))
		    {
		      L2_3_newfmt = 15;
		    }
		  else
		    {
		      if (1)
			{
			  run_time_error
			    ("device cannot grab images of desired size in any format supported by v4ldevice");
			}
		      else
			{
			}
		    }
		}
	    }
	}
      {
	real L3_7_selectqtmp;
	L3_7_selectqtmp = L2_3_newfmt;
	if ((L3_7_selectqtmp == 4))
	  {
	    L_Tmp0 =
	      (L1_this)->Vtbl->M_grab_rgb24_into_rgbx (L1_this, L1_img);
	  }
	else
	  {
	    if ((L3_7_selectqtmp == 5))
	      {
		L_Tmp0 =
		  (L1_this)->Vtbl->M_grab_rgb32_into_rgbx (L1_this, L1_img);
	      }
	    else
	      {
		if ((L3_7_selectqtmp == 15))
		  {
		    L_Tmp0 =
		      (L1_this)->Vtbl->M_grab_yuv420p_into_rgbx (L1_this,
								 L1_img);
		  }
		else
		  {
		    if (1)
		      {
			run_time_error
			  ("image format is not supported by v4ldevice");
			L_Tmp0 = -1;
		      }
		    else
		      {
			run_time_error
			  ("one condition of the selectq must be true");
			L_Tmp0 = 0;
		      }
		  }
	      }
	  }
      }
    }
    TRACE_POP ("C_grab_into_rgb_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-into-rgbx (class v4ldevice)
 */
extern_c real
C_grab_into_rgbx_C_v4ldevice (struct CClass_v4ldevice * L1_this,
			      struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_into_rgbx_C_v4ldevice");
  {
    real L_Tmp0;
    L_Tmp0 = (L1_this)->Vtbl->M_grab_into_rgb (L1_this, L1_img);
    TRACE_POP ("C_grab_into_rgbx_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-into-rgba (class v4ldevice)
 */
extern_c real
C_grab_into_rgba_C_v4ldevice (struct CClass_v4ldevice * L1_this,
			      struct idx * L1_img, int L1_alpha)
{
  TRACE_PUSH ("C_grab_into_rgba_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 4))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBA image matrix");
      }
    {
      int L2_2_fmt;
      int L2_3_newfmt;
      real L_Tmp4;
      real L_Tmp5;
      real L_Tmp6;
      L2_2_fmt = (int) ((L1_this->mmapinfo)->format);
      L2_3_newfmt = L2_2_fmt;
      if ((0 == L2_2_fmt))
	{
	  L_Tmp4 =
	    (L1_this)->Vtbl->M_set_format (L1_this, 4, L1_this->width,
					   L1_this->height);
	  if ((0 == L_Tmp4))
	    {
	      L2_3_newfmt = 4;
	    }
	  else
	    {
	      L_Tmp5 =
		(L1_this)->Vtbl->M_set_format (L1_this, 5, L1_this->width,
					       L1_this->height);
	      if ((0 == L_Tmp5))
		{
		  L2_3_newfmt = 5;
		}
	      else
		{
		  L_Tmp6 =
		    (L1_this)->Vtbl->M_set_format (L1_this, 15,
						   L1_this->width,
						   L1_this->height);
		  if ((0 == L_Tmp6))
		    {
		      L2_3_newfmt = 15;
		    }
		  else
		    {
		      if (1)
			{
			  run_time_error
			    ("device cannot grab images of desired size in any format supported by v4ldevice");
			}
		      else
			{
			}
		    }
		}
	    }
	}
      {
	real L3_7_selectqtmp;
	L3_7_selectqtmp = L2_3_newfmt;
	if ((L3_7_selectqtmp == 4))
	  {
	    L_Tmp0 =
	      (L1_this)->Vtbl->M_grab_rgb24_into_rgbx (L1_this, L1_img);
	  }
	else
	  {
	    if ((L3_7_selectqtmp == 5))
	      {
		L_Tmp0 =
		  (L1_this)->Vtbl->M_grab_rgb32_into_rgbx (L1_this, L1_img);
	      }
	    else
	      {
		if ((L3_7_selectqtmp == 15))
		  {
		    L_Tmp0 =
		      (L1_this)->Vtbl->M_grab_yuv420p_into_rgbx (L1_this,
								 L1_img);
		  }
		else
		  {
		    if (1)
		      {
			run_time_error
			  ("image format is not supported by v4ldevice");
			L_Tmp0 = -1;
		      }
		    else
		      {
			run_time_error
			  ("one condition of the selectq must be true");
			L_Tmp0 = 0;
		      }
		  }
	      }
	  }
      }
    }
    TRACE_POP ("C_grab_into_rgba_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION record-into-rgb (class v4ldevice)
 */
extern_c struct idx *
C_record_into_rgb_C_v4ldevice (struct CClass_v4ldevice *L1_this,
			       struct idx *L1_movie, int L1_s)
{
  TRACE_PUSH ("C_record_into_rgb_C_v4ldevice");
  {
    struct idx *L_Tmp0;
    {
      Midx_begin_bloop1 (L2_f, L1_movie, unsigned char)
      {
	{
	  real L3_1_i;
	  L3_1_i = 1;
	  for (;
	       ((1 > 0) ? (L3_1_i <= L1_s) : (L3_1_i >= L1_s)); (L3_1_i) += 1)
	    {
	      (L1_this)->Vtbl->M_grab_into_rgb (L1_this, &L2_f);
	    }
	}
      }
      Midx_end_bloop1 (L2_f, L1_movie, unsigned char);
      L_Tmp0 = L1_movie;
    }
    TRACE_POP ("C_record_into_rgb_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-rgb24-acc-rgbx (class v4ldevice)
 */
extern_c real
C_grab_rgb24_acc_rgbx_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				   struct idx * L1_img)
{
  TRACE_PUSH ("C_grab_rgb24_acc_rgbx_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] < 3))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBX image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe, code;
	unsigned char *imgptr, *bufptr;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_RGB24;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		imgptr[0] += bufptr[2];
		imgptr[1] += bufptr[1];
		imgptr[2] += bufptr[0];
		bufptr += 3;
		imgptr += mod1;
	      }
	  }

      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_rgb24_acc_rgbx_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION grab-rgb24-acc-rgba (class v4ldevice)
 */
extern_c real
C_grab_rgb24_acc_rgba_C_v4ldevice (struct CClass_v4ldevice * L1_this,
				   struct idx * L1_img, int L1_alpha)
{
  TRACE_PUSH ("C_grab_rgb24_acc_rgba_C_v4ldevice");
  {
    real L_Tmp0;
    char L_Tmp1;
    if (((L1_img)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_img)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_img)->dim[2] != 4))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("wrong size for RGBA image matrix");
      }
    {
      int L2_2_retcode;
      L2_2_retcode = 0;
      {
	int i, j, lastframe;
	int code;
	unsigned char *imgptr, *bufptr;
	int mod1 = (L1_img)->mod[1];
	lastframe = (L1_this->frame);

	/* compute next frame number */
	(L1_this->frame)++;
	if ((L1_this->frame) >= (L1_this->nframe))
	  (L1_this->frame) = 0;

	(L1_this->mmapinfo)->format = VIDEO_PALETTE_RGB24;
	(L1_this->mmapinfo)->width = (L1_this->width);
	(L1_this->mmapinfo)->height = (L1_this->height);
	(L1_this->mmapinfo)->frame = (L1_this->frame);
	(L1_this->depth) = depths[(L1_this->mmapinfo)->format];

	(L2_2_retcode) =
	  ioctl ((L1_this->fd), VIDIOCMCAPTURE, (L1_this->mmapinfo));
	code = ioctl ((L1_this->fd), VIDIOCSYNC, &lastframe);
	// if (code == -1) error(NIL,"error ioctl(VIDIOCSYNC)",NIL);

	(L1_this->framebuffer) = bufptr =
	  (unsigned char *) (L1_this->buffer) +
	  (L1_this->mbuffer)->offsets[lastframe];
	imgptr = IDX_PTR ((L1_img), unsigned char);

	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		imgptr[0] += bufptr[2];
		imgptr[1] += bufptr[1];
		imgptr[2] += bufptr[0];
		imgptr[3] = (L1_alpha);
		bufptr += 3;
		imgptr += mod1;
	      }
	  }

      }
      if ((L2_2_retcode != 0))
	{
	  L_Tmp0 = -1;
	}
      else
	{
	  L_Tmp0 = L1_this->frame;
	}
    }
    TRACE_POP ("C_grab_rgb24_acc_rgba_C_v4ldevice");
    return L_Tmp0;
  }
}

/*
 * CLASS v4ldevice DESTROY
 */
static void
Cdestroy_C_v4ldevice (gptr g)
{
  C__destructor_C_v4ldevice ((struct CClass_v4ldevice *) g);
}

/*
 * CLASS v4ldevice VTABLE
 */
struct VClass_v4ldevice Vt_v4ldevice = {
  (void *) &Vt_object,
  &Cdestroy_C_v4ldevice,
  &C_cleanup_C_v4ldevice,
  &C_set_format_C_v4ldevice,
  &C_v4ldevice_C_v4ldevice,
  &C_adjust_C_v4ldevice,
  &C_tune_C_v4ldevice,
  &C__destructor_C_v4ldevice,
  &C_grab_C_v4ldevice,
  &C_grab_rgb24_into_rgbx_C_v4ldevice,
  &C_grab_rgb32_into_rgbx_C_v4ldevice,
  &C_grab_rgb24_into_rgba_C_v4ldevice,
  &C_grab_rgb32_into_rgba_C_v4ldevice,
  &C_grab_yuv422_into_yuv422_C_v4ldevice,
  &C_grab_yuv420p_into_rgbx_C_v4ldevice,
  &C_grab_yuv420p_into_rgba_C_v4ldevice,
  &C_grab_yuv420p_into_yuv_C_v4ldevice,
  &C_grab_grey_into_y_C_v4ldevice,
  &C_grab_into_rgb_C_v4ldevice,
  &C_grab_into_rgbx_C_v4ldevice,
  &C_grab_into_rgba_C_v4ldevice,
  &C_record_into_rgb_C_v4ldevice,
  &C_grab_rgb24_acc_rgbx_C_v4ldevice,
  &C_grab_rgb24_acc_rgba_C_v4ldevice,
};

/* ---------------------------------------- */

#ifndef NOLISP

/* Declarations */
extern_c dhclassdoc_t Kc_object;
extern_c dhclassdoc_t Kc_v4ldevice_R9b112723;

/*
 * STUB v4l-dummy
 */
DH (X_v4l_dummy)
{
  dharg ret;
  ret.dh_char = C_v4l_dummy ();
  return ret;
}

/*
 * DHDOC v4l-dummy
 */
DHDOC (K_v4l_dummy_Ra8b05737, X_v4l_dummy, "C_v4l_dummy", 0, 0) =
{
DH_FUNC (0), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB cleanup (class v4ldevice)
 */
DH (X_cleanup_C_v4ldevice)
{
  dharg ret;
  ret.dh_char =
    C_cleanup_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr);
  return ret;
}

/*
 * METHOD DHDOC cleanup (class v4ldevice)
 */
DHDOC (K_cleanup_C_v4ldevice_R47cadcb1, X_cleanup_C_v4ldevice,
       "C_cleanup_C_v4ldevice", 0, 0) =
{
DH_FUNC (1),
    DH_OBJ (Kc_v4ldevice_R9b112723), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB set-format (class v4ldevice)
 */
DH (X_set_format_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_set_format_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr,
			      a[2].dh_int, a[3].dh_int, a[4].dh_int);
  return ret;
}

/*
 * METHOD DHDOC set-format (class v4ldevice)
 */
DHDOC (K_set_format_C_v4ldevice_Rcdf3a766, X_set_format_C_v4ldevice,
       "C_set_format_C_v4ldevice", 0, 0) =
{
DH_FUNC (4),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_INT, DH_INT, DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB v4ldevice (class v4ldevice)
 */
DH (X_v4ldevice_C_v4ldevice)
{
  dharg ret;
  ret.dh_char =
    C_v4ldevice_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr,
			     a[2].dh_srg_ptr, a[3].dh_srg_ptr, a[4].dh_int,
			     a[5].dh_int, a[6].dh_int);
  return ret;
}

/*
 * METHOD DHDOC v4ldevice (class v4ldevice)
 */
DHDOC (K_v4ldevice_C_v4ldevice_R50346638, X_v4ldevice_C_v4ldevice,
       "C_v4ldevice_C_v4ldevice", 0, 0) =
{
DH_FUNC (6),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_STR,
    DH_STR, DH_INT, DH_INT, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB adjust (class v4ldevice)
 */
DH (X_adjust_C_v4ldevice)
{
  dharg ret;
  ret.dh_int =
    C_adjust_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr,
			  a[2].dh_int, a[3].dh_int, a[4].dh_int, a[5].dh_int,
			  a[6].dh_int);
  return ret;
}

/*
 * METHOD DHDOC adjust (class v4ldevice)
 */
DHDOC (K_adjust_C_v4ldevice_R7c947ed7, X_adjust_C_v4ldevice,
       "C_adjust_C_v4ldevice", 0, 0) =
{
DH_FUNC (6),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_INT,
    DH_INT, DH_INT, DH_INT, DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB tune (class v4ldevice)
 */
DH (X_tune_C_v4ldevice)
{
  dharg ret;
  ret.dh_int =
    C_tune_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr,
			a[2].dh_int);
  return ret;
}

/*
 * METHOD DHDOC tune (class v4ldevice)
 */
DHDOC (K_tune_C_v4ldevice_R839c5375, X_tune_C_v4ldevice, "C_tune_C_v4ldevice",
       0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB -destructor (class v4ldevice)
 */
DH (X__destructor_C_v4ldevice)
{
  dharg ret;
  ret.dh_char =
    C__destructor_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr);
  return ret;
}

/*
 * METHOD DHDOC -destructor (class v4ldevice)
 */
DHDOC (K__destructor_C_v4ldevice_R47cadcb1, X__destructor_C_v4ldevice,
       "C__destructor_C_v4ldevice", 0, 0) =
{
DH_FUNC (1),
    DH_OBJ (Kc_v4ldevice_R9b112723), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab (class v4ldevice)
 */
DH (X_grab_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab (class v4ldevice)
 */
DHDOC (K_grab_C_v4ldevice_Rc542f89c, X_grab_C_v4ldevice, "C_grab_C_v4ldevice",
       0, 0) =
{
DH_FUNC (1),
    DH_OBJ (Kc_v4ldevice_R9b112723), DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-rgb24-into-rgbx (class v4ldevice)
 */
DH (X_grab_rgb24_into_rgbx_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_rgb24_into_rgbx_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-rgb24-into-rgbx (class v4ldevice)
 */
DHDOC (K_grab_rgb24_into_rgbx_C_v4ldevice_Rbfe572c4,
       X_grab_rgb24_into_rgbx_C_v4ldevice,
       "C_grab_rgb24_into_rgbx_C_v4ldevice", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-rgb32-into-rgbx (class v4ldevice)
 */
DH (X_grab_rgb32_into_rgbx_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_rgb32_into_rgbx_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-rgb32-into-rgbx (class v4ldevice)
 */
DHDOC (K_grab_rgb32_into_rgbx_C_v4ldevice_Rbfe572c4,
       X_grab_rgb32_into_rgbx_C_v4ldevice,
       "C_grab_rgb32_into_rgbx_C_v4ldevice", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-rgb24-into-rgba (class v4ldevice)
 */
DH (X_grab_rgb24_into_rgba_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_rgb24_into_rgba_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					dh_obj_ptr, a[2].dh_idx_ptr,
					a[3].dh_int);
  return ret;
}

/*
 * METHOD DHDOC grab-rgb24-into-rgba (class v4ldevice)
 */
DHDOC (K_grab_rgb24_into_rgba_C_v4ldevice_R5eeb4509,
       X_grab_rgb24_into_rgba_C_v4ldevice,
       "C_grab_rgb24_into_rgba_C_v4ldevice", 0, 0) =
{
DH_FUNC (3),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-rgb32-into-rgba (class v4ldevice)
 */
DH (X_grab_rgb32_into_rgba_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_rgb32_into_rgba_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					dh_obj_ptr, a[2].dh_idx_ptr,
					a[3].dh_int);
  return ret;
}

/*
 * METHOD DHDOC grab-rgb32-into-rgba (class v4ldevice)
 */
DHDOC (K_grab_rgb32_into_rgba_C_v4ldevice_R5eeb4509,
       X_grab_rgb32_into_rgba_C_v4ldevice,
       "C_grab_rgb32_into_rgba_C_v4ldevice", 0, 0) =
{
DH_FUNC (3),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-yuv422-into-yuv422 (class v4ldevice)
 */
DH (X_grab_yuv422_into_yuv422_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_yuv422_into_yuv422_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					   dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-yuv422-into-yuv422 (class v4ldevice)
 */
DHDOC (K_grab_yuv422_into_yuv422_C_v4ldevice_Rbfe572c4,
       X_grab_yuv422_into_yuv422_C_v4ldevice,
       "C_grab_yuv422_into_yuv422_C_v4ldevice", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-yuv420p-into-rgbx (class v4ldevice)
 */
DH (X_grab_yuv420p_into_rgbx_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_yuv420p_into_rgbx_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					  dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-yuv420p-into-rgbx (class v4ldevice)
 */
DHDOC (K_grab_yuv420p_into_rgbx_C_v4ldevice_Rbfe572c4,
       X_grab_yuv420p_into_rgbx_C_v4ldevice,
       "C_grab_yuv420p_into_rgbx_C_v4ldevice", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-yuv420p-into-rgba (class v4ldevice)
 */
DH (X_grab_yuv420p_into_rgba_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_yuv420p_into_rgba_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					  dh_obj_ptr, a[2].dh_idx_ptr,
					  a[3].dh_int);
  return ret;
}

/*
 * METHOD DHDOC grab-yuv420p-into-rgba (class v4ldevice)
 */
DHDOC (K_grab_yuv420p_into_rgba_C_v4ldevice_R5eeb4509,
       X_grab_yuv420p_into_rgba_C_v4ldevice,
       "C_grab_yuv420p_into_rgba_C_v4ldevice", 0, 0) =
{
DH_FUNC (3),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-yuv420p-into-yuv (class v4ldevice)
 */
DH (X_grab_yuv420p_into_yuv_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_yuv420p_into_yuv_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
					 dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-yuv420p-into-yuv (class v4ldevice)
 */
DHDOC (K_grab_yuv420p_into_yuv_C_v4ldevice_Rbfe572c4,
       X_grab_yuv420p_into_yuv_C_v4ldevice,
       "C_grab_yuv420p_into_yuv_C_v4ldevice", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-grey-into-y (class v4ldevice)
 */
DH (X_grab_grey_into_y_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_grey_into_y_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
				    dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-grey-into-y (class v4ldevice)
 */
DHDOC (K_grab_grey_into_y_C_v4ldevice_Rbfe572c4,
       X_grab_grey_into_y_C_v4ldevice, "C_grab_grey_into_y_C_v4ldevice", 0,
       0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-into-rgb (class v4ldevice)
 */
DH (X_grab_into_rgb_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_into_rgb_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr,
				 a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-into-rgb (class v4ldevice)
 */
DHDOC (K_grab_into_rgb_C_v4ldevice_Rbfe572c4, X_grab_into_rgb_C_v4ldevice,
       "C_grab_into_rgb_C_v4ldevice", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-into-rgbx (class v4ldevice)
 */
DH (X_grab_into_rgbx_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_into_rgbx_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr,
				  a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-into-rgbx (class v4ldevice)
 */
DHDOC (K_grab_into_rgbx_C_v4ldevice_Rbfe572c4, X_grab_into_rgbx_C_v4ldevice,
       "C_grab_into_rgbx_C_v4ldevice", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-into-rgba (class v4ldevice)
 */
DH (X_grab_into_rgba_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_into_rgba_C_v4ldevice ((struct CClass_v4ldevice *) a[1].dh_obj_ptr,
				  a[2].dh_idx_ptr, a[3].dh_int);
  return ret;
}

/*
 * METHOD DHDOC grab-into-rgba (class v4ldevice)
 */
DHDOC (K_grab_into_rgba_C_v4ldevice_R5eeb4509, X_grab_into_rgba_C_v4ldevice,
       "C_grab_into_rgba_C_v4ldevice", 0, 0) =
{
DH_FUNC (3),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB record-into-rgb (class v4ldevice)
 */
DH (X_record_into_rgb_C_v4ldevice)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_record_into_rgb_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
				   dh_obj_ptr, a[2].dh_idx_ptr, a[3].dh_int);
  return ret;
}

/*
 * METHOD DHDOC record-into-rgb (class v4ldevice)
 */
DHDOC (K_record_into_rgb_C_v4ldevice_Rd45b63aa, X_record_into_rgb_C_v4ldevice,
       "C_record_into_rgb_C_v4ldevice", 0, 0) =
{
DH_FUNC (3),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 4),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_RETURN,
    DH_IDX (DHT_READ, 4), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-rgb24-acc-rgbx (class v4ldevice)
 */
DH (X_grab_rgb24_acc_rgbx_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_rgb24_acc_rgbx_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
				       dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC grab-rgb24-acc-rgbx (class v4ldevice)
 */
DHDOC (K_grab_rgb24_acc_rgbx_C_v4ldevice_Rbfe572c4,
       X_grab_rgb24_acc_rgbx_C_v4ldevice, "C_grab_rgb24_acc_rgbx_C_v4ldevice",
       0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB grab-rgb24-acc-rgba (class v4ldevice)
 */
DH (X_grab_rgb24_acc_rgba_C_v4ldevice)
{
  dharg ret;
  ret.dh_real =
    C_grab_rgb24_acc_rgba_C_v4ldevice ((struct CClass_v4ldevice *) a[1].
				       dh_obj_ptr, a[2].dh_idx_ptr,
				       a[3].dh_int);
  return ret;
}

/*
 * METHOD DHDOC grab-rgb24-acc-rgba (class v4ldevice)
 */
DHDOC (K_grab_rgb24_acc_rgba_C_v4ldevice_R5eeb4509,
       X_grab_rgb24_acc_rgba_C_v4ldevice, "C_grab_rgb24_acc_rgba_C_v4ldevice",
       0, 0) =
{
DH_FUNC (3),
    DH_OBJ (Kc_v4ldevice_R9b112723),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * CLASS v4ldevice DHCLASSDOC
 */
DHCLASSDOC (Kc_v4ldevice_R9b112723, &Kc_object, v4ldevice, "v4ldevice",
	    Vt_v4ldevice, 22) =
{
DH_CLASS (23, Kc_v4ldevice_R9b112723),
    DH_NAME ("fd", v4ldevice, fd),
    DH_INT,
    DH_NAME ("width", v4ldevice, width),
    DH_INT,
    DH_NAME ("height", v4ldevice, height),
    DH_INT,
    DH_NAME ("frame", v4ldevice, frame),
    DH_INT,
    DH_NAME ("depth", v4ldevice, depth),
    DH_INT,
    DH_NAME ("nframe", v4ldevice, nframe),
    DH_INT,
    DH_NAME ("buffer", v4ldevice, buffer),
    DH_GPTR (0),
    DH_NAME ("buffersize", v4ldevice, buffersize),
    DH_INT,
    DH_NAME ("currentformat", v4ldevice, currentformat),
    DH_INT,
    DH_NAME ("framebuffer", v4ldevice, framebuffer),
    DH_GPTR (0),
    DH_NAME ("cap-channels", v4ldevice, cap_channels),
    DH_INT,
    DH_NAME ("cap-audios", v4ldevice, cap_audios),
    DH_INT,
    DH_NAME ("cap-maxwidth", v4ldevice, cap_maxwidth),
    DH_INT,
    DH_NAME ("cap-maxheight", v4ldevice, cap_maxheight),
    DH_INT,
    DH_NAME ("cap-minwidth", v4ldevice, cap_minwidth),
    DH_INT,
    DH_NAME ("cap-minheight", v4ldevice, cap_minheight),
    DH_INT,
    DH_NAME ("capability", v4ldevice, capability),
    DH_GPTR ("struct video_capability *"),
    DH_NAME ("channel", v4ldevice, channel),
    DH_GPTR ("struct video_channel *"),
    DH_NAME ("tuner", v4ldevice, tuner),
    DH_GPTR ("struct video_tuner *"),
    DH_NAME ("capture", v4ldevice, capture),
    DH_GPTR ("struct video_capture *"),
    DH_NAME ("picture", v4ldevice, picture),
    DH_GPTR ("struct video_picture *"),
    DH_NAME ("mmapinfo", v4ldevice, mmapinfo),
    DH_GPTR ("struct video_mmap *"),
    DH_NAME ("mbuffer", v4ldevice, mbuffer),
    DH_GPTR ("struct video_mbuf *"),
    DH_END_CLASS,
    DH_METHOD ("cleanup", K_cleanup_C_v4ldevice_R47cadcb1),
    DH_METHOD ("set_format", K_set_format_C_v4ldevice_Rcdf3a766),
    DH_METHOD ("v4ldevice", K_v4ldevice_C_v4ldevice_R50346638),
    DH_METHOD ("adjust", K_adjust_C_v4ldevice_R7c947ed7),
    DH_METHOD ("tune", K_tune_C_v4ldevice_R839c5375),
    DH_METHOD ("_destructor", K__destructor_C_v4ldevice_R47cadcb1),
    DH_METHOD ("grab", K_grab_C_v4ldevice_Rc542f89c),
    DH_METHOD ("grab_rgb24_into_rgbx",
		 K_grab_rgb24_into_rgbx_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_rgb32_into_rgbx",
		 K_grab_rgb32_into_rgbx_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_rgb24_into_rgba",
		 K_grab_rgb24_into_rgba_C_v4ldevice_R5eeb4509),
    DH_METHOD ("grab_rgb32_into_rgba",
		 K_grab_rgb32_into_rgba_C_v4ldevice_R5eeb4509),
    DH_METHOD ("grab_yuv422_into_yuv422",
		 K_grab_yuv422_into_yuv422_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_yuv420p_into_rgbx",
		 K_grab_yuv420p_into_rgbx_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_yuv420p_into_rgba",
		 K_grab_yuv420p_into_rgba_C_v4ldevice_R5eeb4509),
    DH_METHOD ("grab_yuv420p_into_yuv",
		 K_grab_yuv420p_into_yuv_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_grey_into_y",
		 K_grab_grey_into_y_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_into_rgb", K_grab_into_rgb_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_into_rgbx", K_grab_into_rgbx_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_into_rgba", K_grab_into_rgba_C_v4ldevice_R5eeb4509),
    DH_METHOD ("record_into_rgb", K_record_into_rgb_C_v4ldevice_Rd45b63aa),
    DH_METHOD ("grab_rgb24_acc_rgbx",
		 K_grab_rgb24_acc_rgbx_C_v4ldevice_Rbfe572c4),
    DH_METHOD ("grab_rgb24_acc_rgba",
		 K_grab_rgb24_acc_rgba_C_v4ldevice_R5eeb4509), DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_v4l (void)
{
  dh_define ("v4l-dummy", &K_v4l_dummy_Ra8b05737);
  dhclass_define ("v4ldevice", &Kc_v4ldevice_R9b112723);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "cleanup",
		   &K_cleanup_C_v4ldevice_R47cadcb1);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "set-format",
		   &K_set_format_C_v4ldevice_Rcdf3a766);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "v4ldevice",
		   &K_v4ldevice_C_v4ldevice_R50346638);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "adjust",
		   &K_adjust_C_v4ldevice_R7c947ed7);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "tune",
		   &K_tune_C_v4ldevice_R839c5375);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "-destructor",
		   &K__destructor_C_v4ldevice_R47cadcb1);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab",
		   &K_grab_C_v4ldevice_Rc542f89c);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-rgb24-into-rgbx",
		   &K_grab_rgb24_into_rgbx_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-rgb32-into-rgbx",
		   &K_grab_rgb32_into_rgbx_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-rgb24-into-rgba",
		   &K_grab_rgb24_into_rgba_C_v4ldevice_R5eeb4509);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-rgb32-into-rgba",
		   &K_grab_rgb32_into_rgba_C_v4ldevice_R5eeb4509);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-yuv422-into-yuv422",
		   &K_grab_yuv422_into_yuv422_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-yuv420p-into-rgbx",
		   &K_grab_yuv420p_into_rgbx_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-yuv420p-into-rgba",
		   &K_grab_yuv420p_into_rgba_C_v4ldevice_R5eeb4509);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-yuv420p-into-yuv",
		   &K_grab_yuv420p_into_yuv_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-grey-into-y",
		   &K_grab_grey_into_y_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-into-rgb",
		   &K_grab_into_rgb_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-into-rgbx",
		   &K_grab_into_rgbx_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-into-rgba",
		   &K_grab_into_rgba_C_v4ldevice_R5eeb4509);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "record-into-rgb",
		   &K_record_into_rgb_C_v4ldevice_Rd45b63aa);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-rgb24-acc-rgbx",
		   &K_grab_rgb24_acc_rgbx_C_v4ldevice_Rbfe572c4);
  dhmethod_define (&Kc_v4ldevice_R9b112723, "grab-rgb24-acc-rgba",
		   &K_grab_rgb24_acc_rgba_C_v4ldevice_R5eeb4509);
}

int majver_v4l = 40;
int minver_v4l = 10;

#endif
