/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"
/*
 * USER DEFINED HEADERS
 */
#include <cv.h>
#include <cvaux.h>
#include <cvcompat.h>
#undef ptr

/* ---------------------------------------- */

/*
 * FUNCTION dummy_aux_convert
 */
extern_c char
C_dummy_aux_convert ()
{
  TRACE_PUSH ("C_dummy_aux_convert");
  {
    TRACE_POP ("C_dummy_aux_convert");
    return 0;
  }
}

/*
 * FUNCTION ipl8u-idx
 */
extern_c char
C_ipl8u_idx (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl8u_idx");
  {
    {
      int d1, d2, d3, rowbytes;
      char *imgptr;
      uchar *matptr;

      d1 = (L1_img)->height;
      d2 = (L1_img)->width;
      d3 = (L1_img)->nChannels;
      rowbytes = d2 * d3 * sizeof (unsigned char);

      Midx_setdim3 ((L1_mat), d1, d2, d3);
      Midx_update_mod_from_dim ((L1_mat));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), uchar) matptr = IDX_PTR (&tmp, uchar);
      memcpy ((void *) matptr, (void *) imgptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), uchar)}
    TRACE_POP ("C_ipl8u_idx");
    return 0;
  }
}

/*
 * FUNCTION ipl8s-idx
 */
extern_c char
C_ipl8s_idx (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl8s_idx");
  {
    {
      int d1, d2, d3, rowbytes;
      char *imgptr;
      signed char *matptr;

      d1 = (L1_img)->height;
      d2 = (L1_img)->width;
      d3 = (L1_img)->nChannels;
      rowbytes = d2 * d3 * sizeof (signed char);

      Midx_setdim3 ((L1_mat), d1, d2, d3);
      Midx_update_mod_from_dim ((L1_mat));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), signed char)
	matptr = IDX_PTR (&tmp, signed char);
      memcpy ((void *) matptr, (void *) imgptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), signed char)}
    TRACE_POP ("C_ipl8s_idx");
    return 0;
  }
}

/*
 * FUNCTION ipl16s-idx
 */
extern_c char
C_ipl16s_idx (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl16s_idx");
  {
    {
      int d1, d2, d3, rowbytes;
      char *imgptr;
      short *matptr;

      d1 = (L1_img)->height;
      d2 = (L1_img)->width;
      d3 = (L1_img)->nChannels;
      rowbytes = d2 * d3 * sizeof (short);

      Midx_setdim3 ((L1_mat), d1, d2, d3);
      Midx_update_mod_from_dim ((L1_mat));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), short) matptr = IDX_PTR (&tmp, short);
      memcpy ((void *) matptr, (void *) imgptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), short)}
    TRACE_POP ("C_ipl16s_idx");
    return 0;
  }
}

/*
 * FUNCTION ipl32s-idx
 */
extern_c char
C_ipl32s_idx (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl32s_idx");
  {
    {
      int d1, d2, d3, rowbytes;
      char *imgptr;
      int *matptr;

      d1 = (L1_img)->height;
      d2 = (L1_img)->width;
      d3 = (L1_img)->nChannels;
      rowbytes = d2 * d3 * sizeof (int);

      Midx_setdim3 ((L1_mat), d1, d2, d3);
      Midx_update_mod_from_dim ((L1_mat));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), int) matptr = IDX_PTR (&tmp, int);
      memcpy ((void *) matptr, (void *) imgptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), int)}
    TRACE_POP ("C_ipl32s_idx");
    return 0;
  }
}

/*
 * FUNCTION ipl32f-idx
 */
extern_c char
C_ipl32f_idx (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl32f_idx");
  {
    {
      int d1, d2, d3, rowbytes;
      char *imgptr;
      float *matptr;

      d1 = (L1_img)->height;
      d2 = (L1_img)->width;
      d3 = (L1_img)->nChannels;
      rowbytes = d2 * d3 * sizeof (float);

      Midx_setdim3 ((L1_mat), d1, d2, d3);
      Midx_update_mod_from_dim ((L1_mat));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), float) matptr = IDX_PTR (&tmp, float);
      memcpy ((void *) matptr, (void *) imgptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), float)}
    TRACE_POP ("C_ipl32f_idx");
    return 0;
  }
}

/*
 * FUNCTION ipl64f-idx
 */
extern_c char
C_ipl64f_idx (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl64f_idx");
  {
    {
      int d1, d2, d3, rowbytes;
      char *imgptr;
      double *matptr;

      d1 = (L1_img)->height;
      d2 = (L1_img)->width;
      d3 = (L1_img)->nChannels;
      rowbytes = d2 * d3 * sizeof (double);

      Midx_setdim3 ((L1_mat), d1, d2, d3);
      Midx_update_mod_from_dim ((L1_mat));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), double)
	matptr = IDX_PTR (&tmp, double);
      memcpy ((void *) matptr, (void *) imgptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), double)}
    TRACE_POP ("C_ipl64f_idx");
    return 0;
  }
}

/*
 * FUNCTION idx8u-ipl
 */
extern_c char
C_idx8u_ipl (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx8u_ipl");
  {
    {
      int width, height, channels, rowbytes;
      char *imgptr;
      uchar *matptr;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (unsigned char);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));
      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_8U, channels, IPL_ORIGIN_TL,
			 4);
      cvCreateData ((L1_img));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), uchar) matptr = IDX_PTR (&tmp, uchar);
      memcpy ((void *) imgptr, (void *) matptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), uchar)}
    TRACE_POP ("C_idx8u_ipl");
    return 0;
  }
}

/*
 * FUNCTION idx8s-ipl
 */
extern_c char
C_idx8s_ipl (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx8s_ipl");
  {
    {
      int width, height, channels, rowbytes;
      char *imgptr;
      signed char *matptr;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (signed char);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));
      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_8S, channels, IPL_ORIGIN_TL,
			 4);
      cvCreateData ((L1_img));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), signed char)
	matptr = IDX_PTR (&tmp, signed char);
      memcpy ((void *) imgptr, (void *) matptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), uchar)}
    TRACE_POP ("C_idx8s_ipl");
    return 0;
  }
}

/*
 * FUNCTION idx16s-ipl
 */
extern_c char
C_idx16s_ipl (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx16s_ipl");
  {
    {
      int width, height, channels, rowbytes;
      char *imgptr;
      short *matptr;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (short);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));
      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_16S, channels, IPL_ORIGIN_TL,
			 4);
      cvCreateData ((L1_img));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), short) matptr = IDX_PTR (&tmp, short);
      memcpy ((void *) imgptr, (void *) matptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), uchar)}
    TRACE_POP ("C_idx16s_ipl");
    return 0;
  }
}

/*
 * FUNCTION idx32s-ipl
 */
extern_c char
C_idx32s_ipl (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx32s_ipl");
  {
    {
      int width, height, channels, rowbytes;
      char *imgptr;
      int *matptr;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (int);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));
      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_32S, channels, IPL_ORIGIN_TL,
			 4);
      cvCreateData ((L1_img));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), int) matptr = IDX_PTR (&tmp, int);
      memcpy ((void *) imgptr, (void *) matptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), uchar)}
    TRACE_POP ("C_idx32s_ipl");
    return 0;
  }
}

/*
 * FUNCTION idx32f-ipl
 */
extern_c char
C_idx32f_ipl (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx32f_ipl");
  {
    {
      int width, height, channels, rowbytes;
      char *imgptr;
      float *matptr;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (float);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));
      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_32F, channels, IPL_ORIGIN_TL,
			 4);
      cvCreateData ((L1_img));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), float) matptr = IDX_PTR (&tmp, float);
      memcpy ((void *) imgptr, (void *) matptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), uchar)}
    TRACE_POP ("C_idx32f_ipl");
    return 0;
  }
}

/*
 * FUNCTION idx64f-ipl
 */
extern_c char
C_idx64f_ipl (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx64f_ipl");
  {
    {
      int width, height, channels, rowbytes;
      char *imgptr;
      double *matptr;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (double);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));
      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_64F, channels, IPL_ORIGIN_TL,
			 4);
      cvCreateData ((L1_img));

      imgptr = (L1_img)->imageData;
      Midx_begin_bloop1 (tmp, (L1_mat), double)
	matptr = IDX_PTR (&tmp, double);
      memcpy ((void *) imgptr, (void *) matptr, rowbytes);
      imgptr += (L1_img)->widthStep;
    Midx_end_bloop1 (tmp, (L1_mat), uchar)}
    TRACE_POP ("C_idx64f_ipl");
    return 0;
  }
}

/*
 * FUNCTION ipl8u-idx-share
 */
extern_c char
C_ipl8u_idx_share (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl8u_idx_share");
  {
    {
      Midx_setdim3 ((L1_mat), (L1_img)->height, (L1_img)->width,
		    (L1_img)->nChannels);
      Midx_update_mod_from_dim ((L1_mat));
      ((L1_mat))->srg->data = (uchar *) (L1_img)->imageData;
    }
    TRACE_POP ("C_ipl8u_idx_share");
    return 0;
  }
}

/*
 * FUNCTION ipl8s-idx-share
 */
extern_c char
C_ipl8s_idx_share (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl8s_idx_share");
  {
    {
      Midx_setdim3 ((L1_mat), (L1_img)->height, (L1_img)->width,
		    (L1_img)->nChannels);
      Midx_update_mod_from_dim ((L1_mat));
      ((L1_mat))->srg->data = (signed char *) (L1_img)->imageData;
    }
    TRACE_POP ("C_ipl8s_idx_share");
    return 0;
  }
}

/*
 * FUNCTION ipl16s-idx-share
 */
extern_c char
C_ipl16s_idx_share (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl16s_idx_share");
  {
    {
      Midx_setdim3 ((L1_mat), (L1_img)->height, (L1_img)->width,
		    (L1_img)->nChannels);
      Midx_update_mod_from_dim ((L1_mat));
      ((L1_mat))->srg->data = (L1_img)->imageData;
    }
    TRACE_POP ("C_ipl16s_idx_share");
    return 0;
  }
}

/*
 * FUNCTION ipl32s-idx-share
 */
extern_c char
C_ipl32s_idx_share (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl32s_idx_share");
  {
    {
      Midx_setdim3 ((L1_mat), (L1_img)->height, (L1_img)->width,
		    (L1_img)->nChannels);
      Midx_update_mod_from_dim ((L1_mat));
      ((L1_mat))->srg->data = (L1_img)->imageData;
    }
    TRACE_POP ("C_ipl32s_idx_share");
    return 0;
  }
}

/*
 * FUNCTION ipl32f-idx-share
 */
extern_c char
C_ipl32f_idx_share (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl32f_idx_share");
  {
    {
      Midx_setdim3 ((L1_mat), (L1_img)->height, (L1_img)->width,
		    (L1_img)->nChannels);
      Midx_update_mod_from_dim ((L1_mat));
      ((L1_mat))->srg->data = (L1_img)->imageData;
    }
    TRACE_POP ("C_ipl32f_idx_share");
    return 0;
  }
}

/*
 * FUNCTION ipl64f-idx-share
 */
extern_c char
C_ipl64f_idx_share (IplImage * L1_img, struct idx *L1_mat)
{
  TRACE_PUSH ("C_ipl64f_idx_share");
  {
    {
      Midx_setdim3 ((L1_mat), (L1_img)->height, (L1_img)->width,
		    (L1_img)->nChannels);
      Midx_update_mod_from_dim ((L1_mat));
      ((L1_mat))->srg->data = (L1_img)->imageData;
    }
    TRACE_POP ("C_ipl64f_idx_share");
    return 0;
  }
}

/*
 * FUNCTION idx8u-ipl-share
 */
extern_c char
C_idx8u_ipl_share (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx8u_ipl_share");
  {
    char L_Tmp0;
    if ((1 != (L1_mat)->mod[2]))
      {
	run_time_error
	  ("The rows of mat must lie in contiguous storage. In other words, (idx-modulo mat 2) must equal 1");
      }
    {
      int L2_1_byte_alignment;
      int L2_2_rowbytes;
      L2_1_byte_alignment = 4;
      L2_2_rowbytes = Midx_mod ((L1_mat), 0) * sizeof (unsigned char);
      if ((0 != (((int) L2_2_rowbytes) % ((int) L2_1_byte_alignment))))
	{
	  run_time_error ("matrix row size in bytes must be a multiple of 4");
	}
      {
	int width, height, channels;
	CvSize sz;

	height = Midx_dim ((L1_mat), 0);
	width = Midx_dim ((L1_mat), 1);
	channels = Midx_dim ((L1_mat), 2);
	sz = cvSize (width, height);

	if ((L1_img)->imageData)
	  cvReleaseData ((L1_img));

	cvInitImageHeader ((L1_img), sz, IPL_DEPTH_8U, channels,
			   IPL_ORIGIN_TL, (L2_1_byte_alignment));
	(L1_img)->imageData = (char *) IDX_PTR ((L1_mat), uchar);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx8u_ipl_share");
    return 0;
  }
}

/*
 * FUNCTION idx8s-ipl-share
 */
extern_c char
C_idx8s_ipl_share (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx8s_ipl_share");
  {
    char L_Tmp0;
    if ((1 != (L1_mat)->mod[2]))
      {
	run_time_error
	  ("The rows of mat must lie in contiguous storage. In other words, (idx-modulo mat 2) must equal 1");
      }
    {
      int L2_1_byte_alignment;
      int L2_2_rowbytes;
      L2_1_byte_alignment = 4;
      L2_2_rowbytes = Midx_mod ((L1_mat), 0) * sizeof (signed char);
      if ((0 != (((int) L2_2_rowbytes) % ((int) L2_1_byte_alignment))))
	{
	  run_time_error ("matrix row size in bytes must be a multiple of 4");
	}
      {
	int width, height, channels, rowbytes;
	CvSize sz;

	height = Midx_dim ((L1_mat), 0);
	width = Midx_dim ((L1_mat), 1);
	channels = Midx_dim ((L1_mat), 2);
	rowbytes = Midx_mod ((L1_mat), 0) * sizeof (signed char);
	sz = cvSize (width, height);

	if ((L1_img)->imageData)
	  cvReleaseData ((L1_img));

	cvInitImageHeader ((L1_img), sz, IPL_DEPTH_8S, channels,
			   IPL_ORIGIN_TL, (L2_1_byte_alignment));
	(L1_img)->imageData = (char *) IDX_PTR ((L1_mat), signed char);
      }
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_idx8s_ipl_share");
    return 0;
  }
}

/*
 * FUNCTION idx16s-ipl-share
 */
extern_c char
C_idx16s_ipl_share (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx16s_ipl_share");
  {
    if ((1 != (L1_mat)->mod[2]))
      {
	run_time_error
	  ("The rows of mat must lie in contiguous storage. In other words, (idx-modulo mat 2) must equal 1");
      }
    {
      int width, height, channels, rowbytes;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (short);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));

      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_16S, channels, IPL_ORIGIN_TL,
			 4);
      (L1_img)->imageData = (char *) IDX_PTR ((L1_mat), short);
    }
    TRACE_POP ("C_idx16s_ipl_share");
    return 0;
  }
}

/*
 * FUNCTION idx32s-ipl-share
 */
extern_c char
C_idx32s_ipl_share (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx32s_ipl_share");
  {
    if ((1 != (L1_mat)->mod[2]))
      {
	run_time_error
	  ("The rows of mat must lie in contiguous storage. In other words, (idx-modulo mat 2) must equal 1");
      }
    {
      int width, height, channels, rowbytes;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (int);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));

      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_32S, channels, IPL_ORIGIN_TL,
			 4);
      (L1_img)->imageData = (char *) IDX_PTR ((L1_mat), int);
    }
    TRACE_POP ("C_idx32s_ipl_share");
    return 0;
  }
}

/*
 * FUNCTION idx32f-ipl-share
 */
extern_c char
C_idx32f_ipl_share (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx32f_ipl_share");
  {
    if ((1 != (L1_mat)->mod[2]))
      {
	run_time_error
	  ("The rows of mat must lie in contiguous storage. In other words, (idx-modulo mat 2) must equal 1");
      }
    {
      int width, height, channels, rowbytes;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (float);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));

      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_32F, channels, IPL_ORIGIN_TL,
			 4);
      (L1_img)->imageData = (char *) IDX_PTR ((L1_mat), float);
    }
    TRACE_POP ("C_idx32f_ipl_share");
    return 0;
  }
}

/*
 * FUNCTION idx64f-ipl-share
 */
extern_c char
C_idx64f_ipl_share (struct idx *L1_mat, IplImage * L1_img)
{
  TRACE_PUSH ("C_idx64f_ipl_share");
  {
    if ((1 != (L1_mat)->mod[2]))
      {
	run_time_error
	  ("The rows of mat must lie in contiguous storage. In other words, (idx-modulo mat 2) must equal 1");
      }
    {
      int width, height, channels, rowbytes;
      CvSize sz;

      height = Midx_dim ((L1_mat), 0);
      width = Midx_dim ((L1_mat), 1);
      channels = Midx_dim ((L1_mat), 2);
      rowbytes = Midx_mod ((L1_mat), 0) * sizeof (double);
      sz = cvSize (width, height);

      if ((L1_img)->imageData)
	cvReleaseData ((L1_img));

      cvInitImageHeader ((L1_img), sz, IPL_DEPTH_64F, channels, IPL_ORIGIN_TL,
			 4);
      (L1_img)->imageData = (char *) IDX_PTR ((L1_mat), double);
    }
    TRACE_POP ("C_idx64f_ipl_share");
    return 0;
  }
}

/*
 * FUNCTION print-ipl-info
 */
extern_c char
C_print_ipl_info (IplImage * L1_s)
{
  TRACE_PUSH ("C_print_ipl_info");
  {
    printf (" nSize: %d\n", (L1_s)->nSize);
    printf (" ID: %d\n", (L1_s)->ID);
    printf (" nChannels: %d\n", (L1_s)->nChannels);
    printf (" alphaChannel: %d\n", (L1_s)->alphaChannel);
    printf (" depth: %d\n", (L1_s)->depth);
    printf (" dataOrder: %d\n", (L1_s)->dataOrder);
    printf (" origin: %d\n", (L1_s)->origin);
    printf (" align: %d\n", (L1_s)->align);
    printf (" width: %d\n", (L1_s)->width);
    printf (" height: %d\n", (L1_s)->height);
    printf (" imageSize: %d\n", (L1_s)->imageSize);
    printf (" widthStep: %d\n", (L1_s)->widthStep);
    TRACE_POP ("C_print_ipl_info");
    return 0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/*
 * STUB dummy_aux_convert
 */
DH (X_dummy_aux_convert)
{
  dharg ret;
  ret.dh_char = C_dummy_aux_convert ();
  return ret;
}

/*
 * DHDOC dummy_aux_convert
 */
DHDOC (K_dummy_aux_convert_Ra8b05737, X_dummy_aux_convert,
       "C_dummy_aux_convert", 0, 0) =
{
DH_FUNC (0), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl8u-idx
 */
DH (X_ipl8u_idx)
{
  dharg ret;
  ret.dh_char = C_ipl8u_idx ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl8u-idx
 */
DHDOC (K_ipl8u_idx_R3d46ee0a, X_ipl8u_idx, "C_ipl8u_idx", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl8s-idx
 */
DH (X_ipl8s_idx)
{
  dharg ret;
  ret.dh_char = C_ipl8s_idx ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl8s-idx
 */
DHDOC (K_ipl8s_idx_R2c50b707, X_ipl8s_idx, "C_ipl8s_idx", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_BYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl16s-idx
 */
DH (X_ipl16s_idx)
{
  dharg ret;
  ret.dh_char = C_ipl16s_idx ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl16s-idx
 */
DHDOC (K_ipl16s_idx_R8d967367, X_ipl16s_idx, "C_ipl16s_idx", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_SHORT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl32s-idx
 */
DH (X_ipl32s_idx)
{
  dharg ret;
  ret.dh_char = C_ipl32s_idx ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl32s-idx
 */
DHDOC (K_ipl32s_idx_R0cd2e357, X_ipl32s_idx, "C_ipl32s_idx", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl32f-idx
 */
DH (X_ipl32f_idx)
{
  dharg ret;
  ret.dh_char = C_ipl32f_idx ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl32f-idx
 */
DHDOC (K_ipl32f_idx_R2cc7217b, X_ipl32f_idx, "C_ipl32f_idx", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl64f-idx
 */
DH (X_ipl64f_idx)
{
  dharg ret;
  ret.dh_char = C_ipl64f_idx ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl64f-idx
 */
DHDOC (K_ipl64f_idx_R2d01ae6f, X_ipl64f_idx, "C_ipl64f_idx", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx8u-ipl
 */
DH (X_idx8u_ipl)
{
  dharg ret;
  ret.dh_char = C_idx8u_ipl (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx8u-ipl
 */
DHDOC (K_idx8u_ipl_R518f2d66, X_idx8u_ipl, "C_idx8u_ipl", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx8s-ipl
 */
DH (X_idx8s_ipl)
{
  dharg ret;
  ret.dh_char = C_idx8s_ipl (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx8s-ipl
 */
DHDOC (K_idx8s_ipl_R73a39f7c, X_idx8s_ipl, "C_idx8s_ipl", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_BYTE, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx16s-ipl
 */
DH (X_idx16s_ipl)
{
  dharg ret;
  ret.dh_char = C_idx16s_ipl (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx16s-ipl
 */
DHDOC (K_idx16s_ipl_R302e17bd, X_idx16s_ipl, "C_idx16s_ipl", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_SHORT, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx32s-ipl
 */
DH (X_idx32s_ipl)
{
  dharg ret;
  ret.dh_char = C_idx32s_ipl (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx32s-ipl
 */
DHDOC (K_idx32s_ipl_R32a737dc, X_idx32s_ipl, "C_idx32s_ipl", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_INT, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx32f-ipl
 */
DH (X_idx32f_ipl)
{
  dharg ret;
  ret.dh_char = C_idx32f_ipl (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx32f-ipl
 */
DHDOC (K_idx32f_ipl_R728cb384, X_idx32f_ipl, "C_idx32f_ipl", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_FLT, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx64f-ipl
 */
DH (X_idx64f_ipl)
{
  dharg ret;
  ret.dh_char = C_idx64f_ipl (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx64f-ipl
 */
DHDOC (K_idx64f_ipl_R7101adac, X_idx64f_ipl, "C_idx64f_ipl", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl8u-idx-share
 */
DH (X_ipl8u_idx_share)
{
  dharg ret;
  ret.dh_char =
    C_ipl8u_idx_share ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl8u-idx-share
 */
DHDOC (K_ipl8u_idx_share_R3d46ee0a, X_ipl8u_idx_share, "C_ipl8u_idx_share", 0,
       0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl8s-idx-share
 */
DH (X_ipl8s_idx_share)
{
  dharg ret;
  ret.dh_char =
    C_ipl8s_idx_share ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl8s-idx-share
 */
DHDOC (K_ipl8s_idx_share_R2c50b707, X_ipl8s_idx_share, "C_ipl8s_idx_share", 0,
       0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_BYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl16s-idx-share
 */
DH (X_ipl16s_idx_share)
{
  dharg ret;
  ret.dh_char =
    C_ipl16s_idx_share ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl16s-idx-share
 */
DHDOC (K_ipl16s_idx_share_R8d967367, X_ipl16s_idx_share, "C_ipl16s_idx_share",
       0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_SHORT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl32s-idx-share
 */
DH (X_ipl32s_idx_share)
{
  dharg ret;
  ret.dh_char =
    C_ipl32s_idx_share ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl32s-idx-share
 */
DHDOC (K_ipl32s_idx_share_R0cd2e357, X_ipl32s_idx_share, "C_ipl32s_idx_share",
       0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl32f-idx-share
 */
DH (X_ipl32f_idx_share)
{
  dharg ret;
  ret.dh_char =
    C_ipl32f_idx_share ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl32f-idx-share
 */
DHDOC (K_ipl32f_idx_share_R2cc7217b, X_ipl32f_idx_share, "C_ipl32f_idx_share",
       0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ipl64f-idx-share
 */
DH (X_ipl64f_idx_share)
{
  dharg ret;
  ret.dh_char =
    C_ipl64f_idx_share ((IplImage *) a[1].dh_gptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC ipl64f-idx-share
 */
DHDOC (K_ipl64f_idx_share_R2d01ae6f, X_ipl64f_idx_share, "C_ipl64f_idx_share",
       0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("IplImage *"),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx8u-ipl-share
 */
DH (X_idx8u_ipl_share)
{
  dharg ret;
  ret.dh_char =
    C_idx8u_ipl_share (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx8u-ipl-share
 */
DHDOC (K_idx8u_ipl_share_R518f2d66, X_idx8u_ipl_share, "C_idx8u_ipl_share", 0,
       0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx8s-ipl-share
 */
DH (X_idx8s_ipl_share)
{
  dharg ret;
  ret.dh_char =
    C_idx8s_ipl_share (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx8s-ipl-share
 */
DHDOC (K_idx8s_ipl_share_R73a39f7c, X_idx8s_ipl_share, "C_idx8s_ipl_share", 0,
       0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_BYTE, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx16s-ipl-share
 */
DH (X_idx16s_ipl_share)
{
  dharg ret;
  ret.dh_char =
    C_idx16s_ipl_share (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx16s-ipl-share
 */
DHDOC (K_idx16s_ipl_share_R302e17bd, X_idx16s_ipl_share, "C_idx16s_ipl_share",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_SHORT, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx32s-ipl-share
 */
DH (X_idx32s_ipl_share)
{
  dharg ret;
  ret.dh_char =
    C_idx32s_ipl_share (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx32s-ipl-share
 */
DHDOC (K_idx32s_ipl_share_R32a737dc, X_idx32s_ipl_share, "C_idx32s_ipl_share",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_INT, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx32f-ipl-share
 */
DH (X_idx32f_ipl_share)
{
  dharg ret;
  ret.dh_char =
    C_idx32f_ipl_share (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx32f-ipl-share
 */
DHDOC (K_idx32f_ipl_share_R728cb384, X_idx32f_ipl_share, "C_idx32f_ipl_share",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_FLT, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx64f-ipl-share
 */
DH (X_idx64f_ipl_share)
{
  dharg ret;
  ret.dh_char =
    C_idx64f_ipl_share (a[1].dh_idx_ptr, (IplImage *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC idx64f-ipl-share
 */
DHDOC (K_idx64f_ipl_share_R7101adac, X_idx64f_ipl_share, "C_idx64f_ipl_share",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL, DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB print-ipl-info
 */
DH (X_print_ipl_info)
{
  dharg ret;
  ret.dh_char = C_print_ipl_info ((IplImage *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC print-ipl-info
 */
DHDOC (K_print_ipl_info_Rc7df00c0, X_print_ipl_info, "C_print_ipl_info", 0,
       0) =
{
DH_FUNC (1), DH_GPTR ("IplImage *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_aux_convert (void)
{
  dh_define ("dummy_aux_convert", &K_dummy_aux_convert_Ra8b05737);
  dh_define ("ipl8u-idx", &K_ipl8u_idx_R3d46ee0a);
  dh_define ("ipl8s-idx", &K_ipl8s_idx_R2c50b707);
  dh_define ("ipl16s-idx", &K_ipl16s_idx_R8d967367);
  dh_define ("ipl32s-idx", &K_ipl32s_idx_R0cd2e357);
  dh_define ("ipl32f-idx", &K_ipl32f_idx_R2cc7217b);
  dh_define ("ipl64f-idx", &K_ipl64f_idx_R2d01ae6f);
  dh_define ("idx8u-ipl", &K_idx8u_ipl_R518f2d66);
  dh_define ("idx8s-ipl", &K_idx8s_ipl_R73a39f7c);
  dh_define ("idx16s-ipl", &K_idx16s_ipl_R302e17bd);
  dh_define ("idx32s-ipl", &K_idx32s_ipl_R32a737dc);
  dh_define ("idx32f-ipl", &K_idx32f_ipl_R728cb384);
  dh_define ("idx64f-ipl", &K_idx64f_ipl_R7101adac);
  dh_define ("ipl8u-idx-share", &K_ipl8u_idx_share_R3d46ee0a);
  dh_define ("ipl8s-idx-share", &K_ipl8s_idx_share_R2c50b707);
  dh_define ("ipl16s-idx-share", &K_ipl16s_idx_share_R8d967367);
  dh_define ("ipl32s-idx-share", &K_ipl32s_idx_share_R0cd2e357);
  dh_define ("ipl32f-idx-share", &K_ipl32f_idx_share_R2cc7217b);
  dh_define ("ipl64f-idx-share", &K_ipl64f_idx_share_R2d01ae6f);
  dh_define ("idx8u-ipl-share", &K_idx8u_ipl_share_R518f2d66);
  dh_define ("idx8s-ipl-share", &K_idx8s_ipl_share_R73a39f7c);
  dh_define ("idx16s-ipl-share", &K_idx16s_ipl_share_R302e17bd);
  dh_define ("idx32s-ipl-share", &K_idx32s_ipl_share_R32a737dc);
  dh_define ("idx32f-ipl-share", &K_idx32f_ipl_share_R728cb384);
  dh_define ("idx64f-ipl-share", &K_idx64f_ipl_share_R7101adac);
  dh_define ("print-ipl-info", &K_print_ipl_info_Rc7df00c0);
}

int majver_aux_convert = 40;
int minver_aux_convert = 10;

#endif
