/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * USER DEFINED HEADERS
 */
#include <fftw3.h>
/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"

/* ---------------------------------------- */

/*
 * FUNCTION fftw-dft-c2c-1d
 */
extern_c char
C_fftw_dft_c2c_1d (struct idx *L1_in, struct idx *L1_out, int L1_forward,
		   char L1_norm)
{
  TRACE_PUSH ("C_fftw_dft_c2c_1d");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    char L_Tmp3;
    if ((2 != (L1_in)->dim[1]))
      {
	run_time_error ("second dimension of input should be 2");
      }
    if ((2 != (L1_out)->dim[1]))
      {
	run_time_error ("second dimension of output should be 2");
      }
    if (((L1_in)->dim[0] != (L1_out)->dim[0]))
      {
	run_time_error ("input and output have different sizes");
      }
    Midx_contiguep2 (L1_in, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep2 (L1_out, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("vector not contiguous");
      }
    {
      int L2_4_n;
      L2_4_n = (L1_in)->dim[0];
      {
	fftw_plan p;
	p =
	  fftw_plan_dft_1d ((L2_4_n), IDX_PTR ((L1_in), fftw_complex),
			    IDX_PTR ((L1_out), fftw_complex),
			    (((L1_forward) >
			      0) ? FFTW_FORWARD : FFTW_BACKWARD),
			    FFTW_ESTIMATE);
	fftw_execute (p);
	fftw_destroy_plan (p);
      }
      if (L1_norm)
	{
	  {
	    real L3_5_s;
	    L3_5_s = (1 / (real) (real) (L2_4_n));
	    {
	      int _i_max = (L1_out)->dim[0];
	      int _L1_out_mod0 = (L1_out)->mod[0];
	      {
		int i;
		real *out = IDX_PTR ((L1_out), real);
		for (i = 0; i < _i_max; i++)
		  {
		    out[0] *= (L3_5_s);
		    out[1] *= (L3_5_s);
		    out += _L1_out_mod0;
		  }
	      }
	    }
	  }
	}
      L_Tmp3 = 0;
    }
    TRACE_POP ("C_fftw_dft_c2c_1d");
    return 0;
  }
}

/*
 * FUNCTION fftw-dft-r2c-1d
 */
extern_c char
C_fftw_dft_r2c_1d (struct idx *L1_in, struct idx *L1_out, char L1_norm)
{
  TRACE_PUSH ("C_fftw_dft_r2c_1d");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    char L_Tmp3;
    if ((2 != (L1_out)->dim[1]))
      {
	run_time_error ("second dimension of output should be 2");
      }
    if (((L1_in)->dim[0] != (L1_out)->dim[0]))
      {
	run_time_error ("input and output have different sizes");
      }
    Midx_contiguep1 (L1_in, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep2 (L1_out, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("vector not contiguous");
      }
    {
      int L2_4_n;
      L2_4_n = (L1_in)->dim[0];
      {
	fftw_plan p;
	p =
	  fftw_plan_dft_r2c_1d ((L2_4_n), IDX_PTR ((L1_in), double),
				IDX_PTR ((L1_out), fftw_complex),
				FFTW_ESTIMATE);
	fftw_execute (p);
	fftw_destroy_plan (p);
      }
      if (L1_norm)
	{
	  {
	    real L3_5_s;
	    L3_5_s = (1 / (real) (real) (L2_4_n));
	    {
	      int _i_max = (L1_out)->dim[0];
	      int _L1_out_mod0 = (L1_out)->mod[0];
	      {
		int i;
		real *out = IDX_PTR ((L1_out), real);
		for (i = 0; i < _i_max; i++)
		  {
		    out[0] *= (L3_5_s);
		    out[1] *= (L3_5_s);
		    out += _L1_out_mod0;
		  }
	      }
	    }
	  }
	}
      L_Tmp3 = 0;
    }
    TRACE_POP ("C_fftw_dft_r2c_1d");
    return 0;
  }
}

/*
 * FUNCTION fftw-dft-c2r-1d
 */
extern_c char
C_fftw_dft_c2r_1d (struct idx *L1_in, struct idx *L1_out, char L1_norm)
{
  TRACE_PUSH ("C_fftw_dft_c2r_1d");
  {
    char L_Tmp0;
    char L_Tmp1_contigue;
    char L_Tmp2_contigue;
    char L_Tmp3;
    if ((2 != (L1_in)->dim[1]))
      {
	run_time_error ("second dimension of output should be 2");
      }
    if (((L1_in)->dim[0] != (L1_out)->dim[0]))
      {
	run_time_error ("input and output have different sizes");
      }
    Midx_contiguep2 (L1_in, L_Tmp1_contigue);
    if (!(L_Tmp1_contigue))
      {
	L_Tmp0 = 1;
      }
    else
      {
	Midx_contiguep1 (L1_out, L_Tmp2_contigue);
	if (!(L_Tmp2_contigue))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("vector not contiguous");
      }
    {
      int L2_4_n;
      L2_4_n = (L1_out)->dim[0];
      {
	fftw_plan p;
	p =
	  fftw_plan_dft_c2r_1d ((L2_4_n), IDX_PTR ((L1_in), fftw_complex),
				IDX_PTR ((L1_out), double), FFTW_ESTIMATE);
	fftw_execute (p);
	fftw_destroy_plan (p);
      }
      if (L1_norm)
	{
	  {
	    real L3_5_s;
	    L3_5_s = (1 / (real) (real) (L2_4_n));
	    {
	      int _i_max = (L1_out)->dim[0];
	      int _L1_out_mod0 = (L1_out)->mod[0];
	      {
		int i;
		real *out = IDX_PTR ((L1_out), real);
		for (i = 0; i < _i_max; i++)
		  {
		    out[0] *= (L3_5_s);
		    out += _L1_out_mod0;
		  }
	      }
	    }
	  }
	}
      L_Tmp3 = 0;
    }
    TRACE_POP ("C_fftw_dft_c2r_1d");
    return 0;
  }
}

/*
 * FUNCTION fftw-dft-c2c-2d
 */
extern_c char
C_fftw_dft_c2c_2d (struct idx *L1_in, struct idx *L1_out, int L1_forward,
		   char L1_norm)
{
  TRACE_PUSH ("C_fftw_dft_c2c_2d");
  {
    char L_Tmp0;
    char L_Tmp1;
    char L_Tmp2_contigue;
    char L_Tmp3_contigue;
    char L_Tmp4;
    if ((2 != (L1_in)->dim[2]))
      {
	run_time_error ("second dimension of input should be 2");
      }
    if ((2 != (L1_out)->dim[2]))
      {
	run_time_error ("second dimension of output should be 2");
      }
    if (((L1_in)->dim[0] != (L1_out)->dim[0]))
      {
	L_Tmp0 = 1;
      }
    else
      {
	if (((L1_in)->dim[1] != (L1_out)->dim[1]))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("input and output have different sizes");
      }
    Midx_contiguep3 (L1_in, L_Tmp2_contigue);
    if (!(L_Tmp2_contigue))
      {
	L_Tmp1 = 1;
      }
    else
      {
	Midx_contiguep3 (L1_out, L_Tmp3_contigue);
	if (!(L_Tmp3_contigue))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    L_Tmp1 = 0;
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("vector not contiguous");
      }
    {
      int L2_5_n0;
      int L2_6_n1;
      L2_5_n0 = (L1_in)->dim[0];
      L2_6_n1 = (L1_in)->dim[1];
      {
	fftw_plan p;
	p =
	  fftw_plan_dft_2d ((L2_6_n1), (L2_5_n0),
			    IDX_PTR ((L1_in), fftw_complex),
			    IDX_PTR ((L1_out), fftw_complex),
			    (((L1_forward) >
			      0) ? FFTW_FORWARD : FFTW_BACKWARD),
			    FFTW_ESTIMATE);
	fftw_execute (p);
	fftw_destroy_plan (p);
      }
      if (L1_norm)
	{
	  {
	    real L3_7_s;
	    L3_7_s = (1 / (real) (real) ((L2_5_n0 * L2_6_n1)));
	    {
	      int _i_max = (L1_out)->dim[0];
	      int _L1_out_mod0 = (L1_out)->mod[0];
	      int _j_max = (L1_out)->dim[1];
	      int _L1_out_mod1 = (L1_out)->mod[1];
	      {
		int i;
		real *_L1_out_loop_i = IDX_PTR ((L1_out), real);
		for (i = 0; i < _i_max; i++)
		  {
		    int j;
		    real *out = _L1_out_loop_i;
		    for (j = 0; j < _j_max; j++)
		      {
			out[0] *= (L3_7_s);
			out[1] *= (L3_7_s);
			out += _L1_out_mod1;
		      }
		    _L1_out_loop_i += _L1_out_mod0;
		  }
	      }
	    }
	  }
	}
      L_Tmp4 = 0;
    }
    TRACE_POP ("C_fftw_dft_c2c_2d");
    return 0;
  }
}

/*
 * FUNCTION fftw-dft-r2c-2d
 */
extern_c char
C_fftw_dft_r2c_2d (struct idx *L1_in, struct idx *L1_out, char L1_norm)
{
  TRACE_PUSH ("C_fftw_dft_r2c_2d");
  {
    char L_Tmp0;
    char L_Tmp1;
    char L_Tmp2_contigue;
    char L_Tmp3_contigue;
    char L_Tmp4;
    if ((2 != (L1_out)->dim[2]))
      {
	run_time_error ("second dimension of output should be 2");
      }
    if (((L1_in)->dim[0] != (L1_out)->dim[0]))
      {
	L_Tmp0 = 1;
      }
    else
      {
	if (((L1_in)->dim[1] != (L1_out)->dim[1]))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("input and output have different sizes");
      }
    Midx_contiguep2 (L1_in, L_Tmp2_contigue);
    if (!(L_Tmp2_contigue))
      {
	L_Tmp1 = 1;
      }
    else
      {
	Midx_contiguep3 (L1_out, L_Tmp3_contigue);
	if (!(L_Tmp3_contigue))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    L_Tmp1 = 0;
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("vector not contiguous");
      }
    {
      int L2_5_n0;
      int L2_6_n1;
      L2_5_n0 = (L1_in)->dim[0];
      L2_6_n1 = (L1_in)->dim[1];
      {
	fftw_plan p;
	p =
	  fftw_plan_dft_r2c_2d ((L2_6_n1), (L2_5_n0),
				IDX_PTR ((L1_in), double), IDX_PTR ((L1_out),
								    fftw_complex),
				FFTW_ESTIMATE);
	fftw_execute (p);
	fftw_destroy_plan (p);
      }
      if (L1_norm)
	{
	  {
	    real L3_7_s;
	    L3_7_s = (1 / (real) (real) ((L2_5_n0 * L2_6_n1)));
	    {
	      int _i_max = (L1_out)->dim[0];
	      int _L1_out_mod0 = (L1_out)->mod[0];
	      int _j_max = (L1_out)->dim[1];
	      int _L1_out_mod1 = (L1_out)->mod[1];
	      {
		int i;
		real *_L1_out_loop_i = IDX_PTR ((L1_out), real);
		for (i = 0; i < _i_max; i++)
		  {
		    int j;
		    real *out = _L1_out_loop_i;
		    for (j = 0; j < _j_max; j++)
		      {
			out[0] *= (L3_7_s);
			out[1] *= (L3_7_s);
			out += _L1_out_mod1;
		      }
		    _L1_out_loop_i += _L1_out_mod0;
		  }
	      }
	    }
	  }
	}
      L_Tmp4 = 0;
    }
    TRACE_POP ("C_fftw_dft_r2c_2d");
    return 0;
  }
}

/*
 * FUNCTION idx1-complex2norm
 */
extern_c char
C_idx1_complex2norm (struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx1_complex2norm");
  {
    if ((2 != (L1_in)->dim[1]))
      {
	run_time_error ("not a complex vector");
      }
    if ((1 != (L1_in)->mod[1]))
      {
	run_time_error ("real and imaginary parts not contiguous");
      }
    {
      int _i_max = (L1_in)->dim[0];
      int _L1_in_mod0 = (L1_in)->mod[0];
      int _L1_out_mod0 = (L1_out)->mod[0];
      if (_i_max != (L1_out)->dim[0])
	run_time_error ("idx L1_out's dim 0 doesn't match idx L1_in's dim 0");
      {
	int i;
	real *in = IDX_PTR ((L1_in), real);
	real *out = IDX_PTR ((L1_out), real);
	for (i = 0; i < _i_max; i++)
	  {
	    *out = sqrt (in[0] * in[0] + in[1] * in[1]);
	    in += _L1_in_mod0;
	    out += _L1_out_mod0;
	  }
      }
    }
    TRACE_POP ("C_idx1_complex2norm");
    return 0;
  }
}

/*
 * FUNCTION idx1-power-spectrum
 */
extern_c char
C_idx1_power_spectrum (struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_idx1_power_spectrum");
  {
    if (((L1_in)->dim[0] != (L1_out)->dim[0]))
      {
	run_time_error ("in and out must have the same size");
      }
    {
      Midx_declare (L2_0_0_matrix, 2);
      Msrg_declare (L2_1_0_srg);
      struct idx *L2_2_ft;
      Midx_init (L2_0_0_matrix, 2);
      Msrg_init (L2_1_0_srg, ST_D);
      (L2_0_0_matrix)->srg = L2_1_0_srg;
      Midx_init_dim2 (L2_0_0_matrix, (L1_in)->dim[0], 2);
      RTERR_DIM (L2_0_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_0_matrix->dim[1] <= 0);
      Midx_maclear (L2_0_0_matrix, real);
      L2_2_ft = L2_0_0_matrix;
      C_fftw_dft_r2c_1d (L1_in, L2_2_ft, 1);
      C_idx1_complex2norm (L2_2_ft, L1_out);
      Msrg_free (L2_1_0_srg);
    }
    TRACE_POP ("C_idx1_power_spectrum");
    return 0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/*
 * STUB fftw-dft-c2c-1d
 */
DH (X_fftw_dft_c2c_1d)
{
  dharg ret;
  ret.dh_char =
    C_fftw_dft_c2c_1d (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
		       a[4].dh_char);
  return ret;
}

/*
 * DHDOC fftw-dft-c2c-1d
 */
DHDOC (K_fftw_dft_c2c_1d_Raa4dd1a3, X_fftw_dft_c2c_1d, "C_fftw_dft_c2c_1d", 0,
       0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL, DH_INT, DH_BOOL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fftw-dft-r2c-1d
 */
DH (X_fftw_dft_r2c_1d)
{
  dharg ret;
  ret.dh_char =
    C_fftw_dft_r2c_1d (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_char);
  return ret;
}

/*
 * DHDOC fftw-dft-r2c-1d
 */
DHDOC (K_fftw_dft_r2c_1d_R793ba221, X_fftw_dft_r2c_1d, "C_fftw_dft_r2c_1d", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL, DH_BOOL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fftw-dft-c2r-1d
 */
DH (X_fftw_dft_c2r_1d)
{
  dharg ret;
  ret.dh_char =
    C_fftw_dft_c2r_1d (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_char);
  return ret;
}

/*
 * DHDOC fftw-dft-c2r-1d
 */
DHDOC (K_fftw_dft_c2r_1d_R793ba221, X_fftw_dft_c2r_1d, "C_fftw_dft_c2r_1d", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL, DH_BOOL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fftw-dft-c2c-2d
 */
DH (X_fftw_dft_c2c_2d)
{
  dharg ret;
  ret.dh_char =
    C_fftw_dft_c2c_2d (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
		       a[4].dh_char);
  return ret;
}

/*
 * DHDOC fftw-dft-c2c-2d
 */
DHDOC (K_fftw_dft_c2c_2d_Raa4dd1a3, X_fftw_dft_c2c_2d, "C_fftw_dft_c2c_2d", 0,
       0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL, DH_INT, DH_BOOL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fftw-dft-r2c-2d
 */
DH (X_fftw_dft_r2c_2d)
{
  dharg ret;
  ret.dh_char =
    C_fftw_dft_r2c_2d (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_char);
  return ret;
}

/*
 * DHDOC fftw-dft-r2c-2d
 */
DHDOC (K_fftw_dft_r2c_2d_R793ba221, X_fftw_dft_r2c_2d, "C_fftw_dft_r2c_2d", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_REAL, DH_BOOL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx1-complex2norm
 */
DH (X_idx1_complex2norm)
{
  dharg ret;
  ret.dh_char = C_idx1_complex2norm (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx1-complex2norm
 */
DHDOC (K_idx1_complex2norm_R4501aced, X_idx1_complex2norm,
       "C_idx1_complex2norm", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx1-power-spectrum
 */
DH (X_idx1_power_spectrum)
{
  dharg ret;
  ret.dh_char = C_idx1_power_spectrum (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx1-power-spectrum
 */
DHDOC (K_idx1_power_spectrum_R4501aced, X_idx1_power_spectrum,
       "C_idx1_power_spectrum", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_REAL,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_fftw (void)
{
  dh_define ("fftw-dft-c2c-1d", &K_fftw_dft_c2c_1d_Raa4dd1a3);
  dh_define ("fftw-dft-r2c-1d", &K_fftw_dft_r2c_1d_R793ba221);
  dh_define ("fftw-dft-c2r-1d", &K_fftw_dft_c2r_1d_R793ba221);
  dh_define ("fftw-dft-c2c-2d", &K_fftw_dft_c2c_2d_Raa4dd1a3);
  dh_define ("fftw-dft-r2c-2d", &K_fftw_dft_r2c_2d_R793ba221);
  dh_define ("idx1-complex2norm", &K_idx1_complex2norm_R4501aced);
  dh_define ("idx1-power-spectrum", &K_idx1_power_spectrum_R4501aced);
}

int majver_fftw = 40;
int minver_fftw = 10;

#endif
