/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"

/*
 * DECLARATIONS
 */
extern_c char C_rgbaim_histo32 (struct idx *, struct idx *, struct idx *);
extern_c char C_cqu_init_proto (struct idx *, struct idx *);
extern_c char C_cqu_kmeans (struct idx *, struct idx *, struct idx *, int,
			    struct idx *, struct idx *, struct idx *,
			    struct idx *);

/* ---------------------------------------- */

/*
 * FUNCTION rgbaim-quickquant
 */
extern_c char
C_rgbaim_quickquant (struct idx *L1_rgbaim, struct idx *L1_ubim,
		     struct idx *L1_ppal, struct idx *L1_assign)
{
  TRACE_PUSH ("C_rgbaim_quickquant");
  {
    char L_Tmp0;
    if (((L1_rgbaim)->dim[0] != (L1_ubim)->dim[0]))
      {
	L_Tmp0 = 1;
      }
    else
      {
	if (((L1_rgbaim)->dim[1] != (L1_ubim)->dim[1]))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("input and output images have inconsistent sizes");
      }
    if (((L1_ppal)->dim[0] != (L1_assign)->dim[0]))
      {
	run_time_error ("histogram and label arrays have different sizes");
      }
    {
      Midx_declare (L2_1_0_matrix, 1);
      Msrg_declare (L2_2_0_srg);
      struct idx *L2_3_rgb2label;
      gptr L2_4_prgb2label;
      Midx_init (L2_1_0_matrix, 1);
      Msrg_init (L2_2_0_srg, ST_I32);
      (L2_1_0_matrix)->srg = L2_2_0_srg;
      Midx_init_dim1 (L2_1_0_matrix, (32 * 32 * 32));
      RTERR_DIM (L2_1_0_matrix->dim[0] <= 0);
      Midx_maclear (L2_1_0_matrix, int);
      L2_3_rgb2label = L2_1_0_matrix;
      L2_4_prgb2label = (gptr) (IDX_PTR ((L2_3_rgb2label), int));
      {
	register flt *p;
	register int *l;
	register int j, jmax = (L1_ppal)->dim[0];
	register int imat1_m0 = (L1_ppal)->mod[0];
	register int imat2_m0 = (L1_assign)->mod[0];
	p = IDX_PTR ((L1_ppal), flt);
	l = IDX_PTR ((L1_assign), int);
	for (j = 0; j < jmax; j++)
	  {;
	    {
	      register int offset;
	      offset =
		(((int) (p[0]) & 0xf8) << 7) | (((int) (p[1]) & 0xf8) << 2) |
		((int) (p[2]) >> 3);
	      ((int *) ((L2_4_prgb2label)))[offset] = *l;
	    }
	    p += imat1_m0;
	    l += imat2_m0;
      }}
      {
	register unsigned char *_idx2loopc1, *p;
	register unsigned char *_idx2loopc2, *s;
	register int i, _imax = (L1_rgbaim)->dim[0];
	register int j, _jmax = (L1_rgbaim)->dim[1];
	register int _imat1_m0 = (L1_rgbaim)->mod[0];
	register int _imat1_m1 = (L1_rgbaim)->mod[1];
	register int _imat2_m0 = (L1_ubim)->mod[0];
	register int _imat2_m1 = (L1_ubim)->mod[1];
	_idx2loopc1 = IDX_PTR ((L1_rgbaim), unsigned char);
	_idx2loopc2 = IDX_PTR ((L1_ubim), unsigned char);
	for (i = 0; i < _imax; i++)
	  {;
	    p = _idx2loopc1;
	    s = _idx2loopc2;
	    for (j = 0; j < _jmax; j++)
	      {;
		{
		  register int offset;
		  offset = (((int) (p[0]) & 0xf8) << 7) |
		    (((int) (p[1]) & 0xf8) << 2) | ((int) (p[2]) >> 3);
		  *s =
		    (unsigned char) (((int *) ((L2_4_prgb2label)))[offset]);
		}
		p += _imat1_m1;
		s += _imat2_m1;
	      }
	    _idx2loopc1 += _imat1_m0;
	    _idx2loopc2 += _imat2_m0;
      }}
      Msrg_free (L2_2_0_srg);
    }
    TRACE_POP ("C_rgbaim_quickquant");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-greyquant
 */
extern_c char
C_rgbaim_greyquant (struct idx *L1_rgbaim, struct idx *L1_ubim,
		    struct idx *L1_proto, int L1_polarity, flt L1_bsatur,
		    flt L1_fsatur)
{
  TRACE_PUSH ("C_rgbaim_greyquant");
  {
    char L_Tmp0;
    if (((L1_bsatur + L1_fsatur) >= 0.95))
      {
	run_time_error ("inconsistent values for bsatur and fsatur");
      }
    if ((0 != L1_polarity))
      {
	if ((1 != L1_polarity))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    else
      {
	L_Tmp0 = 0;
      }
    if (L_Tmp0)
      {
	run_time_error ("invalid polarity value");
      }
    {
      int L2_1_bg;
      int L2_2_fg;
      real L2_3_ro;
      real L2_4_go;
      real L2_5_bo;
      real L2_6_rv;
      real L2_7_gv;
      real L2_8_bv;
      real L2_9_sqnorm;
      if ((0 == L1_polarity))
	{
	  L2_1_bg = 1;
	}
      else
	{
	  L2_1_bg = 0;
	}
      if ((0 == L1_polarity))
	{
	  L2_2_fg = 0;
	}
      else
	{
	  L2_2_fg = 1;
	}
      RTERR_BOUND (L2_1_bg < 0 || L2_1_bg >= (L1_proto)->dim[0]);
      RTERR_BOUND (0 >= (L1_proto)->dim[1]);
      L2_3_ro =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_1_bg) +
		      (L1_proto)->mod[1] * ((int) 0)];
      RTERR_BOUND (L2_1_bg < 0 || L2_1_bg >= (L1_proto)->dim[0]);
      RTERR_BOUND (1 >= (L1_proto)->dim[1]);
      L2_4_go =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_1_bg) +
		      (L1_proto)->mod[1] * ((int) 1)];
      RTERR_BOUND (L2_1_bg < 0 || L2_1_bg >= (L1_proto)->dim[0]);
      RTERR_BOUND (2 >= (L1_proto)->dim[1]);
      L2_5_bo =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_1_bg) +
		      (L1_proto)->mod[1] * ((int) 2)];
      RTERR_BOUND (L2_2_fg < 0 || L2_2_fg >= (L1_proto)->dim[0]);
      RTERR_BOUND (0 >= (L1_proto)->dim[1]);
      L2_6_rv =
	(IDX_PTR (L1_proto, flt)
	 [(L1_proto)->mod[0] * ((int) L2_2_fg) +
	  (L1_proto)->mod[1] * ((int) 0)] - L2_3_ro);
      RTERR_BOUND (L2_2_fg < 0 || L2_2_fg >= (L1_proto)->dim[0]);
      RTERR_BOUND (1 >= (L1_proto)->dim[1]);
      L2_7_gv =
	(IDX_PTR (L1_proto, flt)
	 [(L1_proto)->mod[0] * ((int) L2_2_fg) +
	  (L1_proto)->mod[1] * ((int) 1)] - L2_4_go);
      RTERR_BOUND (L2_2_fg < 0 || L2_2_fg >= (L1_proto)->dim[0]);
      RTERR_BOUND (2 >= (L1_proto)->dim[1]);
      L2_8_bv =
	(IDX_PTR (L1_proto, flt)
	 [(L1_proto)->mod[0] * ((int) L2_2_fg) +
	  (L1_proto)->mod[1] * ((int) 2)] - L2_5_bo);
      L2_9_sqnorm = 0;
      L2_3_ro = (L2_3_ro + (L1_bsatur * L2_6_rv));
      L2_4_go = (L2_4_go + (L1_bsatur * L2_7_gv));
      L2_5_bo = (L2_5_bo + (L1_bsatur * L2_8_bv));
      L2_6_rv = (L2_6_rv + (-((L1_bsatur + L1_fsatur) * L2_6_rv)));
      L2_7_gv = (L2_7_gv + (-((L1_bsatur + L1_fsatur) * L2_7_gv)));
      L2_8_bv = (L2_8_bv + (-((L1_bsatur + L1_fsatur) * L2_8_bv)));
      L2_9_sqnorm =
	((L2_6_rv * L2_6_rv) + (L2_7_gv * L2_7_gv) + (L2_8_bv * L2_8_bv));
      if ((0 == L2_9_sqnorm))
	{
	  run_time_error ("prototypes are identical");
	}
      L2_6_rv = ((255 * L2_6_rv) / (real) L2_9_sqnorm);
      L2_7_gv = ((255 * L2_7_gv) / (real) L2_9_sqnorm);
      L2_8_bv = ((255 * L2_8_bv) / (real) L2_9_sqnorm);
      {
	register unsigned char *_idx2loopc1, *p;
	register unsigned char *_idx2loopc2, *s;
	register int i, _imax = (L1_rgbaim)->dim[0];
	register int j, _jmax = (L1_rgbaim)->dim[1];
	register int _imat1_m0 = (L1_rgbaim)->mod[0];
	register int _imat1_m1 = (L1_rgbaim)->mod[1];
	register int _imat2_m0 = (L1_ubim)->mod[0];
	register int _imat2_m1 = (L1_ubim)->mod[1];
	_idx2loopc1 = IDX_PTR ((L1_rgbaim), unsigned char);
	_idx2loopc2 = IDX_PTR ((L1_ubim), unsigned char);
	for (i = 0; i < _imax; i++)
	  {;
	    p = _idx2loopc1;
	    s = _idx2loopc2;
	    for (j = 0; j < _jmax; j++)
	      {;
		{
		  register flt r, g, b, c;
		  r = (flt) (p[0]);
		  g = (flt) (p[1]);
		  b = (flt) (p[2]);
		  c =
		    (r - (L2_3_ro)) * (L2_6_rv) + (g -
						   (L2_4_go)) * (L2_7_gv) +
		    (b - (L2_5_bo)) * (L2_8_bv);
		  /* saturate */
		  *s = (unsigned char) (c < 0 ? 0 : c > 255 ? 255 : c);
		}
		p += _imat1_m1;
		s += _imat2_m1;
	      }
	    _idx2loopc1 += _imat1_m0;
	    _idx2loopc2 += _imat2_m0;
      }}
    }
    TRACE_POP ("C_rgbaim_greyquant");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-projectcolors
 */
extern_c char
C_rgbaim_projectcolors (struct idx *L1_rgbaim, struct idx *L1_ubim,
			struct idx *L1_proto, int L1_polarity, flt L1_bsatur,
			flt L1_fsatur)
{
  TRACE_PUSH ("C_rgbaim_projectcolors");
  {
    char L_Tmp0;
    if (((L1_bsatur + L1_fsatur) >= 0.95))
      {
	run_time_error ("inconsistent values for bsatur and fsatur");
      }
    if ((0 != L1_polarity))
      {
	if ((1 != L1_polarity))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    else
      {
	L_Tmp0 = 0;
      }
    if (L_Tmp0)
      {
	run_time_error ("invalid polarity value");
      }
    {
      int L2_1_bg;
      int L2_2_fg;
      real L2_3_rbg;
      real L2_4_gbg;
      real L2_5_bbg;
      real L2_6_ro;
      real L2_7_go;
      real L2_8_bo;
      real L2_9_rfg;
      real L2_10_gfg;
      real L2_11_bfg;
      real L2_12_rv;
      real L2_13_gv;
      real L2_14_bv;
      real L2_15_sqnorm;
      if ((0 == L1_polarity))
	{
	  L2_1_bg = 1;
	}
      else
	{
	  L2_1_bg = 0;
	}
      if ((0 == L1_polarity))
	{
	  L2_2_fg = 0;
	}
      else
	{
	  L2_2_fg = 1;
	}
      RTERR_BOUND (L2_1_bg < 0 || L2_1_bg >= (L1_proto)->dim[0]);
      RTERR_BOUND (0 >= (L1_proto)->dim[1]);
      L2_3_rbg =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_1_bg) +
		      (L1_proto)->mod[1] * ((int) 0)];
      RTERR_BOUND (L2_1_bg < 0 || L2_1_bg >= (L1_proto)->dim[0]);
      RTERR_BOUND (1 >= (L1_proto)->dim[1]);
      L2_4_gbg =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_1_bg) +
		      (L1_proto)->mod[1] * ((int) 1)];
      RTERR_BOUND (L2_1_bg < 0 || L2_1_bg >= (L1_proto)->dim[0]);
      RTERR_BOUND (2 >= (L1_proto)->dim[1]);
      L2_5_bbg =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_1_bg) +
		      (L1_proto)->mod[1] * ((int) 2)];
      L2_6_ro = L2_3_rbg;
      L2_7_go = L2_4_gbg;
      L2_8_bo = L2_5_bbg;
      RTERR_BOUND (L2_2_fg < 0 || L2_2_fg >= (L1_proto)->dim[0]);
      RTERR_BOUND (0 >= (L1_proto)->dim[1]);
      L2_9_rfg =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_2_fg) +
		      (L1_proto)->mod[1] * ((int) 0)];
      RTERR_BOUND (L2_2_fg < 0 || L2_2_fg >= (L1_proto)->dim[0]);
      RTERR_BOUND (1 >= (L1_proto)->dim[1]);
      L2_10_gfg =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_2_fg) +
		      (L1_proto)->mod[1] * ((int) 1)];
      RTERR_BOUND (L2_2_fg < 0 || L2_2_fg >= (L1_proto)->dim[0]);
      RTERR_BOUND (2 >= (L1_proto)->dim[1]);
      L2_11_bfg =
	IDX_PTR (L1_proto,
		 flt)[(L1_proto)->mod[0] * ((int) L2_2_fg) +
		      (L1_proto)->mod[1] * ((int) 2)];
      L2_12_rv = (L2_9_rfg - L2_6_ro);
      L2_13_gv = (L2_10_gfg - L2_7_go);
      L2_14_bv = (L2_11_bfg - L2_8_bo);
      L2_15_sqnorm = 0;
      L2_6_ro = (L2_6_ro + (L1_bsatur * L2_12_rv));
      L2_7_go = (L2_7_go + (L1_bsatur * L2_13_gv));
      L2_8_bo = (L2_8_bo + (L1_bsatur * L2_14_bv));
      L2_12_rv = (L2_12_rv + (-((L1_bsatur + L1_fsatur) * L2_12_rv)));
      L2_13_gv = (L2_13_gv + (-((L1_bsatur + L1_fsatur) * L2_13_gv)));
      L2_14_bv = (L2_14_bv + (-((L1_bsatur + L1_fsatur) * L2_14_bv)));
      L2_15_sqnorm =
	((L2_12_rv * L2_12_rv) + (L2_13_gv * L2_13_gv) +
	 (L2_14_bv * L2_14_bv));
      if ((0 == L2_15_sqnorm))
	{
	  run_time_error ("prototypes are identical");
	}
      L2_12_rv = (L2_12_rv / (real) L2_15_sqnorm);
      L2_13_gv = (L2_13_gv / (real) L2_15_sqnorm);
      L2_14_bv = (L2_14_bv / (real) L2_15_sqnorm);
      {
	register unsigned char *_idx2loopc1, *p;
	register unsigned char *_idx2loopc2, *s;
	register int i, _imax = (L1_rgbaim)->dim[0];
	register int j, _jmax = (L1_rgbaim)->dim[1];
	register int _imat1_m0 = (L1_rgbaim)->mod[0];
	register int _imat1_m1 = (L1_rgbaim)->mod[1];
	register int _imat2_m0 = (L1_ubim)->mod[0];
	register int _imat2_m1 = (L1_ubim)->mod[1];
	_idx2loopc1 = IDX_PTR ((L1_rgbaim), unsigned char);
	_idx2loopc2 = IDX_PTR ((L1_ubim), unsigned char);
	for (i = 0; i < _imax; i++)
	  {;
	    p = _idx2loopc1;
	    s = _idx2loopc2;
	    for (j = 0; j < _jmax; j++)
	      {;
		{
		  register flt r, g, b, c, cbar;
		  r = (flt) (p[0]);
		  g = (flt) (p[1]);
		  b = (flt) (p[2]);
		  c =
		    (r - (L2_6_ro)) * (L2_12_rv) + (g -
						    (L2_7_go)) * (L2_13_gv) +
		    (b - (L2_8_bo)) * (L2_14_bv);
		  /* saturate */
		  c = (c < 0 ? 0 : c > 1 ? 1 : c);
		  cbar = 1 - c;
		  s[0] = (unsigned char) ((L2_3_rbg) * cbar + (L2_9_rfg) * c);
		  s[1] =
		    (unsigned char) ((L2_4_gbg) * cbar + (L2_10_gfg) * c);
		  s[2] =
		    (unsigned char) ((L2_5_bbg) * cbar + (L2_11_bfg) * c);
		}
		p += _imat1_m1;
		s += _imat2_m1;
	      }
	    _idx2loopc1 += _imat1_m0;
	    _idx2loopc2 += _imat2_m0;
      }}
    }
    TRACE_POP ("C_rgbaim_projectcolors");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-cluster-colors
 */
extern_c char
C_rgbaim_cluster_colors (struct idx *L1_rgbaim, int L1_polarity,
			 flt L1_bsatur, flt L1_fsatur, struct idx *L1_proto,
			 struct idx *L1_weight, struct idx *L1_variance)
{
  TRACE_PUSH ("C_rgbaim_cluster_colors");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_matrix, 2);
      Msrg_declare (L2_2_0_srg);
      struct idx *L2_3_histo;
      Midx_declare (L2_4_1_matrix, 1);
      Msrg_declare (L2_5_1_srg);
      struct idx *L2_6_count;
      Midx_declare (L2_7_2_matrix, 1);
      Msrg_declare (L2_8_2_srg);
      struct idx *L2_9_label;
      Midx_init (L2_1_0_matrix, 2);
      Msrg_init (L2_2_0_srg, ST_F);
      Midx_init (L2_4_1_matrix, 1);
      Msrg_init (L2_5_1_srg, ST_F);
      Midx_init (L2_7_2_matrix, 1);
      Msrg_init (L2_8_2_srg, ST_I32);
      (L2_1_0_matrix)->srg = L2_2_0_srg;
      Midx_init_dim2 (L2_1_0_matrix, 32768, 3);
      RTERR_DIM (L2_1_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_1_0_matrix->dim[1] <= 0);
      Midx_maclear (L2_1_0_matrix, flt);
      L2_3_histo = L2_1_0_matrix;
      (L2_4_1_matrix)->srg = L2_5_1_srg;
      Midx_init_dim1 (L2_4_1_matrix, 32768);
      RTERR_DIM (L2_4_1_matrix->dim[0] <= 0);
      Midx_maclear (L2_4_1_matrix, flt);
      L2_6_count = L2_4_1_matrix;
      (L2_7_2_matrix)->srg = L2_8_2_srg;
      Midx_init_dim1 (L2_7_2_matrix, 2);
      RTERR_DIM (L2_7_2_matrix->dim[0] <= 0);
      Midx_maclear (L2_7_2_matrix, int);
      L2_9_label = L2_7_2_matrix;
      RTERR_BOUND (0 >= (L2_9_label)->dim[0]);
      IDX_PTR (L2_9_label, int)[(L2_9_label)->mod[0] * ((int) 0)] = 0;
      RTERR_BOUND (1 >= (L2_9_label)->dim[0]);
      IDX_PTR (L2_9_label, int)[(L2_9_label)->mod[0] * ((int) 1)] = 1;
      C_rgbaim_histo32 (L1_rgbaim, L2_3_histo, L2_6_count);
      C_cqu_init_proto (L2_3_histo, L1_proto);
      {
	Midx_declare (L3_10_3_matrix, 1);
	Msrg_declare (L3_11_3_srg);
	struct idx *L3_12_assign;
	int L3_13_split;
	Midx_init (L3_10_3_matrix, 1);
	Msrg_init (L3_11_3_srg, ST_I32);
	(L3_10_3_matrix)->srg = L3_11_3_srg;
	Midx_init_dim1 (L3_10_3_matrix, (L2_3_histo)->dim[0]);
	RTERR_DIM (L3_10_3_matrix->dim[0] <= 0);
	Midx_maclear (L3_10_3_matrix, int);
	L3_12_assign = L3_10_3_matrix;
	L3_13_split = -1;
	{
	  register int *mp;
	  register int i, jmax = (L3_12_assign)->dim[0];
	  register int imat1_m0 = (L3_12_assign)->mod[0];
	  mp = IDX_PTR ((L3_12_assign), int);
	  for (i = 0; i < jmax; i++)
	    {;
	      *mp = (L3_13_split);
	      mp += imat1_m0;
	    }
	}
	C_cqu_kmeans (L2_3_histo, L2_6_count, L3_12_assign, L3_13_split,
		      L1_proto, L2_9_label, L1_weight, L1_variance);
	L_Tmp0 = 0;
	Msrg_free (L3_11_3_srg);
      }
      Msrg_free (L2_2_0_srg);
      Msrg_free (L2_5_1_srg);
      Msrg_free (L2_8_2_srg);
    }
    TRACE_POP ("C_rgbaim_cluster_colors");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-project-greys
 */
extern_c char
C_rgbaim_project_greys (struct idx *L1_rgbaim, struct idx *L1_ubim,
			int L1_polarity, flt L1_bsatur, flt L1_fsatur,
			struct idx *L1_proto)
{
  TRACE_PUSH ("C_rgbaim_project_greys");
  {
    char L_Tmp0;
    if (((L1_rgbaim)->dim[0] != (L1_ubim)->dim[0]))
      {
	L_Tmp0 = 1;
      }
    else
      {
	if (((L1_rgbaim)->dim[1] != (L1_ubim)->dim[1]))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("input and output images have inconsistent sizes");
      }
    {
      Midx_declare (L2_1_0_matrix, 1);
      Msrg_declare (L2_2_0_srg);
      struct idx *L2_3_weight;
      Midx_declare (L2_4_1_matrix, 1);
      Msrg_declare (L2_5_1_srg);
      struct idx *L2_6_variance;
      Midx_init (L2_1_0_matrix, 1);
      Msrg_init (L2_2_0_srg, ST_F);
      Midx_init (L2_4_1_matrix, 1);
      Msrg_init (L2_5_1_srg, ST_F);
      (L2_1_0_matrix)->srg = L2_2_0_srg;
      Midx_init_dim1 (L2_1_0_matrix, 2);
      RTERR_DIM (L2_1_0_matrix->dim[0] <= 0);
      Midx_maclear (L2_1_0_matrix, flt);
      L2_3_weight = L2_1_0_matrix;
      (L2_4_1_matrix)->srg = L2_5_1_srg;
      Midx_init_dim1 (L2_4_1_matrix, 2);
      RTERR_DIM (L2_4_1_matrix->dim[0] <= 0);
      Midx_maclear (L2_4_1_matrix, flt);
      L2_6_variance = L2_4_1_matrix;
      C_rgbaim_cluster_colors (L1_rgbaim, L1_polarity, L1_bsatur, L1_fsatur,
			       L1_proto, L2_3_weight, L2_6_variance);
      if ((-1 == L1_polarity))
	{
	  RTERR_BOUND (1 >= (L2_3_weight)->dim[0]);
	  RTERR_BOUND (0 >= (L2_3_weight)->dim[0]);
	  if ((IDX_PTR (L2_3_weight, flt)[(L2_3_weight)->mod[0] * ((int) 1)] >
	       IDX_PTR (L2_3_weight, flt)[(L2_3_weight)->mod[0] * ((int) 0)]))
	    {
	      L1_polarity = 0;
	    }
	  else
	    {
	      L1_polarity = 1;
	    }
	}
      C_rgbaim_greyquant (L1_rgbaim, L1_ubim, L1_proto, L1_polarity,
			  L1_bsatur, L1_fsatur);
      Msrg_free (L2_2_0_srg);
      Msrg_free (L2_5_1_srg);
    }
    TRACE_POP ("C_rgbaim_project_greys");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-project-colors
 */
extern_c char
C_rgbaim_project_colors (struct idx *L1_rgbaim, struct idx *L1_ubim,
			 int L1_polarity, flt L1_bsatur, flt L1_fsatur,
			 struct idx *L1_proto)
{
  TRACE_PUSH ("C_rgbaim_project_colors");
  {
    char L_Tmp0;
    if (((L1_rgbaim)->dim[0] != (L1_ubim)->dim[0]))
      {
	L_Tmp0 = 1;
      }
    else
      {
	if (((L1_rgbaim)->dim[1] != (L1_ubim)->dim[1]))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    L_Tmp0 = 0;
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("input and output images have inconsistent sizes");
      }
    {
      Midx_declare (L2_1_0_matrix, 1);
      Msrg_declare (L2_2_0_srg);
      struct idx *L2_3_weight;
      Midx_declare (L2_4_1_matrix, 1);
      Msrg_declare (L2_5_1_srg);
      struct idx *L2_6_variance;
      Midx_init (L2_1_0_matrix, 1);
      Msrg_init (L2_2_0_srg, ST_F);
      Midx_init (L2_4_1_matrix, 1);
      Msrg_init (L2_5_1_srg, ST_F);
      (L2_1_0_matrix)->srg = L2_2_0_srg;
      Midx_init_dim1 (L2_1_0_matrix, 2);
      RTERR_DIM (L2_1_0_matrix->dim[0] <= 0);
      Midx_maclear (L2_1_0_matrix, flt);
      L2_3_weight = L2_1_0_matrix;
      (L2_4_1_matrix)->srg = L2_5_1_srg;
      Midx_init_dim1 (L2_4_1_matrix, 2);
      RTERR_DIM (L2_4_1_matrix->dim[0] <= 0);
      Midx_maclear (L2_4_1_matrix, flt);
      L2_6_variance = L2_4_1_matrix;
      C_rgbaim_cluster_colors (L1_rgbaim, L1_polarity, L1_bsatur, L1_fsatur,
			       L1_proto, L2_3_weight, L2_6_variance);
      if ((-1 == L1_polarity))
	{
	  RTERR_BOUND (1 >= (L2_3_weight)->dim[0]);
	  RTERR_BOUND (0 >= (L2_3_weight)->dim[0]);
	  if ((IDX_PTR (L2_3_weight, flt)[(L2_3_weight)->mod[0] * ((int) 1)] >
	       IDX_PTR (L2_3_weight, flt)[(L2_3_weight)->mod[0] * ((int) 0)]))
	    {
	      L1_polarity = 0;
	    }
	  else
	    {
	      L1_polarity = 1;
	    }
	}
      C_rgbaim_projectcolors (L1_rgbaim, L1_ubim, L1_proto, L1_polarity,
			      L1_bsatur, L1_fsatur);
      Msrg_free (L2_2_0_srg);
      Msrg_free (L2_5_1_srg);
    }
    TRACE_POP ("C_rgbaim_project_colors");
    return 0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/* Declarations */
extern_c dhdoc_t K_rgbaim_histo32_R6bea669c;
extern_c dhdoc_t K_cqu_init_proto_R474a3dd1;
extern_c dhdoc_t K_cqu_kmeans_R277e0c6b;

/*
 * STUB rgbaim-quickquant
 */
DH (X_rgbaim_quickquant)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_quickquant (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			 a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-quickquant
 */
DHDOC (K_rgbaim_quickquant_R12bf122a, X_rgbaim_quickquant,
       "C_rgbaim_quickquant", 0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-greyquant
 */
DH (X_rgbaim_greyquant)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_greyquant (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_int, a[5].dh_flt, a[6].dh_flt);
  return ret;
}

/*
 * DHDOC rgbaim-greyquant
 */
DHDOC (K_rgbaim_greyquant_R08e2c533, X_rgbaim_greyquant, "C_rgbaim_greyquant",
       0, 0) =
{
DH_FUNC (6),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT, DH_INT, DH_FLT, DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-projectcolors
 */
DH (X_rgbaim_projectcolors)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_projectcolors (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			    a[4].dh_int, a[5].dh_flt, a[6].dh_flt);
  return ret;
}

/*
 * DHDOC rgbaim-projectcolors
 */
DHDOC (K_rgbaim_projectcolors_R08e2c533, X_rgbaim_projectcolors,
       "C_rgbaim_projectcolors", 0, 0) =
{
DH_FUNC (6),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT, DH_INT, DH_FLT, DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-cluster-colors
 */
DH (X_rgbaim_cluster_colors)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_cluster_colors (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_flt,
			     a[4].dh_flt, a[5].dh_idx_ptr, a[6].dh_idx_ptr,
			     a[7].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-cluster-colors
 */
DHDOC (K_rgbaim_cluster_colors_Rf317add7, X_rgbaim_cluster_colors,
       "C_rgbaim_cluster_colors", 0, 0) =
{
DH_FUNC (7),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_FLT,
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_RETURN,
    DH_NIL,
    DH_END_FUNC,
    DH_REFER (K_rgbaim_histo32_R6bea669c),
    DH_REFER (K_cqu_init_proto_R474a3dd1),
    DH_REFER (K_cqu_kmeans_R277e0c6b), DH_NIL};

/*
 * STUB rgbaim-project-greys
 */
DH (X_rgbaim_project_greys)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_project_greys (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
			    a[4].dh_flt, a[5].dh_flt, a[6].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-project-greys
 */
DHDOC (K_rgbaim_project_greys_R60a5e95f, X_rgbaim_project_greys,
       "C_rgbaim_project_greys", 0, 0) =
{
DH_FUNC (6),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_FLT,
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-project-colors
 */
DH (X_rgbaim_project_colors)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_project_colors (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
			     a[4].dh_flt, a[5].dh_flt, a[6].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-project-colors
 */
DHDOC (K_rgbaim_project_colors_R60a5e95f, X_rgbaim_project_colors,
       "C_rgbaim_project_colors", 0, 0) =
{
DH_FUNC (6),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_FLT,
    DH_FLT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_rgbaim_greypage (void)
{
  dh_define ("rgbaim-quickquant", &K_rgbaim_quickquant_R12bf122a);
  dh_define ("rgbaim-greyquant", &K_rgbaim_greyquant_R08e2c533);
  dh_define ("rgbaim-projectcolors", &K_rgbaim_projectcolors_R08e2c533);
  dh_define ("rgbaim-cluster-colors", &K_rgbaim_cluster_colors_Rf317add7);
  dh_define ("rgbaim-project-greys", &K_rgbaim_project_greys_R60a5e95f);
  dh_define ("rgbaim-project-colors", &K_rgbaim_project_colors_R60a5e95f);
}

int majver_rgbaim_greypage = 40;
int minver_rgbaim_greypage = 10;

#endif
