/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * USER DEFINED HEADERS
 */
#include <fcntl.h>		/* low-level i/o */
#include <unistd.h>
#include <errno.h>
#include <malloc.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <asm/types.h>		/* for videodev2.h */
#include <linux/videodev2.h>
/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"

/*
 * DECLARATIONS
 */
extern_c struct VClass_object Vt_object;
struct CClass_object;
struct CClass_v4l2device
{
  struct VClass_v4l2device *Vtbl;
  int fd;
  int width;
  int height;
  int started;
  struct idx *buffers;
  struct idx *bsizes;
  struct v4l2_capability *capptr;
  struct v4l2_cropcap *cropcapptr;
  struct v4l2_crop *cropptr;
  struct v4l2_format *fmtptr;
  struct v4l2_requestbuffers *rbptr;
};
struct VClass_v4l2device
{
  void *Cdoc;
  void (*Cdestroy) (gptr);
  char (*M_start) (struct CClass_v4l2device *);
  int (*M_stop) (struct CClass_v4l2device *);
  char (*M_cleanup) (struct CClass_v4l2device *);
    real (*M_set_exposure) (struct CClass_v4l2device *, int);
    real (*M_set_gain) (struct CClass_v4l2device *, int);
  int (*M_set_brightness) (struct CClass_v4l2device *, int);
  int (*M_set_contrast) (struct CClass_v4l2device *, int);
  char (*M_v4l2device) (struct CClass_v4l2device *, struct srg *, int, int,
			int, int, struct idx *, struct srg *, struct idx *,
			struct srg *);
  char (*M__destructor) (struct CClass_v4l2device *);
  int (*M_set_input) (struct CClass_v4l2device *, int);
  int (*M_get_frame_yuv422) (struct CClass_v4l2device *, struct idx *);
  int (*M_get_frame_grey) (struct CClass_v4l2device *, struct idx *);
  int (*M_get_frame_yuv) (struct CClass_v4l2device *, struct idx *);
  int (*M_get_frame_rgb) (struct CClass_v4l2device *, struct idx *);
};
extern_c struct VClass_v4l2device Vt_v4l2device;
extern_c char C_start_C_v4l2device (struct CClass_v4l2device *);
extern_c int C_stop_C_v4l2device (struct CClass_v4l2device *);
extern_c char C_cleanup_C_v4l2device (struct CClass_v4l2device *);
extern_c real C_set_exposure_C_v4l2device (struct CClass_v4l2device *, int);
extern_c real C_set_gain_C_v4l2device (struct CClass_v4l2device *, int);
extern_c int C_set_brightness_C_v4l2device (struct CClass_v4l2device *, int);
extern_c int C_set_contrast_C_v4l2device (struct CClass_v4l2device *, int);
extern_c char C_v4l2device_C_v4l2device (struct CClass_v4l2device *,
					 struct srg *, int, int, int, int,
					 struct idx *, struct srg *,
					 struct idx *, struct srg *);
extern_c char C__destructor_C_v4l2device (struct CClass_v4l2device *);
extern_c int C_set_input_C_v4l2device (struct CClass_v4l2device *, int);
extern_c int C_get_frame_yuv422_C_v4l2device (struct CClass_v4l2device *,
					      struct idx *);
extern_c int C_get_frame_grey_C_v4l2device (struct CClass_v4l2device *,
					    struct idx *);
extern_c int C_get_frame_yuv_C_v4l2device (struct CClass_v4l2device *,
					   struct idx *);
extern_c int C_get_frame_rgb_C_v4l2device (struct CClass_v4l2device *,
					   struct idx *);

/* ---------------------------------------- */

/*
 * METHOD FUNCTION start (class v4l2device)
 */
extern_c char
C_start_C_v4l2device (struct CClass_v4l2device *L1_this)
{
  TRACE_PUSH ("C_start_C_v4l2device");
  {
    char L_Tmp0;
    {
      int L2_1_ret;
      L2_1_ret = 0;
      {
	int L3_2_i;
	L3_2_i = 0;
	{
	  Midx_begin_bloop1 (L4_b, L1_this->buffers, gptr)
	  {
	    {
	      {
		struct v4l2_buffer buf;
		memset (&buf, 0, sizeof (struct v4l2_buffer));
		buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		buf.memory = V4L2_MEMORY_MMAP;
		buf.index = (L3_2_i);
		(L2_1_ret) += ioctl ((L1_this->fd), VIDIOC_QBUF, &buf);
	      }
	      L3_2_i = (L3_2_i + 1);
	    }
	  } Midx_end_bloop1 (L4_b, L1_this->buffers, gptr);
	}
      }
      if ((L2_1_ret < 0))
	{
	  printf ("WARNING: could not enqueue v4l2 buffers\n");
	}
      {
	enum v4l2_buf_type type;
	type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	(L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_STREAMON, &type);
      }
      if ((L2_1_ret < 0))
	{
	  printf ("WARNING: could not start v4l2 capture\n");
	  L1_this->started = 0;
	}
      else
	{
	  L1_this->started = 1;
	}
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_start_C_v4l2device");
    return 0;
  }
}

/*
 * METHOD FUNCTION stop (class v4l2device)
 */
extern_c int
C_stop_C_v4l2device (struct CClass_v4l2device *L1_this)
{
  TRACE_PUSH ("C_stop_C_v4l2device");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      L2_1_ret = -1;
      if ((-1 != L1_this->fd))
	{
	  {
	    enum v4l2_buf_type type;
	    type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	    (L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_STREAMOFF, &type);
	  }
	}
      if ((L2_1_ret < 0))
	{
	  printf ("WARNING: could not stop v4l2 streaming\n");
	}
      else
	{
	  L1_this->started = 0;
	}
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_stop_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION cleanup (class v4l2device)
 */
extern_c char
C_cleanup_C_v4l2device (struct CClass_v4l2device *L1_this)
{
  TRACE_PUSH ("C_cleanup_C_v4l2device");
  {
    if ((0 != L1_this->started))
      {
	(L1_this)->Vtbl->M_stop (L1_this);
      }
    if ((L1_this->capptr) != NULL)
      {
	free ((L1_this->capptr));
	(L1_this->capptr) = NULL;
      }
    if ((L1_this->cropcapptr) != NULL)
      {
	free ((L1_this->cropcapptr));
	(L1_this->cropcapptr) = NULL;
      }
    if ((L1_this->cropptr) != NULL)
      {
	free ((L1_this->cropptr));
	(L1_this->cropptr) = NULL;
      }
    if ((L1_this->fmtptr) != NULL)
      {
	free ((L1_this->fmtptr));
	(L1_this->fmtptr) = NULL;
      }
    if ((L1_this->rbptr) != NULL)
      {
	free ((L1_this->rbptr));
	(L1_this->rbptr) = NULL;
      }
    {
      int L2_0_ret;
      int L2_1_n;
      L2_0_ret = 0;
      L2_1_n = (L1_this->buffers)->dim[0];
      {
	void **bufp;
	int *sizep, i;
	bufp = IDX_PTR ((L1_this->buffers), void *);
	sizep = IDX_PTR ((L1_this->bsizes), int);
	for (i = 0; i < (L2_1_n); i++)
	  {
	    (L2_0_ret) += munmap (bufp[i], sizep[i]);
	  }
      }
      if ((L2_0_ret < 0))
	{
	  printf ("WARNING: could not unmap v4l2 buffers\n");
	}
    }
    if ((-1 != L1_this->fd))
      {
	close ((L1_this->fd));
      }
    TRACE_POP ("C_cleanup_C_v4l2device");
    return 0;
  }
}

/*
 * METHOD FUNCTION set-exposure (class v4l2device)
 */
extern_c real
C_set_exposure_C_v4l2device (struct CClass_v4l2device * L1_this, int L1_n)
{
  TRACE_PUSH ("C_set_exposure_C_v4l2device");
  {
    real L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_ret2;
      L2_1_ret = 0;
      L2_2_ret2 = 0;
      if ((L1_n < 0))
	{
	  {
	    struct v4l2_control control;
	    memset (&control, 0, sizeof (control));
	    control.id = V4L2_CID_EXPOSURE_AUTO;
	    control.value = 1;
	    (L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
	  }
	}
      else
	{
	  {
	    struct v4l2_control control;
	    memset (&control, 0, sizeof (control));
	    control.id = V4L2_CID_EXPOSURE_AUTO;
	    control.value = 0;
	    (L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
	    memset (&control, 0, sizeof (control));
	    control.id = V4L2_CID_EXPOSURE_ABSOLUTE;
	    control.value = (L1_n);
	    (L2_2_ret2) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
	  }
	}
      L_Tmp0 = (L2_1_ret + (2 * L2_2_ret2));
    }
    TRACE_POP ("C_set_exposure_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION set-gain (class v4l2device)
 */
extern_c real
C_set_gain_C_v4l2device (struct CClass_v4l2device * L1_this, int L1_n)
{
  TRACE_PUSH ("C_set_gain_C_v4l2device");
  {
    real L_Tmp0;
    {
      int L2_1_ret;
      int L2_2_ret2;
      L2_1_ret = 0;
      L2_2_ret2 = 0;
      if ((L1_n < 0))
	{
	  {
	    struct v4l2_control control;
	    memset (&control, 0, sizeof (control));
	    control.id = V4L2_CID_AUTOGAIN;
	    control.value = 1;
	    (L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
	  }
	}
      else
	{
	  {
	    struct v4l2_control control;
	    memset (&control, 0, sizeof (control));
	    control.id = V4L2_CID_AUTOGAIN;
	    control.value = 0;
	    (L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
	    memset (&control, 0, sizeof (control));
	    control.id = V4L2_CID_GAIN;
	    control.value = (L1_n);
	    (L2_2_ret2) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
	  }
	}
      L_Tmp0 = (L2_1_ret + (2 * L2_2_ret2));
    }
    TRACE_POP ("C_set_gain_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION set-brightness (class v4l2device)
 */
extern_c int
C_set_brightness_C_v4l2device (struct CClass_v4l2device *L1_this, int L1_n)
{
  TRACE_PUSH ("C_set_brightness_C_v4l2device");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      L2_1_ret = 0;
      {
	struct v4l2_control control;
	memset (&control, 0, sizeof (control));
	control.id = V4L2_CID_BRIGHTNESS;
	control.value = (L1_n);
	(L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_set_brightness_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION set-contrast (class v4l2device)
 */
extern_c int
C_set_contrast_C_v4l2device (struct CClass_v4l2device *L1_this, int L1_n)
{
  TRACE_PUSH ("C_set_contrast_C_v4l2device");
  {
    int L_Tmp0;
    {
      int L2_1_ret;
      L2_1_ret = 0;
      {
	struct v4l2_control control;
	memset (&control, 0, sizeof (control));
	control.id = V4L2_CID_CONTRAST;
	control.value = (L1_n);
	(L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_S_CTRL, &control);
      }
      L_Tmp0 = L2_1_ret;
    }
    TRACE_POP ("C_set_contrast_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION v4l2device (class v4l2device)
 */
extern_c char
C_v4l2device_C_v4l2device (struct CClass_v4l2device *L1_this,
			   struct srg *L1_devname, int L1_w, int L1_h,
			   int L1_fps, int L1_nb, struct idx *L1_0_matrix,
			   struct srg *L1_0_srg, struct idx *L1_1_matrix,
			   struct srg *L1_1_srg)
{
  TRACE_PUSH ("C_v4l2device_C_v4l2device");
  {
    char L_Tmp0;
    L1_this->width = L1_w;
    L1_this->height = L1_h;
    (L1_0_matrix)->srg = L1_0_srg;
    Midx_init_dim1 (L1_0_matrix, L1_nb);
    RTERR_DIM (L1_0_matrix->dim[0] <= 0);
    Midx_maclear (L1_0_matrix, gptr);
    L1_this->buffers = L1_0_matrix;
    (L1_1_matrix)->srg = L1_1_srg;
    Midx_init_dim1 (L1_1_matrix, L1_nb);
    RTERR_DIM (L1_1_matrix->dim[0] <= 0);
    Midx_maclear (L1_1_matrix, int);
    L1_this->bsizes = L1_1_matrix;
    L1_this->capptr = (struct v4l2_capability *) ((gptr) (0));
    L1_this->cropcapptr = (struct v4l2_cropcap *) ((gptr) (0));
    L1_this->cropptr = (struct v4l2_crop *) ((gptr) (0));
    L1_this->fmtptr = (struct v4l2_format *) ((gptr) (0));
    L1_this->fd = -1;
    L1_this->started = 0;
    L1_this->fd = (int) (open ((char *) ((L1_devname)->data), O_RDWR));
    if ((L1_this->fd == -1))
      {
	run_time_error ("could not open v4l2 device");
      }
    {
      int L2_1_ret;
      L2_1_ret = 0;
      L1_this->capptr =
	(struct v4l2_capability
	 *) ((gptr) (malloc (sizeof (struct v4l2_capability))));
      memset ((L1_this->capptr), 0, sizeof (struct v4l2_capability));
      (L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_QUERYCAP, (L1_this->capptr));
      if ((L2_1_ret < 0))
	{
	  (L1_this)->Vtbl->M_cleanup (L1_this);
	  run_time_error ("could not query v4l2 device");
	}
      if ((0 ==
	   (int) ((L1_this->capptr)->capabilities & V4L2_CAP_VIDEO_CAPTURE)))
	{
	  (L1_this)->Vtbl->M_cleanup (L1_this);
	  run_time_error ("v4l2 device does not support video capture");
	}
      if ((0 == (int) ((L1_this->capptr)->capabilities & V4L2_CAP_STREAMING)))
	{
	  (L1_this)->Vtbl->M_cleanup (L1_this);
	  run_time_error ("v4l2 device does not support streaming i/o");
	}
      L1_this->cropcapptr =
	(struct v4l2_cropcap
	 *) ((gptr) (malloc (sizeof (struct v4l2_cropcap))));
      L1_this->cropptr =
	(struct v4l2_crop *) ((gptr) (malloc (sizeof (struct v4l2_crop))));
      memset ((L1_this->cropcapptr), 0, sizeof (struct v4l2_cropcap));
      (L1_this->cropcapptr)->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
      if (0 == ioctl ((L1_this->fd), VIDIOC_CROPCAP, (L1_this->cropcapptr)))
	{
	  (L1_this->cropptr)->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	  (L1_this->cropptr)->c = (L1_this->cropcapptr)->defrect;
	  ioctl ((L1_this->fd), VIDIOC_S_CROP, (L1_this->cropptr));
	}
      L1_this->fmtptr =
	(struct v4l2_format
	 *) ((gptr) (malloc (sizeof (struct v4l2_format))));
      memset ((L1_this->fmtptr), 0, sizeof (struct v4l2_format));
      (L1_this->fmtptr)->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
      (L1_this->fmtptr)->fmt.pix.width = (L1_this->width);
      (L1_this->fmtptr)->fmt.pix.height = (L1_this->height);
      (L1_this->fmtptr)->fmt.pix.pixelformat = V4L2_PIX_FMT_YUYV;
      (L1_this->fmtptr)->fmt.pix.field = V4L2_FIELD_ANY;
      if (((int) (ioctl ((L1_this->fd), VIDIOC_S_FMT, (L1_this->fmtptr))) <
	   0))
	{
	  (L1_this)->Vtbl->M_cleanup (L1_this);
	  run_time_error ("unable to set v4l2 format");
	}
      {
	struct v4l2_streamparm *setfps;
	setfps =
	  (struct v4l2_streamparm *) calloc (1,
					     sizeof (struct v4l2_streamparm));
	memset (setfps, 0, sizeof (struct v4l2_streamparm));
	setfps->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	setfps->parm.capture.timeperframe.numerator = 1;
	setfps->parm.capture.timeperframe.denominator = (L1_fps);
	ioctl ((L1_this->fd), VIDIOC_S_PARM, setfps);
      }
      L1_this->rbptr =
	(struct v4l2_requestbuffers
	 *) ((gptr) (malloc (sizeof (struct v4l2_requestbuffers))));
      {
	int L3_2_nbuf;
	L3_2_nbuf = (L1_this->buffers)->dim[0];
	(L1_this->rbptr)->count = (L3_2_nbuf);
	(L1_this->rbptr)->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	(L1_this->rbptr)->memory = V4L2_MEMORY_MMAP;
	(L2_1_ret) = ioctl ((L1_this->fd), VIDIOC_REQBUFS, (L1_this->rbptr));
	if ((L2_1_ret < 0))
	  {
	    (L1_this)->Vtbl->M_cleanup (L1_this);
	    run_time_error ("could not allocate v4l2 buffers");
	  }
	L2_1_ret = 0;
	{
	  void **bufp;
	  int *sizep;
	  int i;
	  bufp = IDX_PTR ((L1_this->buffers), void *);
	  sizep = IDX_PTR ((L1_this->bsizes), int);
	  for (i = 0; i < (L3_2_nbuf); i++)
	    {
	      struct v4l2_buffer buf;
	      int r;
	      memset (&buf, 0, sizeof (struct v4l2_buffer));
	      buf.index = i;
	      buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	      buf.memory = V4L2_MEMORY_MMAP;

	      r = ioctl ((L1_this->fd), VIDIOC_QUERYBUF, &buf);
	      /* printf("i=%u, length: %u, offset: %u, r=%d\n", i, buf.length, buf.m.offset, r); */
	      if (r < 0)
		{
		  (L2_1_ret) = -(i + 1);
		}
	      if ((L2_1_ret) == 0)
		{
		  bufp[i] =
		    mmap (0, buf.length, PROT_READ + PROT_WRITE, MAP_SHARED,
			  (L1_this->fd), buf.m.offset);
		  sizep[i] = buf.length;
		  if (bufp[i] == MAP_FAILED)
		    {
		      (L2_1_ret) = -(i + 1000);
		    }
		}
	    }
	}
      }
      if ((L2_1_ret < 0))
	{
	  printf ("ret=%d\n", L2_1_ret);
	  if ((L2_1_ret > -1000))
	    {
	      printf ("query buffer %d\n", (-(1 + L2_1_ret)));
	      (L1_this)->Vtbl->M_cleanup (L1_this);
	      run_time_error ("could not query v4l2 buffer");
	    }
	  printf ("map buffer %d\n", (-(1000 + L2_1_ret)));
	  (L1_this)->Vtbl->M_cleanup (L1_this);
	  run_time_error ("could not map v4l2 buffer");
	}
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_v4l2device_C_v4l2device");
    return 0;
  }
}

/*
 * METHOD FUNCTION -destructor (class v4l2device)
 */
extern_c char
C__destructor_C_v4l2device (struct CClass_v4l2device *L1_this)
{
  TRACE_PUSH ("C__destructor_C_v4l2device");
  {
    (L1_this)->Vtbl->M_cleanup (L1_this);
    TRACE_POP ("C__destructor_C_v4l2device");
    return 0;
  }
}

/*
 * METHOD FUNCTION set-input (class v4l2device)
 */
extern_c int
C_set_input_C_v4l2device (struct CClass_v4l2device *L1_this, int L1_n)
{
  TRACE_PUSH ("C_set_input_C_v4l2device");
  {
    int L_Tmp0;
    L_Tmp0 = (int) (ioctl ((L1_this->fd), VIDIOC_S_INPUT, &(L1_n)));
    TRACE_POP ("C_set_input_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION get-frame-yuv422 (class v4l2device)
 */
extern_c int
C_get_frame_yuv422_C_v4l2device (struct CClass_v4l2device *L1_this,
				 struct idx *L1_frame)
{
  TRACE_PUSH ("C_get_frame_yuv422_C_v4l2device");
  {
    int L_Tmp0;
    char L_Tmp1;
    if (((L1_frame)->dim[2] != 2))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_frame)->dim[0] != L1_this->height))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_frame)->dim[1] != L1_this->width))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("frame has wrong size");
      }
    if ((0 == L1_this->started))
      {
	(L1_this)->Vtbl->M_start (L1_this);
      }
    {
      int L2_2_ret;
      L2_2_ret = 0;
      {
	struct v4l2_buffer buf;
	void **buffers;
	int *bsizes;
	buffers = IDX_PTR ((L1_this->buffers), void *);
	bsizes = IDX_PTR ((L1_this->bsizes), int);
	memset (&buf, 0, sizeof (struct v4l2_buffer));
	buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	buf.memory = V4L2_MEMORY_MMAP;
	(L2_2_ret) = ioctl ((L1_this->fd), VIDIOC_DQBUF, &buf);
	memcpy (IDX_PTR ((L1_frame), unsigned char), buffers[buf.index],
		bsizes[buf.index]);
	(L2_2_ret) += ioctl ((L1_this->fd), VIDIOC_QBUF, &buf);
      }
      L_Tmp0 = L2_2_ret;
    }
    TRACE_POP ("C_get_frame_yuv422_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION get-frame-grey (class v4l2device)
 */
extern_c int
C_get_frame_grey_C_v4l2device (struct CClass_v4l2device *L1_this,
			       struct idx *L1_frame)
{
  TRACE_PUSH ("C_get_frame_grey_C_v4l2device");
  {
    int L_Tmp0;
    char L_Tmp1;
    if (((L1_frame)->dim[0] != L1_this->height))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_frame)->dim[1] != L1_this->width))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    L_Tmp1 = 0;
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("frame has wrong size");
      }
    if ((0 == L1_this->started))
      {
	(L1_this)->Vtbl->M_start (L1_this);
      }
    {
      int L2_2_ret;
      L2_2_ret = 0;
      {
	struct v4l2_buffer buf;
	void **buffers;
	unsigned char *buffer, *grey;
	int *bsizes, i, j;
	buffers = IDX_PTR ((L1_this->buffers), void *);
	bsizes = IDX_PTR ((L1_this->bsizes), int);
	memset (&buf, 0, sizeof (struct v4l2_buffer));
	buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	buf.memory = V4L2_MEMORY_MMAP;
	(L2_2_ret) = ioctl ((L1_this->fd), VIDIOC_DQBUF, &buf);
	buffer = (unsigned char *) (buffers[buf.index]);
	grey = IDX_PTR ((L1_frame), unsigned char);
	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0; j < (L1_this->width); j++)
	      {
		int k = i * (L1_this->width) + j;
		grey[k] = buffer[k << 1];
	      }
	  }
	(L2_2_ret) += ioctl ((L1_this->fd), VIDIOC_QBUF, &buf);
      }
      L_Tmp0 = L2_2_ret;
    }
    TRACE_POP ("C_get_frame_grey_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION get-frame-yuv (class v4l2device)
 */
extern_c int
C_get_frame_yuv_C_v4l2device (struct CClass_v4l2device *L1_this,
			      struct idx *L1_frame)
{
  TRACE_PUSH ("C_get_frame_yuv_C_v4l2device");
  {
    int L_Tmp0;
    char L_Tmp1;
    if (((L1_frame)->dim[2] < 3))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_frame)->dim[0] != L1_this->height))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_frame)->dim[1] != L1_this->width))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("frame has wrong size");
      }
    if ((0 == L1_this->started))
      {
	(L1_this)->Vtbl->M_start (L1_this);
      }
    {
      int L2_2_ret;
      int L2_3_m0;
      int L2_4_m1;
      L2_2_ret = 0;
      L2_3_m0 = (L1_frame)->mod[0];
      L2_4_m1 = (L1_frame)->mod[1];
      {
	struct v4l2_buffer buf;
	void **buffers;
	unsigned char *src, *dst;
	int *bsizes, i, j, k;
	buffers = IDX_PTR ((L1_this->buffers), void *);
	bsizes = IDX_PTR ((L1_this->bsizes), int);
	memset (&buf, 0, sizeof (struct v4l2_buffer));
	buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	buf.memory = V4L2_MEMORY_MMAP;
	(L2_2_ret) = ioctl ((L1_this->fd), VIDIOC_DQBUF, &buf);
	src = (unsigned char *) (buffers[buf.index]);
	dst = IDX_PTR ((L1_frame), unsigned char);
	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0, k = 0; j < (L1_this->width); j++, k += (L2_4_m1))
	      {
		int j2;
		j2 = j << 1;
		dst[k] = src[j2];
		if (j & 1)
		  {
		    dst[k + 1] = src[j2 - 1];
		    dst[k + 2] = src[j2 + 1];
		  }
		else
		  {
		    dst[k + 1] = src[j2 + 1];
		    dst[k + 2] = src[j2 + 3];
		  }
	      }
	    src += (L1_this->width) << 1;
	    dst += (L2_3_m0);
	  }
	(L2_2_ret) += ioctl ((L1_this->fd), VIDIOC_QBUF, &buf);
      }
      L_Tmp0 = L2_2_ret;
    }
    TRACE_POP ("C_get_frame_yuv_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * METHOD FUNCTION get-frame-rgb (class v4l2device)
 */
extern_c int
C_get_frame_rgb_C_v4l2device (struct CClass_v4l2device *L1_this,
			      struct idx *L1_frame)
{
  TRACE_PUSH ("C_get_frame_rgb_C_v4l2device");
  {
    int L_Tmp0;
    char L_Tmp1;
    if (((L1_frame)->dim[2] < 3))
      {
	L_Tmp1 = 1;
      }
    else
      {
	if (((L1_frame)->dim[0] != L1_this->height))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    if (((L1_frame)->dim[1] != L1_this->width))
	      {
		L_Tmp1 = 1;
	      }
	    else
	      {
		L_Tmp1 = 0;
	      }
	  }
      }
    if (L_Tmp1)
      {
	run_time_error ("frame has wrong size");
      }
    if ((0 == L1_this->started))
      {
	(L1_this)->Vtbl->M_start (L1_this);
      }
    {
      int L2_2_ret;
      int L2_3_m0;
      int L2_4_m1;
      L2_2_ret = 0;
      L2_3_m0 = (L1_frame)->mod[0];
      L2_4_m1 = (L1_frame)->mod[1];
      {
	struct v4l2_buffer buf;
	void **buffers;
	unsigned char *src, *dst;
	int *bsizes, i, j, k;
	buffers = IDX_PTR ((L1_this->buffers), void *);
	bsizes = IDX_PTR ((L1_this->bsizes), int);
	memset (&buf, 0, sizeof (struct v4l2_buffer));
	buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	buf.memory = V4L2_MEMORY_MMAP;
	(L2_2_ret) = ioctl ((L1_this->fd), VIDIOC_DQBUF, &buf);
	src = (unsigned char *) (buffers[buf.index]);
	dst = IDX_PTR ((L1_frame), unsigned char);
	for (i = 0; i < (L1_this->height); i++)
	  {
	    for (j = 0, k = 0; j < (L1_this->width); j++, k += (L2_4_m1))
	      {
		float f, y, u, v;
		int j2;
		j2 = j << 1;
		y = src[j2];
		if (j & 1)
		  {
		    u = src[j2 - 1];
		    v = src[j2 + 1];
		  }
		else
		  {
		    u = src[j2 + 1];
		    v = src[j2 + 3];
		  }
		f = 1.164383 * (y - 16) + 1.596027 * (v - 128);
		dst[k] =
		  (f >= 255) ? 0xff : ((f < 0) ? 0x00 : (unsigned char) f);
		f =
		  1.164383 * (y - 16) - 0.812968 * (v - 128) - 0.391726 * (u -
									   128);
		dst[k + 1] =
		  (f >= 255) ? 0xff : ((f < 0) ? 0x00 : (unsigned char) f);
		f = 1.164383 * (y - 16) + 2.017232 * (u - 128);
		dst[k + 2] =
		  (f >= 255) ? 0xff : ((f < 0) ? 0x00 : (unsigned char) f);
	      }
	    src += (L1_this->width) << 1;
	    dst += (L2_3_m0);
	  }
	(L2_2_ret) += ioctl ((L1_this->fd), VIDIOC_QBUF, &buf);
      }
      L_Tmp0 = L2_2_ret;
    }
    TRACE_POP ("C_get_frame_rgb_C_v4l2device");
    return L_Tmp0;
  }
}

/*
 * CLASS v4l2device DESTROY
 */
static void
Cdestroy_C_v4l2device (gptr g)
{
  C__destructor_C_v4l2device ((struct CClass_v4l2device *) g);
}

/*
 * CLASS v4l2device VTABLE
 */
struct VClass_v4l2device Vt_v4l2device = {
  (void *) &Vt_object,
  &Cdestroy_C_v4l2device,
  &C_start_C_v4l2device,
  &C_stop_C_v4l2device,
  &C_cleanup_C_v4l2device,
  &C_set_exposure_C_v4l2device,
  &C_set_gain_C_v4l2device,
  &C_set_brightness_C_v4l2device,
  &C_set_contrast_C_v4l2device,
  &C_v4l2device_C_v4l2device,
  &C__destructor_C_v4l2device,
  &C_set_input_C_v4l2device,
  &C_get_frame_yuv422_C_v4l2device,
  &C_get_frame_grey_C_v4l2device,
  &C_get_frame_yuv_C_v4l2device,
  &C_get_frame_rgb_C_v4l2device,
};

/* ---------------------------------------- */

#ifndef NOLISP

/* Declarations */
extern_c dhclassdoc_t Kc_object;
extern_c dhclassdoc_t Kc_v4l2device_R57e47d97;

/*
 * METHOD STUB start (class v4l2device)
 */
DH (X_start_C_v4l2device)
{
  dharg ret;
  ret.dh_char =
    C_start_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr);
  return ret;
}

/*
 * METHOD DHDOC start (class v4l2device)
 */
DHDOC (K_start_C_v4l2device_Re20814c0, X_start_C_v4l2device,
       "C_start_C_v4l2device", 0, 0) =
{
DH_FUNC (1),
    DH_OBJ (Kc_v4l2device_R57e47d97), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB stop (class v4l2device)
 */
DH (X_stop_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_stop_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr);
  return ret;
}

/*
 * METHOD DHDOC stop (class v4l2device)
 */
DHDOC (K_stop_C_v4l2device_R48b83221, X_stop_C_v4l2device,
       "C_stop_C_v4l2device", 0, 0) =
{
DH_FUNC (1),
    DH_OBJ (Kc_v4l2device_R57e47d97), DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB cleanup (class v4l2device)
 */
DH (X_cleanup_C_v4l2device)
{
  dharg ret;
  ret.dh_char =
    C_cleanup_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr);
  return ret;
}

/*
 * METHOD DHDOC cleanup (class v4l2device)
 */
DHDOC (K_cleanup_C_v4l2device_Re20814c0, X_cleanup_C_v4l2device,
       "C_cleanup_C_v4l2device", 0, 0) =
{
DH_FUNC (1),
    DH_OBJ (Kc_v4l2device_R57e47d97), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB set-exposure (class v4l2device)
 */
DH (X_set_exposure_C_v4l2device)
{
  dharg ret;
  ret.dh_real =
    C_set_exposure_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr,
				 a[2].dh_int);
  return ret;
}

/*
 * METHOD DHDOC set-exposure (class v4l2device)
 */
DHDOC (K_set_exposure_C_v4l2device_Re021c15a, X_set_exposure_C_v4l2device,
       "C_set_exposure_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB set-gain (class v4l2device)
 */
DH (X_set_gain_C_v4l2device)
{
  dharg ret;
  ret.dh_real =
    C_set_gain_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr,
			     a[2].dh_int);
  return ret;
}

/*
 * METHOD DHDOC set-gain (class v4l2device)
 */
DHDOC (K_set_gain_C_v4l2device_Re021c15a, X_set_gain_C_v4l2device,
       "C_set_gain_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_INT, DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB set-brightness (class v4l2device)
 */
DH (X_set_brightness_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_set_brightness_C_v4l2device ((struct CClass_v4l2device *) a[1].
				   dh_obj_ptr, a[2].dh_int);
  return ret;
}

/*
 * METHOD DHDOC set-brightness (class v4l2device)
 */
DHDOC (K_set_brightness_C_v4l2device_Rc819c396, X_set_brightness_C_v4l2device,
       "C_set_brightness_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB set-contrast (class v4l2device)
 */
DH (X_set_contrast_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_set_contrast_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr,
				 a[2].dh_int);
  return ret;
}

/*
 * METHOD DHDOC set-contrast (class v4l2device)
 */
DHDOC (K_set_contrast_C_v4l2device_Rc819c396, X_set_contrast_C_v4l2device,
       "C_set_contrast_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB v4l2device (class v4l2device)
 */
DH (X_v4l2device_C_v4l2device)
{
  dharg ret;
  ret.dh_char =
    C_v4l2device_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr,
			       a[2].dh_srg_ptr, a[3].dh_int, a[4].dh_int,
			       a[5].dh_int, a[6].dh_int, a[7].dh_idx_ptr,
			       a[8].dh_srg_ptr, a[9].dh_idx_ptr,
			       a[10].dh_srg_ptr);
  return ret;
}

/*
 * METHOD DHDOC v4l2device (class v4l2device)
 */
DHDOC (K_v4l2device_C_v4l2device_R5b8dee7d, X_v4l2device_C_v4l2device,
       "C_v4l2device_C_v4l2device", 0, 0) =
{
DH_FUNC (6),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_STR,
    DH_INT,
    DH_INT,
    DH_INT,
    DH_INT,
    DH_TEMPS (4),
    DH_IDX (DHT_WRITE, 1), DH_GPTR (0),
    DH_SRG (DHT_WRITE), DH_GPTR (0),
    DH_IDX (DHT_WRITE, 1), DH_INT,
    DH_SRG (DHT_WRITE), DH_INT,
    DH_END_TEMPS, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB -destructor (class v4l2device)
 */
DH (X__destructor_C_v4l2device)
{
  dharg ret;
  ret.dh_char =
    C__destructor_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr);
  return ret;
}

/*
 * METHOD DHDOC -destructor (class v4l2device)
 */
DHDOC (K__destructor_C_v4l2device_Re20814c0, X__destructor_C_v4l2device,
       "C__destructor_C_v4l2device", 0, 0) =
{
DH_FUNC (1),
    DH_OBJ (Kc_v4l2device_R57e47d97), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB set-input (class v4l2device)
 */
DH (X_set_input_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_set_input_C_v4l2device ((struct CClass_v4l2device *) a[1].dh_obj_ptr,
			      a[2].dh_int);
  return ret;
}

/*
 * METHOD DHDOC set-input (class v4l2device)
 */
DHDOC (K_set_input_C_v4l2device_Rc819c396, X_set_input_C_v4l2device,
       "C_set_input_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB get-frame-yuv422 (class v4l2device)
 */
DH (X_get_frame_yuv422_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_get_frame_yuv422_C_v4l2device ((struct CClass_v4l2device *) a[1].
				     dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC get-frame-yuv422 (class v4l2device)
 */
DHDOC (K_get_frame_yuv422_C_v4l2device_Rdc58e0eb,
       X_get_frame_yuv422_C_v4l2device, "C_get_frame_yuv422_C_v4l2device", 0,
       0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB get-frame-grey (class v4l2device)
 */
DH (X_get_frame_grey_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_get_frame_grey_C_v4l2device ((struct CClass_v4l2device *) a[1].
				   dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC get-frame-grey (class v4l2device)
 */
DHDOC (K_get_frame_grey_C_v4l2device_Rdc58e0eb, X_get_frame_grey_C_v4l2device,
       "C_get_frame_grey_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB get-frame-yuv (class v4l2device)
 */
DH (X_get_frame_yuv_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_get_frame_yuv_C_v4l2device ((struct CClass_v4l2device *) a[1].
				  dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC get-frame-yuv (class v4l2device)
 */
DHDOC (K_get_frame_yuv_C_v4l2device_Rdc58e0eb, X_get_frame_yuv_C_v4l2device,
       "C_get_frame_yuv_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * METHOD STUB get-frame-rgb (class v4l2device)
 */
DH (X_get_frame_rgb_C_v4l2device)
{
  dharg ret;
  ret.dh_int =
    C_get_frame_rgb_C_v4l2device ((struct CClass_v4l2device *) a[1].
				  dh_obj_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * METHOD DHDOC get-frame-rgb (class v4l2device)
 */
DHDOC (K_get_frame_rgb_C_v4l2device_Rdc58e0eb, X_get_frame_rgb_C_v4l2device,
       "C_get_frame_rgb_C_v4l2device", 0, 0) =
{
DH_FUNC (2),
    DH_OBJ (Kc_v4l2device_R57e47d97),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * CLASS v4l2device DHCLASSDOC
 */
DHCLASSDOC (Kc_v4l2device_R57e47d97, &Kc_object, v4l2device, "v4l2device",
	    Vt_v4l2device, 14) =
{
DH_CLASS (11, Kc_v4l2device_R57e47d97),
    DH_NAME ("fd", v4l2device, fd),
    DH_INT,
    DH_NAME ("width", v4l2device, width),
    DH_INT,
    DH_NAME ("height", v4l2device, height),
    DH_INT,
    DH_NAME ("started", v4l2device, started),
    DH_INT,
    DH_NAME ("buffers", v4l2device, buffers),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_GPTR (0),
    DH_NAME ("bsizes", v4l2device, bsizes),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_NAME ("capptr", v4l2device, capptr),
    DH_GPTR ("struct v4l2_capability *"),
    DH_NAME ("cropcapptr", v4l2device, cropcapptr),
    DH_GPTR ("struct v4l2_cropcap *"),
    DH_NAME ("cropptr", v4l2device, cropptr),
    DH_GPTR ("struct v4l2_crop *"),
    DH_NAME ("fmtptr", v4l2device, fmtptr),
    DH_GPTR ("struct v4l2_format *"),
    DH_NAME ("rbptr", v4l2device, rbptr),
    DH_GPTR ("struct v4l2_requestbuffers *"),
    DH_END_CLASS,
    DH_METHOD ("start", K_start_C_v4l2device_Re20814c0),
    DH_METHOD ("stop", K_stop_C_v4l2device_R48b83221),
    DH_METHOD ("cleanup", K_cleanup_C_v4l2device_Re20814c0),
    DH_METHOD ("set_exposure", K_set_exposure_C_v4l2device_Re021c15a),
    DH_METHOD ("set_gain", K_set_gain_C_v4l2device_Re021c15a),
    DH_METHOD ("set_brightness", K_set_brightness_C_v4l2device_Rc819c396),
    DH_METHOD ("set_contrast", K_set_contrast_C_v4l2device_Rc819c396),
    DH_METHOD ("v4l2device", K_v4l2device_C_v4l2device_R5b8dee7d),
    DH_METHOD ("_destructor", K__destructor_C_v4l2device_Re20814c0),
    DH_METHOD ("set_input", K_set_input_C_v4l2device_Rc819c396),
    DH_METHOD ("get_frame_yuv422",
		 K_get_frame_yuv422_C_v4l2device_Rdc58e0eb),
    DH_METHOD ("get_frame_grey", K_get_frame_grey_C_v4l2device_Rdc58e0eb),
    DH_METHOD ("get_frame_yuv", K_get_frame_yuv_C_v4l2device_Rdc58e0eb),
    DH_METHOD ("get_frame_rgb", K_get_frame_rgb_C_v4l2device_Rdc58e0eb),
    DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_v4l2 (void)
{
  dhclass_define ("v4l2device", &Kc_v4l2device_R57e47d97);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "start",
		   &K_start_C_v4l2device_Re20814c0);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "stop",
		   &K_stop_C_v4l2device_R48b83221);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "cleanup",
		   &K_cleanup_C_v4l2device_Re20814c0);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "set-exposure",
		   &K_set_exposure_C_v4l2device_Re021c15a);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "set-gain",
		   &K_set_gain_C_v4l2device_Re021c15a);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "set-brightness",
		   &K_set_brightness_C_v4l2device_Rc819c396);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "set-contrast",
		   &K_set_contrast_C_v4l2device_Rc819c396);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "v4l2device",
		   &K_v4l2device_C_v4l2device_R5b8dee7d);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "-destructor",
		   &K__destructor_C_v4l2device_Re20814c0);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "set-input",
		   &K_set_input_C_v4l2device_Rc819c396);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "get-frame-yuv422",
		   &K_get_frame_yuv422_C_v4l2device_Rdc58e0eb);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "get-frame-grey",
		   &K_get_frame_grey_C_v4l2device_Rdc58e0eb);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "get-frame-yuv",
		   &K_get_frame_yuv_C_v4l2device_Rdc58e0eb);
  dhmethod_define (&Kc_v4l2device_R57e47d97, "get-frame-rgb",
		   &K_get_frame_rgb_C_v4l2device_Rdc58e0eb);
}

int majver_v4l2 = 40;
int minver_v4l2 = 10;

#endif
