/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"
/*
 * USER DEFINED HEADERS
 */
#define BLK_COPY(nlin, ncol) {\
  int k,l;\
  int acc0=pin[0], acc1=pin[1], acc2=pin[2], acc3=pin[3];\
  for (k=0; k<nlin; k++) {\
    unsigned char *poutptr = pout+k*out_mod0;\
    for (l=0; l<ncol; l++) {\
    poutptr[0]=acc0 ; poutptr[1]=acc1 ; poutptr[2]=acc2 ; poutptr[3]=acc3 ;\
    poutptr += out_mod1;  }}}

#define BLK_AVRG(nlin, ncol) {\
  int k,l; int norm = ncol * nlin;\
  int acc0=0, acc1=0, acc2=0, acc3=0;\
  for (k=0; k<nlin; k++) {\
  register unsigned char *pinptr = pin+k*in_mod0;\
  for (l=0; l<ncol; l++) {\
  acc0 += pinptr[0];acc1 += pinptr[1];acc2 += pinptr[2];acc3 += pinptr[3];\
  pinptr += in_mod1; }}\
  pout[0] = acc0 / norm;pout[1] = acc1 / norm;pout[2] = acc2 / norm; pout[3]= acc3 / norm;}

#define NCOLCELL 32768
static int lum2rgb[NCOLCELL], lum2rgbinit = 0;

/*
 * DECLARATIONS
 */
extern_c char C_idx_u3resize (struct idx *, int, int, int);
extern_c char C_compute_bilin_transform (struct idx *, struct idx *, flt, flt,
					 flt, flt, flt, flt, flt, flt, flt,
					 flt, flt, flt);
extern_c char C_idx_f1i1sortup (struct idx *, struct idx *);
extern_c char C_idx_f2resize (struct idx *, int, int);
extern_c char C_idx_f1resize (struct idx *, int);
extern_c char C_idx_i1fill_with_index (struct idx *);

/* ---------------------------------------- */

/*
 * FUNCTION rgbaim-enlarge
 */
extern_c struct idx *
C_rgbaim_enlarge (struct idx *L1_in, int L1_nlin, int L1_ncol,
		  struct idx *L2_0_matrix, struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_rgbaim_enlarge");
  {
    struct idx *L_Tmp0;
    {
      int L2_1_h;
      int L2_2_w;
      int L2_3_nh;
      int L2_4_nw;
      struct idx *L2_5_out;
      L2_1_h = (L1_in)->dim[0];
      L2_2_w = (L1_in)->dim[1];
      L2_3_nh = (L2_1_h * L1_nlin);
      L2_3_nh = ((int) floor ((double) L2_3_nh));
      L2_4_nw = (L2_2_w * L1_ncol);
      L2_4_nw = ((int) floor ((double) L2_4_nw));
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim3 (L2_0_matrix, L2_3_nh, L2_4_nw, 4);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      RTERR_DIM (L2_0_matrix->dim[2] <= 0);
      L2_5_out = L2_0_matrix;
      {
	unsigned char *in_line, *pin;
	unsigned char *out_line, *pout;
	int i, _imax = ((L1_in))->dim[0];
	int j, _jmax = ((L1_in))->dim[1];
	int in_mod0 = ((L1_in))->mod[0];
	int in_mod1 = ((L1_in))->mod[1];
	int out_mod0 = ((L2_5_out))->mod[0];
	int out_mod1 = ((L2_5_out))->mod[1];
	int pout_incr = (L1_ncol) * out_mod1;

	in_line = IDX_PTR (((L1_in)), unsigned char);
	out_line = IDX_PTR (((L2_5_out)), unsigned char);
	for (i = 0; i < _imax; i++)
	  {
	    pin = in_line;
	    pout = out_line;
	    for (j = 0; j < _jmax; j++)
	      {
		BLK_COPY ((L1_nlin), (L1_ncol));
		pin += in_mod1;
		pout += pout_incr;
	      }
	    in_line += in_mod0;
	    out_line += out_mod0 * (L1_nlin);
	  }
      }
      L_Tmp0 = L2_5_out;
    }
    TRACE_POP ("C_rgbaim_enlarge");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-enlarge-into
 */
extern_c char
C_rgbaim_enlarge_into (struct idx *L1_in, struct idx *L1_out, int L1_nlin,
		       int L1_ncol)
{
  TRACE_PUSH ("C_rgbaim_enlarge_into");
  {
    char L_Tmp0;
    {
      int L2_1_h;
      int L2_2_w;
      int L2_3_nh;
      int L2_4_nw;
      char L_Tmp5;
      char L_Tmp6;
      L2_1_h = (int) ((L1_in)->dim[0]);
      L2_2_w = (int) ((L1_in)->dim[1]);
      L2_3_nh = (int) ((L2_1_h * L1_nlin));
      L2_4_nw = (int) ((L2_2_w * L1_ncol));
      if ((L2_3_nh > (L1_out)->dim[0]))
	{
	  L_Tmp5 = 1;
	}
      else
	{
	  if ((L2_4_nw > (L1_out)->dim[1]))
	    {
	      L_Tmp5 = 1;
	    }
	  else
	    {
	      L_Tmp5 = 0;
	    }
	}
      if (L_Tmp5)
	{
	  C_idx_u3resize (L1_out, L2_3_nh, L2_4_nw, 4);
	}
      if ((L1_nlin == 1))
	{
	  if ((L1_ncol == 1))
	    {
	      L_Tmp6 = 1;
	    }
	  else
	    {
	      L_Tmp6 = 0;
	    }
	}
      else
	{
	  L_Tmp6 = 0;
	}
      if (L_Tmp6)
	{
	  check_main_maout_any (L1_in, L1_out);
	  Midx_macopy (L1_in, L1_out, unsigned char, unsigned char);
	  L_Tmp0 = 0;
	}
      else
	{
	  {
	    unsigned char *in_line, *pin;
	    unsigned char *out_line, *pout;
	    int i, _imax = ((L1_in))->dim[0];
	    int j, _jmax = ((L1_in))->dim[1];
	    int in_mod0 = ((L1_in))->mod[0];
	    int in_mod1 = ((L1_in))->mod[1];
	    int out_mod0 = ((L1_out))->mod[0];
	    int out_mod1 = ((L1_out))->mod[1];
	    int pout_incr = (L1_ncol) * out_mod1;

	    in_line = IDX_PTR (((L1_in)), unsigned char);
	    out_line = IDX_PTR (((L1_out)), unsigned char);
	    for (i = 0; i < _imax; i++)
	      {
		pin = in_line;
		pout = out_line;
		for (j = 0; j < _jmax; j++)
		  {
		    BLK_COPY ((L1_nlin), (L1_ncol));
		    pin += in_mod1;
		    pout += pout_incr;
		  }
		in_line += in_mod0;
		out_line += out_mod0 * (L1_nlin);
	      }
	  }
	  L_Tmp0 = 0;
	}
    }
    TRACE_POP ("C_rgbaim_enlarge_into");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-subsample
 */
extern_c struct idx *
C_rgbaim_subsample (struct idx *L1_in, int L1_nlin, int L1_ncol,
		    struct idx *L2_2_matrix, struct srg *L2_2_srg,
		    struct idx *L3_3_matrix, struct srg *L3_3_srg)
{
  TRACE_PUSH ("C_rgbaim_subsample");
  {
    struct idx *L_Tmp0;
    {
      int L2_1_h;
      int L2_2_w;
      int L2_3_nh;
      int L2_4_nw;
      Midx_declare (L3_5_1_clone, 3);
      struct idx *L2_6_inp;
      struct idx *L2_7_out;
      char L_Tmp14;
      Midx_init (L3_5_1_clone, 3);
      L2_1_h = (L1_in)->dim[0];
      L2_2_w = (L1_in)->dim[1];
      L2_3_nh = (L2_1_h / (real) L1_nlin);
      L2_3_nh = ((int) floor ((double) L2_3_nh));
      L2_4_nw = (L2_2_w / (real) L1_ncol);
      L2_4_nw = ((int) floor ((double) L2_4_nw));
      {
	Midx_declare (L4_8_0_clone, 3);
	struct idx *L3_9___m;
	struct idx *L_Tmp10;
	real L_Tmp13;
	Midx_init (L4_8_0_clone, 3);
	{
	  struct idx *L4_11___m;
	  real L_Tmp12;
	  Midx_clone3 (L4_8_0_clone, L1_in);
	  L4_11___m = L4_8_0_clone;
	  L_Tmp12 = (L1_nlin * L2_3_nh);
	  RTERR_GEN ((((int) L_Tmp12) < 1
		      || ((int) 0) < 0), "illegal 'size' or 'offset'");
	  RTERR_GEN ((((int) 0) + ((int) L_Tmp12) >
		      (L4_11___m)->dim[((int) 0)]),
		     "specified interval is too large");
	  Midx_narrow (L4_11___m, ((int) 0), ((int) L_Tmp12), ((int) 0),
		       unsigned char);
	  L_Tmp10 = L4_11___m;
	}
	Midx_clone3 (L3_5_1_clone, L_Tmp10);
	L3_9___m = L3_5_1_clone;
	L_Tmp13 = (L1_ncol * L2_4_nw);
	RTERR_GEN ((((int) L_Tmp13) < 1
		    || ((int) 0) < 0), "illegal 'size' or 'offset'");
	RTERR_GEN ((((int) 0) + ((int) L_Tmp13) > (L3_9___m)->dim[((int) 1)]),
		   "specified interval is too large");
	Midx_narrow (L3_9___m, ((int) 1), ((int) L_Tmp13), ((int) 0),
		     unsigned char);
	L2_6_inp = L3_9___m;
      }
      (L2_2_matrix)->srg = L2_2_srg;
      Midx_init_dim3 (L2_2_matrix, L2_3_nh, L2_4_nw, 4);
      RTERR_DIM (L2_2_matrix->dim[0] <= 0);
      RTERR_DIM (L2_2_matrix->dim[1] <= 0);
      RTERR_DIM (L2_2_matrix->dim[2] <= 0);
      L2_7_out = L2_2_matrix;
      if ((L1_nlin == 1))
	{
	  if ((L1_ncol == 1))
	    {
	      L_Tmp14 = 1;
	    }
	  else
	    {
	      L_Tmp14 = 0;
	    }
	}
      else
	{
	  L_Tmp14 = 0;
	}
      if (L_Tmp14)
	{
	  {
	    (L3_3_matrix)->srg = L3_3_srg;
	    Midx_init_dim3 (L3_3_matrix, (L1_in)->dim[0], (L1_in)->dim[1],
			    (L1_in)->dim[2]);
	    RTERR_DIM (L3_3_matrix->dim[0] <= 0);
	    RTERR_DIM (L3_3_matrix->dim[1] <= 0);
	    RTERR_DIM (L3_3_matrix->dim[2] <= 0);
	    check_main_maout_any (L1_in, L3_3_matrix);
	    Midx_macopy (L1_in, L3_3_matrix, unsigned char, unsigned char);
	    L_Tmp0 = L3_3_matrix;
	  }
	}
      else
	{
	  {
	    unsigned char *in_line, *pin;
	    unsigned char *out_line, *pout;
	    int i, _imax = ((L2_7_out))->dim[0];
	    int j, _jmax = ((L2_7_out))->dim[1];
	    int in_mod0 = ((L2_6_inp))->mod[0];
	    int in_mod1 = ((L2_6_inp))->mod[1];
	    int out_mod0 = ((L2_7_out))->mod[0];
	    int out_mod1 = ((L2_7_out))->mod[1];
	    int pin_incr = (L1_ncol) * in_mod1;

	    in_line = IDX_PTR (((L2_6_inp)), unsigned char);
	    out_line = IDX_PTR (((L2_7_out)), unsigned char);
	    for (i = 0; i < _imax; i++)
	      {
		pin = in_line;
		pout = out_line;
		for (j = 0; j < _jmax; j++)
		  {
		    BLK_AVRG ((L1_nlin), (L1_ncol));
		    pin += pin_incr;
		    pout += out_mod1;
		  }
		in_line += in_mod0 * (L1_nlin);
		out_line += out_mod0;
	      }
	  }
	  L_Tmp0 = L2_7_out;
	}
    }
    TRACE_POP ("C_rgbaim_subsample");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-subsample-into
 */
extern_c char
C_rgbaim_subsample_into (struct idx *L1_in, struct idx *L1_out, int L1_nlin,
			 int L1_ncol)
{
  TRACE_PUSH ("C_rgbaim_subsample_into");
  {
    char L_Tmp0;
    {
      int L2_1_h;
      int L2_2_w;
      int L2_3_nh;
      int L2_4_nw;
      Midx_declare (L3_5_1_clone, 3);
      struct idx *L2_6_inp;
      char L_Tmp13;
      Midx_init (L3_5_1_clone, 3);
      L2_1_h = (L1_in)->dim[0];
      L2_2_w = (L1_in)->dim[1];
      L2_3_nh = (L2_1_h / (real) L1_nlin);
      L2_3_nh = ((int) floor ((double) L2_3_nh));
      L2_4_nw = (L2_2_w / (real) L1_ncol);
      L2_4_nw = ((int) floor ((double) L2_4_nw));
      {
	Midx_declare (L4_7_0_clone, 3);
	struct idx *L3_8___m;
	struct idx *L_Tmp9;
	real L_Tmp12;
	Midx_init (L4_7_0_clone, 3);
	{
	  struct idx *L4_10___m;
	  real L_Tmp11;
	  Midx_clone3 (L4_7_0_clone, L1_in);
	  L4_10___m = L4_7_0_clone;
	  L_Tmp11 = (L1_nlin * L2_3_nh);
	  RTERR_GEN ((((int) L_Tmp11) < 1
		      || ((int) 0) < 0), "illegal 'size' or 'offset'");
	  RTERR_GEN ((((int) 0) + ((int) L_Tmp11) >
		      (L4_10___m)->dim[((int) 0)]),
		     "specified interval is too large");
	  Midx_narrow (L4_10___m, ((int) 0), ((int) L_Tmp11), ((int) 0),
		       unsigned char);
	  L_Tmp9 = L4_10___m;
	}
	Midx_clone3 (L3_5_1_clone, L_Tmp9);
	L3_8___m = L3_5_1_clone;
	L_Tmp12 = (L1_ncol * L2_4_nw);
	RTERR_GEN ((((int) L_Tmp12) < 1
		    || ((int) 0) < 0), "illegal 'size' or 'offset'");
	RTERR_GEN ((((int) 0) + ((int) L_Tmp12) > (L3_8___m)->dim[((int) 1)]),
		   "specified interval is too large");
	Midx_narrow (L3_8___m, ((int) 1), ((int) L_Tmp12), ((int) 0),
		     unsigned char);
	L2_6_inp = L3_8___m;
      }
      C_idx_u3resize (L1_out, L2_3_nh, L2_4_nw, 4);
      if ((L1_nlin == 1))
	{
	  if ((L1_ncol == 1))
	    {
	      L_Tmp13 = 1;
	    }
	  else
	    {
	      L_Tmp13 = 0;
	    }
	}
      else
	{
	  L_Tmp13 = 0;
	}
      if (L_Tmp13)
	{
	  {
	    RTERR_LOOPDIM ((L1_out)->dim[0] != (L1_in)->dim[0]);
	    Midx_begin_bloop2 (L3_in, L1_in, L3_out, L1_out, unsigned char)
	    {
	      check_main_maout (&L3_in, &L3_out);
	      Midx_m2copy (&L3_in, &L3_out, unsigned char, unsigned char);
	    } Midx_end_bloop2 (L3_in, L1_in, L3_out, L1_out, unsigned char);
	  }
	  L_Tmp0 = 0;
	}
      else
	{
	  {
	    unsigned char *in_line, *pin;
	    unsigned char *out_line, *pout;
	    int i, _imax = ((L1_out))->dim[0];
	    int j, _jmax = ((L1_out))->dim[1];
	    int in_mod0 = ((L2_6_inp))->mod[0];
	    int in_mod1 = ((L2_6_inp))->mod[1];
	    int out_mod0 = ((L1_out))->mod[0];
	    int out_mod1 = ((L1_out))->mod[1];
	    int pin_incr = (L1_ncol) * in_mod1;

	    in_line = IDX_PTR (((L2_6_inp)), unsigned char);
	    out_line = IDX_PTR (((L1_out)), unsigned char);
	    for (i = 0; i < _imax; i++)
	      {
		pin = in_line;
		pout = out_line;
		for (j = 0; j < _jmax; j++)
		  {
		    BLK_AVRG ((L1_nlin), (L1_ncol));
		    pin += pin_incr;
		    pout += out_mod1;
		  }
		in_line += in_mod0 * (L1_nlin);
		out_line += out_mod0;
	      }
	  }
	  L_Tmp0 = 0;
	}
    }
    TRACE_POP ("C_rgbaim_subsample_into");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-rot90-right
 */
extern_c struct idx *
C_rgbaim_rot90_right (struct idx *L1_inp, struct idx *L2_0_matrix,
		      struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_rgbaim_rot90_right");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_out;
      int L2_2_inpdim;
      int L2_3_inpmod;
      int L2_4_outdim;
      int L2_5_outmod;
      int L2_6_inpdim2;
      int L2_7_inpmod2;
      int L2_8_outdim2;
      int L2_9_outmod2;
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim3 (L2_0_matrix, (L1_inp)->dim[1], (L1_inp)->dim[0],
		      (L1_inp)->dim[2]);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      RTERR_DIM (L2_0_matrix->dim[2] <= 0);
      Midx_maclear (L2_0_matrix, unsigned char);
      L2_1_out = L2_0_matrix;
      L2_2_inpdim = (L1_inp)->dim[0];
      L2_3_inpmod = (L1_inp)->mod[0];
      L2_4_outdim = (L2_1_out)->dim[1];
      L2_5_outmod = (L2_1_out)->mod[1];
      L2_6_inpdim2 = (L1_inp)->dim[2];
      L2_7_inpmod2 = (L1_inp)->mod[2];
      L2_8_outdim2 = (L2_1_out)->dim[2];
      L2_9_outmod2 = (L2_1_out)->mod[2];
      {
	Midx_declare (L3_10_1_tclone, 3);
	struct idx *L_Tmp11;
	Midx_init (L3_10_1_tclone, 3);
	{
	  static int permlist[] = {
	    1, 0, 2
	  };
	  Midx_transclone (L3_10_1_tclone, L1_inp, permlist, unsigned char);
	}
	L_Tmp11 = L3_10_1_tclone;
	RTERR_LOOPDIM ((L2_1_out)->dim[0] != (L_Tmp11)->dim[0]);
	Midx_begin_bloop2 (L3_inp, L_Tmp11, L3_out, L2_1_out, unsigned char)
	{
	  {
	    unsigned char *pin, *pout;
	    int i, k;
	    pin = IDX_PTR (((&L3_inp)), unsigned char);
	    pout =
	      IDX_PTR (((&L3_out)),
		       unsigned char) + (L2_4_outdim) * (L2_5_outmod);
	    for (i = 0; i < (L2_2_inpdim); i++)
	      {
		pout -= (L2_5_outmod);
		for (k = 0; k < (L2_6_inpdim2); k++)
		  {
		    pout[k] = pin[k];
		  }
		pin += (L2_3_inpmod);
	      }
	  }
	}
	Midx_end_bloop2 (L3_inp, L_Tmp11, L3_out, L2_1_out, unsigned char);
      }
      L_Tmp0 = L2_1_out;
    }
    TRACE_POP ("C_rgbaim_rot90_right");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-rot90-left
 */
extern_c struct idx *
C_rgbaim_rot90_left (struct idx *L1_inp, struct idx *L2_0_matrix,
		     struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_rgbaim_rot90_left");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_out;
      int L2_2_inpdim;
      int L2_3_inpmod;
      int L2_4_outdim;
      int L2_5_outmod;
      int L2_6_inpdim2;
      int L2_7_inpmod2;
      int L2_8_outdim2;
      int L2_9_outmod2;
      Midx_declare (L3_10_1_tclone, 3);
      Midx_init (L3_10_1_tclone, 3);
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim3 (L2_0_matrix, (L1_inp)->dim[1], (L1_inp)->dim[0],
		      (L1_inp)->dim[2]);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      RTERR_DIM (L2_0_matrix->dim[2] <= 0);
      Midx_maclear (L2_0_matrix, unsigned char);
      L2_1_out = L2_0_matrix;
      L2_2_inpdim = (L1_inp)->dim[1];
      L2_3_inpmod = (L1_inp)->mod[1];
      L2_4_outdim = (L2_1_out)->dim[0];
      L2_5_outmod = (L2_1_out)->mod[0];
      L2_6_inpdim2 = (L1_inp)->dim[2];
      L2_7_inpmod2 = (L1_inp)->mod[2];
      L2_8_outdim2 = (L2_1_out)->dim[2];
      L2_9_outmod2 = (L2_1_out)->mod[2];
      {
	struct idx *L_Tmp11;
	{
	  static int permlist[] = {
	    1, 0, 2
	  };
	  Midx_transclone (L3_10_1_tclone, L2_1_out, permlist, unsigned char);
	}
	L_Tmp11 = L3_10_1_tclone;
	RTERR_LOOPDIM ((L_Tmp11)->dim[0] != (L1_inp)->dim[0]);
	Midx_begin_bloop2 (L3_inp, L1_inp, L3_out, L_Tmp11, unsigned char)
	{
	  {
	    unsigned char *pin, *pout;
	    int i, k;
	    pin = IDX_PTR (((&L3_inp)), unsigned char);
	    pout =
	      IDX_PTR (((&L3_out)),
		       unsigned char) + (L2_4_outdim) * (L2_5_outmod);
	    for (i = 0; i < (L2_2_inpdim); i++)
	      {
		pout -= (L2_5_outmod);
		for (k = 0; k < (L2_6_inpdim2); k++)
		  {
		    pout[k] = pin[k];
		  }
		pin += (L2_3_inpmod);
	      }
	  }
	}
	Midx_end_bloop2 (L3_inp, L1_inp, L3_out, L_Tmp11, unsigned char);
      }
      L_Tmp0 = L2_1_out;
    }
    TRACE_POP ("C_rgbaim_rot90_left");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-rot180
 */
extern_c struct idx *
C_rgbaim_rot180 (struct idx *L1_inp, struct idx *L2_0_matrix,
		 struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_rgbaim_rot180");
  {
    struct idx *L_Tmp0;
    {
      int L2_1_ncol;
      int L2_2_nlin;
      int L2_3_depth;
      struct idx *L2_4_out;
      L2_1_ncol = (L1_inp)->dim[1];
      L2_2_nlin = (L1_inp)->dim[0];
      L2_3_depth = (L1_inp)->dim[2];
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim3 (L2_0_matrix, L2_2_nlin, L2_1_ncol, L2_3_depth);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      RTERR_DIM (L2_0_matrix->dim[2] <= 0);
      Midx_maclear (L2_0_matrix, unsigned char);
      L2_4_out = L2_0_matrix;
      {
	int i, j, k;
	unsigned char *upline, *downline, *upl, *dnl;
	int inpmod0 = (L1_inp)->mod[0];
	int inpmod1 = (L1_inp)->mod[1];
	int outmod0 = (L2_4_out)->mod[0];
	int outmod1 = (L2_4_out)->mod[1];
	upline = IDX_PTR ((L2_4_out), unsigned char);
	downline =
	  IDX_PTR ((L1_inp), unsigned char) + ((L2_2_nlin) - 1) * inpmod0;
	for (i = 0; i < (L2_2_nlin); i++)
	  {
	    upl = upline;
	    dnl = downline + ((L2_1_ncol) - 1) * inpmod1;
	    for (j = 0; j < (L2_1_ncol); j++)
	      {
		for (k = 0; k < (L2_3_depth); k++)
		  {
		    upl[k] = dnl[k];
		  }
		upl += outmod1;
		dnl -= inpmod1;
	      }
	    upline += outmod0;
	    downline -= inpmod0;
	  }
      }
      L_Tmp0 = L2_4_out;
    }
    TRACE_POP ("C_rgbaim_rot180");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-rot180-inplace
 */
extern_c char
C_rgbaim_rot180_inplace (struct idx *L1_image)
{
  TRACE_PUSH ("C_rgbaim_rot180_inplace");
  {
    {
      int L2_0_ncol;
      int L2_1_nlin;
      L2_0_ncol = (L1_image)->dim[1];
      L2_1_nlin = (L1_image)->dim[0];
      {
	int i, j, mod0, mod1;
	unsigned char tmp0, tmp1, tmp2, tmp3, *upline, *downline, *upl, *dnl;
	mod0 = (L1_image)->mod[0];
	mod1 = (L1_image)->mod[1];
	upline = IDX_PTR ((L1_image), unsigned char);
	downline = upline + ((L2_1_nlin) - 1) * mod0;
	for (i = 0; i < ((L2_1_nlin) + 1) / 2; i++)
	  {
	    upl = upline;
	    dnl = downline + (L2_0_ncol) * mod1;
	    for (j = 0; j < (L2_0_ncol); j++)
	      {
		tmp0 = upl[0];
		tmp1 = upl[1];
		tmp2 = upl[2];
		tmp3 = upl[3];
		upl[0] = dnl[0];
		dnl[0] = tmp0;
		upl[1] = dnl[1];
		dnl[1] = tmp1;
		upl[2] = dnl[2];
		dnl[2] = tmp2;
		upl[3] = dnl[3];
		dnl[3] = tmp3;
		upl += mod1;
		dnl -= mod1;
	      }
	    upline += mod0;
	    downline -= mod0;
	  }
      }
    }
    TRACE_POP ("C_rgbaim_rot180_inplace");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-crop
 */
extern_c struct idx *
C_rgbaim_crop (struct idx *L1_in, int L1_x, int L1_y, int L1_w, int L1_h,
	       struct idx *L2_4_matrix, struct srg *L2_4_srg)
{
  TRACE_PUSH ("C_rgbaim_crop");
  {
    struct idx *L_Tmp0;
    Midx_declare (L2_1_1_clone, 3);
    Midx_init (L2_1_1_clone, 3);
    {
      Midx_declare (L3_2_3_clone, 3);
      struct idx *L2_3_in;
      struct idx *L2_4_out;
      Midx_init (L3_2_3_clone, 3);
      {
	Midx_declare (L4_5_2_clone, 3);
	struct idx *L3_6___m;
	struct idx *L_Tmp7;
	Midx_init (L4_5_2_clone, 3);
	{
	  struct idx *L4_8___m;
	  Midx_clone3 (L4_5_2_clone, L1_in);
	  L4_8___m = L4_5_2_clone;
	  RTERR_GEN ((((int) L1_h) < 1
		      || ((int) L1_y) < 0), "illegal 'size' or 'offset'");
	  RTERR_GEN ((((int) L1_y) + ((int) L1_h) >
		      (L4_8___m)->dim[((int) 0)]),
		     "specified interval is too large");
	  Midx_narrow (L4_8___m, ((int) 0), ((int) L1_h), ((int) L1_y),
		       unsigned char);
	  L_Tmp7 = L4_8___m;
	}
	Midx_clone3 (L3_2_3_clone, L_Tmp7);
	L3_6___m = L3_2_3_clone;
	RTERR_GEN ((((int) L1_w) < 1
		    || ((int) L1_x) < 0), "illegal 'size' or 'offset'");
	RTERR_GEN ((((int) L1_x) + ((int) L1_w) > (L3_6___m)->dim[((int) 1)]),
		   "specified interval is too large");
	Midx_narrow (L3_6___m, ((int) 1), ((int) L1_w), ((int) L1_x),
		     unsigned char);
	L2_3_in = L3_6___m;
      }
      (L2_4_matrix)->srg = L2_4_srg;
      Midx_init_dim3 (L2_4_matrix, (L2_3_in)->dim[0], (L2_3_in)->dim[1],
		      (L2_3_in)->dim[2]);
      RTERR_DIM (L2_4_matrix->dim[0] <= 0);
      RTERR_DIM (L2_4_matrix->dim[1] <= 0);
      RTERR_DIM (L2_4_matrix->dim[2] <= 0);
      L2_4_out = L2_4_matrix;
      {
	RTERR_LOOPDIM ((L2_4_out)->dim[0] != (L2_3_in)->dim[0]);
	Midx_begin_bloop2 (L3_in, L2_3_in, L3_out, L2_4_out, unsigned char)
	{
	  check_main_maout (&L3_in, &L3_out);
	  Midx_m2copy (&L3_in, &L3_out, unsigned char, unsigned char);
	} Midx_end_bloop2 (L3_in, L2_3_in, L3_out, L2_4_out, unsigned char);
	L_Tmp0 = L2_4_out;
      }
    }
    TRACE_POP ("C_rgbaim_crop");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-interpolate-bilin
 */
extern_c char
C_rgbaim_interpolate_bilin (unsigned char *L1_background,
			    unsigned char *L1_pin, int L1_indimi,
			    int L1_indimj, int L1_inmodi, int L1_inmodj,
			    int L1_ppi, int L1_ppj, unsigned char *L1_rez)
{
  TRACE_PUSH ("C_rgbaim_interpolate_bilin");
  {
    {
      int li0, lj0;
      register int li1, lj1;
      int deltai, ndeltai;
      int deltaj, ndeltaj;
      register unsigned char *pin00, *back;
      register unsigned char *v00, *v01, *v10, *v11;
      back = (unsigned char *) (L1_background);
      li0 = (L1_ppi) >> 16;
      li1 = li0 + 1;
      deltai = (L1_ppi) & 0x0000ffff;
      ndeltai = 0x00010000 - deltai;
      lj0 = (L1_ppj) >> 16;
      lj1 = lj0 + 1;
      deltaj = (L1_ppj) & 0x0000ffff;
      ndeltaj = 0x00010000 - deltaj;
      pin00 =
	(unsigned char *) ((L1_pin)) + (L1_inmodi) * li0 + (L1_inmodj) * lj0;
      if ((li1 > 0) && (li1 < (L1_indimi)))
	{
	  if ((lj1 > 0) && (lj1 < (L1_indimj)))
	    {
	      v00 = (pin00);
	      v01 = (pin00 + (L1_inmodj));
	      v11 = (pin00 + (L1_inmodi) + (L1_inmodj));
	      v10 = (pin00 + (L1_inmodi));
	      v00 = (pin00);
	    }
	  else if (lj1 == 0)
	    {
	      v00 = back;
	      v01 = (pin00 + (L1_inmodj));
	      v11 = (pin00 + (L1_inmodi) + (L1_inmodj));
	      v10 = back;
	    }
	  else if (lj1 == (L1_indimj))
	    {
	      v00 = (pin00);
	      v01 = back;
	      v11 = back;
	      v10 = (pin00 + (L1_inmodi));
	    }
	  else
	    {
	      v00 = back;
	      v01 = back;
	      v11 = back;
	      v10 = back;
	    }
	}
      else if (li1 == 0)
	{
	  if ((lj1 > 0) && (lj1 < (L1_indimj)))
	    {
	      v00 = back;
	      v01 = back;
	      v11 = (pin00 + (L1_inmodi) + (L1_inmodj));
	      v10 = (pin00 + (L1_inmodi));
	    }
	  else if (lj1 == 0)
	    {
	      v00 = back;
	      v01 = back;
	      v11 = (pin00 + (L1_inmodi) + (L1_inmodj));
	      v10 = back;
	    }
	  else if (lj1 == (L1_indimj))
	    {
	      v00 = back;
	      v01 = back;
	      v11 = back;
	      v10 = (pin00 + (L1_inmodi));
	    }
	  else
	    {
	      v00 = back;
	      v01 = back;
	      v11 = back;
	      v10 = back;
	    }
	}
      else if (li1 == (L1_indimi))
	{
	  if ((lj1 > 0) && (lj1 < (L1_indimj)))
	    {
	      v00 = (pin00);
	      v01 = (pin00 + (L1_inmodj));
	      v11 = back;
	      v10 = back;
	    }
	  else if (lj1 == 0)
	    {
	      v00 = back;
	      v01 = (pin00 + (L1_inmodj));
	      v11 = back;
	      v10 = back;
	    }
	  else if (lj1 == (L1_indimj))
	    {
	      v00 = (pin00);
	      v01 = back;
	      v11 = back;
	      v10 = back;
	    }
	  else
	    {
	      v00 = back;
	      v01 = back;
	      v11 = back;
	      v10 = back;
	    }
	}
      else
	{
	  v00 = back;
	  v01 = back;
	  v11 = back;
	  v10 = back;
	}
      /* printf("deltai=%d, deltaj=%d, r00=%d, r10=%d, r01=%d, r11=%d\n",
         deltai, deltaj, v00[0], v10[0], v01[0], v11[0]); */
      {
	register unsigned char *ubout;
	ubout = (unsigned char *) ((L1_rez));
	ubout[0] = (ndeltaj * ((v10[0] * deltai + v00[0] * ndeltai) >> 16) +
		    deltaj *
		    ((v11[0] * deltai + v01[0] * ndeltai) >> 16)) >> 16;
	ubout[1] =
	  (ndeltaj * ((v10[1] * deltai + v00[1] * ndeltai) >> 16) +
	   deltaj * ((v11[1] * deltai + v01[1] * ndeltai) >> 16)) >> 16;
	ubout[2] =
	  (ndeltaj * ((v10[2] * deltai + v00[2] * ndeltai) >> 16) +
	   deltaj * ((v11[2] * deltai + v01[2] * ndeltai) >> 16)) >> 16;
	ubout[3] =
	  (ndeltaj * ((v10[3] * deltai + v00[3] * ndeltai) >> 16) +
	   deltaj * ((v11[3] * deltai + v01[3] * ndeltai) >> 16)) >> 16;
      }
    }
    TRACE_POP ("C_rgbaim_interpolate_bilin");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-warp
 */
extern_c char
C_rgbaim_warp (struct idx *L1_in, struct idx *L1_out,
	       struct idx *L1_background, struct idx *L1_pi,
	       struct idx *L1_pj)
{
  TRACE_PUSH ("C_rgbaim_warp");
  {
    char L_Tmp0;
    if ((4 != (L1_in)->dim[2]))
      {
	L_Tmp0 = 1;
      }
    else
      {
	if ((4 != (L1_out)->dim[2]))
	  {
	    L_Tmp0 = 1;
	  }
	else
	  {
	    if ((4 != (L1_background)->dim[0]))
	      {
		L_Tmp0 = 1;
	      }
	    else
	      {
		L_Tmp0 = 0;
	      }
	  }
      }
    if (L_Tmp0)
      {
	run_time_error ("last dimension of in, out and background must be 4");
      }
    {
      real L2_1_ni;
      real L2_2_nj;
      gptr L2_3_pin;
      gptr L2_4_pback;
      int L2_5_indimi;
      int L2_6_indimj;
      int L2_7_inmodi;
      int L2_8_inmodj;
      L2_1_ni = (L1_in)->dim[0];
      L2_2_nj = (L1_in)->dim[1];
      L2_3_pin = (gptr) (IDX_PTR (L1_in, unsigned char));
      L2_4_pback = (gptr) (IDX_PTR (L1_background, unsigned char));
      L2_5_indimi = (L1_in)->dim[0];
      L2_6_indimj = (L1_in)->dim[1];
      L2_7_inmodi = (L1_in)->mod[0];
      L2_8_inmodj = (L1_in)->mod[1];
      {
	RTERR_LOOPDIM ((L1_pj)->dim[0] != (L1_pi)->dim[0]
		       || (L1_pj)->dim[0] != (L1_out)->dim[0]);
	Midx_begin_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj, int)
	{
	  {
	    RTERR_LOOPDIM ((&L3_lpj)->dim[0] != (&L3_lpi)->dim[0]
			   || (&L3_lpj)->dim[0] != (&L3_lout)->dim[0]);
	    Midx_begin_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int)
	    {
	      {
		int L5_9_ppi;
		int L5_10_ppj;
		gptr L5_11_pout;
		L5_9_ppi = *IDX_PTR (&L4_llpi, int);
		L5_10_ppj = *IDX_PTR (&L4_llpj, int);
		L5_11_pout = (gptr) (IDX_PTR (&L4_llout, unsigned char));
		C_rgbaim_interpolate_bilin ((unsigned char *) (L2_4_pback),
					    (unsigned char *) (L2_3_pin),
					    L2_5_indimi, L2_6_indimj,
					    L2_7_inmodi, L2_8_inmodj,
					    L5_9_ppi, L5_10_ppj,
					    (unsigned char *) (L5_11_pout));
	      }
	    } Midx_end_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int);
	  }
	} Midx_end_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj,
			   int);
      }
    }
    TRACE_POP ("C_rgbaim_warp");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-warp-fast
 */
extern_c char
C_rgbaim_warp_fast (struct idx *L1_in, struct idx *L1_out,
		    struct idx *L1_background, struct idx *L1_pi,
		    struct idx *L1_pj)
{
  TRACE_PUSH ("C_rgbaim_warp_fast");
  {
    {
      real L2_0_ni;
      real L2_1_nj;
      gptr L2_2_pin;
      gptr L2_3_back;
      int L2_4_indimi;
      int L2_5_indimj;
      int L2_6_inmodi;
      int L2_7_inmodj;
      L2_0_ni = (L1_in)->dim[0];
      L2_1_nj = (L1_in)->dim[1];
      L2_2_pin = (gptr) (IDX_PTR (L1_in, unsigned char));
      L2_3_back = (gptr) (IDX_PTR (L1_background, unsigned char));
      L2_4_indimi = (L1_in)->dim[0];
      L2_5_indimj = (L1_in)->dim[1];
      L2_6_inmodi = (L1_in)->mod[0];
      L2_7_inmodj = (L1_in)->mod[1];
      {
	Midx_begin_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj, int)
	{
	  {
	    Midx_begin_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int)
	    {
	      {
		int L5_8_ppi;
		int L5_9_ppj;
		L5_8_ppi = *IDX_PTR (&L4_llpi, int);
		L5_9_ppj = *IDX_PTR (&L4_llpj, int);
		{
		  register int li, lj;
		  register unsigned char *out, *in;
		  out = IDX_PTR ((&L4_llout), unsigned char);
		  li = ((L5_8_ppi) + 0x7f) >> 16;
		  lj = ((L5_9_ppj) + 0x7f) >> 16;
		  if ((li >= 0) && (li < (L2_4_indimi)) && (lj >= 0)
		      && (lj < (L2_5_indimj)))
		    {
		      in =
			(unsigned char *) ((L2_2_pin)) + (L2_6_inmodi) * li +
			(L2_7_inmodj) * lj;
		      out[0] = in[0];
		      out[1] = in[1];
		      out[2] = in[2];
		      out[3] = in[3];
		    }
		  else
		    {
		      out[0] = *((unsigned char *) ((L2_3_back)));
		      out[1] = *((unsigned char *) ((L2_3_back)) + 1);
		      out[2] = *((unsigned char *) ((L2_3_back)) + 2);
		      out[3] = *((unsigned char *) ((L2_3_back)) + 3);
		    }
		}
	      }
	    } Midx_end_bloop3 (L4_llout, &L3_lout, L4_llpi, &L3_lpi, L4_llpj,
			       &L3_lpj, int);
	  }
	} Midx_end_bloop3 (L3_lout, L1_out, L3_lpi, L1_pi, L3_lpj, L1_pj,
			   int);
      }
    }
    TRACE_POP ("C_rgbaim_warp_fast");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-warp-quad
 */
extern_c char
C_rgbaim_warp_quad (struct idx *L1_in, struct idx *L1_out,
		    struct idx *L1_background, int L1_mode, flt L1_x1,
		    flt L1_y1, flt L1_x2, flt L1_y2, flt L1_x3, flt L1_y3,
		    flt L1_x4, flt L1_y4, flt L1_p1, flt L1_q1, flt L1_p3,
		    flt L1_q3)
{
  TRACE_PUSH ("C_rgbaim_warp_quad");
  {
    {
      real L2_0_outi;
      real L2_1_outj;
      Midx_declare (L2_2_0_matrix, 2);
      Msrg_declare (L2_3_0_srg);
      struct idx *L2_4_dispi;
      Midx_declare (L2_5_1_matrix, 2);
      Msrg_declare (L2_6_1_srg);
      struct idx *L2_7_dispj;
      Midx_init (L2_2_0_matrix, 2);
      Msrg_init (L2_3_0_srg, ST_I32);
      Midx_init (L2_5_1_matrix, 2);
      Msrg_init (L2_6_1_srg, ST_I32);
      L2_0_outi = (L1_out)->dim[0];
      L2_1_outj = (L1_out)->dim[1];
      (L2_2_0_matrix)->srg = L2_3_0_srg;
      Midx_init_dim2 (L2_2_0_matrix, L2_0_outi, L2_1_outj);
      RTERR_DIM (L2_2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_2_0_matrix->dim[1] <= 0);
      L2_4_dispi = L2_2_0_matrix;
      (L2_5_1_matrix)->srg = L2_6_1_srg;
      Midx_init_dim2 (L2_5_1_matrix, L2_0_outi, L2_1_outj);
      RTERR_DIM (L2_5_1_matrix->dim[0] <= 0);
      RTERR_DIM (L2_5_1_matrix->dim[1] <= 0);
      L2_7_dispj = L2_5_1_matrix;
      C_compute_bilin_transform (L2_4_dispi, L2_7_dispj, L1_x1, L1_y1, L1_x2,
				 L1_y2, L1_x3, L1_y3, L1_x4, L1_y4, L1_p1,
				 L1_q1, L1_p3, L1_q3);
      if ((0 == L1_mode))
	{
	  C_rgbaim_warp_fast (L1_in, L1_out, L1_background, L2_4_dispi,
			      L2_7_dispj);
	}
      else
	{
	  C_rgbaim_warp (L1_in, L1_out, L1_background, L2_4_dispi,
			 L2_7_dispj);
	}
      Msrg_free (L2_3_0_srg);
      Msrg_free (L2_6_1_srg);
    }
    TRACE_POP ("C_rgbaim_warp_quad");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-resize
 */
extern_c struct idx *
C_rgbaim_resize (struct idx *L1_im, real L1_w, real L1_h, real L1_mode,
		 struct idx *L3_4_matrix, struct srg *L3_4_srg)
{
  TRACE_PUSH ("C_rgbaim_resize");
  {
    struct idx *L_Tmp0;
    Midx_declare (L2_1_0_rgbaim_subsample, 3);
    Msrg_declare (L2_2_1_rgbaim_subsample);
    Midx_declare (L2_3_2_rgbaim_subsample, 3);
    Msrg_declare (L2_4_3_rgbaim_subsample);
    Midx_init (L2_1_0_rgbaim_subsample, 3);
    Msrg_init (L2_2_1_rgbaim_subsample, ST_U8);
    Midx_init (L2_3_2_rgbaim_subsample, 3);
    Msrg_init (L2_4_3_rgbaim_subsample, ST_U8);
    {
      real L2_5_imw;
      real L2_6_imh;
      int L2_7_rw;
      int L2_8_rh;
      char L_Tmp9;
      char L_Tmp29;
      L2_5_imw = (L1_im)->dim[1];
      L2_6_imh = (L1_im)->dim[0];
      L2_7_rw = 0;
      L2_8_rh = 0;
      if ((0 == L1_w))
	{
	  L_Tmp9 = 1;
	}
      else
	{
	  if ((0 == L1_h))
	    {
	      L_Tmp9 = 1;
	    }
	  else
	    {
	      L_Tmp9 = 0;
	    }
	}
      if (L_Tmp9)
	{
	  if ((0 == L1_w))
	    {
	      if ((0 == L1_h))
		{
		  run_time_error
		    ("desired width and height cannot be both zero");
		}
	      else
		{
		  {
		    real L3_10_a;
		    real L3_11_b;
		    L3_10_a = 1;
		    L3_11_b = (L2_5_imw * (L1_h / (real) L2_6_imh));
		    L3_11_b = ((int) floor ((double) L3_11_b));
		    if ((L3_10_a > L3_11_b))
		      {
			L1_w = L3_10_a;
		      }
		    else
		      {
			L1_w = L3_11_b;
		      }
		  }
		}
	    }
	  else
	    {
	      {
		real L3_12_a;
		real L3_13_b;
		L3_12_a = 1;
		L3_13_b = (L2_6_imh * (L1_w / (real) L2_5_imw));
		L3_13_b = ((int) floor ((double) L3_13_b));
		if ((L3_12_a > L3_13_b))
		  {
		    L1_h = L3_12_a;
		  }
		else
		  {
		    L1_h = L3_13_b;
		  }
	      }
	    }
	}
      else
	{
	  if ((L1_mode == 0))
	    {
	      {
		real L3_14_r;
		{
		  real L4_15_a;
		  real L4_16_b;
		  L4_15_a = (L1_w / (real) L2_5_imw);
		  L4_16_b = (L1_h / (real) L2_6_imh);
		  if ((L4_15_a < L4_16_b))
		    {
		      L3_14_r = L4_15_a;
		    }
		  else
		    {
		      L3_14_r = L4_16_b;
		    }
		}
		{
		  real L4_17_a;
		  real L4_18_b;
		  L4_17_a = 1;
		  L4_18_b = (L3_14_r * L2_5_imw);
		  L4_18_b = ((int) floor ((double) L4_18_b));
		  if ((L4_17_a > L4_18_b))
		    {
		      L1_w = L4_17_a;
		    }
		  else
		    {
		      L1_w = L4_18_b;
		    }
		}
		{
		  real L4_19_a;
		  real L4_20_b;
		  L4_19_a = 1;
		  L4_20_b = (L3_14_r * L2_6_imh);
		  L4_20_b = ((int) floor ((double) L4_20_b));
		  if ((L4_19_a > L4_20_b))
		    {
		      L1_h = L4_19_a;
		    }
		  else
		    {
		      L1_h = L4_20_b;
		    }
		}
	      }
	    }
	  else
	    {
	      if ((L1_mode == 1))
		{
		  {
		    real L3_21_a;
		    real L3_22_b;
		    L3_21_a = 1;
		    L3_22_b = L1_w;
		    L3_22_b = ((int) floor ((double) L3_22_b));
		    if ((L3_21_a > L3_22_b))
		      {
			L1_w = L3_21_a;
		      }
		    else
		      {
			L1_w = L3_22_b;
		      }
		  }
		  {
		    real L3_23_a;
		    real L3_24_b;
		    L3_23_a = 1;
		    L3_24_b = L1_h;
		    L3_24_b = ((int) floor ((double) L3_24_b));
		    if ((L3_23_a > L3_24_b))
		      {
			L1_h = L3_23_a;
		      }
		    else
		      {
			L1_h = L3_24_b;
		      }
		  }
		}
	      else
		{
		  if ((L1_mode == 2))
		    {
		      {
			real L3_25_a;
			real L3_26_b;
			L3_25_a = 1;
			L3_26_b = (L1_w * L2_5_imw);
			L3_26_b = ((int) floor ((double) L3_26_b));
			if ((L3_25_a > L3_26_b))
			  {
			    L1_w = L3_25_a;
			  }
			else
			  {
			    L1_w = L3_26_b;
			  }
		      }
		      {
			real L3_27_a;
			real L3_28_b;
			L3_27_a = 1;
			L3_28_b = (L1_h * L2_6_imh);
			L3_28_b = ((int) floor ((double) L3_28_b));
			if ((L3_27_a > L3_28_b))
			  {
			    L1_h = L3_27_a;
			  }
			else
			  {
			    L1_h = L3_28_b;
			  }
		      }
		    }
		  else
		    {
		      if (1)
			{
			  run_time_error
			    ("illegal mode or desired dimensions");
			}
		      else
			{
			}
		    }
		}
	    }
	}
      L2_7_rw = (((int) L2_5_imw) / ((int) L1_w));
      L2_8_rh = (((int) L2_6_imh) / ((int) L1_h));
      if ((0 != L2_8_rh))
	{
	  L_Tmp29 = 1;
	}
      else
	{
	  if ((0 != L2_7_rw))
	    {
	      L_Tmp29 = 1;
	    }
	  else
	    {
	      L_Tmp29 = 0;
	    }
	}
      if (L_Tmp29)
	{
	  L1_im =
	    (struct idx *) C_rgbaim_subsample (L1_im, L2_8_rh, L2_7_rw,
					       L2_1_0_rgbaim_subsample,
					       L2_2_1_rgbaim_subsample,
					       L2_3_2_rgbaim_subsample,
					       L2_4_3_rgbaim_subsample);
	  L2_5_imw = (L1_im)->dim[1];
	  L2_6_imh = (L1_im)->dim[0];
	}
      {
	struct idx *L3_30_rez;
	Midx_declare (L3_31_5_matrix, 1);
	Msrg_declare (L3_32_5_srg);
	struct idx *L3_33_bg;
	flt L3_34_x1;
	flt L3_35_y1;
	flt L3_36_x3;
	flt L3_37_y3;
	flt L3_38_p1;
	flt L3_39_q1;
	flt L3_40_p3;
	flt L3_41_q3;
	Midx_init (L3_31_5_matrix, 1);
	Msrg_init (L3_32_5_srg, ST_U8);
	(L3_4_matrix)->srg = L3_4_srg;
	Midx_init_dim3 (L3_4_matrix, L1_h, L1_w, 4);
	RTERR_DIM (L3_4_matrix->dim[0] <= 0);
	RTERR_DIM (L3_4_matrix->dim[1] <= 0);
	RTERR_DIM (L3_4_matrix->dim[2] <= 0);
	Midx_maclear (L3_4_matrix, unsigned char);
	L3_30_rez = L3_4_matrix;
	(L3_31_5_matrix)->srg = L3_32_5_srg;
	Midx_init_dim1 (L3_31_5_matrix, 4);
	RTERR_DIM (L3_31_5_matrix->dim[0] <= 0);
	Midx_maclear (L3_31_5_matrix, unsigned char);
	L3_33_bg = L3_31_5_matrix;
	L3_34_x1 = -0.5;
	L3_35_y1 = -0.5;
	L3_36_x3 = (L2_5_imw - 0.5);
	L3_37_y3 = (L2_6_imh - 0.5);
	L3_38_p1 = -0.5;
	L3_39_q1 = -0.5;
	L3_40_p3 = (L1_w - 0.5);
	L3_41_q3 = (L1_h - 0.5);
	C_rgbaim_warp_quad (L1_im, L3_30_rez, L3_33_bg, 1, L3_34_x1, L3_35_y1,
			    L3_36_x3, L3_35_y1, L3_36_x3, L3_37_y3, L3_34_x1,
			    L3_37_y3, L3_38_p1, L3_39_q1, L3_40_p3, L3_41_q3);
	L_Tmp0 = L3_30_rez;
	Msrg_free (L3_32_5_srg);
      }
    }
    Msrg_free (L2_2_1_rgbaim_subsample);
    Msrg_free (L2_4_3_rgbaim_subsample);
    TRACE_POP ("C_rgbaim_resize");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-rotscale
 */
extern_c char
C_rgbaim_rotscale (struct idx *L1_src, flt L1_sx, flt L1_sy,
		   struct idx *L1_dst, flt L1_dx, flt L1_dy, flt L1_angle,
		   flt L1_coeff, struct idx *L1_bg)
{
  TRACE_PUSH ("C_rgbaim_rotscale");
  {
    char L_Tmp0;
    {
      real L2_1_q;
      real L2_2_coeff_inv;
      real L2_3_sa;
      real L2_4_ca;
      real L2_5_caPlussa;
      real L2_6_ca_sa;
      flt L2_7_x1;
      flt L2_8_y1;
      flt L2_9_x2;
      flt L2_10_y2;
      flt L2_11_x3;
      flt L2_12_y3;
      flt L2_13_x4;
      flt L2_14_y4;
      flt L2_15_p1;
      flt L2_16_q1;
      flt L2_17_p3;
      flt L2_18_q3;
      L2_1_q = 1000;
      L2_2_coeff_inv = (1 / (flt) L1_coeff);
      L2_3_sa = (L2_1_q * Fsin ((0.0175 * L1_angle)));
      L2_4_ca = (L2_1_q * Fcos ((0.0175 * L1_angle)));
      L2_5_caPlussa = (L2_2_coeff_inv * (L2_4_ca + L2_3_sa));
      L2_6_ca_sa = (L2_2_coeff_inv * (L2_4_ca - L2_3_sa));
      L2_7_x1 = (L1_sx - L2_5_caPlussa);
      L2_8_y1 = (L1_sy - L2_6_ca_sa);
      L2_9_x2 = (L1_sx + L2_6_ca_sa);
      L2_10_y2 = (L1_sy - L2_5_caPlussa);
      L2_11_x3 = (L1_sx + L2_5_caPlussa);
      L2_12_y3 = (L1_sy + L2_6_ca_sa);
      L2_13_x4 = (L1_sx - L2_6_ca_sa);
      L2_14_y4 = (L1_sy + L2_5_caPlussa);
      L2_15_p1 = (L1_dx - L2_1_q);
      L2_16_q1 = (L1_dy - L2_1_q);
      L2_17_p3 = (L1_dx + L2_1_q);
      L2_18_q3 = (L1_dy + L2_1_q);
      L_Tmp0 =
	(char) C_rgbaim_warp_quad (L1_src, L1_dst, L1_bg, 1, L2_7_x1, L2_8_y1,
				   L2_9_x2, L2_10_y2, L2_11_x3, L2_12_y3,
				   L2_13_x4, L2_14_y4, L2_15_p1, L2_16_q1,
				   L2_17_p3, L2_18_q3);
    }
    TRACE_POP ("C_rgbaim_rotscale");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-rotscale-rect
 */
extern_c char
C_rgbaim_rotscale_rect (int L1_w, int L1_h, flt L1_cx, flt L1_cy,
			flt L1_angle, flt L1_coeff, struct idx *L1_wh,
			struct idx *L1_cxcy)
{
  TRACE_PUSH ("C_rgbaim_rotscale_rect");
  {
    char L_Tmp0;
    {
      real L2_1_sa;
      real L2_2_ca;
      real L2_3_x1;
      real L2_4_y1;
      real L2_5_cw;
      real L2_6_ch;
      real L2_7_x2;
      real L2_8_y2;
      real L2_9_x4;
      real L2_10_y4;
      real L2_11_x3;
      real L2_12_y3;
      real L2_13_dcx;
      real L2_14_dcy;
      real L2_15_lx;
      real L2_16_ly;
      real L2_17_rx;
      real L2_18_ry;
      L2_1_sa = Fsin ((0.0175 * L1_angle));
      L2_2_ca = Fcos ((0.0175 * L1_angle));
      L2_3_x1 = 0;
      L2_4_y1 = 0;
      L2_5_cw = (L1_coeff * L1_w);
      L2_6_ch = (L1_coeff * L1_h);
      L2_7_x2 = (L2_5_cw * L2_2_ca);
      L2_8_y2 = (L2_5_cw * L2_1_sa);
      L2_9_x4 = (-(L2_6_ch * L2_1_sa));
      L2_10_y4 = (L2_6_ch * L2_2_ca);
      L2_11_x3 = (L2_7_x2 + L2_9_x4);
      L2_12_y3 = (L2_8_y2 + L2_10_y4);
      L2_13_dcx = (L1_coeff * ((L1_cx * L2_2_ca) - (L1_cy * L2_1_sa)));
      L2_14_dcy = (L1_coeff * ((L1_cx * L2_1_sa) + (L1_cy * L2_2_ca)));
      {
	real L3_19_a;
	real L3_20_b;
	{
	  if ((L2_3_x1 < L2_7_x2))
	    {
	      L3_19_a = L2_3_x1;
	    }
	  else
	    {
	      L3_19_a = L2_7_x2;
	    }
	}
	{
	  if ((L2_11_x3 < L2_9_x4))
	    {
	      L3_20_b = L2_11_x3;
	    }
	  else
	    {
	      L3_20_b = L2_9_x4;
	    }
	}
	if ((L3_19_a < L3_20_b))
	  {
	    L2_15_lx = L3_19_a;
	  }
	else
	  {
	    L2_15_lx = L3_20_b;
	  }
      }
      {
	real L3_21_a;
	real L3_22_b;
	{
	  if ((L2_4_y1 < L2_8_y2))
	    {
	      L3_21_a = L2_4_y1;
	    }
	  else
	    {
	      L3_21_a = L2_8_y2;
	    }
	}
	{
	  if ((L2_12_y3 < L2_10_y4))
	    {
	      L3_22_b = L2_12_y3;
	    }
	  else
	    {
	      L3_22_b = L2_10_y4;
	    }
	}
	if ((L3_21_a < L3_22_b))
	  {
	    L2_16_ly = L3_21_a;
	  }
	else
	  {
	    L2_16_ly = L3_22_b;
	  }
      }
      {
	real L3_23_a;
	real L3_24_b;
	{
	  if ((L2_3_x1 > L2_7_x2))
	    {
	      L3_23_a = L2_3_x1;
	    }
	  else
	    {
	      L3_23_a = L2_7_x2;
	    }
	}
	{
	  if ((L2_11_x3 > L2_9_x4))
	    {
	      L3_24_b = L2_11_x3;
	    }
	  else
	    {
	      L3_24_b = L2_9_x4;
	    }
	}
	if ((L3_23_a > L3_24_b))
	  {
	    L2_17_rx = L3_23_a;
	  }
	else
	  {
	    L2_17_rx = L3_24_b;
	  }
      }
      {
	real L3_25_a;
	real L3_26_b;
	{
	  if ((L2_4_y1 > L2_8_y2))
	    {
	      L3_25_a = L2_4_y1;
	    }
	  else
	    {
	      L3_25_a = L2_8_y2;
	    }
	}
	{
	  if ((L2_12_y3 > L2_10_y4))
	    {
	      L3_26_b = L2_12_y3;
	    }
	  else
	    {
	      L3_26_b = L2_10_y4;
	    }
	}
	if ((L3_25_a > L3_26_b))
	  {
	    L2_18_ry = L3_25_a;
	  }
	else
	  {
	    L2_18_ry = L3_26_b;
	  }
      }
      RTERR_BOUND (0 >= (L1_wh)->dim[0]);
      IDX_PTR (L1_wh, int)[(L1_wh)->mod[0] * ((int) 0)] =
	((int) floor ((double) (((L2_17_rx - L2_15_lx)) + 1)));
      RTERR_BOUND (1 >= (L1_wh)->dim[0]);
      IDX_PTR (L1_wh, int)[(L1_wh)->mod[0] * ((int) 1)] =
	((int) floor ((double) (((L2_18_ry - L2_16_ly)) + 1)));
      RTERR_BOUND (0 >= (L1_cxcy)->dim[0]);
      IDX_PTR (L1_cxcy, flt)[(L1_cxcy)->mod[0] * ((int) 0)] =
	(L2_13_dcx - L2_15_lx);
      RTERR_BOUND (1 >= (L1_cxcy)->dim[0]);
      IDX_PTR (L1_cxcy, flt)[(L1_cxcy)->mod[0] * ((int) 1)] =
	(L2_14_dcy - L2_16_ly);
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_rgbaim_rotscale_rect");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-contbright
 */
extern_c char
C_rgbaim_contbright (struct idx *L1_in, struct idx *L1_out, flt L1_c,
		     flt L1_b)
{
  TRACE_PUSH ("C_rgbaim_contbright");
  {
    {
      int _i_max = (L1_in)->dim[0];
      int _L1_in_mod0 = (L1_in)->mod[0];
      int _L1_out_mod0 = (L1_out)->mod[0];
      int _j_max = (L1_in)->dim[1];
      int _L1_in_mod1 = (L1_in)->mod[1];
      int _L1_out_mod1 = (L1_out)->mod[1];
      int _k_max = (L1_in)->dim[2];
      int _L1_in_mod2 = (L1_in)->mod[2];
      int _L1_out_mod2 = (L1_out)->mod[2];
      if (_i_max != (L1_out)->dim[0])
	run_time_error ("idx L1_out's dim 0 doesn't match idx L1_in's dim 0");
      if (_j_max != (L1_out)->dim[1])
	run_time_error ("idx L1_out's dim 1 doesn't match idx L1_in's dim 1");
      if (_k_max != (L1_out)->dim[2])
	run_time_error ("idx L1_out's dim 2 doesn't match idx L1_in's dim 2");
      {
	int i;
	unsigned char *_L1_in_loop_i = IDX_PTR ((L1_in), unsigned char);
	unsigned char *_L1_out_loop_i = IDX_PTR ((L1_out), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    unsigned char *_L1_in_loop_j = _L1_in_loop_i;
	    unsigned char *_L1_out_loop_j = _L1_out_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		int k;
		unsigned char *pin = _L1_in_loop_j;
		unsigned char *pout = _L1_out_loop_j;
		for (k = 0; k < _k_max; k++)
		  {
		    {
		      register float z;
		      z = (((float) *pin) - 128) * (L1_c) + (L1_b) + 128;
		      *pout =
			(unsigned char) ((z < 0) ? 0 : ((z > 255) ? 255 : z));
		    }
		    pin += _L1_in_mod2;
		    pout += _L1_out_mod2;
		  }
		_L1_in_loop_j += _L1_in_mod1;
		_L1_out_loop_j += _L1_out_mod1;
	      }
	    _L1_in_loop_i += _L1_in_mod0;
	    _L1_out_loop_i += _L1_out_mod0;
	  }
    }}
    TRACE_POP ("C_rgbaim_contbright");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-luminance
 */
extern_c char
C_rgbaim_luminance (struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_rgbaim_luminance");
  {
    {
      register unsigned char *_idx2loopc1, *pin;
      register unsigned char *_idx2loopc2, *pout;
      register int i, _imax = (L1_in)->dim[0];
      register int j, _jmax = (L1_in)->dim[1];
      register int _imat1_m0 = (L1_in)->mod[0];
      register int _imat1_m1 = (L1_in)->mod[1];
      register int _imat2_m0 = (L1_out)->mod[0];
      register int _imat2_m1 = (L1_out)->mod[1];
      _idx2loopc1 = IDX_PTR ((L1_in), unsigned char);
      _idx2loopc2 = IDX_PTR ((L1_out), unsigned char);
      for (i = 0; i < _imax; i++)
	{;
	  pin = _idx2loopc1;
	  pout = _idx2loopc2;
	  for (j = 0; j < _jmax; j++)
	    {;
	      *pout = (unsigned char) (0.299 * (flt) (pin[0]) +
				       0.587 * (flt) (pin[1]) +
				       0.114 * (flt) (pin[2]));
	      pin += _imat1_m1;
	      pout += _imat2_m1;
	    }
	  _idx2loopc1 += _imat1_m0;
	  _idx2loopc2 += _imat2_m0;
    }}
    TRACE_POP ("C_rgbaim_luminance");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-lum2rgba
 */
extern_c char
C_rgbaim_lum2rgba (struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_rgbaim_lum2rgba");
  {
    {
      register unsigned char *_idx2loopc1, *pin;
      register unsigned char *_idx2loopc2, *pout;
      register int i, _imax = (L1_in)->dim[0];
      register int j, _jmax = (L1_in)->dim[1];
      register int _imat1_m0 = (L1_in)->mod[0];
      register int _imat1_m1 = (L1_in)->mod[1];
      register int _imat2_m0 = (L1_out)->mod[0];
      register int _imat2_m1 = (L1_out)->mod[1];
      _idx2loopc1 = IDX_PTR ((L1_in), unsigned char);
      _idx2loopc2 = IDX_PTR ((L1_out), unsigned char);
      for (i = 0; i < _imax; i++)
	{;
	  pin = _idx2loopc1;
	  pout = _idx2loopc2;
	  for (j = 0; j < _jmax; j++)
	    {;
	      pout[0] = pout[1] = pout[2] = *pin;
	      pout[3] = 0;
	      pin += _imat1_m1;
	      pout += _imat2_m1;
	    }
	  _idx2loopc1 += _imat1_m0;
	  _idx2loopc2 += _imat2_m0;
	}
    }
    TRACE_POP ("C_rgbaim_lum2rgba");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-uvw
 */
extern_c char
C_rgbaim_uvw (struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_rgbaim_uvw");
  {
    {
      register unsigned char *_idx2loopc1, *pin;
      register unsigned char *_idx2loopc2, *pout;
      register int i, _imax = (L1_in)->dim[0];
      register int j, _jmax = (L1_in)->dim[1];
      register int _imat1_m0 = (L1_in)->mod[0];
      register int _imat1_m1 = (L1_in)->mod[1];
      register int _imat2_m0 = (L1_out)->mod[0];
      register int _imat2_m1 = (L1_out)->mod[1];
      _idx2loopc1 = IDX_PTR ((L1_in), unsigned char);
      _idx2loopc2 = IDX_PTR ((L1_out), unsigned char);
      for (i = 0; i < _imax; i++)
	{;
	  pin = _idx2loopc1;
	  pout = _idx2loopc2;
	  for (j = 0; j < _jmax; j++)
	    {;
	      {
		flt r, g, b;
		r = (flt) (pin[0]);
		g = (flt) (pin[1]);
		b = (flt) (pin[2]);
		pout[0] = (unsigned char) (0.405 * r + 0.116 * g + 0.133 * b);
		pout[1] = (unsigned char) (0.299 * r + 0.587 * g + 0.114 * b);
		pout[2] = (unsigned char) (0.145 * r + 0.827 * g + 0.627 * b);
		pout[3] = pin[3];
	      }
	      pin += _imat1_m1;
	      pout += _imat2_m1;
	    }
	  _idx2loopc1 += _imat1_m0;
	  _idx2loopc2 += _imat2_m0;
    }}
    TRACE_POP ("C_rgbaim_uvw");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-saturate
 */
extern_c char
C_rgbaim_saturate (struct idx *L1_in, unsigned char L1_min,
		   unsigned char L1_max, struct idx *L1_out)
{
  TRACE_PUSH ("C_rgbaim_saturate");
  {
    {
      register unsigned char *_idx2loopc1, *pin;
      register unsigned char *_idx2loopc2, *pout;
      register int i, _imax = (L1_in)->dim[0];
      register int j, _jmax = (L1_in)->dim[1];
      register int _imat1_m0 = (L1_in)->mod[0];
      register int _imat1_m1 = (L1_in)->mod[1];
      register int _imat2_m0 = (L1_out)->mod[0];
      register int _imat2_m1 = (L1_out)->mod[1];
      _idx2loopc1 = IDX_PTR ((L1_in), unsigned char);
      _idx2loopc2 = IDX_PTR ((L1_out), unsigned char);
      for (i = 0; i < _imax; i++)
	{;
	  pin = _idx2loopc1;
	  pout = _idx2loopc2;
	  for (j = 0; j < _jmax; j++)
	    {;
	      {
		register unsigned char r;
		r = pin[0];
		pout[0] =
		  (r > (L1_max)) ? (L1_max) : (r < (L1_min)) ? (L1_min) : r;
		r = pin[1];
		pout[1] =
		  (r > (L1_max)) ? (L1_max) : (r < (L1_min)) ? (L1_min) : r;
		r = pin[2];
		pout[2] =
		  (r > (L1_max)) ? (L1_max) : (r < (L1_min)) ? (L1_min) : r;
		r = pin[3];
		pout[3] =
		  (r > (L1_max)) ? (L1_max) : (r < (L1_min)) ? (L1_min) : r;
	      }
	      pin += _imat1_m1;
	      pout += _imat2_m1;
	    }
	  _idx2loopc1 += _imat1_m0;
	  _idx2loopc2 += _imat2_m0;
    }}
    TRACE_POP ("C_rgbaim_saturate");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-blit
 */
extern_c char
C_rgbaim_blit (int L1_x, int L1_y, struct idx *L1_in, struct idx *L1_out)
{
  TRACE_PUSH ("C_rgbaim_blit");
  {
    char L_Tmp0;
    {
      int L2_1_hin;
      int L2_2_win;
      int L2_3_hout;
      int L2_4_wout;
      int L2_5_lx;
      int L2_6_ly;
      int L2_7_ux;
      int L2_8_uy;
      Midx_declare (L3_9_1_clone, 3);
      struct idx *L2_10_dest;
      Midx_declare (L3_11_3_clone, 3);
      struct idx *L2_12_src;
      Midx_init (L3_9_1_clone, 3);
      Midx_init (L3_11_3_clone, 3);
      L2_1_hin = (L1_in)->dim[0];
      L2_2_win = (L1_in)->dim[1];
      L2_3_hout = (L1_out)->dim[0];
      L2_4_wout = (L1_out)->dim[1];
      if ((L1_y < 0))
	{
	  L2_5_lx = 0;
	}
      else
	{
	  L2_5_lx = L1_y;
	}
      if ((L1_x < 0))
	{
	  L2_6_ly = 0;
	}
      else
	{
	  L2_6_ly = L1_x;
	}
      if (((L1_x + L2_2_win) > L2_4_wout))
	{
	  L2_7_ux = L2_4_wout;
	}
      else
	{
	  L2_7_ux = (L1_x + L2_2_win);
	}
      if (((L1_y + L2_1_hin) > L2_3_hout))
	{
	  L2_8_uy = L2_3_hout;
	}
      else
	{
	  L2_8_uy = (L1_y + L2_1_hin);
	}
      {
	Midx_declare (L4_13_0_clone, 3);
	struct idx *L3_14___m;
	struct idx *L_Tmp15;
	real L_Tmp18;
	Midx_init (L4_13_0_clone, 3);
	{
	  struct idx *L4_16___m;
	  real L_Tmp17;
	  Midx_clone3 (L4_13_0_clone, L1_out);
	  L4_16___m = L4_13_0_clone;
	  L_Tmp17 = (L2_8_uy - L2_6_ly);
	  RTERR_GEN ((((int) L_Tmp17) < 1
		      || ((int) L2_6_ly) < 0), "illegal 'size' or 'offset'");
	  RTERR_GEN ((((int) L2_6_ly) + ((int) L_Tmp17) >
		      (L4_16___m)->dim[((int) 0)]),
		     "specified interval is too large");
	  Midx_narrow (L4_16___m, ((int) 0), ((int) L_Tmp17), ((int) L2_6_ly),
		       unsigned char);
	  L_Tmp15 = L4_16___m;
	}
	Midx_clone3 (L3_9_1_clone, L_Tmp15);
	L3_14___m = L3_9_1_clone;
	L_Tmp18 = (L2_7_ux - L2_5_lx);
	RTERR_GEN ((((int) L_Tmp18) < 1
		    || ((int) L2_5_lx) < 0), "illegal 'size' or 'offset'");
	RTERR_GEN ((((int) L2_5_lx) + ((int) L_Tmp18) >
		    (L3_14___m)->dim[((int) 1)]),
		   "specified interval is too large");
	Midx_narrow (L3_14___m, ((int) 1), ((int) L_Tmp18), ((int) L2_5_lx),
		     unsigned char);
	L2_10_dest = L3_14___m;
      }
      {
	Midx_declare (L4_19_2_clone, 3);
	struct idx *L3_20___m;
	struct idx *L_Tmp21;
	real L_Tmp25;
	real L_Tmp26;
	Midx_init (L4_19_2_clone, 3);
	{
	  struct idx *L4_22___m;
	  real L_Tmp23;
	  real L_Tmp24;
	  Midx_clone3 (L4_19_2_clone, L1_in);
	  L4_22___m = L4_19_2_clone;
	  L_Tmp23 = (L2_8_uy - L2_6_ly);
	  L_Tmp24 = (L2_6_ly - L1_y);
	  RTERR_GEN ((((int) L_Tmp23) < 1
		      || ((int) L_Tmp24) < 0), "illegal 'size' or 'offset'");
	  RTERR_GEN ((((int) L_Tmp24) + ((int) L_Tmp23) >
		      (L4_22___m)->dim[((int) 0)]),
		     "specified interval is too large");
	  Midx_narrow (L4_22___m, ((int) 0), ((int) L_Tmp23), ((int) L_Tmp24),
		       unsigned char);
	  L_Tmp21 = L4_22___m;
	}
	Midx_clone3 (L3_11_3_clone, L_Tmp21);
	L3_20___m = L3_11_3_clone;
	L_Tmp25 = (L2_7_ux - L2_5_lx);
	L_Tmp26 = (L2_5_lx - L1_x);
	RTERR_GEN ((((int) L_Tmp25) < 1
		    || ((int) L_Tmp26) < 0), "illegal 'size' or 'offset'");
	RTERR_GEN ((((int) L_Tmp26) + ((int) L_Tmp25) >
		    (L3_20___m)->dim[((int) 1)]),
		   "specified interval is too large");
	Midx_narrow (L3_20___m, ((int) 1), ((int) L_Tmp25), ((int) L_Tmp26),
		     unsigned char);
	L2_12_src = L3_20___m;
      }
      {
	register unsigned char *_idx2loopc1, *pin;
	register unsigned char *_idx2loopc2, *pout;
	register int i, _imax = (L2_12_src)->dim[0];
	register int j, _jmax = (L2_12_src)->dim[1];
	register int _imat1_m0 = (L2_12_src)->mod[0];
	register int _imat1_m1 = (L2_12_src)->mod[1];
	register int _imat2_m0 = (L2_10_dest)->mod[0];
	register int _imat2_m1 = (L2_10_dest)->mod[1];
	_idx2loopc1 = IDX_PTR ((L2_12_src), unsigned char);
	_idx2loopc2 = IDX_PTR ((L2_10_dest), unsigned char);
	for (i = 0; i < _imax; i++)
	  {;
	    pin = _idx2loopc1;
	    pout = _idx2loopc2;
	    for (j = 0; j < _jmax; j++)
	      {;
		{
		  register int r, r1;
		  r = pin[3];
		  r1 = 255 - r;
		  pout[0] =
		    (unsigned char) ((r * pout[0] + r1 * pin[0]) >> 8);
		  pout[1] =
		    (unsigned char) ((r * pout[1] + r1 * pin[1]) >> 8);
		  pout[2] =
		    (unsigned char) ((r * pout[2] + r1 * pin[2]) >> 8);
		}
		pin += _imat1_m1;
		pout += _imat2_m1;
	      }
	    _idx2loopc1 += _imat1_m0;
	    _idx2loopc2 += _imat2_m0;
      }}
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_rgbaim_blit");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-blitcolor
 */
extern_c char
C_rgbaim_blitcolor (int L1_x, int L1_y, struct idx *L1_in, unsigned char L1_r,
		    unsigned char L1_g, unsigned char L1_b,
		    struct idx *L1_out)
{
  TRACE_PUSH ("C_rgbaim_blitcolor");
  {
    char L_Tmp0;
    {
      int L2_1_hin;
      int L2_2_win;
      int L2_3_hout;
      int L2_4_wout;
      int L2_5_lx;
      int L2_6_ly;
      int L2_7_ux;
      int L2_8_uy;
      Midx_declare (L3_9_1_clone, 3);
      struct idx *L2_10_dest;
      Midx_declare (L3_11_3_clone, 2);
      struct idx *L2_12_src;
      Midx_init (L3_9_1_clone, 3);
      Midx_init (L3_11_3_clone, 2);
      L2_1_hin = (L1_in)->dim[0];
      L2_2_win = (L1_in)->dim[1];
      L2_3_hout = (L1_out)->dim[0];
      L2_4_wout = (L1_out)->dim[1];
      if ((L1_y < 0))
	{
	  L2_5_lx = 0;
	}
      else
	{
	  L2_5_lx = L1_y;
	}
      if ((L1_x < 0))
	{
	  L2_6_ly = 0;
	}
      else
	{
	  L2_6_ly = L1_x;
	}
      if (((L1_x + L2_2_win) > L2_4_wout))
	{
	  L2_7_ux = L2_4_wout;
	}
      else
	{
	  L2_7_ux = (L1_x + L2_2_win);
	}
      if (((L1_y + L2_1_hin) > L2_3_hout))
	{
	  L2_8_uy = L2_3_hout;
	}
      else
	{
	  L2_8_uy = (L1_y + L2_1_hin);
	}
      {
	Midx_declare (L4_13_0_clone, 3);
	struct idx *L3_14___m;
	struct idx *L_Tmp15;
	real L_Tmp18;
	Midx_init (L4_13_0_clone, 3);
	{
	  struct idx *L4_16___m;
	  real L_Tmp17;
	  Midx_clone3 (L4_13_0_clone, L1_out);
	  L4_16___m = L4_13_0_clone;
	  L_Tmp17 = (L2_8_uy - L2_6_ly);
	  RTERR_GEN ((((int) L_Tmp17) < 1
		      || ((int) L2_6_ly) < 0), "illegal 'size' or 'offset'");
	  RTERR_GEN ((((int) L2_6_ly) + ((int) L_Tmp17) >
		      (L4_16___m)->dim[((int) 0)]),
		     "specified interval is too large");
	  Midx_narrow (L4_16___m, ((int) 0), ((int) L_Tmp17), ((int) L2_6_ly),
		       unsigned char);
	  L_Tmp15 = L4_16___m;
	}
	Midx_clone3 (L3_9_1_clone, L_Tmp15);
	L3_14___m = L3_9_1_clone;
	L_Tmp18 = (L2_7_ux - L2_5_lx);
	RTERR_GEN ((((int) L_Tmp18) < 1
		    || ((int) L2_5_lx) < 0), "illegal 'size' or 'offset'");
	RTERR_GEN ((((int) L2_5_lx) + ((int) L_Tmp18) >
		    (L3_14___m)->dim[((int) 1)]),
		   "specified interval is too large");
	Midx_narrow (L3_14___m, ((int) 1), ((int) L_Tmp18), ((int) L2_5_lx),
		     unsigned char);
	L2_10_dest = L3_14___m;
      }
      {
	Midx_declare (L4_19_2_clone, 2);
	struct idx *L3_20___m;
	struct idx *L_Tmp21;
	real L_Tmp25;
	real L_Tmp26;
	Midx_init (L4_19_2_clone, 2);
	{
	  struct idx *L4_22___m;
	  real L_Tmp23;
	  real L_Tmp24;
	  Midx_clone2 (L4_19_2_clone, L1_in);
	  L4_22___m = L4_19_2_clone;
	  L_Tmp23 = (L2_8_uy - L2_6_ly);
	  L_Tmp24 = (L2_6_ly - L1_y);
	  RTERR_GEN ((((int) L_Tmp23) < 1
		      || ((int) L_Tmp24) < 0), "illegal 'size' or 'offset'");
	  RTERR_GEN ((((int) L_Tmp24) + ((int) L_Tmp23) >
		      (L4_22___m)->dim[((int) 0)]),
		     "specified interval is too large");
	  Midx_narrow (L4_22___m, ((int) 0), ((int) L_Tmp23), ((int) L_Tmp24),
		       unsigned char);
	  L_Tmp21 = L4_22___m;
	}
	Midx_clone2 (L3_11_3_clone, L_Tmp21);
	L3_20___m = L3_11_3_clone;
	L_Tmp25 = (L2_7_ux - L2_5_lx);
	L_Tmp26 = (L2_5_lx - L1_x);
	RTERR_GEN ((((int) L_Tmp25) < 1
		    || ((int) L_Tmp26) < 0), "illegal 'size' or 'offset'");
	RTERR_GEN ((((int) L_Tmp26) + ((int) L_Tmp25) >
		    (L3_20___m)->dim[((int) 1)]),
		   "specified interval is too large");
	Midx_narrow (L3_20___m, ((int) 1), ((int) L_Tmp25), ((int) L_Tmp26),
		     unsigned char);
	L2_12_src = L3_20___m;
      }
      {
	register unsigned char *_idx2loopc1, *pin;
	register unsigned char *_idx2loopc2, *pout;
	register int i, _imax = (L2_12_src)->dim[0];
	register int j, _jmax = (L2_12_src)->dim[1];
	register int _imat1_m0 = (L2_12_src)->mod[0];
	register int _imat1_m1 = (L2_12_src)->mod[1];
	register int _imat2_m0 = (L2_10_dest)->mod[0];
	register int _imat2_m1 = (L2_10_dest)->mod[1];
	_idx2loopc1 = IDX_PTR ((L2_12_src), unsigned char);
	_idx2loopc2 = IDX_PTR ((L2_10_dest), unsigned char);
	for (i = 0; i < _imax; i++)
	  {;
	    pin = _idx2loopc1;
	    pout = _idx2loopc2;
	    for (j = 0; j < _jmax; j++)
	      {;
		{
		  register int v, v1;
		  v = (*pin);
		  v1 = 255 - v;
		  pout[0] =
		    (unsigned char) ((v * pout[0] + v1 * (L1_r)) >> 8);
		  pout[1] =
		    (unsigned char) ((v * pout[1] + v1 * (L1_g)) >> 8);
		  pout[2] =
		    (unsigned char) ((v * pout[2] + v1 * (L1_b)) >> 8);
		}
		pin += _imat1_m1;
		pout += _imat2_m1;
	      }
	    _idx2loopc1 += _imat1_m0;
	    _idx2loopc2 += _imat2_m0;
      }}
      L_Tmp0 = 0;
    }
    TRACE_POP ("C_rgbaim_blitcolor");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-init-lum2rgb
 */
extern_c char
C_rgbaim_init_lum2rgb ()
{
  TRACE_PUSH ("C_rgbaim_init_lum2rgb");
  {
    char L_Tmp0;
    {
      Midx_declare (L2_1_0_matrix, 1);
      Msrg_declare (L2_2_0_srg);
      struct idx *L2_3_lum;
      Midx_declare (L2_4_1_matrix, 1);
      Msrg_declare (L2_5_1_srg);
      struct idx *L2_6_ind;
      int L2_7_n;
      Midx_init (L2_1_0_matrix, 1);
      Msrg_init (L2_2_0_srg, ST_F);
      Midx_init (L2_4_1_matrix, 1);
      Msrg_init (L2_5_1_srg, ST_I32);
      (L2_1_0_matrix)->srg = L2_2_0_srg;
      Midx_init_dim1 (L2_1_0_matrix, (32 * 32 * 32));
      RTERR_DIM (L2_1_0_matrix->dim[0] <= 0);
      Midx_maclear (L2_1_0_matrix, flt);
      L2_3_lum = L2_1_0_matrix;
      (L2_4_1_matrix)->srg = L2_5_1_srg;
      Midx_init_dim1 (L2_4_1_matrix, (32 * 32 * 32));
      RTERR_DIM (L2_4_1_matrix->dim[0] <= 0);
      Midx_maclear (L2_4_1_matrix, int);
      L2_6_ind = L2_4_1_matrix;
      L2_7_n = 0;
      {
	real L3_8_r;
	L3_8_r = 0;
	for (; ((1 > 0) ? (L3_8_r <= 31) : (L3_8_r >= 31)); (L3_8_r) += 1)
	  {
	    {
	      real L4_9_g;
	      L4_9_g = 0;
	      for (;
		   ((1 > 0) ? (L4_9_g <= 31) : (L4_9_g >= 31)); (L4_9_g) += 1)
		{
		  {
		    real L5_10_b;
		    L5_10_b = 0;
		    for (;
			 ((1 > 0) ? (L5_10_b <= 31) : (L5_10_b >= 31));
			 (L5_10_b) += 1)
		      {
			RTERR_BOUND (L2_7_n < 0
				     || L2_7_n >= (L2_6_ind)->dim[0]);
			IDX_PTR (L2_6_ind,
				 int)[(L2_6_ind)->mod[0] * ((int) L2_7_n)] =
			  L2_7_n;
			RTERR_BOUND (L2_7_n < 0
				     || L2_7_n >= (L2_3_lum)->dim[0]);
			IDX_PTR (L2_3_lum,
				 flt)[(L2_3_lum)->mod[0] * ((int) L2_7_n)] =
			  ((0.299 * L3_8_r) + (0.587 * L4_9_g) +
			   (0.114 * L5_10_b));
			L2_7_n = (L2_7_n + 1);
		      }
		  }
		}
	    }
	  }
      }
      C_idx_f1i1sortup (L2_3_lum, L2_6_ind);
      {
	int *pind, i;
	pind = IDX_PTR ((L2_6_ind), int);
	for (i = 0; i < NCOLCELL; i++)
	  {
	    lum2rgb[i] = pind[i];
	  }
	lum2rgbinit = 1;
      }
      L_Tmp0 = 0;
      Msrg_free (L2_2_0_srg);
      Msrg_free (L2_5_1_srg);
    }
    TRACE_POP ("C_rgbaim_init_lum2rgb");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-lum2rgb
 */
extern_c int
C_rgbaim_lum2rgb (int L1_n)
{
  TRACE_PUSH ("C_rgbaim_lum2rgb");
  {
    int L_Tmp0;
    L_Tmp0 = lum2rgb[(int) (L1_n)];
    L_Tmp0 = ((int) floor ((double) L_Tmp0));
    TRACE_POP ("C_rgbaim_lum2rgb");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-histo32
 */
extern_c char
C_rgbaim_histo32 (struct idx *L1_rgbaim, struct idx *L1_ppal,
		  struct idx *L1_count)
{
  TRACE_PUSH ("C_rgbaim_histo32");
  {
    char L_Tmp0;
    {
      real L2_1_ncolcell;
      Midx_declare (L2_2_0_matrix, 2);
      Msrg_declare (L2_3_0_srg);
      struct idx *L2_4_histo;
      Midx_declare (L2_5_1_matrix, 1);
      Msrg_declare (L2_6_1_srg);
      struct idx *L2_7_hcount;
      gptr L2_8_phisto;
      gptr L2_9_phcount;
      Midx_init (L2_2_0_matrix, 2);
      Msrg_init (L2_3_0_srg, ST_F);
      Midx_init (L2_5_1_matrix, 1);
      Msrg_init (L2_6_1_srg, ST_F);
      L2_1_ncolcell = (32 * 32 * 32);
      (L2_2_0_matrix)->srg = L2_3_0_srg;
      Midx_init_dim2 (L2_2_0_matrix, L2_1_ncolcell, 3);
      RTERR_DIM (L2_2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_2_0_matrix->dim[1] <= 0);
      Midx_maclear (L2_2_0_matrix, flt);
      L2_4_histo = L2_2_0_matrix;
      (L2_5_1_matrix)->srg = L2_6_1_srg;
      Midx_init_dim1 (L2_5_1_matrix, L2_1_ncolcell);
      RTERR_DIM (L2_5_1_matrix->dim[0] <= 0);
      Midx_maclear (L2_5_1_matrix, flt);
      L2_7_hcount = L2_5_1_matrix;
      L2_8_phisto = (gptr) (IDX_PTR ((L2_4_histo), flt));
      L2_9_phcount = (gptr) (IDX_PTR ((L2_7_hcount), flt));
      {
	register unsigned char *_idx2loopc, *p;
	register int i, _imax = (L1_rgbaim)->dim[0];
	register int j, _jmax = (L1_rgbaim)->dim[1];
	register int _imat1_m0 = (L1_rgbaim)->mod[0];
	register int _imat1_m1 = (L1_rgbaim)->mod[1];
	_idx2loopc = IDX_PTR ((L1_rgbaim), unsigned char);
	for (i = 0; i < _imax; i++)
	  {;
	    p = _idx2loopc;
	    for (j = 0; j < _jmax; j++)
	      {;
		{
		  register flt *ph, *pc;
		  int offset;
		  offset =
		    ((p[0] & 0xf8) << 7) | ((p[1] & 0xf8) << 2) | (p[2] >> 3);
		  ph = ((flt *) (L2_8_phisto)) + offset * 3;
		  pc = ((flt *) (L2_9_phcount)) + offset;
		  /* printf("i=%d, j=%d, offset=%d, *pc=%g, ph[]=%g, %g, %g\n",
		     i,j,offset,*pc,ph[0],ph[1],ph[2]); */
		  ph[0] += (flt) p[0];
		  ph[1] += (flt) p[1];
		  ph[2] += (flt) p[2];
		  *pc += 1;
		}
		p += _imat1_m1;
	      }
	    _idx2loopc += _imat1_m0;
      }}
      if ((0 == ((int) floor ((double) lum2rgbinit))))
	{
	  C_rgbaim_init_lum2rgb ();
	}
      {
	int L3_10_ccount;
	L3_10_ccount = 0;
	{
	  int L4_11_i;
	  real L_Tmp12;
	  L_Tmp12 = ((L2_1_ncolcell) - 1);
	  L4_11_i = 0;
	  for (;
	       ((1 > 0) ? (L4_11_i <= L_Tmp12) : (L4_11_i >= L_Tmp12));
	       (L4_11_i) += 1)
	    {
	      {
		int L5_13_c;
		L5_13_c = (int) C_rgbaim_lum2rgb (L4_11_i);
		{
		  flt L6_14_cnt;
		  RTERR_BOUND (L5_13_c < 0
			       || L5_13_c >= (L2_7_hcount)->dim[0]);
		  L6_14_cnt =
		    IDX_PTR (L2_7_hcount,
			     flt)[(L2_7_hcount)->mod[0] * ((int) L5_13_c)];
		  if ((L6_14_cnt > 0))
		    {
		      RTERR_BOUND (L3_10_ccount < 0
				   || L3_10_ccount >= (L1_ppal)->dim[0]);
		      RTERR_BOUND (0 >= (L1_ppal)->dim[1]);
		      RTERR_BOUND (L5_13_c < 0
				   || L5_13_c >= (L2_4_histo)->dim[0]);
		      RTERR_BOUND (0 >= (L2_4_histo)->dim[1]);
		      IDX_PTR (L1_ppal,
			       flt)[(L1_ppal)->mod[0] * ((int) L3_10_ccount) +
				    (L1_ppal)->mod[1] * ((int) 0)] =
			(IDX_PTR (L2_4_histo, flt)
			 [(L2_4_histo)->mod[0] * ((int) L5_13_c) +
			  (L2_4_histo)->mod[1] * ((int) 0)] /
			 (flt) L6_14_cnt);
		      RTERR_BOUND (L3_10_ccount < 0
				   || L3_10_ccount >= (L1_ppal)->dim[0]);
		      RTERR_BOUND (1 >= (L1_ppal)->dim[1]);
		      RTERR_BOUND (L5_13_c < 0
				   || L5_13_c >= (L2_4_histo)->dim[0]);
		      RTERR_BOUND (1 >= (L2_4_histo)->dim[1]);
		      IDX_PTR (L1_ppal,
			       flt)[(L1_ppal)->mod[0] * ((int) L3_10_ccount) +
				    (L1_ppal)->mod[1] * ((int) 1)] =
			(IDX_PTR (L2_4_histo, flt)
			 [(L2_4_histo)->mod[0] * ((int) L5_13_c) +
			  (L2_4_histo)->mod[1] * ((int) 1)] /
			 (flt) L6_14_cnt);
		      RTERR_BOUND (L3_10_ccount < 0
				   || L3_10_ccount >= (L1_ppal)->dim[0]);
		      RTERR_BOUND (2 >= (L1_ppal)->dim[1]);
		      RTERR_BOUND (L5_13_c < 0
				   || L5_13_c >= (L2_4_histo)->dim[0]);
		      RTERR_BOUND (2 >= (L2_4_histo)->dim[1]);
		      IDX_PTR (L1_ppal,
			       flt)[(L1_ppal)->mod[0] * ((int) L3_10_ccount) +
				    (L1_ppal)->mod[1] * ((int) 2)] =
			(IDX_PTR (L2_4_histo, flt)
			 [(L2_4_histo)->mod[0] * ((int) L5_13_c) +
			  (L2_4_histo)->mod[1] * ((int) 2)] /
			 (flt) L6_14_cnt);
		      RTERR_BOUND (L3_10_ccount < 0
				   || L3_10_ccount >= (L1_count)->dim[0]);
		      IDX_PTR (L1_count,
			       flt)[(L1_count)->mod[0] *
				    ((int) L3_10_ccount)] = L6_14_cnt;
		      L3_10_ccount = (L3_10_ccount + 1);
		    }
		}
	      }
	    }
	}
	C_idx_f2resize (L1_ppal, L3_10_ccount, 3);
	C_idx_f1resize (L1_count, L3_10_ccount);
      }
      L_Tmp0 = 0;
      Msrg_free (L2_3_0_srg);
      Msrg_free (L2_6_1_srg);
    }
    TRACE_POP ("C_rgbaim_histo32");
    return 0;
  }
}

/*
 * FUNCTION rgbaim-subsample+
 */
extern_c struct idx *
C_rgbaim_subsamplePlus (struct idx *L1_in, int L1_nlin, int L1_ncol,
			struct idx *L2_0_matrix, struct srg *L2_0_srg,
			struct idx *L2_3_matrix, struct srg *L2_3_srg)
{
  TRACE_PUSH ("C_rgbaim_subsamplePlus");
  {
    struct idx *L_Tmp0;
    char L_Tmp1;
    if ((L1_nlin == 1))
      {
	if ((L1_ncol == 1))
	  {
	    L_Tmp1 = 1;
	  }
	else
	  {
	    L_Tmp1 = 0;
	  }
      }
    else
      {
	L_Tmp1 = 0;
      }
    if (L_Tmp1)
      {
	{
	  (L2_0_matrix)->srg = L2_0_srg;
	  Midx_init_dim3 (L2_0_matrix, (L1_in)->dim[0], (L1_in)->dim[1],
			  (L1_in)->dim[2]);
	  RTERR_DIM (L2_0_matrix->dim[0] <= 0);
	  RTERR_DIM (L2_0_matrix->dim[1] <= 0);
	  RTERR_DIM (L2_0_matrix->dim[2] <= 0);
	  check_main_maout_any (L1_in, L2_0_matrix);
	  Midx_macopy (L1_in, L2_0_matrix, unsigned char, unsigned char);
	  L_Tmp0 = L2_0_matrix;
	}
      }
    else
      {
	{
	  int L2_2_h;
	  int L2_3_w;
	  int L2_4_nh;
	  int L2_5_nw;
	  Midx_declare (L3_6_2_clone, 3);
	  struct idx *L2_7_inp;
	  struct idx *L2_8_out;
	  Midx_init (L3_6_2_clone, 3);
	  L2_2_h = (L1_in)->dim[0];
	  L2_3_w = (L1_in)->dim[1];
	  L2_4_nh = (((int) L2_2_h) / ((int) L1_nlin));
	  L2_5_nw = (((int) L2_3_w) / ((int) L1_ncol));
	  {
	    Midx_declare (L4_9_1_clone, 3);
	    struct idx *L3_10___m;
	    struct idx *L_Tmp11;
	    real L_Tmp14;
	    Midx_init (L4_9_1_clone, 3);
	    {
	      struct idx *L4_12___m;
	      real L_Tmp13;
	      Midx_clone3 (L4_9_1_clone, L1_in);
	      L4_12___m = L4_9_1_clone;
	      L_Tmp13 = (L1_nlin * L2_4_nh);
	      RTERR_GEN ((((int) L_Tmp13) < 1
			  || ((int) 0) < 0), "illegal 'size' or 'offset'");
	      RTERR_GEN ((((int) 0) + ((int) L_Tmp13) >
			  (L4_12___m)->dim[((int) 0)]),
			 "specified interval is too large");
	      Midx_narrow (L4_12___m, ((int) 0), ((int) L_Tmp13), ((int) 0),
			   unsigned char);
	      L_Tmp11 = L4_12___m;
	    }
	    Midx_clone3 (L3_6_2_clone, L_Tmp11);
	    L3_10___m = L3_6_2_clone;
	    L_Tmp14 = (L1_ncol * L2_5_nw);
	    RTERR_GEN ((((int) L_Tmp14) < 1
			|| ((int) 0) < 0), "illegal 'size' or 'offset'");
	    RTERR_GEN ((((int) 0) + ((int) L_Tmp14) >
			(L3_10___m)->dim[((int) 1)]),
		       "specified interval is too large");
	    Midx_narrow (L3_10___m, ((int) 1), ((int) L_Tmp14), ((int) 0),
			 unsigned char);
	    L2_7_inp = L3_10___m;
	  }
	  (L2_3_matrix)->srg = L2_3_srg;
	  Midx_init_dim3 (L2_3_matrix, ((L2_4_nh) + 1), ((L2_5_nw) + 1), 4);
	  RTERR_DIM (L2_3_matrix->dim[0] <= 0);
	  RTERR_DIM (L2_3_matrix->dim[1] <= 0);
	  RTERR_DIM (L2_3_matrix->dim[2] <= 0);
	  L2_8_out = L2_3_matrix;
	  {
	    unsigned char *in_line, *pin;
	    unsigned char *out_line, *pout;
	    int i, _imax = (L2_4_nh);
	    int j, _jmax = (L2_5_nw);
	    int in_mod0 = ((L2_7_inp))->mod[0];
	    int in_mod1 = ((L2_7_inp))->mod[1];
	    int out_mod0 = ((L2_8_out))->mod[0];
	    int out_mod1 = ((L2_8_out))->mod[1];
	    int pin_incr = (L1_ncol) * in_mod1;
	    int last_col = (L2_3_w) - (L1_ncol) * (L2_5_nw);
	    int last_lin = (L2_2_h) - (L1_nlin) * (L2_4_nh);
	    in_line = IDX_PTR (((L2_7_inp)), unsigned char);
	    out_line = IDX_PTR (((L2_8_out)), unsigned char);
	    for (i = 0; i < _imax; i++)
	      {
		pin = in_line;
		pout = out_line;
		for (j = 0; j < _jmax; j++)
		  {
		    BLK_AVRG ((L1_nlin), (L1_ncol));
		    pin += pin_incr;
		    pout += out_mod1;
		  }
		if (last_col != 0)
		  BLK_AVRG ((L1_nlin), last_col);
		in_line += in_mod0 * (L1_nlin);
		out_line += out_mod0;
	      }
	    if (last_lin != 0)
	      {
		pin = in_line;
		pout = out_line;
		for (j = 0; j < _jmax; j++)
		  {
		    BLK_AVRG (last_lin, (L1_ncol));
		    pin += pin_incr;
		    pout += out_mod1;
		  }
		if (last_col != 0)
		  BLK_AVRG (last_lin, last_col);
	      }
	  }
	  L_Tmp0 = L2_8_out;
	}
      }
    TRACE_POP ("C_rgbaim_subsamplePlus");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-med3-slow
 */
extern_c struct idx *
C_rgbaim_med3_slow (struct idx *L1_rgbaim, struct idx *L2_0_matrix,
		    struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_rgbaim_med3_slow");
  {
    struct idx *L_Tmp0;
    {
      real L2_1_h;
      real L2_2_w;
      struct idx *L2_3_subim;
      Midx_declare (L2_4_1_matrix, 2);
      Msrg_declare (L2_5_1_srg);
      struct idx *L2_6_lum_block;
      Midx_declare (L2_7_2_matrix, 1);
      Msrg_declare (L2_8_2_srg);
      struct idx *L2_9_f_block;
      Midx_declare (L2_10_3_matrix, 1);
      Msrg_declare (L2_11_3_srg);
      struct idx *L2_12_index;
      Midx_init (L2_4_1_matrix, 2);
      Msrg_init (L2_5_1_srg, ST_U8);
      Midx_init (L2_7_2_matrix, 1);
      Msrg_init (L2_8_2_srg, ST_F);
      Midx_init (L2_10_3_matrix, 1);
      Msrg_init (L2_11_3_srg, ST_I32);
      L2_1_h = (((int) (L1_rgbaim)->dim[0]) / ((int) 3));
      L2_2_w = (((int) (L1_rgbaim)->dim[1]) / ((int) 3));
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim3 (L2_0_matrix, L2_1_h, L2_2_w, 4);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      RTERR_DIM (L2_0_matrix->dim[2] <= 0);
      Midx_maclear (L2_0_matrix, unsigned char);
      L2_3_subim = L2_0_matrix;
      (L2_4_1_matrix)->srg = L2_5_1_srg;
      Midx_init_dim2 (L2_4_1_matrix, 3, 3);
      RTERR_DIM (L2_4_1_matrix->dim[0] <= 0);
      RTERR_DIM (L2_4_1_matrix->dim[1] <= 0);
      Midx_maclear (L2_4_1_matrix, unsigned char);
      L2_6_lum_block = L2_4_1_matrix;
      (L2_7_2_matrix)->srg = L2_8_2_srg;
      Midx_init_dim1 (L2_7_2_matrix, 9);
      RTERR_DIM (L2_7_2_matrix->dim[0] <= 0);
      Midx_maclear (L2_7_2_matrix, flt);
      L2_9_f_block = L2_7_2_matrix;
      (L2_10_3_matrix)->srg = L2_11_3_srg;
      Midx_init_dim1 (L2_10_3_matrix, 9);
      RTERR_DIM (L2_10_3_matrix->dim[0] <= 0);
      Midx_maclear (L2_10_3_matrix, int);
      L2_12_index = L2_10_3_matrix;
      {
	int L3_13_i;
	L3_13_i = 0;
	{
	  Midx_begin_bloop1 (L4_line, L2_3_subim, unsigned char)
	  {
	    {
	      {
		int L6_14_j;
		L6_14_j = 0;
		{
		  Midx_begin_bloop1 (L7_pix, &L4_line, unsigned char)
		  {
		    {
		      {
			int L9_15_k;
			Midx_declare (L10_16_5_clone, 3);
			struct idx *L9_17_block;
			int L9_18_med;
			Midx_declare (L9_19_6_select, 2);
			Midx_declare (L9_20_7_select, 1);
			struct idx *L_Tmp27;
			int L_Tmp28;
			int L_Tmp29;
			Midx_init (L10_16_5_clone, 3);
			Midx_init (L9_19_6_select, 2);
			Midx_init (L9_20_7_select, 1);
			L9_15_k = 0;
			{
			  Midx_declare (L11_21_4_clone, 3);
			  struct idx *L10_22___m;
			  struct idx *L_Tmp23;
			  real L_Tmp26;
			  Midx_init (L11_21_4_clone, 3);
			  {
			    struct idx *L11_24___m;
			    real L_Tmp25;
			    Midx_clone3 (L11_21_4_clone, L1_rgbaim);
			    L11_24___m = L11_21_4_clone;
			    L_Tmp25 = (3 * L3_13_i);
			    RTERR_GEN ((((int) 3) < 1
					|| ((int) L_Tmp25) < 0),
				       "illegal 'size' or 'offset'");
			    RTERR_GEN ((((int) L_Tmp25) + ((int) 3) >
					(L11_24___m)->dim[((int) 0)]),
				       "specified interval is too large");
			    Midx_narrow (L11_24___m, ((int) 0), ((int) 3),
					 ((int) L_Tmp25), unsigned char);
			    L_Tmp23 = L11_24___m;
			  }
			  Midx_clone3 (L10_16_5_clone, L_Tmp23);
			  L10_22___m = L10_16_5_clone;
			  L_Tmp26 = (3 * L6_14_j);
			  RTERR_GEN ((((int) 3) < 1
				      || ((int) L_Tmp26) < 0),
				     "illegal 'size' or 'offset'");
			  RTERR_GEN ((((int) L_Tmp26) + ((int) 3) >
				      (L10_22___m)->dim[((int) 1)]),
				     "specified interval is too large");
			  Midx_narrow (L10_22___m, ((int) 1), ((int) 3),
				       ((int) L_Tmp26), unsigned char);
			  L9_17_block = L10_22___m;
			}
			L9_18_med = 0;
			C_rgbaim_luminance (L9_17_block, L2_6_lum_block);
			{
			  Midx_begin_bloop1 (L10_block, L2_6_lum_block,
					     unsigned char)
			  {
			    {
			      Midx_begin_bloop1 (L11_block, &L10_block,
						 unsigned char)
			      {
				RTERR_BOUND (L9_15_k < 0
					     || L9_15_k >=
					     (L2_9_f_block)->dim[0]);
				IDX_PTR (L2_9_f_block,
					 flt)[(L2_9_f_block)->mod[0] *
					      ((int) L9_15_k)] =
				  *IDX_PTR (&L11_block, unsigned char);
				L9_15_k = (L9_15_k + 1);
			      } Midx_end_bloop1 (L11_block, &L10_block,
						 unsigned char);
			    }
			  } Midx_end_bloop1 (L10_block, L2_6_lum_block,
					     unsigned char);
			}
			C_idx_i1fill_with_index (L2_12_index);
			C_idx_f1i1sortup (L2_9_f_block, L2_12_index);
			RTERR_BOUND (4 >= (L2_12_index)->dim[0]);
			L9_18_med =
			  IDX_PTR (L2_12_index,
				   int)[(L2_12_index)->mod[0] * ((int) 4)];
			L_Tmp28 = (((int) L9_18_med) / ((int) 3));
			RTERR_GEN ((((int) L_Tmp28) < 0),
				   "illegal parameter");
			RTERR_GEN ((((int) L_Tmp28) >=
				    (L9_17_block)->dim[((int) 0)]),
				   "specified subscript is too large");
			Midx_select (L9_19_6_select, L9_17_block, ((int) 0),
				     ((int) L_Tmp28), unsigned char);
			L_Tmp27 = L9_19_6_select;
			L_Tmp29 = (((int) L9_18_med) % ((int) 3));
			RTERR_GEN ((((int) L_Tmp29) < 0),
				   "illegal parameter");
			RTERR_GEN ((((int) L_Tmp29) >=
				    (L_Tmp27)->dim[((int) 0)]),
				   "specified subscript is too large");
			Midx_select (L9_20_7_select, L_Tmp27, ((int) 0),
				     ((int) L_Tmp29), unsigned char);
			check_main_maout (L9_20_7_select, &L7_pix);
			Midx_m1copy (L9_20_7_select, &L7_pix, unsigned char,
				     unsigned char);
		      }
		      L6_14_j = (L6_14_j + 1);
		    }
		  } Midx_end_bloop1 (L7_pix, &L4_line, unsigned char);
		}
	      }
	      L3_13_i = (L3_13_i + 1);
	    }
	  } Midx_end_bloop1 (L4_line, L2_3_subim, unsigned char);
	}
      }
      L_Tmp0 = L2_3_subim;
      Msrg_free (L2_5_1_srg);
      Msrg_free (L2_8_2_srg);
      Msrg_free (L2_11_3_srg);
    }
    TRACE_POP ("C_rgbaim_med3_slow");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-subsample-med3
 */
extern_c struct idx *
C_rgbaim_subsample_med3 (struct idx *L1_rgbaim, struct idx *L2_0_matrix,
			 struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_rgbaim_subsample_med3");
  {
    struct idx *L_Tmp0;
    {
      real L2_1_h;
      real L2_2_w;
      struct idx *L2_3_subim;
      L2_1_h = (((int) (L1_rgbaim)->dim[0]) / ((int) 3));
      L2_2_w = (((int) (L1_rgbaim)->dim[1]) / ((int) 3));
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim3 (L2_0_matrix, L2_1_h, L2_2_w, 4);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      RTERR_DIM (L2_0_matrix->dim[2] <= 0);
      Midx_maclear (L2_0_matrix, unsigned char);
      L2_3_subim = L2_0_matrix;
      {
	int _i_max = (L2_3_subim)->dim[0];
	int _L2_3_subim_mod0 = (L2_3_subim)->mod[0];
	int _j_max = (L2_3_subim)->dim[1];
	int _L2_3_subim_mod1 = (L2_3_subim)->mod[1];
	{
	  int i;
	  unsigned char *_L2_3_subim_loop_i =
	    IDX_PTR ((L2_3_subim), unsigned char);
	  for (i = 0; i < _i_max; i++)
	    {
	      int j;
	      unsigned char *pout = _L2_3_subim_loop_i;
	      for (j = 0; j < _j_max; j++)
		{
		  {
		    int mod0 = (L1_rgbaim)->mod[0];
		    int mod1 = (L1_rgbaim)->mod[1];
		    unsigned char *block0 =
		      IDX_PTR ((L1_rgbaim),
			       unsigned char) + 3 * i * mod0 + 3 * j * mod1;
		    unsigned char *block = block0;
		    flt line_med[3];
		    int med_j, line_med_j[3];
		    int max_j, line_max_j[3];
		    int min_j, line_min_j[3];
		    int med_i, max_i, min_i, k;
		    flt med;

		    for (k = 0; k < 3; k++)
		      {
			unsigned char *pin = block;
			flt p0 =
			  (0.299 * (flt) (pin[0]) + 0.587 * (flt) (pin[1]) +
			   0.114 * (flt) (pin[2]));
			flt p1 =
			  (0.299 * (flt) ((pin += mod1)[0]) +
			   0.587 * (flt) (pin[1]) + 0.114 * (flt) (pin[2]));
			flt p2 =
			  (0.299 * (flt) ((pin += mod1)[0]) +
			   0.587 * (flt) (pin[1]) + 0.114 * (flt) (pin[2]));
			if (p0 > p1)
			  {
			    if (p1 > p2)
			      {
				med = p1;
				med_j = 1;
				max_j = 0;
				min_j = 2;
			      }
			    else if (p2 > p0)
			      {
				med = p0;
				med_j = 0;
				max_j = 2;
				min_j = 1;
			      }
			    else
			      {
				med = p2;
				med_j = 2;
				max_j = 0;
				min_j = 1;
			      }
			  }
			else
			  {
			    if (p2 > p1)
			      {
				med = p1;
				med_j = 1;
				max_j = 2;
				min_j = 0;
			      }
			    else if (p2 < p0)
			      {
				med = p0;
				med_j = 0;
				max_j = 1;
				min_j = 2;
			      }
			    else
			      {
				med = p2;
				med_j = 2;
				max_j = 1;
				min_j = 0;
			      }
			  }
			block += mod0;
			line_med[k] = med;
			line_med_j[k] = med_j;
			line_max_j[k] = max_j;
			line_min_j[k] = min_j;
			if (med > 990.0)
			  printf ("%f %f %f\n", p0, p1, p2);
		      }
		    {
		      flt p0 = line_med[0];
		      flt p1 = line_med[1];
		      flt p2 = line_med[2];
		      if (p0 > p1)
			{
			  if (p1 > p2)
			    {
			      med = p1;
			      med_i = 1;
			      max_i = 0;
			      min_i = 2;
			    }
			  else if (p2 > p0)
			    {
			      med = p0;
			      med_i = 0;
			      max_i = 2;
			      min_i = 1;
			    }
			  else
			    {
			      med = p2;
			      med_i = 2;
			      max_i = 0;
			      min_i = 1;
			    }
			}
		      else
			{
			  if (p2 > p1)
			    {
			      med = p1;
			      med_i = 1;
			      max_i = 2;
			      min_i = 0;
			    }
			  else if (p2 < p0)
			    {
			      med = p0;
			      med_i = 0;
			      max_i = 1;
			      min_i = 2;
			    }
			  else
			    {
			      med = p2;
			      med_i = 2;
			      max_i = 1;
			      min_i = 0;
			    }
			}
		    }
		    {
		      unsigned char *pin0 =
			block0 + med_i * mod0 + line_med_j[med_i] * mod1;
		      unsigned char *pin1 =
			block0 + max_i * mod0 + line_min_j[max_i] * mod1;
		      unsigned char *pin1b =
			block0 + med_i * mod0 + line_min_j[med_i] * mod1;

		      unsigned char *pin2 =
			block0 + min_i * mod0 + line_max_j[min_i] * mod1;
		      unsigned char *pin2b =
			block0 + med_i * mod0 + line_max_j[med_i] * mod1;
		      unsigned char *pin;
		      flt p0 = med;
		      flt p1 =
			(0.299 * (flt) (pin1[0]) + 0.587 * (flt) (pin1[1]) +
			 0.114 * (flt) (pin1[2]));
		      flt p1b =
			(0.299 * (flt) (pin1b[0]) + 0.587 * (flt) (pin1b[1]) +
			 0.114 * (flt) (pin1b[2]));
		      flt p2 =
			(0.299 * (flt) (pin2[0]) + 0.587 * (flt) (pin2[1]) +
			 0.114 * (flt) (pin2[2]));
		      flt p2b =
			(0.299 * (flt) (pin2b[0]) + 0.587 * (flt) (pin2b[1]) +
			 0.114 * (flt) (pin2b[2]));

		      if (p1 < p1b)
			{
			  p1 = p1b;
			  pin1 = pin1b;
			}
		      if (p2 > p2b)
			{
			  p2 = p2b;
			  pin2 = pin2b;
			}

		      if (p0 > p1)
			{
			  if (p1 > p2)
			    {
			      med = p1;
			      pin = pin1;
			    }
			  else if (p2 > p0)
			    {
			      med = p0;
			      pin = pin0;
			    }
			  else
			    {
			      med = p2;
			      pin = pin2;
			    }
			}
		      else
			{
			  if (p2 > p1)
			    {
			      med = p1;
			      pin = pin1;
			    }
			  else if (p2 < p0)
			    {
			      med = p0;
			      pin = pin0;
			    }
			  else
			    {
			      med = p2;
			      pin = pin2;
			    }
			}

		      pout[0] = pin[0];
		      pout[1] = pin[1];
		      pout[2] = pin[2];
		    }
		  }
		  pout += _L2_3_subim_mod1;
		}
	      _L2_3_subim_loop_i += _L2_3_subim_mod0;
	    }
	}
      }
      L_Tmp0 = L2_3_subim;
    }
    TRACE_POP ("C_rgbaim_subsample_med3");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rgbaim-med3-subopt
 */
extern_c struct idx *
C_rgbaim_med3_subopt (struct idx *L1_rgbaim, struct idx *L2_0_matrix,
		      struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_rgbaim_med3_subopt");
  {
    struct idx *L_Tmp0;
    {
      real L2_1_h;
      real L2_2_w;
      struct idx *L2_3_subim;
      L2_1_h = (((int) (L1_rgbaim)->dim[0]) / ((int) 3));
      L2_2_w = (((int) (L1_rgbaim)->dim[1]) / ((int) 3));
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim3 (L2_0_matrix, L2_1_h, L2_2_w, 4);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      RTERR_DIM (L2_0_matrix->dim[2] <= 0);
      Midx_maclear (L2_0_matrix, unsigned char);
      L2_3_subim = L2_0_matrix;
      {
	int _i_max = (L2_3_subim)->dim[0];
	int _L2_3_subim_mod0 = (L2_3_subim)->mod[0];
	int _j_max = (L2_3_subim)->dim[1];
	int _L2_3_subim_mod1 = (L2_3_subim)->mod[1];
	{
	  int i;
	  unsigned char *_L2_3_subim_loop_i =
	    IDX_PTR ((L2_3_subim), unsigned char);
	  for (i = 0; i < _i_max; i++)
	    {
	      int j;
	      unsigned char *pout = _L2_3_subim_loop_i;
	      for (j = 0; j < _j_max; j++)
		{
		  {
		    int mod0 = (L1_rgbaim)->mod[0];
		    int mod1 = (L1_rgbaim)->mod[1];
		    unsigned char *block0 =
		      IDX_PTR ((L1_rgbaim),
			       unsigned char) + 3 * i * mod0 + 3 * j * mod1;
		    unsigned char *block = block0;
		    flt line_med[3];
		    int line_med_j[3];
		    int med_i, k, med_j;
		    flt p0, p1, p2, med;
		    unsigned char *pin;

		    for (k = 0; k < 3; k++)
		      {
			pin = block;
			p0 =
			  (0.299 * (flt) (pin[0]) + 0.587 * (flt) (pin[1]) +
			   0.114 * (flt) (pin[2]));
			pin += mod1;
			p1 =
			  (0.299 * (flt) (pin[0]) + 0.587 * (flt) (pin[1]) +
			   0.114 * (flt) (pin[2]));
			pin += mod1;
			p2 =
			  (0.299 * (flt) (pin[0]) + 0.587 * (flt) (pin[1]) +
			   0.114 * (flt) (pin[2]));
			if (p0 > p1)
			  {
			    if (p1 > p2)
			      {
				med = p1;
				med_j = 1;
			      }
			    else if (p2 > p0)
			      {
				med = p0;
				med_j = 0;
			      }
			    else
			      {
				med = p2;
				med_j = 2;
			      }
			  }
			else
			  {
			    if (p2 > p1)
			      {
				med = p1;
				med_j = 1;
			      }
			    else if (p2 < p0)
			      {
				med = p0;
				med_j = 0;
			      }
			    else
			      {
				med = p2;
				med_j = 2;
			      }
			  }
			block += mod0;
			line_med[k] = med;
			line_med_j[k] = med_j;
		      }

		    p0 = line_med[0];
		    p1 = line_med[1];
		    p2 = line_med[2];
		    if (p0 > p1)
		      {
			if (p1 > p2)
			  {
			    med = p1;
			    med_i = 1;
			  }
			else if (p2 > p0)
			  {
			    med = p0;
			    med_i = 0;
			  }
			else
			  {
			    med = p2;
			    med_i = 2;
			  }
		      }
		    else
		      {
			if (p2 > p1)
			  {
			    med = p1;
			    med_i = 1;
			  }
			else if (p2 < p0)
			  {
			    med = p0;
			    med_i = 0;
			  }
			else
			  {
			    med = p2;
			    med_i = 2;
			  }
		      }
		    med_j = line_med_j[med_i];
		    pin = block0 + med_i * mod0 + med_j * mod1;
		    med =
		      (0.299 * (flt) (pin[0]) + 0.587 * (flt) (pin[1]) +
		       0.114 * (flt) (pin[2]));

		    pout[0] = pin[0];
		    pout[1] = pin[1];
		    pout[2] = pin[2];
		  }
		  pout += _L2_3_subim_mod1;
		}
	      _L2_3_subim_loop_i += _L2_3_subim_mod0;
	    }
	}
      }
      L_Tmp0 = L2_3_subim;
    }
    TRACE_POP ("C_rgbaim_med3_subopt");
    return L_Tmp0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/* Declarations */
extern_c dhdoc_t K_idx_u3resize_R6def69e6;
extern_c dhdoc_t K_compute_bilin_transform_Ra317d0cb;
extern_c dhdoc_t K_idx_f1i1sortup_R675ffffd;
extern_c dhdoc_t K_idx_f2resize_R23ac6f4c;
extern_c dhdoc_t K_idx_f1resize_R428ad1dd;
extern_c dhdoc_t K_idx_i1fill_with_index_Rd20c4cb9;

/*
 * STUB rgbaim-enlarge
 */
DH (X_rgbaim_enlarge)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_enlarge (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
		      a[4].dh_idx_ptr, a[5].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-enlarge
 */
DHDOC (K_rgbaim_enlarge_R5ef1e386, X_rgbaim_enlarge, "C_rgbaim_enlarge", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-enlarge-into
 */
DH (X_rgbaim_enlarge_into)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_enlarge_into (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
			   a[4].dh_int);
  return ret;
}

/*
 * DHDOC rgbaim-enlarge-into
 */
DHDOC (K_rgbaim_enlarge_into_R3cebe412, X_rgbaim_enlarge_into,
       "C_rgbaim_enlarge_into", 0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_RETURN,
    DH_NIL, DH_END_FUNC, DH_REFER (K_idx_u3resize_R6def69e6), DH_NIL};

/*
 * STUB rgbaim-subsample
 */
DH (X_rgbaim_subsample)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_subsample (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
			a[4].dh_idx_ptr, a[5].dh_srg_ptr, a[6].dh_idx_ptr,
			a[7].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-subsample
 */
DHDOC (K_rgbaim_subsample_R937b2d86, X_rgbaim_subsample, "C_rgbaim_subsample",
       0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_TEMPS (4),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-subsample-into
 */
DH (X_rgbaim_subsample_into)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_subsample_into (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_int,
			     a[4].dh_int);
  return ret;
}

/*
 * DHDOC rgbaim-subsample-into
 */
DHDOC (K_rgbaim_subsample_into_R3cebe412, X_rgbaim_subsample_into,
       "C_rgbaim_subsample_into", 0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_WRITE, 3),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_RETURN,
    DH_NIL, DH_END_FUNC, DH_REFER (K_idx_u3resize_R6def69e6), DH_NIL};

/*
 * STUB rgbaim-rot90-right
 */
DH (X_rgbaim_rot90_right)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_rot90_right (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-rot90-right
 */
DHDOC (K_rgbaim_rot90_right_Rd8c2f0ea, X_rgbaim_rot90_right,
       "C_rgbaim_rot90_right", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-rot90-left
 */
DH (X_rgbaim_rot90_left)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_rot90_left (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-rot90-left
 */
DHDOC (K_rgbaim_rot90_left_Rd8c2f0ea, X_rgbaim_rot90_left,
       "C_rgbaim_rot90_left", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-rot180
 */
DH (X_rgbaim_rot180)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_rot180 (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-rot180
 */
DHDOC (K_rgbaim_rot180_Rd8c2f0ea, X_rgbaim_rot180, "C_rgbaim_rot180", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-rot180-inplace
 */
DH (X_rgbaim_rot180_inplace)
{
  dharg ret;
  ret.dh_char = C_rgbaim_rot180_inplace (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-rot180-inplace
 */
DHDOC (K_rgbaim_rot180_inplace_Re39841e4, X_rgbaim_rot180_inplace,
       "C_rgbaim_rot180_inplace", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-crop
 */
DH (X_rgbaim_crop)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_crop (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int, a[4].dh_int,
		   a[5].dh_int, a[6].dh_idx_ptr, a[7].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-crop
 */
DHDOC (K_rgbaim_crop_R463dae34, X_rgbaim_crop, "C_rgbaim_crop", 0, 0) =
{
DH_FUNC (5),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_INT,
    DH_INT,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-interpolate-bilin
 */
DH (X_rgbaim_interpolate_bilin)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_interpolate_bilin ((unsigned char *) a[1].dh_gptr,
				(unsigned char *) a[2].dh_gptr, a[3].dh_int,
				a[4].dh_int, a[5].dh_int, a[6].dh_int,
				a[7].dh_int, a[8].dh_int,
				(unsigned char *) a[9].dh_gptr);
  return ret;
}

/*
 * DHDOC rgbaim-interpolate-bilin
 */
DHDOC (K_rgbaim_interpolate_bilin_Re6e49836, X_rgbaim_interpolate_bilin,
       "C_rgbaim_interpolate_bilin", 0, 0) =
{
DH_FUNC (9),
    DH_GPTR ("unsigned char *"),
    DH_GPTR ("unsigned char *"),
    DH_INT,
    DH_INT,
    DH_INT,
    DH_INT,
    DH_INT,
    DH_INT,
    DH_GPTR ("unsigned char *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-warp
 */
DH (X_rgbaim_warp)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_warp (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
		   a[4].dh_idx_ptr, a[5].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-warp
 */
DHDOC (K_rgbaim_warp_Re015fb46, X_rgbaim_warp, "C_rgbaim_warp", 0, 0) =
{
DH_FUNC (5),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-warp-fast
 */
DH (X_rgbaim_warp_fast)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_warp_fast (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_idx_ptr, a[5].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-warp-fast
 */
DHDOC (K_rgbaim_warp_fast_Re015fb46, X_rgbaim_warp_fast, "C_rgbaim_warp_fast",
       0, 0) =
{
DH_FUNC (5),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-warp-quad
 */
DH (X_rgbaim_warp_quad)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_warp_quad (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
			a[4].dh_int, a[5].dh_flt, a[6].dh_flt, a[7].dh_flt,
			a[8].dh_flt, a[9].dh_flt, a[10].dh_flt, a[11].dh_flt,
			a[12].dh_flt, a[13].dh_flt, a[14].dh_flt,
			a[15].dh_flt, a[16].dh_flt);
  return ret;
}

/*
 * DHDOC rgbaim-warp-quad
 */
DHDOC (K_rgbaim_warp_quad_R7e8303fa, X_rgbaim_warp_quad, "C_rgbaim_warp_quad",
       0, 0) =
{
DH_FUNC (16),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_RETURN,
    DH_NIL,
    DH_END_FUNC, DH_REFER (K_compute_bilin_transform_Ra317d0cb), DH_NIL};

/*
 * STUB rgbaim-resize
 */
DH (X_rgbaim_resize)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_resize (a[1].dh_idx_ptr, a[2].dh_real, a[3].dh_real,
		     a[4].dh_real, a[5].dh_idx_ptr, a[6].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-resize
 */
DHDOC (K_rgbaim_resize_R93f5bbce, X_rgbaim_resize, "C_rgbaim_resize", 0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_WRITE),
    DH_UBYTE,
    DH_REAL,
    DH_REAL,
    DH_REAL,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-rotscale
 */
DH (X_rgbaim_rotscale)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_rotscale (a[1].dh_idx_ptr, a[2].dh_flt, a[3].dh_flt,
		       a[4].dh_idx_ptr, a[5].dh_flt, a[6].dh_flt, a[7].dh_flt,
		       a[8].dh_flt, a[9].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-rotscale
 */
DHDOC (K_rgbaim_rotscale_R27ec7e02, X_rgbaim_rotscale, "C_rgbaim_rotscale", 0,
       0) =
{
DH_FUNC (9),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_FLT,
    DH_FLT,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-rotscale-rect
 */
DH (X_rgbaim_rotscale_rect)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_rotscale_rect (a[1].dh_int, a[2].dh_int, a[3].dh_flt,
			    a[4].dh_flt, a[5].dh_flt, a[6].dh_flt,
			    a[7].dh_idx_ptr, a[8].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-rotscale-rect
 */
DHDOC (K_rgbaim_rotscale_rect_Re6e911d7, X_rgbaim_rotscale_rect,
       "C_rgbaim_rotscale_rect", 0, 0) =
{
DH_FUNC (8),
    DH_INT,
    DH_INT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE),
    DH_INT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-contbright
 */
DH (X_rgbaim_contbright)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_contbright (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_flt,
			 a[4].dh_flt);
  return ret;
}

/*
 * DHDOC rgbaim-contbright
 */
DHDOC (K_rgbaim_contbright_R026b8412, X_rgbaim_contbright,
       "C_rgbaim_contbright", 0, 0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_FLT, DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-luminance
 */
DH (X_rgbaim_luminance)
{
  dharg ret;
  ret.dh_char = C_rgbaim_luminance (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-luminance
 */
DHDOC (K_rgbaim_luminance_R75c86c42, X_rgbaim_luminance, "C_rgbaim_luminance",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-lum2rgba
 */
DH (X_rgbaim_lum2rgba)
{
  dharg ret;
  ret.dh_char = C_rgbaim_lum2rgba (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-lum2rgba
 */
DHDOC (K_rgbaim_lum2rgba_R75c86c42, X_rgbaim_lum2rgba, "C_rgbaim_lum2rgba", 0,
       0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-uvw
 */
DH (X_rgbaim_uvw)
{
  dharg ret;
  ret.dh_char = C_rgbaim_uvw (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-uvw
 */
DHDOC (K_rgbaim_uvw_R75c86c42, X_rgbaim_uvw, "C_rgbaim_uvw", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-saturate
 */
DH (X_rgbaim_saturate)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_saturate (a[1].dh_idx_ptr, a[2].dh_uchar, a[3].dh_uchar,
		       a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-saturate
 */
DHDOC (K_rgbaim_saturate_Ra3368acd, X_rgbaim_saturate, "C_rgbaim_saturate", 0,
       0) =
{
DH_FUNC (4),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_UBYTE,
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-blit
 */
DH (X_rgbaim_blit)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_blit (a[1].dh_int, a[2].dh_int, a[3].dh_idx_ptr,
		   a[4].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-blit
 */
DHDOC (K_rgbaim_blit_Rf3251789, X_rgbaim_blit, "C_rgbaim_blit", 0, 0) =
{
DH_FUNC (4),
    DH_INT,
    DH_INT,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-blitcolor
 */
DH (X_rgbaim_blitcolor)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_blitcolor (a[1].dh_int, a[2].dh_int, a[3].dh_idx_ptr,
			a[4].dh_uchar, a[5].dh_uchar, a[6].dh_uchar,
			a[7].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-blitcolor
 */
DHDOC (K_rgbaim_blitcolor_Ra2f42284, X_rgbaim_blitcolor, "C_rgbaim_blitcolor",
       0, 0) =
{
DH_FUNC (7),
    DH_INT,
    DH_INT,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_UBYTE,
    DH_UBYTE,
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-init-lum2rgb
 */
DH (X_rgbaim_init_lum2rgb)
{
  dharg ret;
  ret.dh_char = C_rgbaim_init_lum2rgb ();
  return ret;
}

/*
 * DHDOC rgbaim-init-lum2rgb
 */
DHDOC (K_rgbaim_init_lum2rgb_Ra8b05737, X_rgbaim_init_lum2rgb,
       "C_rgbaim_init_lum2rgb", 0, 0) =
{
DH_FUNC (0),
    DH_RETURN,
    DH_NIL, DH_END_FUNC, DH_REFER (K_idx_f1i1sortup_R675ffffd), DH_NIL};

/*
 * STUB rgbaim-lum2rgb
 */
DH (X_rgbaim_lum2rgb)
{
  dharg ret;
  ret.dh_int = C_rgbaim_lum2rgb (a[1].dh_int);
  return ret;
}

/*
 * DHDOC rgbaim-lum2rgb
 */
DHDOC (K_rgbaim_lum2rgb_R5d694478, X_rgbaim_lum2rgb, "C_rgbaim_lum2rgb", 0,
       0) =
{
DH_FUNC (1), DH_INT, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-histo32
 */
DH (X_rgbaim_histo32)
{
  dharg ret;
  ret.dh_char =
    C_rgbaim_histo32 (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-histo32
 */
DHDOC (K_rgbaim_histo32_R6bea669c, X_rgbaim_histo32, "C_rgbaim_histo32", 0,
       0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_WRITE),
    DH_FLT,
    DH_RETURN,
    DH_NIL,
    DH_END_FUNC,
    DH_REFER (K_idx_f2resize_R23ac6f4c),
    DH_REFER (K_idx_f1resize_R428ad1dd), DH_NIL};

/*
 * STUB rgbaim-subsample+
 */
DH (X_rgbaim_subsamplePlus)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_subsamplePlus (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_int,
			    a[4].dh_idx_ptr, a[5].dh_srg_ptr, a[6].dh_idx_ptr,
			    a[7].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-subsample+
 */
DHDOC (K_rgbaim_subsamplePlus_R937b2d86, X_rgbaim_subsamplePlus,
       "C_rgbaim_subsamplePlus", 0, 0) =
{
DH_FUNC (3),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_INT,
    DH_TEMPS (4),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-med3-slow
 */
DH (X_rgbaim_med3_slow)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_med3_slow (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-med3-slow
 */
DHDOC (K_rgbaim_med3_slow_Rd8c2f0ea, X_rgbaim_med3_slow, "C_rgbaim_med3_slow",
       0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_END_FUNC,
    DH_REFER (K_idx_i1fill_with_index_Rd20c4cb9),
    DH_REFER (K_idx_f1i1sortup_R675ffffd), DH_NIL};

/*
 * STUB rgbaim-subsample-med3
 */
DH (X_rgbaim_subsample_med3)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_subsample_med3 (a[1].dh_idx_ptr, a[2].dh_idx_ptr,
			     a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-subsample-med3
 */
DHDOC (K_rgbaim_subsample_med3_Rd8c2f0ea, X_rgbaim_subsample_med3,
       "C_rgbaim_subsample_med3", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB rgbaim-med3-subopt
 */
DH (X_rgbaim_med3_subopt)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_rgbaim_med3_subopt (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC rgbaim-med3-subopt
 */
DHDOC (K_rgbaim_med3_subopt_Rd8c2f0ea, X_rgbaim_med3_subopt,
       "C_rgbaim_med3_subopt", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_rgbaimage (void)
{
  dh_define ("rgbaim-enlarge", &K_rgbaim_enlarge_R5ef1e386);
  dh_define ("rgbaim-enlarge-into", &K_rgbaim_enlarge_into_R3cebe412);
  dh_define ("rgbaim-subsample", &K_rgbaim_subsample_R937b2d86);
  dh_define ("rgbaim-subsample-into", &K_rgbaim_subsample_into_R3cebe412);
  dh_define ("rgbaim-rot90-right", &K_rgbaim_rot90_right_Rd8c2f0ea);
  dh_define ("rgbaim-rot90-left", &K_rgbaim_rot90_left_Rd8c2f0ea);
  dh_define ("rgbaim-rot180", &K_rgbaim_rot180_Rd8c2f0ea);
  dh_define ("rgbaim-rot180-inplace", &K_rgbaim_rot180_inplace_Re39841e4);
  dh_define ("rgbaim-crop", &K_rgbaim_crop_R463dae34);
  dh_define ("rgbaim-interpolate-bilin",
	     &K_rgbaim_interpolate_bilin_Re6e49836);
  dh_define ("rgbaim-warp", &K_rgbaim_warp_Re015fb46);
  dh_define ("rgbaim-warp-fast", &K_rgbaim_warp_fast_Re015fb46);
  dh_define ("rgbaim-warp-quad", &K_rgbaim_warp_quad_R7e8303fa);
  dh_define ("rgbaim-resize", &K_rgbaim_resize_R93f5bbce);
  dh_define ("rgbaim-rotscale", &K_rgbaim_rotscale_R27ec7e02);
  dh_define ("rgbaim-rotscale-rect", &K_rgbaim_rotscale_rect_Re6e911d7);
  dh_define ("rgbaim-contbright", &K_rgbaim_contbright_R026b8412);
  dh_define ("rgbaim-luminance", &K_rgbaim_luminance_R75c86c42);
  dh_define ("rgbaim-lum2rgba", &K_rgbaim_lum2rgba_R75c86c42);
  dh_define ("rgbaim-uvw", &K_rgbaim_uvw_R75c86c42);
  dh_define ("rgbaim-saturate", &K_rgbaim_saturate_Ra3368acd);
  dh_define ("rgbaim-blit", &K_rgbaim_blit_Rf3251789);
  dh_define ("rgbaim-blitcolor", &K_rgbaim_blitcolor_Ra2f42284);
  dh_define ("rgbaim-init-lum2rgb", &K_rgbaim_init_lum2rgb_Ra8b05737);
  dh_define ("rgbaim-lum2rgb", &K_rgbaim_lum2rgb_R5d694478);
  dh_define ("rgbaim-histo32", &K_rgbaim_histo32_R6bea669c);
  dh_define ("rgbaim-subsample+", &K_rgbaim_subsamplePlus_R937b2d86);
  dh_define ("rgbaim-med3-slow", &K_rgbaim_med3_slow_Rd8c2f0ea);
  dh_define ("rgbaim-subsample-med3", &K_rgbaim_subsample_med3_Rd8c2f0ea);
  dh_define ("rgbaim-med3-subopt", &K_rgbaim_med3_subopt_Rd8c2f0ea);
}

int majver_rgbaimage = 40;
int minver_rgbaimage = 10;

#endif
