/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"

/* ---------------------------------------- */

/*
 * FUNCTION idx-ub3mat-add
 */
extern_c struct idx *
C_idx_ub3mat_add (struct idx *L1_m1, struct idx *L1_m2,
		  struct idx *L3_0_matrix, struct srg *L3_0_srg)
{
  TRACE_PUSH ("C_idx_ub3mat_add");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_m12;
      {
	(L3_0_matrix)->srg = L3_0_srg;
	Midx_init_dim3 (L3_0_matrix, (L1_m1)->dim[0], (L1_m1)->dim[1],
			(L1_m1)->dim[2]);
	RTERR_DIM (L3_0_matrix->dim[0] <= 0);
	RTERR_DIM (L3_0_matrix->dim[1] <= 0);
	RTERR_DIM (L3_0_matrix->dim[2] <= 0);
	check_main_maout_any (L1_m1, L3_0_matrix);
	Midx_macopy (L1_m1, L3_0_matrix, unsigned char, unsigned char);
	L2_1_m12 = L3_0_matrix;
      }
      {
	int _i_max = (L1_m2)->dim[0];
	int _L1_m2_mod0 = (L1_m2)->mod[0];
	int _L2_1_m12_mod0 = (L2_1_m12)->mod[0];
	int _j_max = (L1_m2)->dim[1];
	int _L1_m2_mod1 = (L1_m2)->mod[1];
	int _L2_1_m12_mod1 = (L2_1_m12)->mod[1];
	int _k_max = (L1_m2)->dim[2];
	int _L1_m2_mod2 = (L1_m2)->mod[2];
	int _L2_1_m12_mod2 = (L2_1_m12)->mod[2];
	if (_i_max != (L2_1_m12)->dim[0])
	  run_time_error
	    ("idx L2_1_m12's dim 0 doesn't match idx L1_m2's dim 0");
	if (_j_max != (L2_1_m12)->dim[1])
	  run_time_error
	    ("idx L2_1_m12's dim 1 doesn't match idx L1_m2's dim 1");
	if (_k_max != (L2_1_m12)->dim[2])
	  run_time_error
	    ("idx L2_1_m12's dim 2 doesn't match idx L1_m2's dim 2");
	{
	  int i;
	  unsigned char *_L1_m2_loop_i = IDX_PTR ((L1_m2), unsigned char);
	  unsigned char *_L2_1_m12_loop_i =
	    IDX_PTR ((L2_1_m12), unsigned char);
	  for (i = 0; i < _i_max; i++)
	    {
	      int j;
	      unsigned char *_L1_m2_loop_j = _L1_m2_loop_i;
	      unsigned char *_L2_1_m12_loop_j = _L2_1_m12_loop_i;
	      for (j = 0; j < _j_max; j++)
		{
		  int k;
		  unsigned char *p2 = _L1_m2_loop_j;
		  unsigned char *p12 = _L2_1_m12_loop_j;
		  for (k = 0; k < _k_max; k++)
		    {
		      int v = *p12 + *p2 - 128;
		      if (v < 0)
			v = 0;
		      if (v > 255)
			v = 255;
		      *p12 = v;
		      p2 += _L1_m2_mod2;
		      p12 += _L2_1_m12_mod2;
		    }
		  _L1_m2_loop_j += _L1_m2_mod1;
		  _L2_1_m12_loop_j += _L2_1_m12_mod1;
		}
	      _L1_m2_loop_i += _L1_m2_mod0;
	      _L2_1_m12_loop_i += _L2_1_m12_mod0;
	    }
	}
      }
      L_Tmp0 = L2_1_m12;
    }
    TRACE_POP ("C_idx_ub3mat_add");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-ub-to-bits
 */
extern_c int
C_idx_ub_to_bits (struct idx *L1_ub)
{
  TRACE_PUSH ("C_idx_ub_to_bits");
  {
    int L_Tmp0;
    {
      int L2_1_bits;
      L2_1_bits = 0;
      {
	int _i_max = (L1_ub)->dim[0];
	int _L1_ub_mod0 = (L1_ub)->mod[0];
	{
	  int i;
	  unsigned char *ub = IDX_PTR ((L1_ub), unsigned char);
	  for (i = 0; i < _i_max; i++)
	    {
	      (L2_1_bits) <<= 1;
	      (L2_1_bits) += (*ub > 0);
	      ub += _L1_ub_mod0;
	    }
	}
      }
      L_Tmp0 = L2_1_bits;
    }
    TRACE_POP ("C_idx_ub_to_bits");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-ub-from-bits
 */
extern_c char
C_idx_ub_from_bits (struct idx *L1_ub, int L1_bits)
{
  TRACE_PUSH ("C_idx_ub_from_bits");
  {
    {
      int L2_0_l;
      int L2_1_m;
      L2_0_l = (L1_ub)->dim[0];
      L2_1_m = pow ((double) (2), (double) (((L2_0_l) - 1)));
      if ((L2_0_l >= 32))
	{
	  run_time_error ("vector has more than 32 elements");
	}
      {
	int _i_max = (L1_ub)->dim[0];
	int _L1_ub_mod0 = (L1_ub)->mod[0];
	{
	  int i;
	  unsigned char *ub = IDX_PTR ((L1_ub), unsigned char);
	  for (i = 0; i < _i_max; i++)
	    {
	      *ub = 255 * (((L1_bits) & (L2_1_m)) > 0);
	      (L1_bits) <<= 1;
	      ub += _L1_ub_mod0;
	    }
	}
      }
    }
    TRACE_POP ("C_idx_ub_from_bits");
    return 0;
  }
}

/*
 * FUNCTION idx-ub1add
 */
extern_c char
C_idx_ub1add (struct idx *L1_m, int L1_c)
{
  TRACE_PUSH ("C_idx_ub1add");
  {
    {
      int _i_max = (L1_m)->dim[0];
      int _L1_m_mod0 = (L1_m)->mod[0];
      {
	int i;
	unsigned char *mp = IDX_PTR ((L1_m), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    *mp += (L1_c);
	    mp += _L1_m_mod0;
	  }
      }
    }
    TRACE_POP ("C_idx_ub1add");
    return 0;
  }
}

/*
 * FUNCTION idx-ub2mul
 */
extern_c char
C_idx_ub2mul (struct idx *L1_m, int L1_c)
{
  TRACE_PUSH ("C_idx_ub2mul");
  {
    {
      int _i_max = (L1_m)->dim[0];
      int _L1_m_mod0 = (L1_m)->mod[0];
      int _j_max = (L1_m)->dim[1];
      int _L1_m_mod1 = (L1_m)->mod[1];
      {
	int i;
	unsigned char *_L1_m_loop_i = IDX_PTR ((L1_m), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    unsigned char *mp = _L1_m_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		*mp *= (L1_c);
		mp += _L1_m_mod1;
	      }
	    _L1_m_loop_i += _L1_m_mod0;
	  }
      }
    }
    TRACE_POP ("C_idx_ub2mul");
    return 0;
  }
}

/*
 * FUNCTION idx-ub2-i2mul
 */
extern_c struct idx *
C_idx_ub2_i2mul (struct idx *L1_i2, int L1_c, struct idx *L2_0_matrix,
		 struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_idx_ub2_i2mul");
  {
    struct idx *L_Tmp0;
    {
      struct idx *L2_1_u2;
      (L2_0_matrix)->srg = L2_0_srg;
      Midx_init_dim2 (L2_0_matrix, (L1_i2)->dim[0], (L1_i2)->dim[1]);
      RTERR_DIM (L2_0_matrix->dim[0] <= 0);
      RTERR_DIM (L2_0_matrix->dim[1] <= 0);
      L2_1_u2 = L2_0_matrix;
      {
	int _i_max = (L1_i2)->dim[0];
	int _L1_i2_mod0 = (L1_i2)->mod[0];
	int _L2_1_u2_mod0 = (L2_1_u2)->mod[0];
	int _j_max = (L1_i2)->dim[1];
	int _L1_i2_mod1 = (L1_i2)->mod[1];
	int _L2_1_u2_mod1 = (L2_1_u2)->mod[1];
	if (_i_max != (L2_1_u2)->dim[0])
	  run_time_error
	    ("idx L2_1_u2's dim 0 doesn't match idx L1_i2's dim 0");
	if (_j_max != (L2_1_u2)->dim[1])
	  run_time_error
	    ("idx L2_1_u2's dim 1 doesn't match idx L1_i2's dim 1");
	{
	  int i;
	  int *_L1_i2_loop_i = IDX_PTR ((L1_i2), int);
	  unsigned char *_L2_1_u2_loop_i = IDX_PTR ((L2_1_u2), unsigned char);
	  for (i = 0; i < _i_max; i++)
	    {
	      int j;
	      int *in = _L1_i2_loop_i;
	      unsigned char *out = _L2_1_u2_loop_i;
	      for (j = 0; j < _j_max; j++)
		{
		  int f = *in * (L1_c);
		  if (f > 255)
		    f = 255;
		  if (f < 0)
		    f = 0;
		  *out = f;
		  in += _L1_i2_mod1;
		  out += _L2_1_u2_mod1;
		}
	      _L1_i2_loop_i += _L1_i2_mod0;
	      _L2_1_u2_loop_i += _L2_1_u2_mod0;
	    }
	}
      }
      L_Tmp0 = L2_1_u2;
    }
    TRACE_POP ("C_idx_ub2_i2mul");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-ub2add
 */
extern_c char
C_idx_ub2add (struct idx *L1_m, int L1_c)
{
  TRACE_PUSH ("C_idx_ub2add");
  {
    {
      int _i_max = (L1_m)->dim[0];
      int _L1_m_mod0 = (L1_m)->mod[0];
      int _j_max = (L1_m)->dim[1];
      int _L1_m_mod1 = (L1_m)->mod[1];
      {
	int i;
	unsigned char *_L1_m_loop_i = IDX_PTR ((L1_m), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    unsigned char *mp = _L1_m_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		*mp += (L1_c);
		mp += _L1_m_mod1;
	      }
	    _L1_m_loop_i += _L1_m_mod0;
	  }
      }
    }
    TRACE_POP ("C_idx_ub2add");
    return 0;
  }
}

/*
 * FUNCTION idx-ub1fill
 */
extern_c char
C_idx_ub1fill (struct idx *L1_m, int L1_c)
{
  TRACE_PUSH ("C_idx_ub1fill");
  {
    {
      int _i_max = (L1_m)->dim[0];
      int _L1_m_mod0 = (L1_m)->mod[0];
      {
	int i;
	unsigned char *mp = IDX_PTR ((L1_m), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    *mp = (L1_c);
	    mp += _L1_m_mod0;
	  }
      }
    }
    TRACE_POP ("C_idx_ub1fill");
    return 0;
  }
}

/*
 * FUNCTION idx-ub2fill
 */
extern_c char
C_idx_ub2fill (struct idx *L1_m, int L1_c)
{
  TRACE_PUSH ("C_idx_ub2fill");
  {
    {
      int _i_max = (L1_m)->dim[0];
      int _L1_m_mod0 = (L1_m)->mod[0];
      int _j_max = (L1_m)->dim[1];
      int _L1_m_mod1 = (L1_m)->mod[1];
      {
	int i;
	unsigned char *_L1_m_loop_i = IDX_PTR ((L1_m), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    unsigned char *mp = _L1_m_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		*mp = (L1_c);
		mp += _L1_m_mod1;
	      }
	    _L1_m_loop_i += _L1_m_mod0;
	  }
      }
    }
    TRACE_POP ("C_idx_ub2fill");
    return 0;
  }
}

/*
 * FUNCTION idx-m2opp
 */
extern_c struct idx *
C_idx_m2opp (struct idx *L1_m)
{
  TRACE_PUSH ("C_idx_m2opp");
  {
    struct idx *L_Tmp0;
    {
      int _i_max = (L1_m)->dim[0];
      int _L1_m_mod0 = (L1_m)->mod[0];
      int _j_max = (L1_m)->dim[1];
      int _L1_m_mod1 = (L1_m)->mod[1];
      {
	int i;
	flt *_L1_m_loop_i = IDX_PTR ((L1_m), flt);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    flt *p = _L1_m_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		{
		  *p = -*p;
		}
		p += _L1_m_mod1;
	      }
	    _L1_m_loop_i += _L1_m_mod0;
	  }
      }
    }
    L_Tmp0 = L1_m;
    TRACE_POP ("C_idx_m2opp");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u2sub
 */
extern_c struct idx *
C_idx_u2sub (struct idx *L1_ubim, int L1_v)
{
  TRACE_PUSH ("C_idx_u2sub");
  {
    struct idx *L_Tmp0;
    {
      int _i_max = (L1_ubim)->dim[0];
      int _L1_ubim_mod0 = (L1_ubim)->mod[0];
      int _j_max = (L1_ubim)->dim[1];
      int _L1_ubim_mod1 = (L1_ubim)->mod[1];
      {
	int i;
	unsigned char *_L1_ubim_loop_i = IDX_PTR ((L1_ubim), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    unsigned char *u = _L1_ubim_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		{
		  int d = *u - (L1_v);
		  *u = (d > 0 ? d : 0);
		}
		u += _L1_ubim_mod1;
	      }
	    _L1_ubim_loop_i += _L1_ubim_mod0;
	  }
    }}
    L_Tmp0 = L1_ubim;
    TRACE_POP ("C_idx_u2sub");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-u2rev
 */
extern_c struct idx *
C_idx_u2rev (struct idx *L1_ubim)
{
  TRACE_PUSH ("C_idx_u2rev");
  {
    struct idx *L_Tmp0;
    {
      int _i_max = (L1_ubim)->dim[0];
      int _L1_ubim_mod0 = (L1_ubim)->mod[0];
      int _j_max = (L1_ubim)->dim[1];
      int _L1_ubim_mod1 = (L1_ubim)->mod[1];
      {
	int i;
	unsigned char *_L1_ubim_loop_i = IDX_PTR ((L1_ubim), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    unsigned char *u = _L1_ubim_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		{
		  *u ^= 255;
		}
		u += _L1_ubim_mod1;
	      }
	    _L1_ubim_loop_i += _L1_ubim_mod0;
	  }
      }
    }
    L_Tmp0 = L1_ubim;
    TRACE_POP ("C_idx_u2rev");
    return L_Tmp0;
  }
}

/*
 * FUNCTION idx-copy-inv
 */
extern_c struct idx *
C_idx_copy_inv (struct idx *L1_u1, struct idx *L1_u2)
{
  TRACE_PUSH ("C_idx_copy_inv");
  {
    struct idx *L_Tmp0;
    {
      int _i_max = (L1_u1)->dim[0];
      int _L1_u1_mod0 = (L1_u1)->mod[0];
      int _L1_u2_mod0 = (L1_u2)->mod[0];
      int _j_max = (L1_u1)->dim[1];
      int _L1_u1_mod1 = (L1_u1)->mod[1];
      int _L1_u2_mod1 = (L1_u2)->mod[1];
      if (_i_max != (L1_u2)->dim[0])
	run_time_error ("idx L1_u2's dim 0 doesn't match idx L1_u1's dim 0");
      if (_j_max != (L1_u2)->dim[1])
	run_time_error ("idx L1_u2's dim 1 doesn't match idx L1_u1's dim 1");
      {
	int i;
	unsigned char *_L1_u1_loop_i = IDX_PTR ((L1_u1), unsigned char);
	unsigned char *_L1_u2_loop_i = IDX_PTR ((L1_u2), unsigned char);
	for (i = 0; i < _i_max; i++)
	  {
	    int j;
	    unsigned char *u1 = _L1_u1_loop_i;
	    unsigned char *u2 = _L1_u2_loop_i;
	    for (j = 0; j < _j_max; j++)
	      {
		*u2 = 255 - *u1;
		u1 += _L1_u1_mod1;
		u2 += _L1_u2_mod1;
	      }
	    _L1_u1_loop_i += _L1_u1_mod0;
	    _L1_u2_loop_i += _L1_u2_mod0;
	  }
      }
    }
    L_Tmp0 = L1_u2;
    TRACE_POP ("C_idx_copy_inv");
    return L_Tmp0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/*
 * STUB idx-ub3mat-add
 */
DH (X_idx_ub3mat_add)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_ub3mat_add (a[1].dh_idx_ptr, a[2].dh_idx_ptr, a[3].dh_idx_ptr,
		      a[4].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC idx-ub3mat-add
 */
DHDOC (K_idx_ub3mat_add_R4e92dd4c, X_idx_ub3mat_add, "C_idx_ub3mat_add", 0,
       0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 3),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 3), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 3), DH_SRG (DHT_WRITE), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub-to-bits
 */
DH (X_idx_ub_to_bits)
{
  dharg ret;
  ret.dh_int = C_idx_ub_to_bits (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-ub-to-bits
 */
DHDOC (K_idx_ub_to_bits_R49286705, X_idx_ub_to_bits, "C_idx_ub_to_bits", 0,
       0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ), DH_UBYTE, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub-from-bits
 */
DH (X_idx_ub_from_bits)
{
  dharg ret;
  ret.dh_char = C_idx_ub_from_bits (a[1].dh_idx_ptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC idx-ub-from-bits
 */
DHDOC (K_idx_ub_from_bits_R61894f3f, X_idx_ub_from_bits, "C_idx_ub_from_bits",
       0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub1add
 */
DH (X_idx_ub1add)
{
  dharg ret;
  ret.dh_char = C_idx_ub1add (a[1].dh_idx_ptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC idx-ub1add
 */
DHDOC (K_idx_ub1add_R61894f3f, X_idx_ub1add, "C_idx_ub1add", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub2mul
 */
DH (X_idx_ub2mul)
{
  dharg ret;
  ret.dh_char = C_idx_ub2mul (a[1].dh_idx_ptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC idx-ub2mul
 */
DHDOC (K_idx_ub2mul_R61894f3f, X_idx_ub2mul, "C_idx_ub2mul", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub2-i2mul
 */
DH (X_idx_ub2_i2mul)
{
  dharg ret;
  ret.dh_idx_ptr =
    C_idx_ub2_i2mul (a[1].dh_idx_ptr, a[2].dh_int, a[3].dh_idx_ptr,
		     a[4].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC idx-ub2-i2mul
 */
DHDOC (K_idx_ub2_i2mul_R39fbe48b, X_idx_ub2_i2mul, "C_idx_ub2_i2mul", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_INT,
    DH_INT,
    DH_TEMPS (2),
    DH_IDX (DHT_WRITE, 2), DH_UBYTE,
    DH_SRG (DHT_WRITE), DH_UBYTE,
    DH_END_TEMPS,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub2add
 */
DH (X_idx_ub2add)
{
  dharg ret;
  ret.dh_char = C_idx_ub2add (a[1].dh_idx_ptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC idx-ub2add
 */
DHDOC (K_idx_ub2add_R61894f3f, X_idx_ub2add, "C_idx_ub2add", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub1fill
 */
DH (X_idx_ub1fill)
{
  dharg ret;
  ret.dh_char = C_idx_ub1fill (a[1].dh_idx_ptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC idx-ub1fill
 */
DHDOC (K_idx_ub1fill_R61894f3f, X_idx_ub1fill, "C_idx_ub1fill", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 1),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-ub2fill
 */
DH (X_idx_ub2fill)
{
  dharg ret;
  ret.dh_char = C_idx_ub2fill (a[1].dh_idx_ptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC idx-ub2fill
 */
DHDOC (K_idx_ub2fill_R61894f3f, X_idx_ub2fill, "C_idx_ub2fill", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-m2opp
 */
DH (X_idx_m2opp)
{
  dharg ret;
  ret.dh_idx_ptr = C_idx_m2opp (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-m2opp
 */
DHDOC (K_idx_m2opp_Rd811b5f5, X_idx_m2opp, "C_idx_m2opp", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_FLT,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2sub
 */
DH (X_idx_u2sub)
{
  dharg ret;
  ret.dh_idx_ptr = C_idx_u2sub (a[1].dh_idx_ptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC idx-u2sub
 */
DHDOC (K_idx_u2sub_R69b14db1, X_idx_u2sub, "C_idx_u2sub", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_INT,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-u2rev
 */
DH (X_idx_u2rev)
{
  dharg ret;
  ret.dh_idx_ptr = C_idx_u2rev (a[1].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-u2rev
 */
DHDOC (K_idx_u2rev_Reba0436a, X_idx_u2rev, "C_idx_u2rev", 0, 0) =
{
DH_FUNC (1),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB idx-copy-inv
 */
DH (X_idx_copy_inv)
{
  dharg ret;
  ret.dh_idx_ptr = C_idx_copy_inv (a[1].dh_idx_ptr, a[2].dh_idx_ptr);
  return ret;
}

/*
 * DHDOC idx-copy-inv
 */
DHDOC (K_idx_copy_inv_R7df06ecc, X_idx_copy_inv, "C_idx_copy_inv", 0, 0) =
{
DH_FUNC (2),
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_IDX (DHT_READ, 2),
    DH_SRG (DHT_READ),
    DH_UBYTE,
    DH_RETURN,
    DH_IDX (DHT_READ, 2), DH_SRG (DHT_READ), DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_idx_ubyte (void)
{
  dh_define ("idx-ub3mat-add", &K_idx_ub3mat_add_R4e92dd4c);
  dh_define ("idx-ub-to-bits", &K_idx_ub_to_bits_R49286705);
  dh_define ("idx-ub-from-bits", &K_idx_ub_from_bits_R61894f3f);
  dh_define ("idx-ub1add", &K_idx_ub1add_R61894f3f);
  dh_define ("idx-ub2mul", &K_idx_ub2mul_R61894f3f);
  dh_define ("idx-ub2-i2mul", &K_idx_ub2_i2mul_R39fbe48b);
  dh_define ("idx-ub2add", &K_idx_ub2add_R61894f3f);
  dh_define ("idx-ub1fill", &K_idx_ub1fill_R61894f3f);
  dh_define ("idx-ub2fill", &K_idx_ub2fill_R61894f3f);
  dh_define ("idx-m2opp", &K_idx_m2opp_Rd811b5f5);
  dh_define ("idx-u2sub", &K_idx_u2sub_R69b14db1);
  dh_define ("idx-u2rev", &K_idx_u2rev_Reba0436a);
  dh_define ("idx-copy-inv", &K_idx_copy_inv_R7df06ecc);
}

int majver_idx_ubyte = 40;
int minver_idx_ubyte = 10;

#endif
