/* WARNING: Automatically generated code.
 * This code has been generated by the DH compiler.
 */
#ifdef HAVE_CONFIG_H
# include "lushconf.h"
#endif

/*
 * LUSH HEADERS
 */
#include "header.h"
#include "dh.h"
#include "idxmac.h"
#include "idxops.h"
#include "check_func.h"
/*
 * USER DEFINED HEADERS
 */
#include <stdio.h>

#define STRING_DATA(s) (s->data)
static int endiantest = 1;
#define little_endian_p (*(char*)&endiantest)
#include <sys/types.h>
#include <sys/stat.h>

/* ---------------------------------------- */

/*
 * FUNCTION reverse-n
 */
extern_c char
C_reverse_n (gptr L1_ptr, int L1_size, int L1_n)
{
  TRACE_PUSH ("C_reverse_n");
  {
    {
      char *mptr = (char *) (L1_ptr);
      while ((L1_n)--)
	{
	  char tmp;
	  char *uptr = mptr + (L1_size);
	  if ((L1_size) >= 2)
	    {
	      tmp = mptr[0];
	      mptr[0] = uptr[-1];
	      uptr[-1] = tmp;
	    }
	  if ((L1_size) >= 4)
	    {
	      tmp = mptr[1];
	      mptr[1] = uptr[-2];
	      uptr[-2] = tmp;
	    }
	  if ((L1_size) >= 6)
	    {
	      tmp = mptr[2];
	      mptr[2] = uptr[-3];
	      uptr[-3] = tmp;
	    }
	  if ((L1_size) >= 8)
	    {
	      tmp = mptr[3];
	      mptr[3] = uptr[-4];
	      uptr[-4] = tmp;
	    }
	  mptr = uptr;
	}
    }
    TRACE_POP ("C_reverse_n");
    return 0;
  }
}

/*
 * FUNCTION stdout
 */
extern_c gptr
C_stdout ()
{
  TRACE_PUSH ("C_stdout");
  {
    gptr L_Tmp0;
    L_Tmp0 = (gptr) (stdout);
    TRACE_POP ("C_stdout");
    return L_Tmp0;
  }
}

/*
 * FUNCTION stdin
 */
extern_c gptr
C_stdin ()
{
  TRACE_PUSH ("C_stdin");
  {
    gptr L_Tmp0;
    L_Tmp0 = (gptr) (stdin);
    TRACE_POP ("C_stdin");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fwrite-str
 */
extern_c char
C_fwrite_str (FILE * L1_file, struct srg *L1_s)
{
  TRACE_PUSH ("C_fwrite_str");
  {

    if (!(L1_file))
      printf ("%s", (char *) ((L1_s)->data));
    else
      {
	fprintf ((FILE *) (L1_file), "%s", (char *) ((L1_s)->data));
	fflush ((FILE *) (L1_file));
      }
    TRACE_POP ("C_fwrite_str");
    return 0;
  }
}

/*
 * FUNCTION fprints
 */
extern_c char
C_fprints (FILE * L1_fw, struct srg *L1_s)
{
  TRACE_PUSH ("C_fprints");
  {
    char L_Tmp0;
    L_Tmp0 = (char) C_fwrite_str (L1_fw, L1_s);
    TRACE_POP ("C_fprints");
    return 0;
  }
}

/*
 * FUNCTION fopen
 */
extern_c gptr
C_fopen (struct srg * L1_filename, struct srg * L1_type)
{
  TRACE_PUSH ("C_fopen");
  {
    gptr L_Tmp0;
    L_Tmp0 = (gptr) (fopen ((L1_filename)->data, (L1_type)->data));
    TRACE_POP ("C_fopen");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fclose
 */
extern_c char
C_fclose (FILE * L1_file)
{
  TRACE_PUSH ("C_fclose");
  {
    if ((L1_file))
      fclose ((FILE *) (L1_file));
    TRACE_POP ("C_fclose");
    return 0;
  }
}

/*
 * FUNCTION popen
 */
extern_c gptr
C_popen (struct srg * L1_filename, struct srg * L1_type)
{
  TRACE_PUSH ("C_popen");
  {
    gptr L_Tmp0;
    L_Tmp0 = (gptr) (popen ((L1_filename)->data, (L1_type)->data));
    TRACE_POP ("C_popen");
    return L_Tmp0;
  }
}

/*
 * FUNCTION pclose
 */
extern_c char
C_pclose (FILE * L1_file)
{
  TRACE_PUSH ("C_pclose");
  {
    pclose ((FILE *) (L1_file));
    TRACE_POP ("C_pclose");
    return 0;
  }
}

/*
 * FUNCTION ftell
 */
extern_c real
C_ftell (FILE * L1_file)
{
  TRACE_PUSH ("C_ftell");
  {
    real L_Tmp0;
    {
      real L2_1_result;
      L2_1_result = 0;

#ifdef HAVE_FTELLO
      (L2_1_result) = (double) ftello ((FILE *) (L1_file));
#else
      (L2_1_result) = (double) ftell ((FILE *) (L1_file));
#endif
      L_Tmp0 = L2_1_result;
    }
    TRACE_POP ("C_ftell");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fseek
 */
extern_c char
C_fseek (FILE * L1_file, real L1_pos)
{
  TRACE_PUSH ("C_fseek");
  {

#ifdef HAVE_FSEEKO
    fseeko ((FILE *) (L1_file), (off_t) (L1_pos), SEEK_SET);
#else
    fseek ((FILE *) (L1_file), (long) (L1_pos), SEEK_SET);
#endif
    TRACE_POP ("C_fseek");
    return 0;
  }
}

/*
 * FUNCTION fseek-from-current
 */
extern_c char
C_fseek_from_current (FILE * L1_file, real L1_pos)
{
  TRACE_PUSH ("C_fseek_from_current");
  {

#ifdef HAVE_FSEEKO
    fseeko ((FILE *) (L1_file), (off_t) (L1_pos), SEEK_CUR);
#else
    fseek ((FILE *) (L1_file), (long) (L1_pos), SEEK_CUR);
#endif
    TRACE_POP ("C_fseek_from_current");
    return 0;
  }
}

/*
 * FUNCTION fseek-from-end
 */
extern_c char
C_fseek_from_end (FILE * L1_file, real L1_pos)
{
  TRACE_PUSH ("C_fseek_from_end");
  {

#ifdef HAVE_FSEEKO
    fseeko ((FILE *) (L1_file), (off_t) (L1_pos), SEEK_END);
#else
    fseek ((FILE *) (L1_file), (long) (L1_pos), SEEK_END);
#endif
    TRACE_POP ("C_fseek_from_end");
    return 0;
  }
}

/*
 * FUNCTION fgetc
 */
extern_c int
C_fgetc (FILE * L1_file)
{
  TRACE_PUSH ("C_fgetc");
  {
    int L_Tmp0;
    {
      int L2_1_result;
      L2_1_result = 0;
      (L2_1_result) = getc ((FILE *) (L1_file));
      L_Tmp0 = L2_1_result;
    }
    TRACE_POP ("C_fgetc");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fputc
 */
extern_c char
C_fputc (FILE * L1_file, int L1_val)
{
  TRACE_PUSH ("C_fputc");
  {
    putc ((char) (L1_val), (FILE *) (L1_file));
    TRACE_POP ("C_fputc");
    return 0;
  }
}

/*
 * FUNCTION fread-ubyte
 */
extern_c unsigned char
C_fread_ubyte (FILE * L1_file)
{
  TRACE_PUSH ("C_fread_ubyte");
  {
    unsigned char L_Tmp0;
    {
      unsigned char L2_1_val;
      L2_1_val = 0;
      (L2_1_val) = (unsigned char) getc ((FILE *) (L1_file));
      L_Tmp0 = L2_1_val;
    }
    TRACE_POP ("C_fread_ubyte");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fwrite-ubyte
 */
extern_c char
C_fwrite_ubyte (FILE * L1_file, unsigned char L1_val)
{
  TRACE_PUSH ("C_fwrite_ubyte");
  {
    putc ((L1_val), (FILE *) (L1_file));
    TRACE_POP ("C_fwrite_ubyte");
    return 0;
  }
}

/*
 * FUNCTION fread-byte
 */
extern_c char
C_fread_byte (FILE * L1_file)
{
  TRACE_PUSH ("C_fread_byte");
  {
    char L_Tmp0;
    {
      char L2_1_val;
      L2_1_val = 0;
      (L2_1_val) = (char) getc ((FILE *) (L1_file));
      L_Tmp0 = L2_1_val;
    }
    TRACE_POP ("C_fread_byte");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fwrite-byte
 */
extern_c char
C_fwrite_byte (FILE * L1_file, char L1_val)
{
  TRACE_PUSH ("C_fwrite_byte");
  {
    putc ((L1_val), (FILE *) (L1_file));
    TRACE_POP ("C_fwrite_byte");
    return 0;
  }
}

/*
 * FUNCTION fread-short
 */
extern_c short
C_fread_short (FILE * L1_file)
{
  TRACE_PUSH ("C_fread_short");
  {
    short L_Tmp0;
    {
      short L2_1_val;
      L2_1_val = 0;

      fread ((char *) &(L2_1_val), sizeof (short), 1, (FILE *) (L1_file));
      if (little_endian_p)
	C_reverse_n (&(L2_1_val), sizeof (short), 1);
      L_Tmp0 = L2_1_val;
    }
    TRACE_POP ("C_fread_short");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fwrite-short
 */
extern_c char
C_fwrite_short (FILE * L1_file, short L1_val)
{
  TRACE_PUSH ("C_fwrite_short");
  {
    {
      short s = (L1_val);
      if (little_endian_p)
	C_reverse_n (&s, sizeof (short), 1);
      fwrite ((char *) &s, sizeof (short), 1, (FILE *) (L1_file));
    }
    TRACE_POP ("C_fwrite_short");
    return 0;
  }
}

/*
 * FUNCTION fread-int
 */
extern_c int
C_fread_int (FILE * L1_file)
{
  TRACE_PUSH ("C_fread_int");
  {
    int L_Tmp0;
    {
      int L2_1_val;
      L2_1_val = 0;

      fread ((char *) &(L2_1_val), sizeof (int), 1, (FILE *) (L1_file));
      if (little_endian_p)
	C_reverse_n (&(L2_1_val), sizeof (int), 1);
      L_Tmp0 = L2_1_val;
    }
    TRACE_POP ("C_fread_int");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fwrite-int
 */
extern_c char
C_fwrite_int (FILE * L1_file, int L1_val)
{
  TRACE_PUSH ("C_fwrite_int");
  {
    {
      int s = (L1_val);
      if (little_endian_p)
	C_reverse_n (&s, sizeof (int), 1);
      fwrite ((char *) &s, sizeof (int), 1, (FILE *) (L1_file));
    }
    TRACE_POP ("C_fwrite_int");
    return 0;
  }
}

/*
 * FUNCTION fread-flt
 */
extern_c flt
C_fread_flt (FILE * L1_file)
{
  TRACE_PUSH ("C_fread_flt");
  {
    flt L_Tmp0;
    {
      flt L2_1_val;
      L2_1_val = 0;

      fread (&(L2_1_val), sizeof (flt), 1, (FILE *) (L1_file));
      if (little_endian_p)
	C_reverse_n (&(L2_1_val), sizeof (flt), 1);
      L_Tmp0 = L2_1_val;
    }
    TRACE_POP ("C_fread_flt");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fwrite-flt
 */
extern_c char
C_fwrite_flt (FILE * L1_file, flt L1_val)
{
  TRACE_PUSH ("C_fwrite_flt");
  {
    {
      float fl = (L1_val);
      if (little_endian_p)
	C_reverse_n (&fl, sizeof (flt), 1);
      fwrite ((char *) &fl, sizeof (flt), 1, (FILE *) (L1_file));
    }
    TRACE_POP ("C_fwrite_flt");
    return 0;
  }
}

/*
 * FUNCTION fread-real
 */
extern_c real
C_fread_real (FILE * L1_file)
{
  TRACE_PUSH ("C_fread_real");
  {
    real L_Tmp0;
    {
      real L2_1_val;
      L2_1_val = 0;

      fread (&(L2_1_val), sizeof (real), 1, (FILE *) (L1_file));
      if (little_endian_p)
	C_reverse_n (&(L2_1_val), sizeof (real), 1);
      L_Tmp0 = L2_1_val;
    }
    TRACE_POP ("C_fread_real");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fwrite-real
 */
extern_c char
C_fwrite_real (FILE * L1_file, real L1_val)
{
  TRACE_PUSH ("C_fwrite_real");
  {
    {
      real fl = (L1_val);
      if (little_endian_p)
	C_reverse_n (&fl, sizeof (real), 1);
      fwrite ((char *) &fl, sizeof (real), 1, (FILE *) (L1_file));
    }
    TRACE_POP ("C_fwrite_real");
    return 0;
  }
}

/*
 * FUNCTION fscan-int
 */
extern_c int
C_fscan_int (FILE * L1_fp)
{
  TRACE_PUSH ("C_fscan_int");
  {
    int L_Tmp0;
    {
      int L2_1_result;
      L2_1_result = 0;
      fscanf ((L1_fp), "%d", &(L2_1_result));
      L_Tmp0 = L2_1_result;
    }
    TRACE_POP ("C_fscan_int");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fscan-flt
 */
extern_c flt
C_fscan_flt (FILE * L1_fp)
{
  TRACE_PUSH ("C_fscan_flt");
  {
    flt L_Tmp0;
    {
      flt L2_1_result;
      L2_1_result = 0;
      fscanf ((L1_fp), "%f", &(L2_1_result));
      L_Tmp0 = L2_1_result;
    }
    TRACE_POP ("C_fscan_flt");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fscan-str
 */
extern_c struct srg *
C_fscan_str (FILE * L1_fp, struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_fscan_str");
  {
    struct srg *L_Tmp0;
    {
      struct srg *L2_1_result;
      Msrg_resize (L2_0_srg, 0 + 1);
      strcpy ((char *) ((L2_0_srg)->data), "");
      L2_1_result = L2_0_srg;
      {
	char buffer[1024];
	int s, size;
	s = fscanf ((L1_fp), "%s", buffer);
	if (s < 1)
	  {
	    buffer[0] = 0;
	  }
	size = strlen (buffer);
	Msrg_resize ((L2_1_result), size + 1);
	strcpy (STRING_DATA ((L2_1_result)), buffer);
      }
      L_Tmp0 = L2_1_result;
    }
    TRACE_POP ("C_fscan_str");
    return L_Tmp0;
  }
}

/*
 * FUNCTION fgets
 */
extern_c struct srg *
C_fgets (FILE * L1_fp, int L1_maxsize, struct srg *L2_0_srg)
{
  TRACE_PUSH ("C_fgets");
  {
    struct srg *L_Tmp0;
    {
      struct srg *L2_1_result;
      Msrg_resize (L2_0_srg, 0 + 1);
      strcpy ((char *) ((L2_0_srg)->data), "");
      L2_1_result = L2_0_srg;
      {
	char *buffer = malloc ((L1_maxsize));
	int size;
	fgets (buffer, (L1_maxsize), (L1_fp));
	size = strlen (buffer);
	Msrg_resize ((L2_1_result), size + 1);
	strcpy (STRING_DATA ((L2_1_result)), buffer);
	free (buffer);
      }
      L_Tmp0 = L2_1_result;
    }
    TRACE_POP ("C_fgets");
    return L_Tmp0;
  }
}

/*
 * FUNCTION file-size
 */
extern_c int
C_file_size (struct srg *L1_fname)
{
  TRACE_PUSH ("C_file_size");
  {
    int L_Tmp0;
    {
      int L2_1_ans;
      L2_1_ans = -1;
      {
	struct stat buf;
	if (stat ((L1_fname)->data, &buf) >= 0)
	  if (S_ISREG (buf.st_mode))
	    (L2_1_ans) = buf.st_size;
      }
      L_Tmp0 = L2_1_ans;
    }
    TRACE_POP ("C_file_size");
    return L_Tmp0;
  }
}

/*
 * FUNCTION rewind
 */
extern_c char
C_rewind (FILE * L1_f)
{
  TRACE_PUSH ("C_rewind");
  {
    rewind ((L1_f));
    TRACE_POP ("C_rewind");
    return 0;
  }
}

/*
 * FUNCTION skip-comments
 */
extern_c char
C_skip_comments (unsigned char L1_start, FILE * L1_f)
{
  TRACE_PUSH ("C_skip_comments");
  {
    if (!(L1_f))
      {
	run_time_error ("file is not opened");
      }
    {
      FILE *ff = (L1_f);
      int c;
      for (;;)
	{
	  c = getc (ff);
	  while (c == ' ' || c == '\n' || c == '\t' || c == '\r')
	    c = getc (ff);
	  if (c != (L1_start))
	    break;
	  while (c != '\n')
	    c = getc (ff);
	}
      ungetc (c, ff);
    }
    TRACE_POP ("C_skip_comments");
    return 0;
  }
}

/*
 * FUNCTION reverse2
 */
extern_c char
C_reverse2 (gptr L1_ptr, int L1_n)
{
  TRACE_PUSH ("C_reverse2");
  {
    char L_Tmp0;
    L_Tmp0 = (char) C_reverse_n (L1_ptr, 2, L1_n);
    TRACE_POP ("C_reverse2");
    return 0;
  }
}

/*
 * FUNCTION reverse4
 */
extern_c char
C_reverse4 (gptr L1_ptr, int L1_n)
{
  TRACE_PUSH ("C_reverse4");
  {
    char L_Tmp0;
    L_Tmp0 = (char) C_reverse_n (L1_ptr, 4, L1_n);
    TRACE_POP ("C_reverse4");
    return 0;
  }
}

/*
 * FUNCTION reverse8
 */
extern_c char
C_reverse8 (gptr L1_ptr, int L1_n)
{
  TRACE_PUSH ("C_reverse8");
  {
    char L_Tmp0;
    L_Tmp0 = (char) C_reverse_n (L1_ptr, 8, L1_n);
    TRACE_POP ("C_reverse8");
    return 0;
  }
}

/* ---------------------------------------- */

#ifndef NOLISP

/*
 * STUB reverse-n
 */
DH (X_reverse_n)
{
  dharg ret;
  ret.dh_char = C_reverse_n (a[1].dh_gptr, a[2].dh_int, a[3].dh_int);
  return ret;
}

/*
 * DHDOC reverse-n
 */
DHDOC (K_reverse_n_Rf4b65618, X_reverse_n, "C_reverse_n", 0, 0) =
{
DH_FUNC (3),
    DH_GPTR (0), DH_INT, DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB stdout
 */
DH (X_stdout)
{
  dharg ret;
  ret.dh_gptr = C_stdout ();
  return ret;
}

/*
 * DHDOC stdout
 */
DHDOC (K_stdout_R2400bd9d, X_stdout, "C_stdout", 0, 0) =
{
DH_FUNC (0), DH_RETURN, DH_GPTR (0), DH_END_FUNC, DH_NIL};

/*
 * STUB stdin
 */
DH (X_stdin)
{
  dharg ret;
  ret.dh_gptr = C_stdin ();
  return ret;
}

/*
 * DHDOC stdin
 */
DHDOC (K_stdin_R2400bd9d, X_stdin, "C_stdin", 0, 0) =
{
DH_FUNC (0), DH_RETURN, DH_GPTR (0), DH_END_FUNC, DH_NIL};

/*
 * STUB fwrite-str
 */
DH (X_fwrite_str)
{
  dharg ret;
  ret.dh_char = C_fwrite_str ((FILE *) a[1].dh_gptr, a[2].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC fwrite-str
 */
DHDOC (K_fwrite_str_R99463037, X_fwrite_str, "C_fwrite_str", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_STR, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fprints
 */
DH (X_fprints)
{
  dharg ret;
  ret.dh_char = C_fprints ((FILE *) a[1].dh_gptr, a[2].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC fprints
 */
DHDOC (K_fprints_R99463037, X_fprints, "C_fprints", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_STR, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fopen
 */
DH (X_fopen)
{
  dharg ret;
  ret.dh_gptr = C_fopen (a[1].dh_srg_ptr, a[2].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC fopen
 */
DHDOC (K_fopen_R1579e4ae, X_fopen, "C_fopen", 0, 0) =
{
DH_FUNC (2), DH_STR, DH_STR, DH_RETURN, DH_GPTR (0), DH_END_FUNC, DH_NIL};

/*
 * STUB fclose
 */
DH (X_fclose)
{
  dharg ret;
  ret.dh_char = C_fclose ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fclose
 */
DHDOC (K_fclose_Rc7df00c0, X_fclose, "C_fclose", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB popen
 */
DH (X_popen)
{
  dharg ret;
  ret.dh_gptr = C_popen (a[1].dh_srg_ptr, a[2].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC popen
 */
DHDOC (K_popen_R1579e4ae, X_popen, "C_popen", 0, 0) =
{
DH_FUNC (2), DH_STR, DH_STR, DH_RETURN, DH_GPTR (0), DH_END_FUNC, DH_NIL};

/*
 * STUB pclose
 */
DH (X_pclose)
{
  dharg ret;
  ret.dh_char = C_pclose ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC pclose
 */
DHDOC (K_pclose_Rc7df00c0, X_pclose, "C_pclose", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB ftell
 */
DH (X_ftell)
{
  dharg ret;
  ret.dh_real = C_ftell ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC ftell
 */
DHDOC (K_ftell_R455724ed, X_ftell, "C_ftell", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB fseek
 */
DH (X_fseek)
{
  dharg ret;
  ret.dh_char = C_fseek ((FILE *) a[1].dh_gptr, a[2].dh_real);
  return ret;
}

/*
 * DHDOC fseek
 */
DHDOC (K_fseek_R68c7db16, X_fseek, "C_fseek", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fseek-from-current
 */
DH (X_fseek_from_current)
{
  dharg ret;
  ret.dh_char = C_fseek_from_current ((FILE *) a[1].dh_gptr, a[2].dh_real);
  return ret;
}

/*
 * DHDOC fseek-from-current
 */
DHDOC (K_fseek_from_current_R68c7db16, X_fseek_from_current,
       "C_fseek_from_current", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fseek-from-end
 */
DH (X_fseek_from_end)
{
  dharg ret;
  ret.dh_char = C_fseek_from_end ((FILE *) a[1].dh_gptr, a[2].dh_real);
  return ret;
}

/*
 * DHDOC fseek-from-end
 */
DHDOC (K_fseek_from_end_R68c7db16, X_fseek_from_end, "C_fseek_from_end", 0,
       0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fgetc
 */
DH (X_fgetc)
{
  dharg ret;
  ret.dh_int = C_fgetc ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fgetc
 */
DHDOC (K_fgetc_R6d6f2621, X_fgetc, "C_fgetc", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB fputc
 */
DH (X_fputc)
{
  dharg ret;
  ret.dh_char = C_fputc ((FILE *) a[1].dh_gptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC fputc
 */
DHDOC (K_fputc_R2907cd77, X_fputc, "C_fputc", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fread-ubyte
 */
DH (X_fread_ubyte)
{
  dharg ret;
  ret.dh_uchar = C_fread_ubyte ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fread-ubyte
 */
DHDOC (K_fread_ubyte_R49f7a222, X_fread_ubyte, "C_fread_ubyte", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_UBYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB fwrite-ubyte
 */
DH (X_fwrite_ubyte)
{
  dharg ret;
  ret.dh_char = C_fwrite_ubyte ((FILE *) a[1].dh_gptr, a[2].dh_uchar);
  return ret;
}

/*
 * DHDOC fwrite-ubyte
 */
DHDOC (K_fwrite_ubyte_R0dc3ed6e, X_fwrite_ubyte, "C_fwrite_ubyte", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_UBYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fread-byte
 */
DH (X_fread_byte)
{
  dharg ret;
  ret.dh_char = C_fread_byte ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fread-byte
 */
DHDOC (K_fread_byte_Rc1efe952, X_fread_byte, "C_fread_byte", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_BYTE, DH_END_FUNC, DH_NIL};

/*
 * STUB fwrite-byte
 */
DH (X_fwrite_byte)
{
  dharg ret;
  ret.dh_char = C_fwrite_byte ((FILE *) a[1].dh_gptr, a[2].dh_char);
  return ret;
}

/*
 * DHDOC fwrite-byte
 */
DHDOC (K_fwrite_byte_R4d01b6ea, X_fwrite_byte, "C_fwrite_byte", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_BYTE, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fread-short
 */
DH (X_fread_short)
{
  dharg ret;
  ret.dh_short = C_fread_short ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fread-short
 */
DHDOC (K_fread_short_Redc7c667, X_fread_short, "C_fread_short", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_SHORT, DH_END_FUNC, DH_NIL};

/*
 * STUB fwrite-short
 */
DH (X_fwrite_short)
{
  dharg ret;
  ret.dh_char = C_fwrite_short ((FILE *) a[1].dh_gptr, a[2].dh_short);
  return ret;
}

/*
 * DHDOC fwrite-short
 */
DHDOC (K_fwrite_short_R2c40cf43, X_fwrite_short, "C_fwrite_short", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_SHORT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fread-int
 */
DH (X_fread_int)
{
  dharg ret;
  ret.dh_int = C_fread_int ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fread-int
 */
DHDOC (K_fread_int_R6d6f2621, X_fread_int, "C_fread_int", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB fwrite-int
 */
DH (X_fwrite_int)
{
  dharg ret;
  ret.dh_char = C_fwrite_int ((FILE *) a[1].dh_gptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC fwrite-int
 */
DHDOC (K_fwrite_int_R2907cd77, X_fwrite_int, "C_fwrite_int", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fread-flt
 */
DH (X_fread_flt)
{
  dharg ret;
  ret.dh_flt = C_fread_flt ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fread-flt
 */
DHDOC (K_fread_flt_R6fdf2221, X_fread_flt, "C_fread_flt", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB fwrite-flt
 */
DH (X_fwrite_flt)
{
  dharg ret;
  ret.dh_char = C_fwrite_flt ((FILE *) a[1].dh_gptr, a[2].dh_flt);
  return ret;
}

/*
 * DHDOC fwrite-flt
 */
DHDOC (K_fwrite_flt_R3c87ed77, X_fwrite_flt, "C_fwrite_flt", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_FLT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fread-real
 */
DH (X_fread_real)
{
  dharg ret;
  ret.dh_real = C_fread_real ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fread-real
 */
DHDOC (K_fread_real_R455724ed, X_fread_real, "C_fread_real", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_REAL, DH_END_FUNC, DH_NIL};

/*
 * STUB fwrite-real
 */
DH (X_fwrite_real)
{
  dharg ret;
  ret.dh_char = C_fwrite_real ((FILE *) a[1].dh_gptr, a[2].dh_real);
  return ret;
}

/*
 * DHDOC fwrite-real
 */
DHDOC (K_fwrite_real_R68c7db16, X_fwrite_real, "C_fwrite_real", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"), DH_REAL, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB fscan-int
 */
DH (X_fscan_int)
{
  dharg ret;
  ret.dh_int = C_fscan_int ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fscan-int
 */
DHDOC (K_fscan_int_R6d6f2621, X_fscan_int, "C_fscan_int", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB fscan-flt
 */
DH (X_fscan_flt)
{
  dharg ret;
  ret.dh_flt = C_fscan_flt ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC fscan-flt
 */
DHDOC (K_fscan_flt_R6fdf2221, X_fscan_flt, "C_fscan_flt", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_FLT, DH_END_FUNC, DH_NIL};

/*
 * STUB fscan-str
 */
DH (X_fscan_str)
{
  dharg ret;
  ret.dh_srg_ptr = C_fscan_str ((FILE *) a[1].dh_gptr, a[2].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC fscan-str
 */
DHDOC (K_fscan_str_R56b091a6, X_fscan_str, "C_fscan_str", 0, 0) =
{
DH_FUNC (1),
    DH_GPTR ("FILE *"),
    DH_TEMPS (1),
    DH_STR, DH_END_TEMPS, DH_RETURN, DH_STR, DH_END_FUNC, DH_NIL};

/*
 * STUB fgets
 */
DH (X_fgets)
{
  dharg ret;
  ret.dh_srg_ptr =
    C_fgets ((FILE *) a[1].dh_gptr, a[2].dh_int, a[3].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC fgets
 */
DHDOC (K_fgets_Rb8685c11, X_fgets, "C_fgets", 0, 0) =
{
DH_FUNC (2),
    DH_GPTR ("FILE *"),
    DH_INT,
    DH_TEMPS (1),
    DH_STR, DH_END_TEMPS, DH_RETURN, DH_STR, DH_END_FUNC, DH_NIL};

/*
 * STUB file-size
 */
DH (X_file_size)
{
  dharg ret;
  ret.dh_int = C_file_size (a[1].dh_srg_ptr);
  return ret;
}

/*
 * DHDOC file-size
 */
DHDOC (K_file_size_Red28b938, X_file_size, "C_file_size", 0, 0) =
{
DH_FUNC (1), DH_STR, DH_RETURN, DH_INT, DH_END_FUNC, DH_NIL};

/*
 * STUB rewind
 */
DH (X_rewind)
{
  dharg ret;
  ret.dh_char = C_rewind ((FILE *) a[1].dh_gptr);
  return ret;
}

/*
 * DHDOC rewind
 */
DHDOC (K_rewind_Rc7df00c0, X_rewind, "C_rewind", 0, 0) =
{
DH_FUNC (1), DH_GPTR ("FILE *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB skip-comments
 */
DH (X_skip_comments)
{
  dharg ret;
  ret.dh_char = C_skip_comments (a[1].dh_uchar, (FILE *) a[2].dh_gptr);
  return ret;
}

/*
 * DHDOC skip-comments
 */
DHDOC (K_skip_comments_R30852bae, X_skip_comments, "C_skip_comments", 0, 0) =
{
DH_FUNC (2),
    DH_UBYTE, DH_GPTR ("FILE *"), DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB reverse2
 */
DH (X_reverse2)
{
  dharg ret;
  ret.dh_char = C_reverse2 (a[1].dh_gptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC reverse2
 */
DHDOC (K_reverse2_R2907cd77, X_reverse2, "C_reverse2", 0, 0) =
{
DH_FUNC (2), DH_GPTR (0), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB reverse4
 */
DH (X_reverse4)
{
  dharg ret;
  ret.dh_char = C_reverse4 (a[1].dh_gptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC reverse4
 */
DHDOC (K_reverse4_R2907cd77, X_reverse4, "C_reverse4", 0, 0) =
{
DH_FUNC (2), DH_GPTR (0), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * STUB reverse8
 */
DH (X_reverse8)
{
  dharg ret;
  ret.dh_char = C_reverse8 (a[1].dh_gptr, a[2].dh_int);
  return ret;
}

/*
 * DHDOC reverse8
 */
DHDOC (K_reverse8_R2907cd77, X_reverse8, "C_reverse8", 0, 0) =
{
DH_FUNC (2), DH_GPTR (0), DH_INT, DH_RETURN, DH_NIL, DH_END_FUNC, DH_NIL};

/*
 * INIT FUNCTION
 */
extern_c void
init_stdio (void)
{
  dh_define ("reverse-n", &K_reverse_n_Rf4b65618);
  dh_define ("stdout", &K_stdout_R2400bd9d);
  dh_define ("stdin", &K_stdin_R2400bd9d);
  dh_define ("fwrite-str", &K_fwrite_str_R99463037);
  dh_define ("fprints", &K_fprints_R99463037);
  dh_define ("fopen", &K_fopen_R1579e4ae);
  dh_define ("fclose", &K_fclose_Rc7df00c0);
  dh_define ("popen", &K_popen_R1579e4ae);
  dh_define ("pclose", &K_pclose_Rc7df00c0);
  dh_define ("ftell", &K_ftell_R455724ed);
  dh_define ("fseek", &K_fseek_R68c7db16);
  dh_define ("fseek-from-current", &K_fseek_from_current_R68c7db16);
  dh_define ("fseek-from-end", &K_fseek_from_end_R68c7db16);
  dh_define ("fgetc", &K_fgetc_R6d6f2621);
  dh_define ("fputc", &K_fputc_R2907cd77);
  dh_define ("fread-ubyte", &K_fread_ubyte_R49f7a222);
  dh_define ("fwrite-ubyte", &K_fwrite_ubyte_R0dc3ed6e);
  dh_define ("fread-byte", &K_fread_byte_Rc1efe952);
  dh_define ("fwrite-byte", &K_fwrite_byte_R4d01b6ea);
  dh_define ("fread-short", &K_fread_short_Redc7c667);
  dh_define ("fwrite-short", &K_fwrite_short_R2c40cf43);
  dh_define ("fread-int", &K_fread_int_R6d6f2621);
  dh_define ("fwrite-int", &K_fwrite_int_R2907cd77);
  dh_define ("fread-flt", &K_fread_flt_R6fdf2221);
  dh_define ("fwrite-flt", &K_fwrite_flt_R3c87ed77);
  dh_define ("fread-real", &K_fread_real_R455724ed);
  dh_define ("fwrite-real", &K_fwrite_real_R68c7db16);
  dh_define ("fscan-int", &K_fscan_int_R6d6f2621);
  dh_define ("fscan-flt", &K_fscan_flt_R6fdf2221);
  dh_define ("fscan-str", &K_fscan_str_R56b091a6);
  dh_define ("fgets", &K_fgets_Rb8685c11);
  dh_define ("file-size", &K_file_size_Red28b938);
  dh_define ("rewind", &K_rewind_Rc7df00c0);
  dh_define ("skip-comments", &K_skip_comments_R30852bae);
  dh_define ("reverse2", &K_reverse2_R2907cd77);
  dh_define ("reverse4", &K_reverse4_R2907cd77);
  dh_define ("reverse8", &K_reverse8_R2907cd77);
}

int majver_stdio = 40;
int minver_stdio = 10;

#endif
