module memory/fixedSizeMemory [Addr, Data]

sig FixMemory {
	data: Addr -> one Data	
}

pred init [m: FixMemory] {
	// This predicate is empty in order to allow non-deterministic initialization
}

pred write [m, m': FixMemory, a: Addr, d: Data] {
	m'.data = m.data ++ a -> d
}

pred read [m: FixMemory, a: Addr, d: Data] {
	d = m.data [a]
}

fact Canonicalize {
	no disj m, m': FixMemory | m.data = m'.data
}
