/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java.util.BitSet;
import java.util.TreeSet;
import java_cup.CombRow;
import java_cup.Grammar;
import java_cup.lalr_state;

public class parse_reduce_table {
    public lalr_state[][] table;
    protected int _num_states;
    private int _num_nonterm;

    public parse_reduce_table(Grammar grammar) {
        this._num_states = grammar.lalr_states().size();
        this._num_nonterm = grammar.num_non_terminals();
        this.table = new lalr_state[this._num_states][this._num_nonterm];
    }

    public int num_states() {
        return this._num_states;
    }

    public short[] compress() {
        int n;
        BitSet bitSet = new BitSet();
        TreeSet<CombRow> treeSet = new TreeSet<CombRow>();
        for (int i = 0; i < this._num_states; ++i) {
            int n2 = 0;
            for (n = 0; n < this._num_nonterm; ++n) {
                if (this.table[i][n] == null) continue;
                ++n2;
            }
            if (n2 == 0) continue;
            bitSet.set(i);
            int[] nArray = new int[n2];
            n2 = 0;
            for (int j = 0; j < this._num_nonterm; ++j) {
                if (this.table[i][j] == null) continue;
                nArray[n2++] = j;
            }
            CombRow combRow = new CombRow(i, nArray);
            treeSet.add(combRow);
        }
        for (CombRow combRow : treeSet) {
            combRow.fitInComb(bitSet);
        }
        int n3 = bitSet.size();
        while (!bitSet.get(n3 - 1)) {
            --n3;
        }
        short[] sArray = new short[n3];
        for (n = 0; n < n3; ++n) {
            sArray[n] = 1;
        }
        for (CombRow combRow : treeSet) {
            int n4 = combRow.base;
            sArray[combRow.index] = (short)n4;
            for (int i = 0; i < combRow.comb.length; ++i) {
                sArray[n4 + combRow.comb[i]] = (short)this.table[combRow.index][combRow.comb[i]].index();
            }
        }
        return sArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-------- REDUCE_TABLE --------\n");
        for (int i = 0; i < this.num_states(); ++i) {
            stringBuilder.append("From state #").append(i).append("\n");
            int n = 0;
            for (int j = 0; j < this._num_nonterm; ++j) {
                lalr_state lalr_state2 = this.table[i][j];
                if (lalr_state2 == null) continue;
                stringBuilder.append(" [non term ").append(j).append("->");
                stringBuilder.append("state ").append(lalr_state2.index()).append("]");
                if (++n != 3) continue;
                stringBuilder.append("\n");
                n = 0;
            }
            if (n == 0) continue;
            stringBuilder.append("\n");
        }
        stringBuilder.append("-----------------------------");
        return stringBuilder.toString();
    }
}

