/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

public class IntAllocator {
    private IntervalNode mRoot;

    public IntAllocator(int low, int up) {
        this.mRoot = new IntervalNode(low, up);
    }

    public boolean isEmpty() {
        return this.mRoot == null;
    }

    public int alloc() {
        if (this.mRoot.mLow == this.mRoot.mUp) {
            throw new RuntimeException("Allocation on empty IntAllocator");
        }
        IntervalNode allocNode = this.mRoot;
        IntervalNode parent = null;
        while (allocNode.mLeft != null) {
            parent = allocNode;
            allocNode = allocNode.mLeft;
        }
        int res = allocNode.mLow++;
        if (allocNode.mLow == allocNode.mUp) {
            if (parent == null) {
                this.mRoot = allocNode.mRight;
            } else {
                parent.mLeft = allocNode.mRight;
            }
        }
        return res;
    }

    public int[] alloc(int n) {
        int[] res = new int[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.alloc();
        }
        return res;
    }

    public void free(int val) {
        if (this.mRoot != null) {
            IntervalNode insert = this.mRoot;
            while (true) {
                if (val + 1 == insert.mLow) {
                    insert.mLow = val;
                    this.joinLeft(insert);
                    return;
                }
                if (val == insert.mUp) {
                    ++insert.mUp;
                    this.joinRight(insert);
                    return;
                }
                if (val < insert.mLow) {
                    if (insert.mLeft == null) {
                        insert.mLeft = new IntervalNode(val, val + 1);
                        return;
                    }
                    insert = insert.mLeft;
                    continue;
                }
                if (insert.mRight == null) {
                    insert.mRight = new IntervalNode(val, val + 1);
                    return;
                }
                insert = insert.mRight;
            }
        }
        this.mRoot = new IntervalNode(val, val + 1);
    }

    public void free(int[] vals) {
        for (int val : vals) {
            this.free(val);
        }
    }

    private void joinLeft(IntervalNode insert) {
        IntervalNode prev = insert.mLeft;
        if (prev == null) {
            return;
        }
        IntervalNode parent = insert;
        while (prev.mRight != null) {
            parent = prev;
            prev = prev.mRight;
        }
        if (insert.mLow == prev.mUp) {
            insert.mLow = prev.mLow;
            if (parent == insert) {
                parent.mLeft = prev.mLeft;
            } else {
                parent.mRight = prev.mLeft;
            }
        }
    }

    private void joinRight(IntervalNode insert) {
        IntervalNode next = insert.mRight;
        if (next == null) {
            return;
        }
        IntervalNode parent = insert;
        while (next.mLeft != null) {
            parent = next;
            next = next.mLeft;
        }
        if (insert.mUp == next.mLow) {
            insert.mUp = next.mUp;
            if (parent == insert) {
                parent.mRight = next.mRight;
            } else {
                parent.mLeft = next.mRight;
            }
        }
    }

    public int peekLast() {
        if (this.mRoot.mLow == this.mRoot.mUp) {
            return this.mRoot.mLow - 1;
        }
        IntervalNode allocNode = this.mRoot;
        while (allocNode.mRight != null) {
            allocNode = allocNode.mRight;
        }
        return allocNode.mLow - 1;
    }

    private static class IntervalNode {
        int mLow;
        int mUp;
        IntervalNode mLeft;
        IntervalNode mRight;

        public IntervalNode(int low, int up) {
            this.mLow = low;
            this.mUp = up;
            this.mRight = null;
            this.mLeft = null;
        }
    }
}

