/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DAGSize
extends NonRecursive {
    private Set<Term> mSeen = new HashSet<Term>();
    private int mSize = 0;

    public void reset() {
        super.reset();
        this.mSeen.clear();
        this.mSize = 0;
    }

    public int size(Term term) {
        this.run(new TermOnceWalker(new FormulaUnLet().unlet(term)));
        return this.mSize;
    }

    public int treesize(Term term) {
        Set<Term> old = this.mSeen;
        this.mSeen = ConstantEmptySet.EMPTY;
        this.run(new TermOnceWalker(new FormulaUnLet().unlet(term)));
        this.mSeen = old;
        return this.mSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstantEmptySet
    extends AbstractSet<Term> {
        private static final Set<Term> EMPTY = new ConstantEmptySet();

        private ConstantEmptySet() {
        }

        @Override
        public Iterator<Term> iterator() {
            return Collections.emptySet().iterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean add(Term e) {
            return true;
        }
    }

    private class TermOnceWalker
    extends NonRecursive.TermWalker {
        public TermOnceWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker) {
            if (DAGSize.this.mSeen.add(this.mTerm)) {
                ++DAGSize.this.mSize;
                super.walk(walker);
            }
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new TermOnceWalker(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            for (Term t : term.getParameters()) {
                walker.enqueueWalker(new TermOnceWalker(t));
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Input should be unletted");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            walker.enqueueWalker(new TermOnceWalker(term.getSubformula()));
        }

        public void walk(NonRecursive walker, TermVariable term) {
        }
    }
}

