/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.MutableRational;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableInfinitNumber;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinVar
implements Comparable<LinVar> {
    Object mName;
    LAReason mUpper;
    LAReason mLower;
    InfinitNumber mCurval;
    boolean mIsInt;
    NavigableMap<InfinitNumber, BoundConstraint> mConstraints = new TreeMap<InfinitNumber, BoundConstraint>();
    NavigableMap<InfinitNumber, LAEquality> mEqualities = new TreeMap<InfinitNumber, LAEquality>();
    Map<Rational, LAEquality> mDisequalities;
    boolean mBasic;
    final int mMatrixpos;
    int mNumcuts = 0;
    MatrixEntry mHeadEntry;
    int mNumUpperInf;
    int mNumLowerInf;
    int mNumUpperEps;
    int mNumLowerEps;
    private MutableRational mUpperComposite = new MutableRational(Rational.ZERO);
    private MutableRational mLowerComposite = new MutableRational(Rational.ZERO);
    LinVar[] mCachedRowVars;
    Rational[] mCachedRowCoeffs;
    int mAssertionstacklevel;
    boolean mDead = false;
    int mChainlength;
    static final LinVar DUMMY_LINVAR = new LinVar();

    private LinVar() {
        this.mName = "Dummy";
        this.mMatrixpos = Integer.MAX_VALUE;
    }

    public LinVar(Object name, boolean isint, int assertionstacklevel, int num) {
        this.mName = name;
        this.mCurval = InfinitNumber.ZERO;
        this.mIsInt = isint;
        this.mBasic = false;
        this.mMatrixpos = num;
        this.mHeadEntry = new MatrixEntry();
        this.mHeadEntry.mColumn = this;
        this.mHeadEntry.mRow = DUMMY_LINVAR;
        this.mHeadEntry.mPrevInCol = this.mHeadEntry;
        this.mHeadEntry.mNextInCol = this.mHeadEntry;
        this.mAssertionstacklevel = assertionstacklevel;
        this.mChainlength = 0;
    }

    public final InfinitNumber getUpperBound() {
        return this.mUpper == null ? InfinitNumber.POSITIVE_INFINITY : this.mUpper.getBound();
    }

    public final InfinitNumber getLowerBound() {
        return this.mLower == null ? InfinitNumber.NEGATIVE_INFINITY : this.mLower.getBound();
    }

    public InfinitNumber getExactUpperBound() {
        return this.mUpper == null ? InfinitNumber.POSITIVE_INFINITY : this.mUpper.getExactBound();
    }

    public InfinitNumber getExactLowerBound() {
        return this.mLower == null ? InfinitNumber.NEGATIVE_INFINITY : this.mLower.getExactBound();
    }

    public final boolean hasUpperBound() {
        return this.mUpper != null;
    }

    public final boolean hasLowerBound() {
        return this.mLower != null;
    }

    public final boolean isIncrementPossible() {
        assert (!this.mBasic);
        return this.mCurval.less(this.getUpperBound());
    }

    public final boolean isDecrementPossible() {
        assert (!this.mBasic);
        return this.getLowerBound().less(this.mCurval);
    }

    public String toString() {
        return this.mName.toString();
    }

    public boolean isInitiallyBasic() {
        return this.mName instanceof LinTerm;
    }

    public int hashCode() {
        return this.mMatrixpos;
    }

    @Override
    public final int compareTo(LinVar o) {
        return this.mMatrixpos - o.mMatrixpos;
    }

    public boolean outOfBounds() {
        if (this.mUpper instanceof LiteralReason || this.isInt() && this.mUpper != null) {
            if (this.mCurval.mA.equals(this.mUpper.getExactBound().mA)) {
                this.fixEpsilon();
            }
            if (this.mUpper.getExactBound().less(this.mCurval)) {
                return true;
            }
        }
        if (this.mLower instanceof LiteralReason || this.isInt() && this.mLower != null) {
            if (this.mCurval.mA.equals(this.mLower.getExactBound().mA)) {
                this.fixEpsilon();
            }
            if (this.mCurval.less(this.mLower.getExactBound())) {
                return true;
            }
        }
        return false;
    }

    void addDiseq(LAEquality ea) {
        if (this.mDisequalities == null) {
            this.mDisequalities = new HashMap<Rational, LAEquality>();
        }
        if (!this.mDisequalities.containsKey(ea.getBound())) {
            this.mDisequalities.put(ea.getBound(), ea);
        }
    }

    void removeDiseq(LAEquality ea) {
        if (this.mDisequalities != null && this.mDisequalities.get(ea.getBound()) == ea) {
            this.mDisequalities.remove(ea.getBound());
        }
    }

    LAEquality getDiseq(Rational bound) {
        if (this.mDisequalities != null) {
            return this.mDisequalities.get(bound);
        }
        return null;
    }

    public void addEquality(LAEquality ea) {
        this.mEqualities.put(new InfinitNumber(ea.getBound(), 0), ea);
    }

    boolean unconstrained() {
        return this.mConstraints.isEmpty() && this.mEqualities.isEmpty();
    }

    boolean isCurrentlyUnconstrained() {
        return this.mLower == null && this.mUpper == null;
    }

    public boolean isInt() {
        return this.mIsInt;
    }

    public InfinitNumber getEpsilon() {
        return this.mIsInt ? InfinitNumber.ONE : InfinitNumber.EPSILON;
    }

    public final void moveBounds(LinVar other) {
        this.mNumUpperInf = other.mNumUpperInf;
        this.mNumLowerInf = other.mNumLowerInf;
        this.mNumUpperEps = other.mNumUpperEps;
        this.mNumLowerEps = other.mNumLowerEps;
        this.mUpperComposite = other.mUpperComposite;
        this.mLowerComposite = other.mLowerComposite;
        other.mUpperComposite = null;
        other.mLowerComposite = null;
    }

    public void mulUpperLower(Rational r) {
        this.mUpperComposite.mul(r);
        this.mLowerComposite.mul(r);
    }

    public final void updateUpper(BigInteger coeff, InfinitNumber oldBound, InfinitNumber newBound) {
        if (oldBound.isInfinity()) {
            if (newBound.isInfinity()) {
                return;
            }
            --this.mNumUpperInf;
            this.mUpperComposite.addmul(newBound.mA, coeff);
        } else if (newBound.isInfinity()) {
            ++this.mNumUpperInf;
            this.mUpperComposite.addmul(oldBound.mA.negate(), coeff);
        } else {
            this.mUpperComposite.addmul(newBound.mA.sub(oldBound.mA), coeff);
        }
        this.mNumUpperEps += (newBound.mEps - oldBound.mEps) * coeff.signum();
    }

    public final void updateLower(BigInteger coeff, InfinitNumber oldBound, InfinitNumber newBound) {
        if (oldBound.isInfinity()) {
            if (newBound.isInfinity()) {
                return;
            }
            --this.mNumLowerInf;
            this.mLowerComposite.addmul(newBound.mA, coeff);
        } else if (newBound.isInfinity()) {
            ++this.mNumLowerInf;
            this.mLowerComposite.addmul(oldBound.mA.negate(), coeff);
        } else {
            this.mLowerComposite.addmul(newBound.mA.sub(oldBound.mA), coeff);
        }
        this.mNumLowerEps += (newBound.mEps - oldBound.mEps) * coeff.signum();
    }

    public void updateUpperLowerSet(BigInteger coeff, LinVar nb) {
        InfinitNumber ubound = nb.getUpperBound();
        InfinitNumber lbound = nb.getLowerBound();
        if (coeff.signum() < 0) {
            InfinitNumber swap = ubound;
            ubound = lbound;
            lbound = swap;
        }
        if (ubound.isInfinity()) {
            ++this.mNumUpperInf;
        } else {
            this.mUpperComposite.addmul(ubound.mA, coeff);
        }
        this.mNumUpperEps += ubound.mEps * coeff.signum();
        if (lbound.isInfinity()) {
            ++this.mNumLowerInf;
        } else {
            this.mLowerComposite.addmul(lbound.mA, coeff);
        }
        this.mNumLowerEps += lbound.mEps * coeff.signum();
    }

    public void updateUpperLowerClear(BigInteger coeff, LinVar nb) {
        InfinitNumber ubound = nb.getUpperBound().negate();
        InfinitNumber lbound = nb.getLowerBound().negate();
        if (coeff.signum() < 0) {
            InfinitNumber swap = ubound;
            ubound = lbound;
            lbound = swap;
        }
        if (ubound.isInfinity()) {
            --this.mNumUpperInf;
        } else {
            this.mUpperComposite.addmul(ubound.mA, coeff);
        }
        this.mNumUpperEps += ubound.mEps * coeff.signum();
        if (lbound.isInfinity()) {
            --this.mNumLowerInf;
        } else {
            this.mLowerComposite.addmul(lbound.mA, coeff);
        }
        this.mNumLowerEps += lbound.mEps * coeff.signum();
    }

    public InfinitNumber getUpperComposite() {
        if (this.mHeadEntry.mCoeff.signum() < 0) {
            if (this.mNumUpperInf != 0) {
                return InfinitNumber.POSITIVE_INFINITY;
            }
            Rational denom = this.mUpperComposite.toRational().mul(Rational.valueOf(BigInteger.valueOf(-1L), this.mHeadEntry.mCoeff));
            return new InfinitNumber(denom, InfinitNumber.normEpsilon(this.mNumUpperEps));
        }
        if (this.mNumLowerInf != 0) {
            return InfinitNumber.POSITIVE_INFINITY;
        }
        Rational denom = this.mLowerComposite.toRational().mul(Rational.valueOf(BigInteger.valueOf(-1L), this.mHeadEntry.mCoeff));
        return new InfinitNumber(denom, -InfinitNumber.normEpsilon(this.mNumLowerEps));
    }

    public InfinitNumber getLowerComposite() {
        if (this.mHeadEntry.mCoeff.signum() < 0) {
            if (this.mNumLowerInf != 0) {
                return InfinitNumber.NEGATIVE_INFINITY;
            }
            Rational denom = this.mLowerComposite.toRational().mul(Rational.valueOf(BigInteger.valueOf(-1L), this.mHeadEntry.mCoeff));
            return new InfinitNumber(denom, InfinitNumber.normEpsilon(this.mNumLowerEps));
        }
        if (this.mNumUpperInf != 0) {
            return InfinitNumber.NEGATIVE_INFINITY;
        }
        Rational denom = this.mUpperComposite.toRational().mul(Rational.valueOf(BigInteger.valueOf(-1L), this.mHeadEntry.mCoeff));
        return new InfinitNumber(denom, -InfinitNumber.normEpsilon(this.mNumUpperEps));
    }

    void resetComposites() {
        this.mLowerComposite.setValue(Rational.ZERO);
        this.mUpperComposite.setValue(Rational.ZERO);
        this.mNumUpperInf = 0;
        this.mNumLowerInf = 0;
        this.mNumUpperEps = 0;
        this.mNumLowerEps = 0;
        this.mCachedRowCoeffs = null;
        this.mCachedRowVars = null;
    }

    public Map<LinVar, BigInteger> getLinTerm() {
        return ((LinTerm)this.mName).mCoeffs;
    }

    public SharedTerm getSharedTerm() {
        return (SharedTerm)this.mName;
    }

    public int getAssertionStackLevel() {
        return this.mAssertionstacklevel;
    }

    public boolean checkBrpCounters() {
        assert (this.mBasic);
        int cntLower = 0;
        int cntLowerEps = 0;
        int cntUpper = 0;
        int cntUpperEps = 0;
        MutableInfinitNumber value = new MutableInfinitNumber();
        MutableInfinitNumber lbound = new MutableInfinitNumber();
        MutableInfinitNumber ubound = new MutableInfinitNumber();
        MatrixEntry entry = this.mHeadEntry.mNextInRow;
        while (entry != this.mHeadEntry) {
            value.addmul(entry.mColumn.mCurval, entry.mCoeff);
            if (entry.mCoeff.signum() < 0) {
                if (entry.mColumn.hasUpperBound()) {
                    lbound.addmul(entry.mColumn.getUpperBound(), entry.mCoeff);
                } else {
                    ++cntLower;
                }
                cntLowerEps -= entry.mColumn.getUpperBound().mEps;
                if (entry.mColumn.hasLowerBound()) {
                    ubound.addmul(entry.mColumn.getLowerBound(), entry.mCoeff);
                } else {
                    ++cntUpper;
                }
                cntUpperEps -= entry.mColumn.getLowerBound().mEps;
            } else {
                if (entry.mColumn.hasUpperBound()) {
                    ubound.addmul(entry.mColumn.getUpperBound(), entry.mCoeff);
                } else {
                    ++cntUpper;
                }
                cntUpperEps += entry.mColumn.getUpperBound().mEps;
                if (entry.mColumn.hasLowerBound()) {
                    lbound.addmul(entry.mColumn.getLowerBound(), entry.mCoeff);
                } else {
                    ++cntLower;
                }
                cntLowerEps += entry.mColumn.getLowerBound().mEps;
            }
            entry = entry.mNextInRow;
        }
        value = value.div(Rational.valueOf(this.mHeadEntry.mCoeff.negate(), BigInteger.ONE));
        assert (cntLower == this.mNumLowerInf && cntUpper == this.mNumUpperInf);
        assert (lbound.mA.equals(this.mLowerComposite));
        assert (lbound.mEps == InfinitNumber.normEpsilon(this.mNumLowerEps));
        assert (cntLowerEps == this.mNumLowerEps);
        assert (ubound.mA.equals(this.mUpperComposite));
        assert (ubound.mEps == InfinitNumber.normEpsilon(this.mNumUpperEps));
        assert (cntUpperEps == this.mNumUpperEps);
        assert (value.mA.equals(this.mCurval.mA));
        return true;
    }

    public boolean checkCoeffChain() {
        if (!this.mBasic) {
            return true;
        }
        assert (this.mHeadEntry.mRow == this.mHeadEntry.mColumn);
        MutableAffinTerm mat = new MutableAffinTerm();
        MatrixEntry entry = this.mHeadEntry;
        do {
            assert (entry.mRow == this);
            assert (entry.mRow == entry.mColumn || !entry.mColumn.mBasic);
            assert (entry.mNextInRow.mPrevInRow == entry);
            mat.add(Rational.valueOf(entry.mCoeff, BigInteger.ONE), entry.mColumn);
        } while ((entry = entry.mNextInRow) != this.mHeadEntry);
        assert (mat.isConstant() && mat.getConstant().equals(InfinitNumber.ZERO));
        return true;
    }

    public boolean isFixed() {
        return this.mUpper != null && this.mLower != null && this.mUpper.getBound().equals(this.mLower.getBound());
    }

    boolean checkChainlength() {
        if (this.mBasic) {
            int length = 0;
            MatrixEntry entry = this.mHeadEntry.mNextInRow;
            while (entry != this.mHeadEntry) {
                ++length;
                entry = entry.mNextInRow;
            }
            assert (length == this.mChainlength);
        } else {
            int length = 0;
            MatrixEntry entry = this.mHeadEntry.mNextInCol;
            while (entry != this.mHeadEntry) {
                ++length;
                entry = entry.mNextInCol;
            }
            assert (length == this.mChainlength);
        }
        return true;
    }

    public Rational computeEpsilon() {
        if (!this.mBasic) {
            return Rational.valueOf(this.mCurval.mEps, 1L);
        }
        BigInteger epsilons = BigInteger.ZERO;
        MatrixEntry entry = this.mHeadEntry.mNextInRow;
        while (entry != this.mHeadEntry) {
            int eps = entry.mColumn.mCurval.mEps;
            if (eps > 0) {
                epsilons = epsilons.subtract(entry.mCoeff);
            } else if (eps < 0) {
                epsilons = epsilons.add(entry.mCoeff);
            }
            entry = entry.mNextInRow;
        }
        return Rational.valueOf(epsilons, this.mHeadEntry.mCoeff);
    }

    public void fixEpsilon() {
        if (this.mBasic) {
            BigInteger epsilons = BigInteger.ZERO;
            MatrixEntry entry = this.mHeadEntry.mNextInRow;
            while (entry != this.mHeadEntry) {
                int eps = entry.mColumn.mCurval.mEps;
                if (eps > 0) {
                    epsilons = epsilons.subtract(entry.mCoeff);
                } else if (eps < 0) {
                    epsilons = epsilons.add(entry.mCoeff);
                }
                entry = entry.mNextInRow;
            }
            this.mCurval = new InfinitNumber(this.mCurval.mA, epsilons.signum() * this.mHeadEntry.mCoeff.signum());
        }
    }

    public LAEquality getEquality(InfinitNumber bound) {
        return (LAEquality)this.mEqualities.get(bound);
    }

    public boolean isAlive() {
        return !this.mDead;
    }
}

