/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public class BoundConstraint
extends DPLLAtom {
    final InfinitNumber mBound;
    final InfinitNumber mIBound;
    final LinVar mVar;

    public BoundConstraint(InfinitNumber bound, LinVar var, int assertionstacklevel) {
        super(HashUtils.hashJenkins(var.hashCode(), (Object)bound), assertionstacklevel);
        assert (bound.mEps <= 0);
        assert (!var.mIsInt || bound.isIntegral());
        this.mBound = bound;
        this.mIBound = bound.add(var.getEpsilon());
        assert (!this.mBound.equals(this.mIBound));
        this.mVar = var;
        assert (!this.mVar.mConstraints.containsKey(bound));
        this.mVar.mConstraints.put(bound, this);
    }

    public LinVar getVar() {
        return this.mVar;
    }

    public InfinitNumber getBound() {
        return this.mBound;
    }

    public InfinitNumber getInverseBound() {
        return this.mIBound;
    }

    public String toStringNegated() {
        InfinitNumber ibound = this.getInverseBound();
        if (ibound.mEps > 0) {
            return "[" + this.hashCode() + "]" + this.mVar + " > " + ibound.mA;
        }
        return "[" + this.hashCode() + "]" + this.mVar + " >= " + ibound;
    }

    public String toString() {
        if (this.mBound.mEps < 0) {
            return "[" + this.hashCode() + "]" + this.mVar + " < " + this.mBound.mA;
        }
        return "[" + this.hashCode() + "]" + this.mVar + " <= " + this.mBound;
    }

    boolean impliedByUpperBound(InfinitNumber ubound) {
        return ubound.lesseq(this.mBound);
    }

    boolean impliedByLowerBound(InfinitNumber lbound) {
        return this.getInverseBound().lesseq(lbound);
    }

    public Term getSMTFormula(Theory smtTheory, boolean quoted) {
        MutableAffinTerm at = new MutableAffinTerm();
        at.add(Rational.ONE, this.mVar);
        at.add(this.mBound.negate());
        return at.toSMTLibLeq0(smtTheory, quoted);
    }

    public boolean equals(Object other) {
        if (other instanceof BoundConstraint) {
            BoundConstraint o = (BoundConstraint)other;
            return o.mVar == this.mVar && o.mBound.equals(this.mBound);
        }
        return false;
    }
}

