/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakCongruencePath
extends CongruencePath {
    final ArrayTheory mArrayTheory;

    public WeakCongruencePath(ArrayTheory arrayTheory) {
        super(arrayTheory.getCClosure());
        this.mArrayTheory = arrayTheory;
    }

    private CCEquality createEquality(CCTerm t1, CCTerm t2) {
        EqualityProxy ep = t1.getFlatTerm().createEquality(t2.getFlatTerm());
        if (ep == EqualityProxy.getFalseProxy()) {
            return null;
        }
        DPLLAtom res = ep.getLiteral();
        if (res instanceof CCEquality) {
            return (CCEquality)res;
        }
        return ep.createCCEquality(t1.getFlatTerm(), t2.getFlatTerm());
    }

    public Clause computeSelectOverWeakEQ(CCAppTerm select1, CCAppTerm select2, boolean produceProofs) {
        CCEquality eq = this.createEquality(select1, select2);
        CCTerm i1 = select1.getArg();
        CCTerm i2 = select2.getArg();
        CCTerm a = ((CCAppTerm)select1.getFunc()).getArg();
        CCTerm b = ((CCAppTerm)select2.getFunc()).getArg();
        CongruencePath.SubPath indexPath = this.computePath(i1, i2);
        WeakSubPath weakPath = this.computeWeakPath(a, b, i1, produceProofs);
        this.mAllPaths.addFirst(weakPath);
        if (indexPath != null) {
            this.mAllPaths.addFirst(indexPath);
        }
        return this.generateClause(eq, produceProofs, ArrayAnnotation.RuleKind.READ_OVER_WEAKEQ);
    }

    public Clause computeWeakeqExt(CCTerm a, CCTerm b, boolean produceProofs) {
        assert (a != b);
        CCEquality eq = this.createEquality(a, b);
        HashSet<CCTerm> storeIndices = new HashSet<CCTerm>();
        Cursor start = new Cursor(a, this.mArrayTheory.mCongRoots.get(a.getRepresentative()));
        Cursor dest = new Cursor(b, this.mArrayTheory.mCongRoots.get(b.getRepresentative()));
        CongruencePath.SubPath path = this.collectPathNoSelect(start, dest, storeIndices, produceProofs);
        for (CCTerm idx : storeIndices) {
            WeakSubPath weakpath = this.computeWeakPathWithModulo(a, b, idx, produceProofs);
            this.mAllPaths.addFirst(weakpath);
        }
        this.mAllPaths.addFirst(path);
        return this.generateClause(eq, produceProofs, ArrayAnnotation.RuleKind.WEAKEQ_EXT);
    }

    private WeakSubPath computeWeakPath(CCTerm ccArray1, CCTerm ccArray2, CCTerm index, boolean produceProofs) {
        int count1;
        HashSet<CCTerm> storeIndices = new HashSet<CCTerm>();
        CCTerm indexRep = index.getRepresentative();
        Cursor cursor1 = new Cursor(ccArray1, this.mArrayTheory.mCongRoots.get(ccArray1.getRepresentative()));
        Cursor cursor2 = new Cursor(ccArray2, this.mArrayTheory.mCongRoots.get(ccArray2.getRepresentative()));
        WeakSubPath sub1 = new WeakSubPath(index, ccArray1, produceProofs);
        WeakSubPath sub2 = new WeakSubPath(index, ccArray2, produceProofs);
        assert (cursor1.mArrayNode.getWeakIRepresentative(indexRep) == cursor2.mArrayNode.getWeakIRepresentative(indexRep));
        int count2 = cursor2.mArrayNode.countSelectEdges(indexRep);
        for (count1 = cursor1.mArrayNode.countSelectEdges(indexRep); count1 > count2; --count1) {
            this.collectPathOneSelect(cursor1, sub1, storeIndices, produceProofs);
        }
        while (count2 > count1) {
            this.collectPathOneSelect(cursor2, sub2, storeIndices, produceProofs);
            --count2;
        }
        while (cursor1.mArrayNode.findSelectNode(indexRep) != cursor2.mArrayNode.findSelectNode(indexRep)) {
            this.collectPathOneSelect(cursor1, sub1, storeIndices, produceProofs);
            this.collectPathOneSelect(cursor2, sub2, storeIndices, produceProofs);
        }
        sub1.addSubPath(this.collectPathNoSelect(cursor1, cursor2, storeIndices, produceProofs));
        sub1.addSubPath(sub2);
        for (CCTerm storeIdx : storeIndices) {
            this.computeIndexDiseq(index, storeIdx);
        }
        return sub1;
    }

    private WeakSubPath computeWeakPathWithModulo(CCTerm array1, CCTerm array2, CCTerm index, boolean produceProofs) {
        ArrayTheory.ArrayNode rep2;
        CCTerm indexRep = index.getRepresentative();
        ArrayTheory.ArrayNode node1 = this.mArrayTheory.mCongRoots.get(array1.getRepresentative());
        ArrayTheory.ArrayNode node2 = this.mArrayTheory.mCongRoots.get(array2.getRepresentative());
        ArrayTheory.ArrayNode rep1 = node1.getWeakIRepresentative(indexRep);
        if (rep1 == (rep2 = node2.getWeakIRepresentative(indexRep))) {
            return this.computeWeakPath(array1, array2, index, produceProofs);
        }
        CCAppTerm select1 = rep1.mSelects.get(indexRep);
        CCAppTerm select2 = rep2.mSelects.get(indexRep);
        assert (select1.getRepresentative() == select2.getRepresentative());
        CongruencePath.SubPath indexPath = this.computePath(index, ArrayTheory.getIndexFromSelect(select1));
        if (indexPath != null) {
            this.mAllPaths.addFirst(indexPath);
        }
        if ((indexPath = this.computePath(index, ArrayTheory.getIndexFromSelect(select2))) != null) {
            this.mAllPaths.addFirst(indexPath);
        }
        this.mAllPaths.addFirst(this.computePath(select1, select2));
        CCTerm selArray1 = ArrayTheory.getArrayFromSelect(select1);
        CCTerm selArray2 = ArrayTheory.getArrayFromSelect(select2);
        WeakSubPath weakpath = this.computeWeakPath(array1, selArray1, index, produceProofs);
        weakpath.addEntry(selArray2, null);
        weakpath.addSubPath(this.computeWeakPath(array2, selArray2, index, produceProofs));
        return weakpath;
    }

    public void collectPathOneStore(Cursor cursor, CongruencePath.SubPath path, HashSet<CCTerm> storeIndices) {
        CCAppTerm store;
        ArrayTheory.ArrayNode node = cursor.mArrayNode;
        CCTerm t1 = store = node.mStoreReason;
        CCTerm t2 = ArrayTheory.getArrayFromStore(store);
        if (t2.mRepStar == cursor.mArrayNode.mTerm) {
            CCTerm t = t2;
            t2 = t1;
            t1 = t;
        }
        assert (t1.mRepStar == node.mTerm);
        assert (t2.mRepStar == node.mStoreEdge.mTerm);
        path.addSubPath(this.computePath(cursor.mTerm, t1));
        path.addEntry(t2, null);
        cursor.update(t2, node.mStoreEdge);
        storeIndices.add(ArrayTheory.getIndexFromStore(store));
    }

    private CongruencePath.SubPath collectPathNoSelect(Cursor start, Cursor dest, HashSet<CCTerm> storeIndices, boolean produceProofs) {
        int count1;
        CongruencePath.SubPath path1 = new CongruencePath.SubPath(start.mTerm, produceProofs);
        CongruencePath.SubPath path2 = new CongruencePath.SubPath(dest.mTerm, produceProofs);
        int count2 = dest.mArrayNode.countStoreEdges();
        for (count1 = start.mArrayNode.countStoreEdges(); count1 > count2; --count1) {
            this.collectPathOneStore(start, path1, storeIndices);
        }
        while (count2 > count1) {
            this.collectPathOneStore(dest, path2, storeIndices);
            --count2;
        }
        while (start.mArrayNode != dest.mArrayNode) {
            this.collectPathOneStore(start, path1, storeIndices);
            this.collectPathOneStore(dest, path2, storeIndices);
        }
        path1.addSubPath(this.computePath(start.mTerm, dest.mTerm));
        path1.addSubPath(path2);
        return path1;
    }

    private void collectPathOneSelect(Cursor cursor, WeakSubPath path, HashSet<CCTerm> storeIndices, boolean produceProofs) {
        CCAppTerm store;
        ArrayTheory.ArrayNode selector = cursor.mArrayNode.findSelectNode(path.mIdxRep);
        CCTerm t1 = store = selector.mSelectReason;
        CCTerm t2 = ArrayTheory.getArrayFromStore(store);
        ArrayTheory.ArrayNode n1 = this.mArrayTheory.mCongRoots.get(t1.mRepStar);
        ArrayTheory.ArrayNode n2 = this.mArrayTheory.mCongRoots.get(t2.mRepStar);
        if (n2.findSelectNode(path.mIdxRep) == selector) {
            ArrayTheory.ArrayNode n = n2;
            n2 = n1;
            n1 = n;
            CCTerm t = t2;
            t2 = t1;
            t1 = t;
        }
        assert (n1.findSelectNode(path.mIdxRep) == selector);
        path.addSubPath(this.collectPathNoSelect(cursor, new Cursor(t1, n1), storeIndices, produceProofs));
        path.addEntry(t2, null);
        cursor.update(t2, n2);
        storeIndices.add(ArrayTheory.getIndexFromStore(store));
    }

    private void computeIndexDiseq(CCTerm idx, CCTerm idxFromStore) {
        CCEquality eqlit = this.createEquality(idx, idxFromStore);
        if (eqlit != null) {
            this.mAllLiterals.add(eqlit.negate());
        }
    }

    private Clause generateClause(CCEquality diseq, boolean produceProofs, ArrayAnnotation.RuleKind rule) {
        assert (diseq != null);
        this.mAllLiterals.add(diseq.negate());
        Literal[] lemma = new Literal[this.mAllLiterals.size()];
        int i = 0;
        for (Literal l : this.mAllLiterals) {
            lemma[i++] = l.negate();
        }
        Clause c = new Clause(lemma);
        if (produceProofs) {
            c.setProof(new LeafNode(-5, this.createAnnotation(diseq, rule)));
        }
        return c;
    }

    private ArrayAnnotation createAnnotation(CCEquality diseq, ArrayAnnotation.RuleKind rule) {
        return new ArrayAnnotation(diseq, this.mAllPaths, rule);
    }

    class WeakSubPath
    extends CongruencePath.SubPath {
        private final CCTerm mIdx;
        private final CCTerm mIdxRep;

        public WeakSubPath(CCTerm idx, CCTerm start, boolean produceProofs) {
            super(start, produceProofs);
            this.mIdx = idx;
            this.mIdxRep = idx.getRepresentative();
        }

        public String toString() {
            return "Weakpath " + this.mIdx + (this.mTermsOnPath == null ? "" : " " + this.mTermsOnPath.toString());
        }

        public CCTerm getIndex() {
            return this.mIdx;
        }
    }

    private static class Cursor {
        public CCTerm mTerm;
        public ArrayTheory.ArrayNode mArrayNode;

        public Cursor(CCTerm term, ArrayTheory.ArrayNode arrayNode) {
            this.mTerm = term;
            this.mArrayNode = arrayNode;
        }

        public void update(CCTerm term, ArrayTheory.ArrayNode arrayNode) {
            this.mTerm = term;
            this.mArrayNode = arrayNode;
        }
    }
}

