/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Coercion;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public class CCEquality
extends DPLLAtom {
    private final CCTerm mLhs;
    private final CCTerm mRhs;
    CCEquality mDiseqReason;
    private LAEquality mLasd;
    private Rational mLAFactor;
    private final Entry mEntry;
    int mStackDepth = -1;

    CCEquality(int assertionstacklevel, CCTerm c1, CCTerm c2) {
        super(HashUtils.hashJenkins(c1.hashCode(), (Object)c2), assertionstacklevel);
        this.mLhs = c1;
        this.mRhs = c2;
        this.mEntry = new Entry();
    }

    public CCTerm getLhs() {
        return this.mLhs;
    }

    public CCTerm getRhs() {
        return this.mRhs;
    }

    public Entry getEntry() {
        return this.mEntry;
    }

    public LAEquality getLASharedData() {
        return this.mLasd;
    }

    public void setLASharedData(LAEquality lasd, Rational factor) {
        this.mLasd = lasd;
        this.mLAFactor = factor;
    }

    public Rational getLAFactor() {
        return this.mLAFactor;
    }

    public void removeLASharedData() {
        this.mLasd = null;
        this.mLAFactor = null;
    }

    public Term getSMTFormula(Theory smtTheory, boolean quoted) {
        Term lhs = this.mLhs.toSMTTerm(smtTheory, quoted);
        Term rhs = this.mRhs.toSMTTerm(smtTheory, quoted);
        Term res = Coercion.buildEq(lhs, rhs);
        return quoted ? smtTheory.annotatedTerm(NamedAtom.QUOTED, res) : res;
    }

    public String toString() {
        return this.mLhs + " == " + this.mRhs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    extends SimpleListable<Entry> {
        Entry() {
        }

        public CCEquality getCCEquality() {
            return CCEquality.this;
        }
    }
}

