/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCAnnotation
implements IAnnotation {
    CCEquality mDiseq;
    CCTerm[][] mPaths;

    public CCAnnotation(CCEquality diseq, Collection<CongruencePath.SubPath> paths) {
        this.mDiseq = diseq;
        this.mPaths = new CCTerm[paths.size()][];
        int i = 0;
        for (CongruencePath.SubPath p : paths) {
            this.mPaths[i++] = p.getTerms();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.mDiseq);
        for (int p = 0; p < this.mPaths.length; ++p) {
            sb.append("::(");
            String comma = "";
            for (CCTerm term : this.mPaths[p]) {
                sb.append(comma).append(term);
                comma = " ";
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public CCEquality getDiseq() {
        return this.mDiseq;
    }

    public CCTerm[][] getPaths() {
        return this.mPaths;
    }

    @Override
    public Term toTerm(Clause cls, Theory theory) {
        Term base = cls.toTerm(theory);
        Object[] subannots = new Object[2 * this.mPaths.length + (this.mDiseq == null ? 0 : 1)];
        int i = 0;
        if (this.mDiseq != null) {
            subannots[i++] = this.mDiseq.getSMTFormula(theory);
        }
        for (CCTerm[] subpath : this.mPaths) {
            Term[] subs = new Term[subpath.length];
            for (int j = 0; j < subpath.length; ++j) {
                subs[j] = subpath[j].toSMTTerm(theory);
            }
            subannots[i++] = ":subpath";
            subannots[i++] = subs;
        }
        Annotation[] annots = new Annotation[]{new Annotation(":CC", subannots)};
        return theory.term("@lemma", theory.annotatedTerm(annots, base));
    }
}

