/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import de.uni_freiburg.informatik.ultimate.logic.IRAConstantFormatter;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ExitHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Lexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Parser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.MySymbolFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseEnvironment {
    final Script mScript;
    private PrintWriter mOut = new PrintWriter(System.out);
    private boolean mPrintSuccess = true;
    private boolean mPrintTermCSE = true;
    private File mCwd = null;
    private ExitHook mExitHook;
    private Deque<Long> mTiming;
    private boolean mContinueOnError = true;

    public ParseEnvironment(Script script) {
        this(script, null);
    }

    public ParseEnvironment(Script script, ExitHook exit) {
        this.mScript = script;
        this.mExitHook = exit;
    }

    public Script getScript() {
        return this.mScript;
    }

    static boolean convertSexp(StringBuilder sb, Object o, int level) {
        if (o instanceof Object[]) {
            if (level > 0) {
                sb.append(System.getProperty("line.separator"));
                for (int i = 0; i < level; ++i) {
                    sb.append(' ');
                }
            }
            sb.append('(');
            Object[] array = (Object[])o;
            boolean subarray = false;
            String sep = "";
            for (Object el : array) {
                sb.append(sep);
                subarray |= ParseEnvironment.convertSexp(sb, el, level + 2);
                sep = " ";
            }
            if (subarray) {
                sb.append(System.getProperty("line.separator"));
                for (int i = 0; i < level; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(')');
            return true;
        }
        sb.append(o);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseScript(String filename) throws SMTLIBException {
        File oldcwd = this.mCwd;
        try {
            InputStreamReader reader;
            if (filename.equals("<stdin>")) {
                reader = new InputStreamReader(System.in);
            } else {
                File script = new File(filename);
                if (!script.isAbsolute()) {
                    script = new File(this.mCwd, filename);
                }
                this.mCwd = script.getParentFile();
                try {
                    reader = new FileReader(script);
                }
                catch (FileNotFoundException ex) {
                    throw new SMTLIBException("File not found: " + filename);
                }
            }
            this.parseStream(reader, filename);
        }
        finally {
            this.mCwd = oldcwd;
        }
    }

    public void parseStream(Reader reader, String streamname) throws SMTLIBException {
        MySymbolFactory symfactory = new MySymbolFactory();
        Lexer lexer = new Lexer(reader);
        lexer.setSymbolFactory(symfactory);
        Parser parser2 = new Parser(lexer, symfactory);
        parser2.setFileName(streamname);
        parser2.setParseEnvironment(this);
        try {
            parser2.parse();
        }
        catch (Exception ex) {
            Logger.getRootLogger().error("Unexpected Exception", ex);
            throw new SMTLIBException(ex);
        }
    }

    public void include(String filename) throws SMTLIBException {
        ExitHook oldexit = this.mExitHook;
        this.mExitHook = new ExitHook(){

            public void exitHook() {
            }
        };
        File oldcwd = this.mCwd;
        this.parseScript(filename);
        this.mCwd = oldcwd;
        this.mExitHook = oldexit;
    }

    public void printSuccess() {
        if (this.mPrintSuccess) {
            this.mOut.println("success");
            this.mOut.flush();
        }
    }

    public void printError(String message) {
        this.mOut.print("(error \"");
        this.mOut.print(message);
        this.mOut.println("\")");
        this.mOut.flush();
        if (!this.mContinueOnError) {
            System.exit(1);
        }
    }

    public void printValues(Map<Term, Term> values) {
        PrintTerm pt = new PrintTerm();
        this.mOut.print('(');
        String sep = "";
        String itemSep = System.getProperty("line.separator") + " ";
        for (Map.Entry<Term, Term> me : values.entrySet()) {
            this.mOut.print(sep);
            this.mOut.print('(');
            pt.append((Appendable)this.mOut, me.getKey());
            this.mOut.print(' ');
            pt.append((Appendable)this.mOut, me.getValue().getTheory().getLogic().isIRA() ? new IRAConstantFormatter().transform(me.getValue()) : me.getValue());
            this.mOut.print(')');
            sep = itemSep;
        }
        this.mOut.println(')');
        this.mOut.flush();
    }

    public void printResponse(Object response) {
        if (!this.mPrintTermCSE) {
            if (response instanceof Term) {
                new PrintTerm().append((Appendable)this.mOut, (Term)response);
                this.mOut.println();
                this.mOut.flush();
                return;
            }
            if (response instanceof Term[]) {
                this.printTermResponse((Term[])response);
                this.mOut.flush();
                return;
            }
        }
        if (response instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            ParseEnvironment.convertSexp(sb, response, 0);
            this.mOut.println(sb.toString());
        } else if (response instanceof Iterable) {
            Iterable it = (Iterable)response;
            this.mOut.print("(");
            for (Object o : it) {
                this.printResponse(o);
            }
            this.mOut.println(")");
        } else {
            this.mOut.println(response);
        }
        this.mOut.flush();
    }

    public void printInfoResponse(String info, Object response) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(info).append(' ');
        ParseEnvironment.convertSexp(sb, response, 0);
        this.mOut.println(sb.append(')').toString());
        this.mOut.flush();
    }

    public void printTermResponse(Term[] response) {
        StringBuilder sb = new StringBuilder();
        PrintTerm pt = new PrintTerm();
        sb.append('(');
        String sep = "";
        String itemSep = System.getProperty("line.separator") + " ";
        for (Term t : response) {
            sb.append(sep);
            pt.append((Appendable)sb, t);
            sep = itemSep;
        }
        sb.append(')');
        this.mOut.println(sb.toString());
        this.mOut.flush();
    }

    public void exit() {
        if (this.mExitHook == null) {
            this.mScript.exit();
            Runtime.getRuntime().exit(0);
        } else {
            this.mExitHook.exitHook();
        }
    }

    public PrintWriter createChannel(String file) throws IOException {
        if (file.equals("stdout")) {
            return new PrintWriter(System.out);
        }
        if (file.equals("stderr")) {
            return new PrintWriter(System.err);
        }
        return new PrintWriter(new FileWriter(file));
    }

    public void setOption(String opt, Object value) throws SMTLIBException {
        if (opt.equals(":regular-output-channel")) {
            try {
                this.mOut = new PrintWriter(this.createChannel((String)value));
            }
            catch (IOException ex) {
                throw new SMTLIBException(ex);
            }
        } else if (opt.equals(":print-success")) {
            if (value instanceof Boolean) {
                this.mPrintSuccess = (Boolean)value;
            } else if (value instanceof String) {
                this.mPrintSuccess = Boolean.valueOf((String)value);
            }
        } else if (opt.equals(":print-terms-cse")) {
            if (value instanceof Boolean) {
                this.mPrintTermCSE = (Boolean)value;
            } else if (value instanceof String) {
                this.mPrintTermCSE = Boolean.valueOf((String)value);
            }
        }
        this.mScript.setOption(opt, value);
    }

    public void setInfo(String info, Object value) {
        if (info.equals(":error-behavior")) {
            if ("immediate-exit".equals(value)) {
                this.mContinueOnError = false;
            } else if ("continued-execution".equals(value)) {
                this.mContinueOnError = true;
            }
        }
        this.mScript.setInfo(info, value);
    }

    public Object getInfo(String info) {
        if (info.equals(":error-behavior")) {
            return this.mContinueOnError ? "continued-execution" : "immediate-exit";
        }
        return this.mScript.getInfo(info);
    }

    public void setOutStream(PrintWriter stream) {
        this.mOut = stream;
    }

    public void startTiming() {
        if (this.mTiming == null) {
            this.mTiming = new ArrayDeque<Long>();
        }
        this.mOut.print('(');
        this.mTiming.push(System.nanoTime());
    }

    public void endTiming() {
        long old = this.mTiming.pop();
        long duration = System.nanoTime() - old;
        double secs = (double)duration / 1.0E9;
        this.mOut.printf((Locale)null, " :time %.3f)", secs);
        this.mOut.println();
        this.mOut.flush();
    }

    public boolean isContinueOnError() {
        return this.mContinueOnError;
    }
}

