/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib;

import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.Lexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.Parser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.MySymbolFactory;
import java.io.FileReader;
import java.io.InputStreamReader;

public class SMTLIBParser
implements IParser {
    public int run(Script solver, String filename) {
        try {
            InputStreamReader reader;
            MySymbolFactory symfactory = new MySymbolFactory();
            if (filename == null) {
                filename = "<stdin>";
                reader = new InputStreamReader(System.in);
            } else {
                reader = new FileReader(filename);
            }
            Lexer lexer = new Lexer(reader);
            lexer.setSymbolFactory(symfactory);
            Parser parser2 = new Parser(lexer, symfactory);
            parser2.setFileName(filename);
            parser2.setSolver(solver, false);
            parser2.parse();
            Term[] interpolants = parser2.benchmark.check();
            if (interpolants != null) {
                for (int i = 0; i < interpolants.length; ++i) {
                    System.out.println("Interpolant " + i + ": " + interpolants[i]);
                }
            }
            parser2.benchmark.close();
            return 0;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }
}

