/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.IdentityHashSet;
import java.util.HashSet;

public class UnsatCoreCollector {
    private final Script mScript;
    private final HashSet<String> mUnsatCoreIds;
    private final IdentityHashSet<Clause> mVisited;

    public UnsatCoreCollector(Script script) {
        this.mScript = script;
        this.mUnsatCoreIds = new HashSet();
        this.mVisited = new IdentityHashSet();
    }

    public Term[] getUnsatCore(Clause unsat) {
        try {
            this.accept(unsat);
            Term[] res = new Term[this.mUnsatCoreIds.size()];
            int i = -1;
            for (String s : this.mUnsatCoreIds) {
                res[++i] = this.mScript.term(s, new Term[0]);
            }
            return res;
        }
        catch (SMTLIBException ese) {
            throw new InternalError(ese.getMessage());
        }
    }

    private void accept(Clause c) {
        if (this.mVisited.add(c)) {
            if (c.getProof().isLeaf()) {
                this.visit((LeafNode)c.getProof());
            } else {
                this.visit((ResolutionNode)c.getProof());
            }
        }
    }

    private void visit(ResolutionNode node) {
        ResolutionNode.Antecedent[] ants;
        this.accept(node.getPrimary());
        for (ResolutionNode.Antecedent a : ants = node.getAntecedents()) {
            this.accept(a.mAntecedent);
        }
    }

    private void visit(LeafNode node) {
        String name;
        if (node.getLeafKind() == -1 && node.getTheoryAnnotation() instanceof SourceAnnotation && !(name = ((SourceAnnotation)node.getTheoryAnnotation()).getAnnotation()).isEmpty()) {
            this.mUnsatCoreIds.add(name);
        }
    }
}

