/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;

public class PropProofChecker {
    private final ArrayDeque<Clause> mTodo = new ArrayDeque();
    private final HashSet<Clause> mCorrect = new HashSet();

    public boolean check(Clause refutation) {
        this.mTodo.add(refutation);
        return this.run();
    }

    private boolean run() {
        while (!this.mTodo.isEmpty()) {
            Clause clause = this.mTodo.removeLast();
            if (this.mCorrect.contains(clause)) continue;
            ProofNode pn = clause.getProof();
            if (pn.isLeaf()) {
                this.mCorrect.add(clause);
                continue;
            }
            ResolutionNode.Antecedent[] antes = ((ResolutionNode)pn).getAntecedents();
            Clause prim = ((ResolutionNode)pn).getPrimary();
            boolean unknownChild = false;
            if (!this.mCorrect.contains(prim)) {
                if (!unknownChild) {
                    this.mTodo.addLast(clause);
                }
                unknownChild = true;
                this.mTodo.addLast(prim);
            }
            for (ResolutionNode.Antecedent ante : antes) {
                if (this.mCorrect.contains(ante.mAntecedent)) continue;
                if (!unknownChild) {
                    this.mTodo.addLast(clause);
                }
                unknownChild = true;
                this.mTodo.addLast(ante.mAntecedent);
            }
            if (unknownChild) continue;
            HashSet<Literal> clauselits = new HashSet<Literal>();
            for (int i = 0; i < prim.getSize(); ++i) {
                clauselits.add(prim.getLiteral(i));
            }
            for (ResolutionNode.Antecedent ante : antes) {
                Clause antecls = ante.mAntecedent;
                if (!antecls.contains(ante.mPivot)) {
                    System.err.println("Pivot literal " + ante.mPivot + " not in antecedent");
                    return false;
                }
                if (!clauselits.remove(ante.mPivot.negate())) {
                    System.err.println("Negated pivot literal " + ante.mPivot.negate() + " not in primary");
                    return false;
                }
                for (int i = 0; i < antecls.getSize(); ++i) {
                    Literal lit = antecls.getLiteral(i);
                    if (lit == ante.mPivot) continue;
                    clauselits.add(lit);
                }
            }
            HashSet<Literal> clslits = new HashSet<Literal>();
            for (int i = 0; i < clause.getSize(); ++i) {
                clslits.add(clause.getLiteral(i));
            }
            if (clauselits.containsAll(clslits) && clslits.containsAll(clauselits)) {
                this.mCorrect.add(clause);
                continue;
            }
            System.err.println("Result of resolution incorrect");
            System.err.println();
            System.err.println("Result misses:");
            Set clauseremain = (Set)clauselits.clone();
            clauseremain.removeAll(clslits);
            System.err.println(clauseremain);
            System.err.println();
            System.err.println("Result additionally has:");
            Set clsremain = (Set)clslits.clone();
            clsremain.removeAll(clauselits);
            System.err.println(clsremain);
            return false;
        }
        return true;
    }
}

