/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class ProofTermGenerator {
    private final Deque<Visitor> mTodo = new ArrayDeque<Visitor>();
    private final Deque<Term> mConverted = new ArrayDeque<Term>();
    private final Theory mTheory;
    private final Map<Clause, Term> mNodes = new HashMap<Clause, Term>();

    void enqueue(Visitor visitor) {
        this.mTodo.push(visitor);
    }

    private void run() {
        while (!this.mTodo.isEmpty()) {
            this.mTodo.pop().visit(this);
        }
    }

    public ProofTermGenerator(Theory t) {
        this.mTheory = t;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    Term getTerm(Clause cls) {
        return this.mNodes.get(cls);
    }

    Term getConverted() {
        return this.mConverted.pop();
    }

    void pushConverted(Term res) {
        assert (res.getSort().getName().equals("@Proof"));
        this.mConverted.push(res);
    }

    void setResult(Clause cls, Term res) {
        this.mNodes.put(cls, res);
    }

    public Term convert(Clause cls) {
        assert (cls.getSize() == 0);
        assert (cls.getProof() != null);
        this.enqueue(new Expander(cls));
        this.run();
        Term res = this.mConverted.pop();
        return SMTAffineTerm.cleanup(res);
    }

    private static class Expander
    implements Visitor {
        private final Clause mCls;

        public Expander(Clause cls) {
            this.mCls = cls;
        }

        public void visit(ProofTermGenerator engine) {
            Term known = engine.getTerm(this.mCls);
            if (known != null) {
                engine.pushConverted(known);
                return;
            }
            ProofNode pn = this.mCls.getProof();
            if (pn.isLeaf()) {
                LeafNode ln = (LeafNode)pn;
                Theory t = engine.getTheory();
                IAnnotation annot = ln.getTheoryAnnotation();
                Term res = annot.toTerm(this.mCls, t);
                engine.setResult(this.mCls, res);
                engine.pushConverted(res);
            } else {
                ResolutionNode.Antecedent[] antes;
                ResolutionNode rn = (ResolutionNode)pn;
                engine.enqueue(new GenerateTerm(this.mCls));
                engine.enqueue(new Expander(rn.getPrimary()));
                for (ResolutionNode.Antecedent ante : antes = rn.getAntecedents()) {
                    engine.enqueue(new Expander(ante.mAntecedent));
                }
            }
        }
    }

    private static class GenerateTerm
    implements Visitor {
        private final Clause mCls;

        public GenerateTerm(Clause cls) {
            assert (cls.getProof() instanceof ResolutionNode);
            this.mCls = cls;
        }

        public void visit(ProofTermGenerator engine) {
            Theory t = engine.getTheory();
            ResolutionNode.Antecedent[] antes = ((ResolutionNode)this.mCls.getProof()).getAntecedents();
            Term[] args = new Term[1 + antes.length];
            args[0] = engine.getConverted();
            for (int i = 0; i < antes.length; ++i) {
                args[i + 1] = t.annotatedTerm(new Annotation[]{new Annotation(":pivot", antes[i].mPivot.getSMTFormula(t, true))}, engine.getConverted());
            }
            ApplicationTerm res = t.term("@res", args);
            engine.setResult(this.mCls, res);
            engine.pushConverted(res);
        }
    }

    private static interface Visitor {
        public void visit(ProofTermGenerator var1);
    }
}

