/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.BooleanVarAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BoolSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FiniteSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelFormatter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
implements de.uni_freiburg.informatik.ultimate.logic.Model {
    private final HashMap<Sort, SortInterpretation> mSorts = new HashMap();
    private final HashMap<Sort, ArraySortInterpretation> mArraySorts = new HashMap();
    private final BoolSortInterpretation mBoolSort;
    private final NumericSortInterpretation mNumSorts;
    private final HashMap<FunctionSymbol, FunctionValue> mFuncVals = new HashMap();
    private final Theory mTheory;
    private final ModelEvaluator mEval;
    private final FormulaUnLet mUnlet = new FormulaUnLet(FormulaUnLet.UnletType.EXPAND_DEFINITIONS);
    private final boolean mPartialModel;

    public Model(Clausifier clausifier, Theory t, boolean partial) {
        this.mTheory = t;
        this.mPartialModel = partial;
        this.mBoolSort = new BoolSortInterpretation();
        this.mNumSorts = new NumericSortInterpretation();
        FunctionValue trueValue = new FunctionValue(this.mBoolSort.getTrueIdx());
        FunctionValue falseValue = new FunctionValue(this.mBoolSort.getFalseIdx());
        for (BooleanVarAtom atom : clausifier.getBooleanVars()) {
            ApplicationTerm at = (ApplicationTerm)atom.getSMTFormula(t);
            FunctionValue value = atom.getDecideStatus() == null ? (atom.getPreferredStatus() == atom ? trueValue : falseValue) : (atom.getDecideStatus() == atom ? trueValue : falseValue);
            this.mFuncVals.put(at.getFunction(), value);
        }
        CClosure cc = clausifier.getCClosure();
        LinArSolve la = null;
        ArrayTheory array = null;
        for (ITheory theory : clausifier.getEngine().getAttachedTheories()) {
            if (theory instanceof LinArSolve) {
                la = (LinArSolve)theory;
                continue;
            }
            if (theory instanceof ArrayTheory) {
                array = (ArrayTheory)theory;
                continue;
            }
            if (theory == cc) continue;
            throw new InternalError("Modelproduction for theory not implemented: " + theory);
        }
        SharedTermEvaluator ste = new SharedTermEvaluator(la);
        if (la != null) {
            la.fillInModel(this, t, ste);
        }
        if (cc != null) {
            cc.fillInModel(this, t, ste);
        }
        if (array != null) {
            array.fillInModel(this, t, ste);
        }
        this.mEval = new ModelEvaluator(this);
    }

    public int getFalseIdx() {
        return this.mBoolSort.getFalseIdx();
    }

    public int getTrueIdx() {
        return this.mBoolSort.getTrueIdx();
    }

    public int extendNumeric(FunctionSymbol fsym, Rational rat) {
        assert (fsym.getReturnSort().isNumericSort());
        int idx = this.mNumSorts.extend(rat);
        this.mFuncVals.put(fsym, new FunctionValue(idx));
        return idx;
    }

    public int putNumeric(Rational rat) {
        return this.mNumSorts.extend(rat);
    }

    public int extendFresh(Sort s) {
        if (s.isArraySort()) {
            ArraySortInterpretation si = this.mArraySorts.get(s);
            if (si == null) {
                si = new ArraySortInterpretation(this.provideSortInterpretation(s.getArguments()[0]), this.provideSortInterpretation(s.getArguments()[1]));
                this.mArraySorts.put(s, si);
            }
            return si.extendFresh();
        }
        SortInterpretation si = this.mSorts.get(s);
        if (si == null) {
            si = new FiniteSortInterpretation();
            this.mSorts.put(s, si);
        }
        return si.extendFresh();
    }

    public FunctionValue map(FunctionSymbol fs, int value) {
        FunctionValue res = this.mFuncVals.get(fs);
        if (res == null) {
            res = new FunctionValue(value);
            this.mFuncVals.put(fs, res);
        }
        assert (res.getDefault() == value);
        return res;
    }

    public FunctionValue map(FunctionSymbol fs, int[] args, int value) {
        assert (fs.getParameterSorts().length == args.length);
        FunctionValue val = this.mFuncVals.get(fs);
        if (val == null) {
            val = new FunctionValue();
            this.mFuncVals.put(fs, val);
        }
        val.put(value, args);
        return val;
    }

    Term getUndefined(Sort s) {
        FunctionSymbol fsym = this.mTheory.getFunctionWithResult("@undefined", null, s, new Sort[0]);
        return this.mTheory.term(fsym, new Term[0]);
    }

    @Override
    public Term evaluate(Term input) {
        Term unletted = this.mUnlet.unlet(input);
        return this.mEval.evaluate(unletted);
    }

    @Override
    public Map<Term, Term> evaluate(Term[] input) {
        LinkedHashMap<Term, Term> values = new LinkedHashMap<Term, Term>();
        for (Term t : input) {
            values.put(t, this.evaluate(t));
        }
        return values;
    }

    public String toString() {
        ModelFormatter mf = new ModelFormatter(this.mTheory, this);
        if (!this.mSorts.isEmpty()) {
            mf.appendComment("Sort interpretations");
        }
        for (Map.Entry<Sort, SortInterpretation> entry : this.mSorts.entrySet()) {
            mf.appendSortInterpretation(entry.getValue(), entry.getKey());
        }
        if (!this.mSorts.isEmpty()) {
            mf.appendComment("Function interpretations");
        }
        for (Map.Entry<Object, Object> entry : this.mFuncVals.entrySet()) {
            if (((FunctionSymbol)entry.getKey()).isIntern()) continue;
            mf.appendValue((FunctionSymbol)entry.getKey(), (FunctionValue)entry.getValue(), this.mTheory);
        }
        return mf.finish();
    }

    Theory getTheory() {
        return this.mTheory;
    }

    public boolean isPartialModel() {
        return this.mPartialModel;
    }

    public BoolSortInterpretation getBoolSortInterpretation() {
        return this.mBoolSort;
    }

    public NumericSortInterpretation getNumericSortInterpretation() {
        return this.mNumSorts;
    }

    public SortInterpretation provideSortInterpretation(Sort sort) {
        if (sort.isNumericSort()) {
            return this.mNumSorts;
        }
        if (sort == this.mTheory.getBooleanSort()) {
            return this.mBoolSort;
        }
        if (sort.isArraySort()) {
            ArraySortInterpretation array = this.mArraySorts.get(sort);
            if (array == null) {
                array = new ArraySortInterpretation(this.provideSortInterpretation(sort.getArguments()[0]), this.provideSortInterpretation(sort.getArguments()[1]));
                this.mArraySorts.put(sort, array);
            }
            return array;
        }
        SortInterpretation res = this.mSorts.get(sort);
        if (res == null) {
            res = new FiniteSortInterpretation();
            this.mSorts.put(sort, res);
        }
        return res;
    }

    public FunctionValue getFunctionValue(FunctionSymbol fs) {
        return this.mFuncVals.get(fs);
    }

    public Term toModelTerm(int idx, Sort resultSort) {
        if (idx == -1) {
            return this.getUndefined(resultSort);
        }
        if (resultSort == this.mTheory.getBooleanSort()) {
            return this.mBoolSort.get(idx, resultSort, this.mTheory);
        }
        if (resultSort.isNumericSort()) {
            Rational val = this.mNumSorts.get(idx);
            return val.toTerm(resultSort);
        }
        if (resultSort.isArraySort()) {
            ArraySortInterpretation array = this.mArraySorts.get(resultSort);
            if (array == null) {
                if (this.mPartialModel) {
                    return this.getUndefined(resultSort);
                }
                array = new ArraySortInterpretation(this.provideSortInterpretation(resultSort.getArguments()[0]), this.provideSortInterpretation(resultSort.getArguments()[1]));
                this.mArraySorts.put(resultSort, array);
            }
            return array.get(idx, resultSort, this.mTheory);
        }
        SortInterpretation si = this.mSorts.get(resultSort);
        if (si == null) {
            if (this.mPartialModel) {
                return this.getUndefined(resultSort);
            }
            si = new FiniteSortInterpretation();
            si.ensureCapacity(idx + 1);
        }
        return si.get(idx, resultSort, this.mTheory);
    }

    public ArraySortInterpretation getArrayInterpretation(Sort arraySort) {
        return this.mArraySorts.get(arraySort);
    }
}

