/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArrayValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.ArrayList;
import java.util.HashMap;

public class ArraySortInterpretation
implements SortInterpretation {
    private final SortInterpretation mIndexSort;
    private final SortInterpretation mValueSort;
    private final ArrayList<ArrayValue> mValues;
    private HashMap<ArrayValue, Integer> mUnifier;

    public ArraySortInterpretation(SortInterpretation index, SortInterpretation value) {
        this.mIndexSort = index;
        this.mValueSort = value;
        this.mValues = new ArrayList();
        this.mValues.add(0, ArrayValue.DEFAULT_ARRAY);
    }

    public int ensureCapacity(int numValues) {
        while (this.mValues.size() < numValues) {
            this.extendFresh();
        }
        return this.mValues.size();
    }

    public int createEmptyArrayValue() {
        int val = this.mValues.size();
        ArrayValue fresh = new ArrayValue();
        this.mValues.add(val, fresh);
        return val;
    }

    public int extendFresh() {
        int val = this.mValues.size();
        ArrayValue fresh = new ArrayValue();
        this.mValueSort.ensureCapacity(2);
        int idxval = this.mIndexSort.extendFresh();
        int old = fresh.store(idxval, 1);
        assert (old == 1) : "Fresh index already used!";
        this.mValues.add(val, fresh);
        if (this.mUnifier != null) {
            this.mUnifier.put(fresh, val);
        }
        return val;
    }

    public int size() {
        return this.mValues.size();
    }

    public Term get(int idx, Sort s, Theory t) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.mValues.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (idx == 0) {
            return t.term(t.getFunctionWithResult("@0", null, s, new Sort[0]), new Term[0]);
        }
        return this.mValues.get(idx).toSMTLIB(s, t, this.mIndexSort, this.mValueSort);
    }

    public Term toSMTLIB(Theory t, Sort sort) {
        return null;
    }

    public ArrayValue getValue(int idx) {
        return this.mValues.get(idx);
    }

    public SortInterpretation getIndexInterpretation() {
        return this.mIndexSort;
    }

    public SortInterpretation getValueInterpretation() {
        return this.mValueSort;
    }

    public int value2index(ArrayValue value) {
        Integer res;
        if (this.mUnifier == null) {
            this.mUnifier = new HashMap();
            for (int i = 0; i < this.mValues.size(); ++i) {
                Integer prev = this.mUnifier.put(this.mValues.get(i), i);
                assert (prev == null) : "Same array values at different indices";
            }
        }
        if ((res = this.mUnifier.get(value)) != null) {
            return res;
        }
        int idx = this.mValues.size();
        this.mValues.add(idx, value);
        this.mUnifier.put(value, idx);
        return idx;
    }
}

