/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolChecker
extends TermTransformer {
    private Map<FunctionSymbol, Integer> mLeftAllowed;
    private Map<FunctionSymbol, Integer> mRightAllowed;
    private HashSet<FunctionSymbol> mLeftErrors;
    private HashSet<FunctionSymbol> mRightErrors;
    private final Set<FunctionSymbol> mGlobals;

    public SymbolChecker(Set<FunctionSymbol> globals) {
        this.mGlobals = globals;
    }

    public final boolean check(Term interpolant, Map<FunctionSymbol, Integer> leftAllowed, Map<FunctionSymbol, Integer> rightAllowed) {
        this.mLeftAllowed = leftAllowed;
        this.mRightAllowed = rightAllowed;
        this.mLeftErrors = new HashSet();
        this.mRightErrors = new HashSet();
        this.transform(interpolant);
        return !this.mLeftErrors.isEmpty() || !this.mRightErrors.isEmpty();
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        FunctionSymbol fs = appTerm.getFunction();
        if (!fs.isIntern() && !this.mGlobals.contains(fs)) {
            Integer left = this.mLeftAllowed.get(fs);
            Integer right = this.mRightAllowed.get(fs);
            if (left == null && right == null) {
                throw new InternalError("Detected new symbol in interpolant: " + fs);
            }
            if (left == null) {
                this.mRightErrors.add(fs);
            } else if (right - left <= 0) {
                this.mLeftErrors.add(fs);
            }
        }
        super.convertApplicationTerm(appTerm, newArgs);
    }

    public Set<FunctionSymbol> getLeftErrors() {
        return this.mLeftErrors;
    }

    public Set<FunctionSymbol> getRightErrors() {
        return this.mRightErrors;
    }
}

