/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SMTAffineTerm
extends Term {
    private final Sort mSort;
    private final Map<Term, Rational> mSummands;
    private final Rational mConstant;

    private SMTAffineTerm(Map<Term, Rational> summands, Rational constant, Sort sort) {
        super(constant.hashCode() * 11 + summands.hashCode() + 1423 * sort.hashCode());
        this.mSort = sort;
        this.mSummands = summands;
        this.mConstant = constant;
    }

    public static SMTAffineTerm create(Map<Term, Rational> summands, Rational constant, Sort sort) {
        return new SMTAffineTerm(summands, constant, sort);
    }

    public static SMTAffineTerm create(Rational rat, Sort sort) {
        return SMTAffineTerm.create(Collections.<Term, Rational>emptyMap(), rat, sort);
    }

    public static SMTAffineTerm create(Term term) {
        if (term instanceof SMTAffineTerm) {
            return (SMTAffineTerm)term;
        }
        return SMTAffineTerm.create(Rational.ONE, term);
    }

    public static SMTAffineTerm create(Rational factor, Term subterm) {
        Rational constant;
        Map<Term, Rational> summands;
        Sort sort = subterm.getSort();
        if (factor.equals(Rational.ZERO)) {
            summands = Collections.emptyMap();
            constant = Rational.ZERO;
        } else if (subterm instanceof SMTAffineTerm) {
            SMTAffineTerm a = (SMTAffineTerm)subterm;
            constant = a.mConstant.mul(factor);
            summands = new HashMap<Term, Rational>();
            for (Map.Entry<Term, Rational> me : a.mSummands.entrySet()) {
                summands.put(me.getKey(), me.getValue().mul(factor));
            }
        } else if (subterm instanceof ConstantTerm) {
            Object value = ((ConstantTerm)subterm).getValue();
            if (value instanceof BigInteger) {
                constant = Rational.valueOf((BigInteger)value, BigInteger.ONE).mul(factor);
                summands = Collections.emptyMap();
            } else if (value instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)value;
                if (decimal.scale() <= 0) {
                    BigInteger num = decimal.toBigInteger();
                    constant = Rational.valueOf(num, BigInteger.ONE).mul(factor);
                } else {
                    BigInteger num = decimal.unscaledValue();
                    BigInteger denom = BigInteger.TEN.pow(decimal.scale());
                    constant = Rational.valueOf(num, denom).mul(factor);
                }
                summands = Collections.emptyMap();
            } else if (value instanceof Rational) {
                constant = (Rational)value;
                summands = Collections.emptyMap();
            } else {
                summands = Collections.singletonMap(subterm, factor);
                constant = Rational.ZERO;
            }
        } else {
            summands = Collections.singletonMap(subterm, factor);
            constant = Rational.ZERO;
        }
        return SMTAffineTerm.create(summands, constant, sort);
    }

    public SMTAffineTerm add(SMTAffineTerm a2) {
        assert (this.getSort().equals(a2.getSort()));
        return this.addUnchecked(a2, true);
    }

    public SMTAffineTerm addUnchecked(SMTAffineTerm a2, boolean sortCorrect) {
        HashMap<Term, Rational> summands = new HashMap<Term, Rational>();
        summands.putAll(this.mSummands);
        for (Map.Entry<Term, Rational> entry : a2.mSummands.entrySet()) {
            Term var = entry.getKey();
            if (summands.containsKey(var)) {
                Rational r = ((Rational)summands.get(var)).add(entry.getValue());
                if (r.equals(Rational.ZERO)) {
                    summands.remove(var);
                    continue;
                }
                summands.put(var, r);
                continue;
            }
            summands.put(var, entry.getValue());
        }
        return SMTAffineTerm.create(summands, this.mConstant.add(a2.mConstant), sortCorrect ? this.mSort : (a2.getSort().getName().equals("Real") ? a2.getSort() : this.mSort));
    }

    public SMTAffineTerm add(Rational c) {
        return SMTAffineTerm.create(this.mSummands, this.mConstant.add(c), this.mSort);
    }

    public SMTAffineTerm typecast(Sort realSort) {
        return SMTAffineTerm.create(this.mSummands, this.mConstant, realSort);
    }

    public SMTAffineTerm mul(Rational factor) {
        if (factor.equals(Rational.ZERO)) {
            return SMTAffineTerm.create(Rational.ZERO, this.mSort);
        }
        Rational constant = this.mConstant.mul(factor);
        HashMap<Term, Rational> summands = new HashMap<Term, Rational>();
        for (Map.Entry<Term, Rational> me : this.mSummands.entrySet()) {
            summands.put(me.getKey(), me.getValue().mul(factor));
        }
        return SMTAffineTerm.create(summands, constant, this.mSort);
    }

    public SMTAffineTerm div(Rational c) {
        return this.mul(c.inverse());
    }

    public SMTAffineTerm negate() {
        return this.mul(Rational.MONE);
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty();
    }

    public Rational getConstant() {
        return this.mConstant;
    }

    public boolean isIntegral() {
        return this.mSort.getName().equals("Int");
    }

    public boolean equals(Object o) {
        if (!(o instanceof SMTAffineTerm)) {
            return false;
        }
        SMTAffineTerm l = (SMTAffineTerm)o;
        return this.mSort == l.mSort && this.mConstant.equals(l.mConstant) && this.mSummands.equals(l.mSummands);
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    Rational getCoefficient(Term subterm) {
        Rational coeff = this.mSummands.get(subterm);
        return coeff == null ? Rational.ZERO : coeff;
    }

    public Rational getGcd() {
        assert (!this.mSummands.isEmpty());
        Iterator<Rational> it = this.mSummands.values().iterator();
        Rational gcd = it.next().abs();
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next().abs());
        }
        return gcd;
    }

    public Map<Term, Rational> getSummands() {
        return this.mSummands;
    }

    private static Term toPlainTerm(Map<Term, Rational> summands, Rational constant, Sort sort) {
        assert (sort.isNumericSort());
        Theory t = sort.getTheory();
        int size = summands.size();
        if (size == 0 || !constant.equals(Rational.ZERO)) {
            ++size;
        }
        Term[] sum = new Term[size];
        int i = 0;
        for (Map.Entry<Term, Rational> factor : summands.entrySet()) {
            Term convTerm = factor.getKey();
            if (!convTerm.getSort().equals(sort)) {
                convTerm = t.term("to_real", convTerm);
            }
            if (factor.getValue().equals(Rational.MONE)) {
                convTerm = t.term("-", convTerm);
            } else if (!factor.getValue().equals(Rational.ONE)) {
                Term convfac = t.rational(factor.getValue(), sort);
                convTerm = t.term("*", convfac, convTerm);
            }
            sum[i++] = convTerm;
        }
        if (i < size) {
            sum[i++] = t.rational(constant, sort);
        }
        return size == 1 ? sum[0] : t.term("+", sum);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> m_Todo) {
        m_Todo.addLast(SMTAffineTerm.toPlainTerm(this.mSummands, this.mConstant, this.mSort));
    }

    @Override
    public String toString() {
        return SMTAffineTerm.cleanup(this).toString();
    }

    public static Term cleanup(Term term) {
        return new TermTransformer(){

            public void convert(Term term) {
                if (term instanceof SMTAffineTerm) {
                    final SMTAffineTerm affine = (SMTAffineTerm)term;
                    this.enqueueWalker(new NonRecursive.Walker(){

                        public void walk(NonRecursive engine) {
                            HashMap<Term, Rational> summands = new HashMap<Term, Rational>();
                            for (Rational v : affine.mSummands.values()) {
                                summands.put(this.getConverted(), v);
                            }
                            Term term = SMTAffineTerm.toPlainTerm(summands, affine.mConstant, affine.mSort);
                            this.setResult(term);
                        }
                    });
                    for (Term t : affine.mSummands.keySet()) {
                        this.pushTerm(t);
                    }
                    return;
                }
                super.convert(term);
            }
        }.transform(term);
    }

    public Term normalize(TermCompiler compiler) {
        Map.Entry<Term, Rational> me;
        if (this.mConstant.equals(Rational.ZERO) && this.mSummands.size() == 1 && (me = this.mSummands.entrySet().iterator().next()).getValue().equals(Rational.ONE) && me.getKey().getSort() == this.mSort) {
            return me.getKey();
        }
        return compiler.unify(this);
    }

    public Term internalize(TermCompiler compiler) {
        SMTAffineTerm res = this;
        if (this.getTheory().getLogic().isIRA() && !this.isIntegral() && this.isAllInt()) {
            res = SMTAffineTerm.create(this.mSummands, this.mConstant, this.getTheory().getSort("Int", new Sort[0]));
        }
        return res.normalize(compiler);
    }

    public boolean isAllIntSummands() {
        for (Map.Entry<Term, Rational> me : this.mSummands.entrySet()) {
            if (!me.getKey().getSort().getName().equals("Int")) {
                return false;
            }
            if (me.getValue().isIntegral()) continue;
            return false;
        }
        return true;
    }

    private boolean isAllInt() {
        return this.isAllIntSummands() && this.mConstant.isIntegral();
    }
}

