/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.aiger.AIGERFrontEnd;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dimacs.DIMACSParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.SMTLIBParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTLIB2Parser;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Properties;

public final class Main {
    public static Properties sVersionInfo = new Properties();

    private Main() {
    }

    public static final String getVersion() {
        String version2 = sVersionInfo.getProperty("version", "unknown version");
        return version2;
    }

    private static void usage() {
        System.err.println("USAGE: smtinterpol [OPTION]... [INPUTFILE]");
        System.err.println("If no INPUTFILE is given, stdin is used.");
        System.err.println("  -transform <output>  Transform the input to SMTLIB 2 and write into output.");
        System.err.println("  -script <class>      Send the input to another Java class implementing Script.");
        System.err.println("  -no-success          Don't print success messages.");
        System.err.println("  -q                   Only print error messages.");
        System.err.println("  -w                   Don't print statistics and models.");
        System.err.println("  -v                   Print debugging messages.");
        System.err.println("  -t <num>             Set the timeout per check-sat call to <num> milliseconds.");
        System.err.println("  -r <num>             Use a different random seed.");
        System.err.println("  -smt2                Parse input as SMTLIB 2 script.");
        System.err.println("  -smt                 Parse input as SMTLIB 1 benchmark.");
        System.err.println("  -d                   Parse input as DIMACS benchmark.");
        System.err.println("  -version             Print version and exit.");
    }

    private static void version() {
        String date = sVersionInfo.getProperty("build.date");
        System.err.println("SMTInterpol " + Main.getVersion());
        if (date != null) {
            System.err.println("  built on " + date);
        }
    }

    public static void main(String[] param) throws Exception {
        int paramctr;
        BigInteger verbosity = null;
        BigInteger timeout = null;
        BigInteger seed = null;
        IParser parser2 = new SMTLIB2Parser();
        Script solver = null;
        boolean printSuccess = true;
        for (paramctr = 0; paramctr < param.length && param[paramctr].startsWith("-"); ++paramctr) {
            if (param[paramctr].equals("--")) {
                ++paramctr;
                break;
            }
            if (param[paramctr].equals("-transform") && paramctr + 1 < param.length) {
                solver = new LoggingScript(param[++paramctr], true);
                continue;
            }
            if (param[paramctr].equals("-script") && paramctr + 1 < param.length) {
                Class<?> scriptClass = Class.forName(param[++paramctr]);
                solver = (Script)scriptClass.newInstance();
                continue;
            }
            if (param[paramctr].equals("-no-success")) {
                printSuccess = false;
                continue;
            }
            if (param[paramctr].equals("-v")) {
                verbosity = BigInteger.valueOf(5L);
                continue;
            }
            if (param[paramctr].equals("-w")) {
                verbosity = BigInteger.valueOf(3L);
                continue;
            }
            if (param[paramctr].equals("-q")) {
                verbosity = BigInteger.valueOf(2L);
                continue;
            }
            if (param[paramctr].equals("-t") && ++paramctr < param.length) {
                try {
                    timeout = new BigInteger(param[paramctr]);
                    if (timeout.signum() > 0) continue;
                    timeout = null;
                    System.err.println("Cannot parse timeout argument: Non-positive number");
                }
                catch (NumberFormatException enfe) {
                    System.err.println("Cannot parse timeout argument: Not a number");
                }
                continue;
            }
            if (param[paramctr].equals("-r") && ++paramctr < param.length) {
                try {
                    seed = new BigInteger(param[paramctr]);
                    if (seed.signum() >= 0) continue;
                    System.err.println("Cannot parse random seed argument: Negative number");
                    seed = null;
                }
                catch (NumberFormatException enfe) {
                    System.err.println("Cannot parse random seed argument: Not a number");
                }
                continue;
            }
            if (param[paramctr].equals("-smt2")) {
                parser2 = new SMTLIB2Parser();
                continue;
            }
            if (param[paramctr].equals("-smt")) {
                parser2 = new SMTLIBParser();
                continue;
            }
            if (param[paramctr].equals("-d")) {
                parser2 = new DIMACSParser();
                continue;
            }
            if (param[paramctr].equals("-a")) {
                parser2 = new AIGERFrontEnd();
                continue;
            }
            if (param[paramctr].equals("-trace")) {
                verbosity = BigInteger.ONE.negate();
                continue;
            }
            if (param[paramctr].equals("-version")) {
                Main.version();
                return;
            }
            Main.usage();
            return;
        }
        String filename = null;
        if (paramctr < param.length) {
            filename = param[paramctr++];
        }
        if (paramctr != param.length) {
            Main.usage();
            return;
        }
        if (solver == null) {
            solver = new SMTInterpol();
        }
        solver.setOption(":print-success", printSuccess);
        if (verbosity != null) {
            solver.setOption(":verbosity", verbosity);
        }
        if (timeout != null) {
            solver.setOption(":timeout", timeout);
        }
        if (seed != null) {
            solver.setOption(":random-seed", seed);
        }
        int exitCode = parser2.run(solver, filename);
        System.exit(exitCode);
    }

    static {
        try {
            InputStream is = Main.class.getResourceAsStream("Version.properties");
            if (is != null) {
                sVersionInfo.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

