/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.LinkedHashSet;

public final class Util {
    private static final Sort[] EMPTY_SORT_ARRAY = new Sort[0];

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script.LBool checkSat(Script script, Term term) {
        script.push(1);
        try {
            Script.LBool result;
            TermVariable[] vars = term.getFreeVars();
            Term[] values = new Term[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                values[i] = Util.termVariable2constant(script, vars[i]);
            }
            term = script.let(vars, values, term);
            script.assertTerm(term);
            Script.LBool lBool = result = script.checkSat();
            return lBool;
        }
        finally {
            script.pop(1);
        }
    }

    private static Term termVariable2constant(Script script, TermVariable tv) {
        String name = tv.getName() + "_const_" + tv.hashCode();
        Sort resultSort = tv.getSort();
        script.declareFun(name, EMPTY_SORT_ARRAY, resultSort);
        return script.term(name, new Term[0]);
    }

    public static Term not(Script script, Term f) {
        if (f == script.term("true", new Term[0])) {
            return script.term("false", new Term[0]);
        }
        if (f == script.term("false", new Term[0])) {
            return script.term("true", new Term[0]);
        }
        if (f instanceof ApplicationTerm && ((ApplicationTerm)f).getFunction().getName().equals("not")) {
            return ((ApplicationTerm)f).getParameters()[0];
        }
        return script.term("not", f);
    }

    public static Term and(Script script, Term ... subforms) {
        return Util.simplifyAndOr(script, "and", subforms);
    }

    public static Term or(Script script, Term ... subforms) {
        return Util.simplifyAndOr(script, "or", subforms);
    }

    private static Term simplifyAndOr(Script script, String connector, Term ... subforms) {
        Term absorbing;
        Term neutral;
        Term trueTerm = script.term("true", new Term[0]);
        Term falseTerm = script.term("false", new Term[0]);
        if (connector.equals("and")) {
            neutral = trueTerm;
            absorbing = falseTerm;
        } else {
            neutral = falseTerm;
            absorbing = trueTerm;
        }
        LinkedHashSet<Term> formulas = new LinkedHashSet<Term>();
        for (Term f : subforms) {
            if (f == neutral) continue;
            if (f == absorbing) {
                return f;
            }
            if (f instanceof ApplicationTerm && ((ApplicationTerm)f).getFunction().getName().equals(connector)) {
                for (Term subf : ((ApplicationTerm)f).getParameters()) {
                    formulas.add(subf);
                }
                continue;
            }
            formulas.add(f);
        }
        if (formulas.size() <= 1) {
            if (formulas.isEmpty()) {
                return neutral;
            }
            return (Term)formulas.iterator().next();
        }
        Term[] arrforms = formulas.toArray(new Term[formulas.size()]);
        return script.term(connector, arrforms);
    }

    public static Term ite(Script script, Term cond, Term thenPart, Term elsePart) {
        Term trueTerm = script.term("true", new Term[0]);
        Term falseTerm = script.term("false", new Term[0]);
        if (cond == trueTerm || thenPart == elsePart) {
            return thenPart;
        }
        if (cond == falseTerm) {
            return elsePart;
        }
        if (thenPart == trueTerm) {
            return Util.or(script, cond, elsePart);
        }
        if (elsePart == falseTerm) {
            return Util.and(script, cond, thenPart);
        }
        if (thenPart == falseTerm) {
            return Util.and(script, Util.not(script, cond), elsePart);
        }
        if (elsePart == trueTerm) {
            return Util.or(script, Util.not(script, cond), thenPart);
        }
        return script.term("ite", cond, thenPart, elsePart);
    }

    public static Term implies(Script script, Term ... subforms) {
        Term lastFormula = subforms[subforms.length - 1];
        Term trueTerm = script.term("true", new Term[0]);
        if (lastFormula == trueTerm) {
            return trueTerm;
        }
        Term falseTerm = script.term("false", new Term[0]);
        if (lastFormula == falseTerm) {
            Term[] allButLast = new Term[subforms.length - 1];
            System.arraycopy(subforms, 0, allButLast, 0, subforms.length - 1);
            return Util.not(script, Util.and(script, allButLast));
        }
        LinkedHashSet<Term> newSubforms = new LinkedHashSet<Term>();
        for (int i = 0; i < subforms.length - 1; ++i) {
            if (subforms[i] == falseTerm) {
                return trueTerm;
            }
            if (subforms[i] == trueTerm) continue;
            newSubforms.add(subforms[i]);
        }
        if (newSubforms.isEmpty()) {
            return lastFormula;
        }
        Term[] newParams = newSubforms.toArray(new Term[newSubforms.size() + 1]);
        newParams[newParams.length - 1] = lastFormula;
        return script.term("=>", newParams);
    }
}

