/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;

public class TermTransformer
extends NonRecursive {
    private final ArrayDeque<HashMap<Term, Term>> mCache = new ArrayDeque();
    private final ArrayDeque<Term> mConverted = new ArrayDeque();

    protected final void pushTerms(Term[] terms) {
        for (int i = terms.length - 1; i >= 0; --i) {
            this.pushTerm(terms[i]);
        }
    }

    protected final void pushTerm(Term term) {
        this.enqueueWalker(new Convert(term));
    }

    protected final void setResult(Term term) {
        this.mConverted.addLast(term);
    }

    private void cacheConvert(Term term) {
        Term newTerm = this.mCache.getLast().get(term);
        if (newTerm == null) {
            this.enqueueWalker(new AddCache(term));
            this.convert(term);
        } else {
            this.setResult(newTerm);
        }
    }

    protected void beginScope() {
        this.mCache.addLast(new HashMap());
    }

    protected void endScope() {
        this.mCache.removeLast();
    }

    protected void convert(Term term) {
        if (term instanceof ConstantTerm || term instanceof TermVariable) {
            this.mConverted.addLast(term);
        } else if (term instanceof ApplicationTerm) {
            this.enqueueWalker(new BuildApplicationTerm((ApplicationTerm)term));
            this.pushTerms(((ApplicationTerm)term).getParameters());
        } else if (term instanceof LetTerm) {
            this.enqueueWalker(new StartLetTerm((LetTerm)term));
            this.pushTerms(((LetTerm)term).getValues());
        } else if (term instanceof QuantifiedFormula) {
            this.enqueueWalker(new BuildQuantifier((QuantifiedFormula)term));
            this.pushTerm(((QuantifiedFormula)term).getSubformula());
            this.beginScope();
        } else {
            if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annterm = (AnnotatedTerm)term;
                this.enqueueWalker(new BuildAnnotation(annterm));
                Annotation[] annots = annterm.getAnnotations();
                for (int i = annots.length - 1; i >= 0; --i) {
                    Object value = annots[i].getValue();
                    if (value instanceof Term) {
                        this.pushTerm((Term)value);
                        continue;
                    }
                    if (!(value instanceof Term[])) continue;
                    this.pushTerms((Term[])value);
                }
                this.pushTerm(annterm.getSubterm());
                return;
            }
            throw new AssertionError((Object)("Unknown Term: " + term.toStringDirect()));
        }
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        ApplicationTerm newTerm = appTerm;
        if (newArgs != appTerm.getParameters()) {
            FunctionSymbol fun = appTerm.getFunction();
            Theory theory = fun.getTheory();
            newTerm = theory.term(fun, newArgs);
        }
        this.setResult(newTerm);
    }

    public void preConvertLet(LetTerm oldLet, Term[] newValues) {
        this.beginScope();
        this.enqueueWalker(new BuildLetTerm(oldLet, newValues));
        this.pushTerm(oldLet.getSubTerm());
    }

    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        Term result = oldLet;
        if (oldLet.getValues() != newValues || oldLet.getSubTerm() != newBody) {
            result = oldLet.getTheory().let(oldLet.getVariables(), newValues, newBody);
        }
        this.setResult(result);
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        Term newFormula = old;
        if (newBody != old.getSubformula()) {
            Theory theory = old.getTheory();
            TermVariable[] vars = old.getVariables();
            newFormula = old.getQuantifier() == 0 ? theory.exists(vars, newBody) : theory.forall(vars, newBody);
        }
        this.setResult(newFormula);
    }

    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        Annotation[] annots = old.getAnnotations();
        Term result = old;
        if (newBody != old.getSubterm() || newAnnots != annots) {
            result = old.getTheory().annotatedTerm(newAnnots, newBody);
        }
        this.setResult(result);
    }

    public final Term transform(Term term) {
        this.beginScope();
        this.run(new Convert(term));
        this.endScope();
        return this.mConverted.removeLast();
    }

    protected final Term getConverted() {
        return this.mConverted.removeLast();
    }

    protected final Term[] getConverted(Term[] oldArgs) {
        Term[] newArgs = oldArgs;
        for (int i = oldArgs.length - 1; i >= 0; --i) {
            Term newTerm = this.getConverted();
            if (newTerm == oldArgs[i]) continue;
            if (newArgs == oldArgs) {
                newArgs = (Term[])oldArgs.clone();
            }
            newArgs[i] = newTerm;
        }
        return newArgs;
    }

    public void reset() {
        super.reset();
        this.mConverted.clear();
        this.mCache.clear();
    }

    protected static class BuildAnnotation
    implements NonRecursive.Walker {
        private final AnnotatedTerm mAnnotatedTerm;

        public BuildAnnotation(AnnotatedTerm term) {
            this.mAnnotatedTerm = term;
        }

        public void walk(NonRecursive engine) {
            Annotation[] annots;
            TermTransformer transformer = (TermTransformer)engine;
            Annotation[] newAnnots = annots = this.mAnnotatedTerm.getAnnotations();
            for (int i = annots.length - 1; i >= 0; --i) {
                Object value = annots[i].getValue();
                Object newValue = value instanceof Term ? transformer.getConverted() : (value instanceof Term[] ? transformer.getConverted((Term[])value) : value);
                if (newValue == value) continue;
                if (annots == newAnnots) {
                    newAnnots = (Annotation[])annots.clone();
                }
                newAnnots[i] = new Annotation(annots[i].getKey(), newValue);
            }
            Term sub = transformer.getConverted();
            transformer.postConvertAnnotation(this.mAnnotatedTerm, newAnnots, sub);
        }

        public String toString() {
            return "annotate";
        }
    }

    protected static class BuildQuantifier
    implements NonRecursive.Walker {
        private final QuantifiedFormula mQuant;

        public BuildQuantifier(QuantifiedFormula term) {
            this.mQuant = term;
        }

        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term sub = transformer.getConverted();
            transformer.postConvertQuantifier(this.mQuant, sub);
            transformer.endScope();
        }

        public String toString() {
            return this.mQuant.getQuantifier() == 0 ? "exists" : "forall";
        }
    }

    protected static class BuildLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;
        private final Term[] mNewValues;

        public BuildLetTerm(LetTerm term, Term[] newValues) {
            this.mLetTerm = term;
            this.mNewValues = newValues;
        }

        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term newBody = transformer.getConverted();
            transformer.postConvertLet(this.mLetTerm, this.mNewValues, newBody);
            transformer.endScope();
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class StartLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;

        public StartLetTerm(LetTerm term) {
            this.mLetTerm = term;
        }

        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term[] values = transformer.getConverted(this.mLetTerm.getValues());
            transformer.preConvertLet(this.mLetTerm, values);
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class BuildApplicationTerm
    implements NonRecursive.Walker {
        private final ApplicationTerm mAppTerm;

        public BuildApplicationTerm(ApplicationTerm term) {
            this.mAppTerm = term;
        }

        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term[] oldArgs = this.mAppTerm.getParameters();
            Term[] newArgs = transformer.getConverted(oldArgs);
            transformer.convertApplicationTerm(this.mAppTerm, newArgs);
        }

        public String toString() {
            return this.mAppTerm.getFunction().getApplicationString();
        }
    }

    private static class AddCache
    implements NonRecursive.Walker {
        Term mOldTerm;

        public AddCache(Term term) {
            this.mOldTerm = term;
        }

        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            ((HashMap)transformer.mCache.getLast()).put(this.mOldTerm, transformer.mConverted.getLast());
        }

        public String toString() {
            return "AddCache[" + this.mOldTerm.toStringDirect() + "]";
        }
    }

    private static class Convert
    implements NonRecursive.Walker {
        private final Term mTerm;

        public Convert(Term term) {
            this.mTerm = term;
        }

        public String toString() {
            return "Convert " + this.mTerm.toStringDirect();
        }

        public void walk(NonRecursive walker) {
            ((TermTransformer)walker).cacheConvert(this.mTerm);
        }
    }
}

