/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantifiedFormula
extends Term {
    public static final int EXISTS = 0;
    public static final int FORALL = 1;
    private final int mQuantifier;
    private final TermVariable[] mVariables;
    private final Term mSubFormula;

    QuantifiedFormula(int quant, TermVariable[] vars, Term f, int hash) {
        super(hash);
        this.mQuantifier = quant;
        this.mVariables = vars;
        this.mSubFormula = f;
    }

    public int getQuantifier() {
        return this.mQuantifier;
    }

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term getSubformula() {
        return this.mSubFormula;
    }

    @Override
    public Sort getSort() {
        return this.mSubFormula.getSort();
    }

    @Override
    public int hashCode() {
        return QuantifiedFormula.hashQuantifier(this.mQuantifier, this.mVariables, this.mSubFormula);
    }

    public static final int hashQuantifier(int quant, TermVariable[] vars, Term f) {
        return HashUtils.hashJenkins(f.hashCode() ^ quant, vars);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> m_Todo) {
        m_Todo.addLast(")");
        m_Todo.addLast(this.getSubformula());
        m_Todo.addLast(")) ");
        TermVariable[] vars = this.getVariables();
        for (int i = vars.length - 1; i > 0; --i) {
            m_Todo.addLast(vars[i].getSort());
            m_Todo.addLast(") (" + vars[i] + " ");
        }
        m_Todo.addLast(vars[0].getSort());
        m_Todo.addLast("(" + (this.getQuantifier() == 0 ? "exists" : "forall") + " ((" + vars[0] + " ");
    }
}

