/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetTerm
extends Term {
    private final TermVariable[] mVariables;
    private final Term[] mValues;
    private final Term mSubterm;

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term[] getValues() {
        return this.mValues;
    }

    public Term getSubTerm() {
        return this.mSubterm;
    }

    LetTerm(TermVariable[] vars, Term[] vals, Term t, int hash) {
        super(hash);
        this.mVariables = vars;
        this.mValues = vals;
        this.mSubterm = t;
    }

    @Override
    public Sort getSort() {
        LetTerm sortterm = this;
        while (sortterm.mSubterm instanceof LetTerm) {
            sortterm = (LetTerm)sortterm.mSubterm;
        }
        return sortterm.mSubterm.getSort();
    }

    public static final int hashLet(TermVariable[] vars, Term[] values, Term subform) {
        return HashUtils.hashJenkins(HashUtils.hashJenkins(subform.hashCode(), values), vars);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> m_Todo) {
        m_Todo.addLast(")");
        m_Todo.addLast(this.getSubTerm());
        m_Todo.addLast(")) ");
        TermVariable[] vars = this.getVariables();
        Term[] values = this.getValues();
        for (int i = values.length - 1; i > 0; --i) {
            m_Todo.addLast(values[i]);
            m_Todo.addLast(") (" + vars[i].toString() + " ");
        }
        m_Todo.addLast(values[0]);
        m_Todo.addLast("(let ((" + vars[0].toString() + " ");
    }
}

