/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IRAConstantFormatter
extends TermTransformer {
    protected void convert(Term term) {
        if (term instanceof ConstantTerm) {
            ConstantTerm ct = (ConstantTerm)term;
            Rational rat = null;
            if (ct.getValue() instanceof Rational) {
                rat = (Rational)ct.getValue();
            } else if (ct.getValue() instanceof BigDecimal) {
                BigDecimal val = (BigDecimal)ct.getValue();
                int scale = val.scale();
                BigInteger unscaled = val.unscaledValue();
                BigInteger scaler = BigInteger.TEN.pow(scale);
                rat = Rational.valueOf(unscaled, scaler);
            } else if (ct.getValue() instanceof BigInteger) {
                rat = Rational.valueOf((BigInteger)ct.getValue(), BigInteger.ONE);
            } else {
                this.setResult(ct);
                return;
            }
            this.setResult(ct.getTheory().modelRational(rat, ct.getSort()));
        } else {
            super.convert(term);
        }
    }
}

