/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assignments {
    private final Map<String, Boolean> mAssignment;
    private int mNumTrue = -1;

    public Assignments(Map<String, Boolean> assignment) {
        this.mAssignment = assignment;
    }

    public Boolean getAssignment(String label) {
        return this.mAssignment.get(label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Map.Entry<String, Boolean> me : this.mAssignment.entrySet()) {
            sb.append('(').append(me.getKey()).append(' ').append(me.getValue()).append(')');
        }
        sb.append(')');
        return sb.toString();
    }

    public Iterable<String> getTrueAssignments() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TruthIterator(Boolean.TRUE);
            }
        };
    }

    public Iterable<String> getFalseAssignments() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TruthIterator(Boolean.FALSE);
            }
        };
    }

    public int getNumTrueAssignments() {
        if (this.mNumTrue == -1) {
            this.mNumTrue = 0;
            for (Map.Entry<String, Boolean> me : this.mAssignment.entrySet()) {
                if (me.getValue() != Boolean.TRUE) continue;
                ++this.mNumTrue;
            }
        }
        return this.mNumTrue;
    }

    public int getNumFalseAssignments() {
        return this.mAssignment.size() - this.getNumTrueAssignments();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TruthIterator
    implements Iterator<String> {
        private final Boolean mTruthVal;
        private final Iterator<Map.Entry<String, Boolean>> mIt;
        private String mNextVal;

        public TruthIterator(Boolean truthVal) {
            this.mTruthVal = truthVal;
            this.mIt = Assignments.this.mAssignment.entrySet().iterator();
            this.nextVal();
        }

        private void nextVal() {
            while (this.mIt.hasNext()) {
                Map.Entry<String, Boolean> me = this.mIt.next();
                if (me.getValue() != this.mTruthVal) continue;
                this.mNextVal = me.getKey();
                return;
            }
            this.mNextVal = null;
        }

        @Override
        public boolean hasNext() {
            return this.mNextVal != null;
        }

        @Override
        public String next() {
            String val = this.mNextVal;
            if (val == null) {
                throw new NoSuchElementException();
            }
            this.nextVal();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

